using System;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Windows.Forms;

namespace Alternative.Forms
{
    using Windows;
    using WebServiceClient;
    using WebServiceClient.Text;
    using WebServiceClient.Forms;
    using Alternative.Forms;

    public partial class MainForm
    {
        #region Constant

        /// <summary>_E[hXgIۂTreeViewɕ\镶łB</summary>
        public const string DownloadFolderName = "_E[h";
        /// <summary>ۑtH_IۂTreeViewɕ\镶łB</summary>
        public const string SaveFolderName = "ۑtH_";
        /// <summary>t@CIۂTreeViewɕ\镶łB</summary>
        public const string SearchFilesName = "t@C";

        #endregion

        #region Field

        /// <summary>[gm[hWJ邽߂̃_~[m[h̃xeLXg\ stringB</summary>
        private const string DummyNodeLabel = "<>";
        /// <summary>_E[hm[h̖O\ stringB</summary>
        private const string DownloadNodeKey = "downloadNode";
        /// <summary>t@Cۑm[h̖O\ stringB</summary>
        private const string SaveFolderNodeKey = "saveFolderNode";
        /// <summary>t@Cm[h̖O\ stringB</summary>
        private const string SearchFilesNodeKey = "searchFilesNode";

        /// <summary>c[r[̓WJ}~邩ǂ\ boolB</summary>
        private bool _isLockSaveFolderExpand = false;
        /// <summary>t@Cۑ惊Xgr[̍XV}~邩ǂ\ boolB</summary>
        private bool _isLockUpdateSaveFolder = false;
        /// <summary>ŌɑIm[h\ <see cref="TreeNode"/></summary>
        private TreeNode _lastSelectedNode;

        #endregion

        #region EventHandler

        /// <summary>m[hIɂ̓Tum[hWJ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="TreeViewEventArgs"/>B</param>
        private void saveFolderTreeView_AfterSelect(object sender, TreeViewEventArgs e)
        {
            switch (e.Node.Name)
            {
            // _E[hXg
            case DownloadNodeKey:
                if (DownloadListView.Visible == false)
                {
                    DownloadListView.Visible = true;
                    SaveFolderListView.Visible = false;
                    SearchResultListView.Visible = false;
                }
                break;

            // t@C
            case SearchFilesNodeKey:
                if (SearchResultListView.Visible == false)
                {
                    SearchResultListView.Visible = true;
                    DownloadListView.Visible = false;
                    SaveFolderListView.Visible = false;
                }

                ShowSearchFileDialog();
                break;

            // ۑtH_
            default:
                if (_isLockUpdateSaveFolder == false)
                {
                    if (SaveFolderListView.Visible == false)
                    {
                        SaveFolderListView.Visible = true;
                        DownloadListView.Visible = false;
                        SearchResultListView.Visible = false;
                    }

                    CreateSaveFolderListViewItems(e.Node);
                }

                if (_isLockSaveFolderExpand == false && _isLockUpdateSaveFolder == false)
                {
                    e.Node.Expand();
                }
                break;
            }

            if (_isLockUpdateSaveFolder == false)
            {
                _lastSelectedNode = SaveFolderTreeView.SelectedNode;
            }
        }

        /// <summary>t@Cm[h_uNbNꂽt@C_CAO\܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="MouseEventArgs"/>B</param>
        private void saveFolderTreeView_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            TreeNode node = SaveFolderTreeView.GetNodeAt(e.Location);
            if (node.Name == SearchFilesNodeKey)
            {
                if (SearchResultListView.Visible == false)
                {
                    SearchResultListView.Visible = true;
                    DownloadListView.Visible = false;
                    SaveFolderListView.Visible = false;
                }

                ShowSearchFileDialog();
            }
        }

        /// <summary>m[hWJ钼Oɑm[h쐬܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="TreeViewCancelEventArgs"/>B</param>
        private void saveFolderTreeView_BeforeExpand(object sender, TreeViewCancelEventArgs e)
        {
            // 2Kw܂ŃfBNgǂݍłȂm[h̏ꍇ̓m[h
            if ((bool)e.Node.Tag == false)
            {
                // ŏʂ̊Kw̏ꍇ1KwǂݍłȂ̂ŏɐ
                if (e.Node.Name == SaveFolderNodeKey)
                {
                    e.Node.Nodes.Clear();
                    CreateSubTreeNodes(e.Node);
                }

                foreach (TreeNode node in e.Node.Nodes)
                {
                    CreateSubTreeNodes(node);
                }

                // TutH_ς݂̈t
                e.Node.Tag = true;
            }
        }

        /// <summary>xύX悤ƂĂm[h[gm[h̏ꍇ͕ҏW֎~Ƃ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="NodeLabelEditEventArgs"/>B</param>
        private void saveFolderTreeView_BeforeLabelEdit(object sender, NodeLabelEditEventArgs e)
        {
            e.CancelEdit = (e.Node.Parent == null);
        }

        /// <summary>ύXxɑΉtH_l[܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="NodeLabelEditEventArgs"/>B</param>
        private void saveFolderTreeView_AfterLabelEdit(object sender, NodeLabelEditEventArgs e)
        {
            // LZꂽOŊm肵ꍇ͉Ȃ
            if (e.Label != null && string.Compare(e.Node.Text, e.Label, true) != 0)
            {
                try
                {
                    string src = GetSaveFolderPath(e.Node);
                    string dest = src.Substring(0, src.LastIndexOf('\\')) + "\\" + e.Label;
                    Directory.Move(src, dest);
                }
                catch (Exception ex)
                {
                    e.CancelEdit = true;
                    MessageBox.Show(ex.Message, Application.ProductName);
                }
            }
            else
            {
                e.CancelEdit = true;
            }
        }

        /// <summary>Im[h̃ReLXgj[\܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="TreeNodeMouseClickEventArgs"/>B</param>
        private void saveFolderTreeView_NodeMouseClick(object sender, TreeNodeMouseClickEventArgs e)
        {
            if (e.Node != null && e.Button == MouseButtons.Right)
            {
                // m[hIɓWJƃXN[邽ߓWJ}~
                _isLockSaveFolderExpand = true;
                SaveFolderTreeView.SelectedNode = e.Node;
                _isLockSaveFolderExpand = false;

                switch (e.Node.Name)
                {
                // _E[hXg
                case DownloadNodeKey:
                    SaveFolderTreeView.ContextMenuStrip = SaveFolderTreeViewDownloadMenu;
                    break;

                // 挟
                case SearchFilesNodeKey:
                    // j[Ȃ
                    break;

                // ۑtH_̃[g
                case SaveFolderNodeKey:
                    SaveFolderTreeView.ContextMenuStrip = SaveFolderTreeViewFolderMenu;
                    break;

                // ۑtH_̃TutH_
                default:
                    SaveFolderTreeView.ContextMenuStrip = SaveFolderTreeViewFolderMenu;
                    break;
                }
            }
        }

        /// <summary>m[hhbOꍇ͑ΉtH_ړ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="ItemDragEventArgs"/>B</param>
        private void saveFolderTreeView_ItemDrag(object sender, ItemDragEventArgs e)
        {
            LockUpdateSelectNode(e.Item as TreeNode);
            SaveFolderTreeView.DoDragDrop(e.Item, DragDropEffects.Move);
        }

        /// <summary>hbOAhhbvɑΉf[^ǂ𒲂ׂ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="DragEventArgs"/>B</param>
        private void saveFolderTreeView_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(typeof(TreeNode)) == true)
            {
                e.Effect = DragDropEffects.Move;
            }
            else if (e.Data.GetDataPresent(typeof(GkListViewItem[])) == true)
            {
                e.Effect = DragDropEffects.Move;
            }
            else if (e.Data.GetDataPresent("UniformResourceLocator") || e.Data.GetDataPresent("UniformResourceLocatorW"))
            {
                e.Effect = DragDropEffects.Link;
            }
        }

        /// <summary>hbO̓}EX|C^̈ʒuɑΉm[hIԂɂ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="DragEventArgs"/>B</param>
        private void saveFolderTreeView_DragOver(object sender, DragEventArgs e)
        {
            Point pos = SaveFolderTreeView.PointToClient(new Point(e.X, e.Y));
            TreeNode node = SaveFolderTreeView.GetNodeAt(pos);
            e.Effect = DragDropEffects.None;

            if (node != null)
            {
                switch (node.Name)
                {
                // _E[hXg
                case DownloadNodeKey:
                    if (e.Data.GetDataPresent("UniformResourceLocator") || e.Data.GetDataPresent("UniformResourceLocatorW"))
                    {
                        e.Effect = DragDropEffects.Link;
                        LockUpdateSelectNode(node);
                    }
                    break;

                // 挟
                case SearchFilesNodeKey:
                    e.Effect = DragDropEffects.None;
                    break;

                // ۑtH_
                default:
                    if (e.Data.GetDataPresent(typeof(TreeNode)) == true && node.Equals(e.Data.GetData(typeof(TreeNode))) == false)
                    {
                        e.Effect = DragDropEffects.Move;
                        LockUpdateSelectNode(node);
                    }
                    else if (e.Data.GetDataPresent(typeof(GkListViewItem[])) == true)
                    {
                        e.Effect = DragDropEffects.Move;
                        LockUpdateSelectNode(node);
                    }
                    break;
                }
            }
        }

        /// <summary>ef[^̃hbv̏s܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="DragEventArgs"/>B</param>
        private void saveFolderTreeView_DragDrop(object sender, DragEventArgs e)
        {
            // c[m[h̏ꍇ̓tH_ړ
            if (e.Data.GetDataPresent(typeof(TreeNode)) == true)
            {
                try
                {
                    TreeNode srcNode = e.Data.GetData(typeof(TreeNode)) as TreeNode;
                    TreeNode destNode = SaveFolderTreeView.SelectedNode;
                    string srcPath = GetSaveFolderPath(srcNode);
                    string destPath = GetSaveFolderPath(destNode) + "\\" + srcNode.Text;
                    Directory.Move(srcPath, destPath);
                    srcNode.Remove();
                    destNode.Nodes.Add(srcNode);
                    LockUpdateSelectNode(srcNode);
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message, Application.ProductName);
                }
            }
            // GkListViewItem[] ̏ꍇ͑I𒆂̓Ɗ֘At@Cړ
            else if (e.Data.GetDataPresent(typeof(GkListViewItem[])) == true)
            {
                string srcDir = GetSaveFolderPath(_lastSelectedNode);
                string destDir = GetSaveFolderPath(SaveFolderTreeView.SelectedNode);
                DirectoryInfo dir = new DirectoryInfo(srcDir);
                GkListViewItem[] items = e.Data.GetData(typeof(GkListViewItem[])) as GkListViewItem[];

                try
                {
                    foreach (GkListViewItem item in items)
                    {
                        NicoVideoFile.Move(Path.Combine(srcDir, item.Text + ".mp4"), destDir);
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message, Application.ProductName);
                }
            }
            // nCp[N̏ꍇ̓AhX̖̃pX𓮉IDƂă_E[hACeɓo^
            else if (e.Data.GetDataPresent("UniformResourceLocator") || e.Data.GetDataPresent("UniformResourceLocatorW"))
            {
                try
                {
                    NicoVideoPageUrl url = new NicoVideoPageUrl(e.Data.GetData(DataFormats.Text).ToString());
                    NicoDownloadItem item = new NicoDownloadItem(url.VideoId, url.VideoId, _config.SaveFullPathFormat, DownloadTarget.Default);
                    _downloadManager.AddItem(Path.Combine(_config.SaveFolderPath, url.VideoId), item);
                    SaveFolderTreeView.SelectedNode = SaveFolderTreeView.Nodes[DownloadNodeKey];
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message, Application.ProductName);
                }
            }
        }

        #endregion

        #region Method

        /// <summary>saveFolderTreeView܂B</summary>
        private void InitializeSaveFolderTreeView()
        {
            IComparer<string> comparer = new NaturalComparer(NaturalSortOrder.Ascending, NaturalComparerOptions.Default);
            SaveFolderTreeView.TreeViewNodeSorter = new TreeViewNodeComparerAsAny(SortOrder.Ascending, new TreeViewNodeComparerAsAny.CustomCompare(delegate(TreeNode x, TreeNode y)
            {
                if (x.Name != "" || y.Name != "")
                {
                    return 0;
                }
                else
                {
                    return comparer.Compare(x.Text, y.Text);
                }
            }));

            TreeNode node;
            SaveFolderTreeView.BeginUpdate();
            SaveFolderTreeView.Nodes.Clear();
            SaveFolderTreeView.Tag = _config.SaveFolderPath;

            // _E[hXg
            node = new TreeNode(DownloadFolderName, 0, 0);
            node.Name = DownloadNodeKey;
            node.Tag = true;
            SaveFolderTreeView.Nodes.Add(node);

            // ۑtH_
            node = new TreeNode(SaveFolderName, 1, 3);
            node.Name = SaveFolderNodeKey;
            node.Tag = false;
            SaveFolderTreeView.Nodes.Add(node);
            node.Nodes.Add(null, DummyNodeLabel, 1, 3);

            // t@C
            node = new TreeNode(SearchFilesName, 2, 2);
            node.Name = SearchFilesNodeKey;
            node.Tag = true;
            SaveFolderTreeView.Nodes.Add(node);

            SaveFolderTreeView.SelectedNode = SaveFolderTreeView.Nodes[DownloadNodeKey];
            SaveFolderTreeView.EndUpdate();
        }

        /// <summary>w̃m[hɑΉtH_̃tpX擾܂B</summary>
        /// <param name="targetNode">tpX擾Ώۃm[h\ <see cref="TreeNode"/>B</param>
        /// <returns>擾tpX\ stringB</returns>
        private string GetSaveFolderPath(TreeNode targetNode)
        {
            if (targetNode.Parent != null)
            {
                return Path.Combine(GetSaveFolderPath(targetNode.Parent), targetNode.Text);
            }
            else
            {
                return _config.SaveFolderPath;
            }
        }

        /// <summary>w̃m[hɑΉtH_̃TutH_Ďqm[h쐬܂B</summary>
        /// <param name="targetNode">qm[h쐬Ώۃm[h\ <see cref="TreeNode"/>B</param>
        private void CreateSubTreeNodes(TreeNode targetNode)
        {
            DirectoryInfo dir = new DirectoryInfo(GetSaveFolderPath(targetNode));
            DirectoryInfo[] subdir = dir.GetDirectories();
            TreeNode[] addNodes = new TreeNode[subdir.Length];

            for (int i = 0; i < subdir.Length; i++)
            {
                TreeNode node = new TreeNode(subdir[i].Name, 1, 3);
                node.Tag = false;
                addNodes[i] = node;
            }

            targetNode.Nodes.AddRange(addNodes);
        }

        /// <summary>w̃m[hɑΉtH_̃t@Cꗗ쐬܂B</summary>
        /// <param name="targetNode"></param>
        private void CreateSaveFolderListViewItems(TreeNode targetNode)
        {
            DirectoryInfo dir = new DirectoryInfo(GetSaveFolderPath(targetNode));
            FileInfo[] files = dir.GetFiles();

            SaveFolderListView.BeginUpdate();
            SaveFolderListView.Items.Clear();

            for (int i = 0; i < files.Length; i++)
            {
                if (NicoVideoFile.NicoVideoExtensions.ContainsKey(files[i].Extension.ToLower()) == true)
                {
                    GkListViewItem item = new GkListViewItem(Path.GetFileNameWithoutExtension(files[i].Name));
                    item.SubItems.Add(string.Format("{0:N3}", MathHelper.Ceiling((decimal)files[i].Length / 1024000, 3)));
                    item.SubItems.Add(files[i].LastWriteTime.ToString("yyyy/MM/dd HH:mm:ss"));
                    item.SubItems.Add(files[i].Extension.Substring(1));
                    SaveFolderListView.Items.Add(item);
                }
            }

            SaveFolderListView.EndUpdate();
        }

        /// <summary>Xgr[̏ԂςɃm[h̑IԂύX܂B</summary>
        /// <param name="node">IԂɂm[h\ <see cref="TreeNode"/>B</param>
        /// <param name="focus">tH[JXZbg邩ǂ\ boolB</param>
        private void LockUpdateSelectNode(TreeNode node)
        {
            _isLockUpdateSaveFolder = true;
            node.TreeView.SelectedNode = node;
            node.TreeView.Focus();
            _isLockUpdateSaveFolder = false;
        }

        /// <summary>t@C_CAO\܂B</summary>
        private void ShowSearchFileDialog()
        {
            using (SearchFileDialog dialog = new SearchFileDialog(_config.SearchFileInfo))
            {
                if (dialog.DefaultFolder.Length == 0)
                {
                    dialog.DefaultFolder = _config.SaveFolderPath;
                }

                if (dialog.ShowDialog(this) == DialogResult.OK)
                {
                    SearchResultListView.BeginUpdate();
                    SearchResultListView.Items.Clear();
                    List<GkListViewItem> items = new List<GkListViewItem>();

                    foreach (FileInfo file in dialog.SearchFileInfo.Search())
                    {
                        if (NicoVideoFile.NicoVideoExtensions.ContainsKey(file.Extension) == true)
                        {
                            items.Add(new GkListViewItem(new string[] {
						        Path.GetFileNameWithoutExtension(file.Name), 
						        String.Format("{0:N3}", MathHelper.Ceiling((decimal)file.Length / 1024000, 3)),
						        file.LastWriteTime.ToString(),
						        file.Extension.Substring(1),
						        file.FullName
					        }));
                        }
                    }

                    SearchResultListView.Items.AddRange(items.ToArray());
                    SearchResultListView.EndUpdate();
                }
            }
        }

        /// <summary>tH_쐬_CAO\܂B</summary>
        /// <param name="parentPath">tH_쐬pX\ stringB</param>
        /// <param name="defaultName">\ɎgptH_\ stringB</param>
        private void ShowCreateFolderDialog(string parentPath, string defaultName)
        {
            _config.CreateFolderInfo.ParentFolder = parentPath;
            _config.CreateFolderInfo.DefaultFolderName = defaultName;

            using (CreateFolderDialog dialog = new CreateFolderDialog(_config.CreateFolderInfo))
            {
                if (dialog.ShowDialog(this) == DialogResult.OK)
                {
                    try
                    {
                        CreateFolderInfo info = dialog.FolderInfo;
                        info.CreateFolder();
                        TreeNode node = new TreeNode(dialog.NewFolder);
                        node.Tag = true;
                        SaveFolderTreeView.SelectedNode.Nodes.Add(node);
                        SaveFolderTreeView.SelectedNode.Expand();
                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show(ex.Message, Application.ProductName);
                    }
                }
            }
        }

        #endregion

        #region TreeViewEx

        /// <summary>m[hl[̕בւׂ̈̃JX^NXłB</summary>
        public class TreeViewEx : TreeView
        {
            #region Field

            /// <summary>ŌɑIm[h\ <see cref="TreeNode"/></summary>
            private TreeNode _lastLabelEditNode;
            /// <summary>t@Cۑ惊Xgr[̍XV}~邩ǂ\ boolB</summary>
            private bool _isAfterLabelEdited = false;

            #endregion

            #region Constructor

            /// <summary>CX^X܂B</summary>
            public TreeViewEx()
            {
                SetStyle(ControlStyles.EnableNotifyMessage, true);
            }

            #endregion

            #region Method

            /// <summary>WM_NOTIFY bZ[W܂B</summary>
            /// <param name="message">Windows bZ[W\ <see cref="Message"/>B</param>
            protected override void OnNotifyMessage(Message m)
            {
                if (_isAfterLabelEdited == true && m.Msg == WindowsMessage.WM_PARENTNOTIFY)
                {
                    TreeNode parent = _lastLabelEditNode.Parent;
                    _lastLabelEditNode.Remove();
                    parent.Nodes.Add(_lastLabelEditNode);
                    this.SelectedNode = _lastLabelEditNode;
                    _isAfterLabelEdited = false;
                }

                base.OnNotifyMessage(m);
            }

            /// <summary>AfterLabelEdit Cxg𔭐܂B</summary>
            /// <param name="e">Cxg\ <see cref="NodeLabelEditEventArgs"/>B</param>
            protected override void OnAfterLabelEdit(NodeLabelEditEventArgs e)
            {
                base.OnAfterLabelEdit(e);

                if (e.CancelEdit == false)
                {
                    _isAfterLabelEdited = true;
                    _lastLabelEditNode = e.Node;
                }
            }

            /// <summary>AfterSelect Cxg𔭐܂B</summary>
            /// <param name="e">Cxg\ <see cref="TreeViewEventArgs"/>B</param>
            protected override void OnAfterSelect(TreeViewEventArgs e)
            {
                if (_isAfterLabelEdited == false)
                {
                    base.OnAfterSelect(e);
                }
            }

            #endregion
        }

        #endregion
    }
}
