using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Text;
using System.Windows.Forms;

namespace Alternative.Forms
{
    using WebServiceClient.Text;
    using WebServiceClient.Forms;
    using WebServiceClient.NicoVideo;
    using Alternative.Forms;

    public partial class MainForm
    {
        #region EventHandler

        /// <summary>Jwb_NbNƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="GkColumnClickEventArgs"/>B</param>
        private void saveFolderListView_ColumnClick(object sender, GkColumnClickEventArgs e)
        {
            e.Column.ReversalSortOrder();

            if (e.Column.Index == columnHeader2_title.Index)
            {
                SaveFolderListView.ListViewItemSorter = new ListViewItemComparerAsNatural(e.Column.Index, e.Column.SortOrder, NaturalComparerOptions.Default, new char[] { '' });
            }
            else if (e.Column.Index == columnHeader2_size.Index)
            {
                SaveFolderListView.ListViewItemSorter = new ListViewItemComparerAsDouble(e.Column.Index, e.Column.SortOrder);
            }
            else if (e.Column.Index == columnHeader2_updateTimestamp.Index)
            {
                SaveFolderListView.ListViewItemSorter = new ListViewItemComparerAsDateTime(e.Column.Index, e.Column.SortOrder);
            }
            else if (e.Column.Index == columnHeader2_extension.Index)
            {
                SaveFolderListView.ListViewItemSorter = new ListViewItemComparerAsString(e.Column.Index, e.Column.SortOrder);
            }
        }

        /// <summary>[U[ڂ̃hbOJnƔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="GkItemDragEventArgs"/>B</param>
        private void saveFolderListView_ItemDrag(object sender, GkItemDragEventArgs e)
        {
            DragDropEffects dde = SaveFolderListView.DoDragDrop(SaveFolderListView.SelectedItems.ToArray(), DragDropEffects.Move);
            if (dde == DragDropEffects.Move)
            {
                SaveFolderListView.Items.RemoveRange(SaveFolderListView.SelectedItems.ToArray());
            }
            LockUpdateSelectNode(_lastSelectedNode);
            SaveFolderListView.Focus();
        }

        /// <summary>IuWFNgRg[̋EɃhbOƔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="DragEventArgs"/>B</param>
        private void saveFolderListView_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent("UniformResourceLocator") || e.Data.GetDataPresent("UniformResourceLocatorW"))
            {
                e.Effect = DragDropEffects.Link;
            }
        }

        /// <summary>IuWFNgRg[̋E𒴂ăhbOƔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="DragEventArgs"/>B</param>
        private void saveFolderListView_DragOver(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent("UniformResourceLocator") || e.Data.GetDataPresent("UniformResourceLocatorW"))
            {
                e.Effect = DragDropEffects.Link;
            }
        }

        /// <summary>hbOhbv삪Ƃɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="DragEventArgs"/>B</param>
        private void saveFolderListView_DragDrop(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent("UniformResourceLocator") || e.Data.GetDataPresent("UniformResourceLocatorW"))
            {
                try
                {
                    NicoVideoPageUrl url = new NicoVideoPageUrl(e.Data.GetData(DataFormats.Text).ToString());
                    NicoDownloadItem item = new NicoDownloadItem(url.VideoId, url.VideoId, _config.SaveFullPathFormat, DownloadTarget.Default);
                    _downloadManager.AddItem(Path.Combine(_config.SaveFolderPath, url.VideoId), item);
                    SaveFolderTreeView.SelectedNode = SaveFolderTreeView.Nodes[DownloadNodeKey];
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message, Application.ProductName);
                }
            }
        }

        /// <summary>ACe`悷KvƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="GkListViewCustomDrawEventArgs"/>B</param>
        private void saveFolderListView_CustomDrawSubItem(object sender, WebServiceClient.Forms.GkListViewCustomDrawEventArgs e)
        {
            if (e.SubItem.VisibleControl == false && e.SubItem.ListViewItem.Index % 2 != 0)
            {
                e.Result = GkListViewCustomDrawResult.CustonDraw;
                e.BackColor = Color.FromArgb(0xF0, 0xF0, 0xF0);
            }
        }

        /// <summary>L[{[h̃L[Ƃɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="KeyEventArgs"/>B</param>
        private void saveFolderListView_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left)
            {
                saveFolderListView_Play();
            }
        }

        /// <summary>}EX{^_uNbNƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="MouseEventArgs"/>B</param>
        private void saveFolderListView_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter)
            {
                saveFolderListView_Play();
            }
        }

        #endregion

        #region Method

        /// <summary>w̃ACeɑΉt@C̃pX擾܂B</summary>
        /// <param name="item">擾Ώۂ̃ACe\ <see cref="GkListViewItem"/>B</param>
        /// <returns>擾t@C̃pX\ steingB</returns>
        private string GetSaveFolderFilePath(GkListViewItem item)
        {
            string folder = GetSaveFolderPath(SaveFolderTreeView.SelectedNode);
            string file = string.Format("{0}.{1}", item.SubItems[0].Text, item.SubItems[3].Text);
            return Path.Combine(folder, file);
        }

        /// <summary>tH[JXACe̓Đ܂B</summary>
        private void saveFolderListView_Play()
        {
            string path = GetSaveFolderFilePath(SaveFolderListView.FocusedItem);
            if (PlayVideoFile(path) == false)
            {
                MessageBox.Show(" ID ܂B", Application.ProductName);
            }
        }

        /// <summary>tH[JXACe̎y[W̃uEUŊJ܂B</summary>
        private void saveFolderListView_PlayByDefaultBrowser()
        {
            string path = GetSaveFolderFilePath(SaveFolderListView.FocusedItem);
            if (ShowWatchPageByDefaultBrowser(path) == false)
            {
                MessageBox.Show(" ID ܂B", Application.ProductName);
            }
        }

        /// <summary>tH[JXACe̎y[W̃uEUŊJ܂B</summary>
        private void saveFolderListView_PlayByAlternative()
        {
            string path = GetSaveFolderFilePath(SaveFolderListView.FocusedItem);
            if (ShowWatchPageByAlternative(path) == false)
            {
                MessageBox.Show(" ID ܂B", Application.ProductName);
            }
        }

        /// <summary>I𒆂̃ACe̓Ɗ֘At@C폜܂B</summary>
        private void saveFolderListView_DeleteFile()
        {
            try
            {
                string directory = GetSaveFolderPath(SaveFolderTreeView.SelectedNode);

                foreach (ListViewItem item in SaveFolderListView.SelectedItems)
                {
                    NicoVideoFile.Delete(Path.Combine(directory, item.Text + ".mp4"));
                }

                SaveFolderListView.Items.RemoveRange(SaveFolderListView.SelectedItems.ToArray());
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, Application.ProductName);
            }
        }

        /// <summary>I𒆂̃ACe_E[h܂B</summary>
        /// <param name="target">_E[hΏۂ̃Rec\ <see cref="DownloadTarget"/>B</param>
        private void saveFolderListView_Download(DownloadTarget target)
        {
            StringBuilder buffer = new StringBuilder();

            foreach (GkListViewItem lvItem in SaveFolderListView.SelectedItems)
            {
                string path = GetSaveFolderFilePath(lvItem);
                string videoId = NicoVideoFile.GetVideoId(path);

                if (videoId != "")
                {
                    string key = Path.Combine(_config.SaveFolderPath, videoId);

                    if (_downloadManager.Contains(key) == true)
                    {
                        IDownloadItem item = _downloadManager[key];
                        item.LocalPath = path;
                        item.DownloadedSize = 0;
                        item.DownloadTime = 0;
                        item.Target = target;
                        _downloadManager.Start(key);
                    }
                    else
                    {
                        NicoDownloadItem item = new NicoDownloadItem(videoId, lvItem.Text, path, target);
                        _downloadManager.AddItem(key, item);
                    }
                }
                else
                {
                    buffer.AppendLine(lvItem.Text);
                }
            }

            if (buffer.Length > 0)
            {
                buffer.Insert(0, "ȉ͓ ID Ȃ߃_E[ho܂B\n\n");
                MessageBox.Show(buffer.ToString(), Application.ProductName);
            }
        }

        /// <summary>I𒆂̃ACẽ^Cg URL Nbv{[hɃRs[܂B</summary>
        /// <param name="copyTitle">^CgRs[邩ǂ\ boolB</param>
        /// <param name="copyUrl">URL Rs[邩ǂ\ boolB</param>
        private void saveFolderListView_CopyTitleAndUrl(bool copyTitle, bool copyUrl)
        {
            bool isError = false;
            StringBuilder buffer = new StringBuilder();

            foreach (GkListViewItem lvItem in SaveFolderListView.SelectedItems)
            {
                if (copyTitle == true)
                {
                    buffer.AppendLine(lvItem.Text);
                }

                if (copyUrl == true)
                {
                    string path = GetSaveFolderFilePath(lvItem);
                    string videoId = NicoVideoFile.GetVideoId(path);

                    if (videoId != "")
                    {
                        string url = string.Format(_nicoApi.Url.WatchInfo, videoId);
                        buffer.AppendLine(url);
                    }
                    else
                    {
                        isError = true;
                    }
                }
            }

            Clipboard.SetDataObject(buffer.ToString(), true);

            if (isError == true)
            {
                MessageBox.Show(" ID Ȃ߃Rs[oȂ URL ܂B", Application.ProductName);
            }
        }

        #endregion
    }
}
