using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.IO;
using System.Text;
using System.Windows.Forms;

namespace Alternative.Forms
{
    using WebServiceClient.Forms;
    using WebServiceClient.NicoVideo;
    using Alternative.Forms;

    public partial class MainForm
    {
        #region downloadListView

        #region Field

        /// <summary>_E[hXgŃhbOړǂ\ boolB</summary>
        private bool _isDownloadListMoved = false;

        #endregion

        #region EventHandler

        /// <summary>[U[ڂ̃hbOJnƔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="GkItemDragEventArgs"/>B</param>
        private void downloadListView_ItemDrag(object sender, WebServiceClient.Forms.GkItemDragEventArgs e)
        {
            if (DownloadListView.SelectedItems.Count > 0)
            {
                DataObject dataObj = new DataObject();

                if (DownloadListView.VirtualMode == false)
                {
                    if (DownloadListView.SelectedItems.Count == 1)
                    {
                        dataObj.SetData(DownloadListView.DragDropItemType, DownloadListView.SelectedItems[0]);
                        if ((DownloadListView.SelectedItems[0] as IDownloadItem).State == DownloadItemState.Completed)
                        {
                            dataObj.SetData(typeof(GkListViewItem[]), new GkListViewItem[] { DownloadListView.SelectedItems[0] });
                        }
                    }
                    else
                    {
                        GkListViewItem[] moveItems = new GkListViewItem[DownloadListView.SelectedItems.Count];
                        List<GkListViewItem> dragItems = new List<GkListViewItem>();
                        for (int i = 0; i < moveItems.Length; i++)
                        {
                            moveItems[i] = DownloadListView.SelectedItems[i];
                            if ((moveItems[i] as IDownloadItem).State == DownloadItemState.Completed)
                            {
                                dragItems.Add(moveItems[i]);
                            }
                        }

                        dataObj.SetData(DownloadListView.DragDropItemType, moveItems);
                        if (dragItems.Count > 0)
                        {
                            dataObj.SetData(typeof(GkListViewItem[]), dragItems.ToArray());
                        }
                    }
                }
                else
                {
                    if (DownloadListView.SelectedIndices.Count == 1)
                    {
                        dataObj.SetData(DownloadListView.DragDropItemType, e.Item);
                        if ((e.Item as IDownloadItem).State == DownloadItemState.Completed)
                        {
                            dataObj.SetData(typeof(GkListViewItem[]), new GkListViewItem[] { e.Item });
                        }
                    }
                    else
                    {
                        GkListViewItem[] moveItems = new GkListViewItem[DownloadListView.SelectedIndices.Count];
                        List<GkListViewItem> dragItems = new List<GkListViewItem>();
                        for (int i = 0; i < moveItems.Length; i++)
                        {
                            moveItems[i] = DownloadListView.Items[DownloadListView.SelectedIndices[i]];
                            if ((moveItems[i] as IDownloadItem).State == DownloadItemState.Completed)
                            {
                                dragItems.Add(moveItems[i]);
                            }
                        }

                        dataObj.SetData(DownloadListView.DragDropItemType, moveItems);
                        if (dragItems.Count > 0)
                        {
                            dataObj.SetData(typeof(GkListViewItem[]), dragItems.ToArray());
                        }
                    }
                }

                _isDownloadListMoved = false;
                DragDropEffects dde = DownloadListView.DoDragDrop(dataObj, DragDropEffects.Copy | DragDropEffects.Move);
                if (dde == DragDropEffects.Move && _isDownloadListMoved == false)
                {
                    DownloadListView.Items.RemoveRange(DownloadListView.SelectedItems.ToArray());
                }
                LockUpdateSelectNode(_lastSelectedNode);
                DownloadListView.Focus();
            }
        }

        /// <summary>IuWFNgRg[̋EɃhbOƔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="DragEventArgs"/>B</param>
        private void downloadListView_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent("UniformResourceLocator") || e.Data.GetDataPresent("UniformResourceLocatorW"))
            {
                e.Effect = DragDropEffects.Link;
            }
        }

        /// <summary>IuWFNgRg[̋E𒴂ăhbOƔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="DragEventArgs"/>B</param>
        private void downloadListView_DragOver(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent("UniformResourceLocator") || e.Data.GetDataPresent("UniformResourceLocatorW"))
            {
                e.Effect = DragDropEffects.Link;
            }
        }

        /// <summary>hbOhbv삪Ƃɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="DragEventArgs"/>B</param>
        private void downloadListView_DragDrop(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent("UniformResourceLocator") || e.Data.GetDataPresent("UniformResourceLocatorW"))
            {
                try
                {
                    NicoVideoPageUrl url = new NicoVideoPageUrl(e.Data.GetData(DataFormats.Text).ToString());
                    NicoDownloadItem item = new NicoDownloadItem(url.VideoId, url.VideoId, _config.SaveFullPathFormat, DownloadTarget.Default);
                    _downloadManager.AddItem(Path.Combine(_config.SaveFolderPath, url.VideoId), item);
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message, Application.ProductName);
                }
            }
            else if (e.Data.GetDataPresent(DownloadListView.DragDropItemType))
            {
                _isDownloadListMoved = true;
            }
        }

        /// <summary>}EX{^_uNbNƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="MouseEventArgs"/>B</param>
        private void downloadListView_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left)
            {
                downloadListView_Play();
            }
        }

        /// <summary>L[{[h̃L[Ƃɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="KeyEventArgs"/>B</param>
        private void downloadListView_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Enter)
            {
                downloadListView_Play();
            }
        }

        #endregion

        #region Method

        /// <summary>w̃ACeɑΉt@C̃pX擾܂B</summary>
        /// <param name="item">擾Ώۂ̃ACe\ <see cref="GkListViewItem"/>B</param>
        /// <returns>擾t@C̃pX\ steingB</returns>
        private string GetDownloadFilePath(GkListViewItem item)
        {
            return _downloadManager[item.Name].LocalPath;
        }

        /// <summary>ׂẴACe폜܂B</summary>
        private void downloadListView_ClearItem()
        {
            _downloadManager.Clear();
        }

        /// <summary>tH[JXACe̓Đ܂B</summary>
        private void downloadListView_Play()
        {
            IDownloadItem item = DownloadListView.FocusedItem as IDownloadItem;
            if (item.State == DownloadItemState.Completed)
            {
                if (PlayVideoFile(item.LocalPath) == false)
                {
                    MessageBox.Show(" ID ܂B", Application.ProductName);
                }
            }
       }

        /// <summary>tH[JXACe̎y[W̃uEUŊJ܂B</summary>
        private void downloadListView_PlayByDefaultBrowser()
        {
            IDownloadItem item = DownloadListView.FocusedItem as IDownloadItem;
            Process.Start(string.Format(_nicoApi.Url.WatchInfo, item.VideoId));
        }

        /// <summary>tH[JXACe̎y[W̃uEUŊJ܂B</summary>
        private void downloadListView_PlayByAlternative()
        {
            IDownloadItem item = DownloadListView.FocusedItem as IDownloadItem;
            tabBrowser.TbNavigate(string.Format(_nicoApi.Url.WatchInfo, item.VideoId));
        }

        /// <summary>I𒆂̃ACe̓Ɗ֘At@C폜܂B</summary>
        private void downloadListView_DeleteFile()
        {
            try
            {
                foreach (IDownloadItem item in DownloadListView.SelectedItems)
                {
                    if (item.State == DownloadItemState.Completed)
                    {
                        NicoVideoFile.Delete(item.LocalPath);
                    }
                }

                DownloadListView.Items.RemoveRange(DownloadListView.SelectedItems.ToArray());
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, Application.ProductName);
            }
        }

        /// <summary>I𒆂̃ACe폜܂B</summary>
        private void downloadListView_RemoveItem()
        {
            List<GkListViewItem> deleteItems = new List<GkListViewItem>();

            foreach (IDownloadItem item in DownloadListView.SelectedItems)
            {
                switch (item.State)
                {
                case DownloadItemState.None:
                case DownloadItemState.Completed:
                case DownloadItemState.Cancelled:
                case DownloadItemState.Failed:
                    deleteItems.Add(item as GkListViewItem);
                    break;
                }
            }

            DownloadListView.Items.RemoveRange(deleteItems.ToArray());
        }

        /// <summary>I𒆂̃ACe_E[h܂B</summary>
        /// <param name="target">_E[hΏۂ̃Rec\ <see cref="DownloadTarget"/>B</param>
        private void downloadListView_Download(DownloadTarget target)
        {
            DownloadListView.BeginUpdate();
            foreach (IDownloadItem item in DownloadListView.SelectedItems)
            {
                item.DownloadedSize = 0;
                item.DownloadTime = 0;
                item.Target = target;
                _downloadManager.Start(item.Key);
            }
            DownloadListView.EndUpdate();
        }

        /// <summary>I𒆂̃ACẽ^Cg URL Nbv{[hɃRs[܂B</summary>
        /// <param name="copyTitle">^CgRs[邩ǂ\ boolB</param>
        /// <param name="copyUrl">URL Rs[邩ǂ\ boolB</param>
        private void downloadListView_CopyTitleAndUrl(bool copyTitle, bool copyUrl)
        {
            StringBuilder buffer = new StringBuilder();
            foreach (IDownloadItem item in DownloadListView.SelectedItems)
            {
                if (copyTitle == true)
                {
                    buffer.AppendLine(item.Title);
                }

                if (copyUrl == true)
                {
                    buffer.AppendLine(string.Format(_nicoApi.Url.WatchInfo, item.VideoId));
                }
            }
            Clipboard.SetDataObject(buffer.ToString(), true);
        }

        #endregion

        #endregion
    }
}