using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.Net;
using System.Text;
using System.Threading;
using System.Text.RegularExpressions;
using System.Windows.Forms;

namespace Alternative.Forms
{
    using WebServiceClient.Forms;
    using WebServiceClient.NicoVideo;

    using Alternative.Controls.Browsers;
    using Alternative.Forms;

    public partial class MainForm
    {
        #region saveFolderTreeViewDownloadMenu (u_E[hvm[h)

        /// <summary>u_E[hXg̑SvIƂɔ܂B</summary>
        /// <param name="sender">Cxgs̃IuWFNg</param>
        /// <param name="e">Cxgp[^ێEventArgsIuWFNg</param>
        private void saveFolderTreeViewDownloadMenu_ClearDownloadListItem_Click(object sender, EventArgs e)
        {
            if (MessageBox.Show(this, "{Ƀ_E[hXgSĂ낵łH", "_E[hXg̑S", MessageBoxButtons.OKCancel) == DialogResult.OK)
            {
                _downloadManager.Clear();
            }
        }

        #endregion

        #region saveFolderTreeViewFolderMenu (uۑtH_vm[h)

        /// <summary>j[\钼Oɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="CancelEventArgs"/>B</param>
        private void saveFolderTreeViewFolderMenu_Opening(object sender, CancelEventArgs e)
        {
            if (SaveFolderTreeView.SelectedNode.Name == SaveFolderNodeKey)
            {
                SaveFolderTreeViewFolderMenu.Items["RenameFolder"].Visible = false;
                SaveFolderTreeViewFolderMenu.Items["DeleteFolder"].Visible = false;
            }
            else
            {
                SaveFolderTreeViewFolderMenu.Items["RenameFolder"].Visible = true;
                SaveFolderTreeViewFolderMenu.Items["DeleteFolder"].Visible = true;
            }
        }

        /// <summary>utH_̍쐬vIƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void saveFolderTreeViewFolderMenu_CreateFolder_Click(object sender, EventArgs e)
        {
            string parentPath = GetSaveFolderPath(SaveFolderTreeView.SelectedNode);
            string defaultName = "";
            if (SaveFolderListView.SelectedItems.Count > 0)
            {
                defaultName = SaveFolderListView.SelectedItems[0].Text;
            }

            this.ShowCreateFolderDialog(parentPath, defaultName);
        }

        /// <summary>uOύXvIƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void saveFolderTreeViewFolderMenu_Rename_Click(object sender, EventArgs e)
        {
            SaveFolderTreeView.SelectedNode.BeginEdit();
        }

        /// <summary>utH_폜vIƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void saveFolderTreeViewFolderMenu_DeleteFolder_Click(object sender, EventArgs e)
        {
            try
            {
                Directory.Delete(GetSaveFolderPath(SaveFolderTreeView.SelectedNode), true);
                SaveFolderTreeView.SelectedNode.Remove();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, Application.ProductName);
            }
        }

        /// <summary>uGNXv[ŊJvIƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void saveFolderTreeViewFolderMenu_ShellOpenFolder_Click(object sender, EventArgs e)
        {
            Process.Start("EXPLORER.EXE", @"/e, " + GetSaveFolderPath(SaveFolderTreeView.SelectedNode));
        }

        #endregion

        #region downloadListMenu (u_E[hvuۑtH_vut@Cv)

        /// <summary>j[\钼Oɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="CancelEventArgs"/>B</param>
        private void downloadListViewMenu_Opening(object sender, CancelEventArgs e)
        {
            switch (SaveFolderTreeView.SelectedNode.Name)
            {
            // _E[hXg
            case DownloadNodeKey:
                if (DownloadListView.SelectedItems.Count > 0)
                {
                    bool singleSelected = DownloadListView.SelectedItems.Count == 1;
                    bool downloading = false;
                    bool completed = false;
                    bool stoped = false;

                    foreach (GkListViewItem item in DownloadListView.SelectedItems)
                    {
                        switch ((item as IDownloadItem).State)
                        {
                        case DownloadItemState.Waiting:
                        case DownloadItemState.Start:
                        case DownloadItemState.Processing:
                            downloading = true;
                            break;

                        case DownloadItemState.Completed:
                            completed = true;
                            stoped = true;
                            break;

                        case DownloadItemState.Cancelled:
                        case DownloadItemState.Failed:
                        case DownloadItemState.Pause:
                            stoped = true;
                            break;
                        }

                        if (downloading == true && completed == true)
                        {
                            break;
                        }
                    }

                    DownloadListViewMenu.Items["CancelDownload"].Visible = downloading;
                    DownloadListViewMenu.Items["Play"].Visible = singleSelected && completed;
                    DownloadListViewMenu.Items["PlayByDefaultBrowser"].Visible = singleSelected;
                    DownloadListViewMenu.Items["PlayByAlternative"].Visible = singleSelected;
                    DownloadListViewMenu.Items["Separator1"].Visible = downloading || singleSelected;
                    DownloadListViewMenu.Items["DeleteFile"].Visible = completed;
                    DownloadListViewMenu.Items["RemoveItem"].Visible = true;
                    DownloadListViewMenu.Items["Separator2"].Visible = true;
                    DownloadListViewMenu.Items["Download"].Visible = stoped;
                    DownloadListViewMenu.Items["DownloadVideoOnly"].Visible = stoped;
                    DownloadListViewMenu.Items["Separator3"].Visible = stoped;
                    DownloadListViewMenu.Items["CopyTitleAndUrl"].Visible = true;
                    DownloadListViewMenu.Items["CopyTitle"].Visible = true;
                    DownloadListViewMenu.Items["CopyUrl"].Visible = true;
                    //downloadListViewMenu.Items["Separator4"].Visible = singleSelected;
                    //downloadListViewMenu.Items["PlayWithOtherVideo"].Visible = singleSelected;
                    //downloadListViewMenu.Items["PlayWithOtherComment"].Visible = singleSelected;
                }
                else
                {
                    e.Cancel = true;
                }
                break;

            // 挟
            case SearchFilesNodeKey:
                if (SearchResultListView.SelectedItems.Count > 0)
                {
                    bool singleSelected = SearchResultListView.SelectedItems.Count == 1;

                    DownloadListViewMenu.Items["CancelDownload"].Visible = false;
                    DownloadListViewMenu.Items["Play"].Visible = singleSelected;
                    DownloadListViewMenu.Items["PlayByDefaultBrowser"].Visible = singleSelected;
                    DownloadListViewMenu.Items["PlayByAlternative"].Visible = singleSelected;
                    DownloadListViewMenu.Items["Separator1"].Visible = singleSelected;
                    DownloadListViewMenu.Items["DeleteFile"].Visible = true;
                    DownloadListViewMenu.Items["RemoveItem"].Visible = false;
                    DownloadListViewMenu.Items["Separator2"].Visible = true;
                    DownloadListViewMenu.Items["Download"].Visible = true;
                    DownloadListViewMenu.Items["DownloadVideoOnly"].Visible = true;
                    DownloadListViewMenu.Items["Separator3"].Visible = true;
                    DownloadListViewMenu.Items["CopyTitleAndUrl"].Visible = true;
                    DownloadListViewMenu.Items["CopyTitle"].Visible = true;
                    DownloadListViewMenu.Items["CopyUrl"].Visible = true;
                    //downloadListViewMenu.Items["Separator4"].Visible = true;
                    //downloadListViewMenu.Items["PlayWithOtherVideo"].Visible = singleSelected;
                    //downloadListViewMenu.Items["PlayWithOtherComment"].Visible = singleSelected;
                }
                else
                {
                    e.Cancel = true;
                }
                break;

            // ۑtH_
            default:
                if (SaveFolderListView.SelectedItems.Count > 0)
                {
                    bool singleSelected = SaveFolderListView.SelectedItems.Count == 1;

                    DownloadListViewMenu.Items["CancelDownload"].Visible = false;
                    DownloadListViewMenu.Items["Play"].Visible = singleSelected;
                    DownloadListViewMenu.Items["PlayByDefaultBrowser"].Visible = singleSelected;
                    DownloadListViewMenu.Items["PlayByAlternative"].Visible = singleSelected;
                    DownloadListViewMenu.Items["Separator1"].Visible = singleSelected;
                    DownloadListViewMenu.Items["DeleteFile"].Visible = true;
                    DownloadListViewMenu.Items["RemoveItem"].Visible = false;
                    DownloadListViewMenu.Items["Separator2"].Visible = true;
                    DownloadListViewMenu.Items["Download"].Visible = true;
                    DownloadListViewMenu.Items["DownloadVideoOnly"].Visible = true;
                    DownloadListViewMenu.Items["Separator3"].Visible = true;
                    DownloadListViewMenu.Items["CopyTitleAndUrl"].Visible = true;
                    DownloadListViewMenu.Items["CopyTitle"].Visible = true;
                    DownloadListViewMenu.Items["CopyUrl"].Visible = true;
                    //downloadListViewMenu.Items["Separator4"].Visible = true;
                    //downloadListViewMenu.Items["PlayWithOtherVideo"].Visible = singleSelected;
                    //downloadListViewMenu.Items["PlayWithOtherComment"].Visible = singleSelected;
                }
                else
                {
                    e.Cancel = true;
                }
                break;
            }
        }

        /// <summary>uLZvIƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void downloadListMenu_CancelDownload_Click(object sender, EventArgs e)
        {
            IDownloadItem item = DownloadListView.SelectedItems[0] as IDownloadItem;
            _downloadManager.Cancel(item.Key);
        }

        /// <summary>uĐvIƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void downloadListMenu_Play_Click(object sender, EventArgs e)
        {
            switch (SaveFolderTreeView.SelectedNode.Name)
            {
            // _E[hXg
            case DownloadNodeKey:
                downloadListView_Play();
                break;

            // 挟
            case SearchFilesNodeKey:
                searchResultListView_Play();
                break;

            // ۑtH_
            default:
                saveFolderListView_Play();
                break;
            }
        }

        /// <summary>ũuEUŌJvIƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void downloadListMenu_PlayByDefaultBrowser_Click(object sender, EventArgs e)
        {
            switch (SaveFolderTreeView.SelectedNode.Name)
            {
            // _E[hXg
            case DownloadNodeKey:
                downloadListView_PlayByDefaultBrowser();
                break;

            // 挟
            case SearchFilesNodeKey:
                searchResultListView_PlayByDefaultBrowser();
                break;

            // ۑtH_
            default:
                saveFolderListView_PlayByDefaultBrowser();
                break;
            }
        }

        /// <summary>uALTERNATIVE ŌJvIƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void downloadListMenu_PlayByAlternative_Click(object sender, EventArgs e)
        {
            switch (SaveFolderTreeView.SelectedNode.Name)
            {
            // _E[hXg
            case DownloadNodeKey:
                downloadListView_PlayByAlternative();
                break;

            // 挟
            case SearchFilesNodeKey:
                searchResultListView_PlayByAlternative();
                break;

            // ۑtH_
            default:
                saveFolderListView_PlayByAlternative();
                break;
            }
        }

        /// <summary>ut@C폜vIƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void downloadListMenu_DeleteFile_Click(object sender, EventArgs e)
        {
            if (MessageBox.Show(this, "{Ƀt@C폜Ă낵łH", "t@C폜", MessageBoxButtons.OKCancel) == DialogResult.OK)
            {
                switch (SaveFolderTreeView.SelectedNode.Name)
                {
                // _E[hXg
                case DownloadNodeKey:
                    downloadListView_DeleteFile();
                    break;

                // 挟
                case SearchFilesNodeKey:
                    searchResultListView_DeleteFile();
                    break;

                // ۑtH_
                default:
                    saveFolderListView_DeleteFile();
                    break;
                }
            }
        }

        /// <summary>uXgvIƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void downloadListMenu_RemoveItem_Click(object sender, EventArgs e)
        {
            downloadListView_RemoveItem();
        }

        /// <summary>u_E[h̍ĎsvIƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void downloadListMenu_Download_Click(object sender, EventArgs e)
        {
            switch (SaveFolderTreeView.SelectedNode.Name)
            {
            // _E[hXg
            case DownloadNodeKey:
                downloadListView_Download(DownloadTarget.Default);
                break;

            // 挟
            case SearchFilesNodeKey:
                searchResultListView_Download(DownloadTarget.Default);
                break;

            // ۑtH_
            default:
                saveFolderListView_Download(DownloadTarget.Default);
                break;
            }

            SaveFolderTreeView.SelectedNode = SaveFolderTreeView.Nodes[DownloadNodeKey];
        }

        /// <summary>u悾_E[hĎsvIƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void downloadListMenu_DownloadVideoOnly_Click(object sender, EventArgs e)
        {
            switch (SaveFolderTreeView.SelectedNode.Name)
            {
            // _E[hXg
            case DownloadNodeKey:
                downloadListView_Download(DownloadTarget.Video);
                break;

            // 挟
            case SearchFilesNodeKey:
                searchResultListView_Download(DownloadTarget.Video);
                break;

            // ۑtH_
            default:
                saveFolderListView_Download(DownloadTarget.Video);
                break;
            }

            SaveFolderTreeView.SelectedNode = SaveFolderTreeView.Nodes[DownloadNodeKey];
        }

        /// <summary>u^CgURLRs[vIƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void downloadListMenu_CopyTitleAndUrl_Click(object sender, EventArgs e)
        {
            switch (SaveFolderTreeView.SelectedNode.Name)
            {
            // _E[hXg
            case DownloadNodeKey:
                downloadListView_CopyTitleAndUrl(true, true);
                break;

            // 挟
            case SearchFilesNodeKey:
                searchResultListView_CopyTitleAndUrl(true, true);
                break;

            // ۑtH_
            default:
                saveFolderListView_CopyTitleAndUrl(true, true);
                break;
            }
        }

        /// <summary>u^CgRs[vIƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void downloadListMenu_CopyTitle_Click(object sender, EventArgs e)
        {
            switch (SaveFolderTreeView.SelectedNode.Name)
            {
            // _E[hXg
            case DownloadNodeKey:
                downloadListView_CopyTitleAndUrl(true, false);
                break;

            // 挟
            case SearchFilesNodeKey:
                searchResultListView_CopyTitleAndUrl(true, false);
                break;

            // ۑtH_
            default:
                saveFolderListView_CopyTitleAndUrl(true, false);
                break;
            }
        }

        /// <summary>uURLRs[vIƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void downloadListMenu_CopyUrl_Click(object sender, EventArgs e)
        {
            switch (SaveFolderTreeView.SelectedNode.Name)
            {
            // _E[hXg
            case DownloadNodeKey:
                downloadListView_CopyTitleAndUrl(false, true);
                break;

            // 挟
            case SearchFilesNodeKey:
                searchResultListView_CopyTitleAndUrl(false, true);
                break;

            // ۑtH_
            default:
                saveFolderListView_CopyTitleAndUrl(false, true);
                break;
            }
        }

        /// <summary>ut@CւčĐvIƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void downloadListMenu_PlayWithOtherVideo_Click(object sender, EventArgs e)
        {
            //MessageBox.Show("ut@CւčĐvF(vȂ)");
        }

        /// <summary>uRgt@CւčĐvIƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void downloadListMenu_PlayWithOtherComment_Click(object sender, EventArgs e)
        {
            //MessageBox.Show("uRgt@CւčĐvF(vȂ)");
        }

        #endregion
    }
}
