using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.IO;
using System.IO.Compression;
using System.Net;
using System.Text;
using System.Threading;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using System.Xml;
using System.Xml.Serialization;

namespace Alternative.Forms
{
    using WebServiceClient;
    using WebServiceClient.Forms;
    using WebServiceClient.NicoVideo;
    using Alternative.Controls.Browsers;
    using Alternative.Win32;

    public partial class MainForm : Form
    {
        #region Constant

        /// <summary>AvP[Vݒt@C̕ۑpX\ stringB</summary>
        private static readonly string ConfigFolderPath = Path.Combine(Application.StartupPath, "config");
        /// <summary>AvP[Vݒt@C̕ۑpX\ stringB</summary>
        private static readonly string ConfigFilePath = Path.Combine(ConfigFolderPath, "alternative.xml");
        /// <summary>Cɓݒt@C̕ۑpX\ stringB</summary>
        private static readonly string FavoriteFilePath = Path.Combine(ConfigFolderPath, "favorite.xml");
        /// <summary>_E[hXg̕ۑpX\ stringB</summary>
        private static readonly string DownloadFilePath = Path.Combine(ConfigFolderPath, "download.xml");
        /// <summary>Xg̕ۑpX\ stringB</summary>
        private static readonly string HistoryFilePath = Path.Combine(ConfigFolderPath, "history.xml");
        /// <summary>ŋߕ^uXg̕ۑpX\ stringB</summary>
        private static readonly string ClosedTabFilePath = Path.Combine(ConfigFolderPath, "closedtab.xml");
        /// <summary>EBhȄԕۑt@C̕ۑpX\ stringB</summary>
        private static readonly string WindowStateFilePath = Path.Combine(ConfigFolderPath, "window.xml");

        #endregion

        #region Field

        /// <summary>AvP[Vݒ񋟂 <see cref="AlternativeConfig"/>B</summary>
        private AlternativeConfig _config;
        /// <summary>jRjR API փANZXi񋟂 <see cref="NicoApiClient"/>B</summary>
        private NicoApiClient _nicoApi = NicoApiClient.Instance;
        /// <summary>̃_E[h^XNǗ@\񋟂 <see cref="NicoDownloadManager"/>B</summary>
        private NicoDownloadManager _downloadManager;

        #endregion

        #region Constructor

        /// <summary>CX^X܂B</summary>
        public MainForm()
        {
            // Rg[̏
            InitializeComponent();

            // fUCiŐݒłȂRg[̐ݒ
            SideBarTab.ImageList = GlobalImages.GlobalListA;
            FavoriteTabPage.ImageKey = GlobalImages.IKEY_A_FAVORITE;
            HistoryTabPage.ImageKey = GlobalImages.IKEY_A_PAGE;

            DownloadListView.Dock = DockStyle.Fill;
            SaveFolderListView.Dock = DockStyle.Fill;
            SearchResultListView.Dock = DockStyle.Fill;

            // AvP[Vݒ̓ǂݍ
            if (File.Exists(ConfigFilePath) == true)
            {
                _config = XmlDeserialize<AlternativeConfig>(ConfigFilePath, "AlternativeConfigRoot");
                if (_config == null)
                {
                    MessageBox.Show("ݒt@Cǂݍ߂܂łB", Application.ProductName);
                }
            }

            if (_config == null)
            {
                _config = new AlternativeConfig();
            }

            // vLVT[o[̐ݒ
            switch (_config.ProxySetting)
            {
            case ProxySetting.None:
                Urlmon.InternetOptionProxy(InternetOpenType.INTERNET_OPEN_TYPE_DIRECT);
                break;
            case ProxySetting.InternetExplorer:
                Urlmon.InternetOptionProxy(InternetOpenType.INTERNET_OPEN_TYPE_PRECONFIG);
                break;
            case ProxySetting.Custom:
                Urlmon.InternetOptionProxy(InternetOpenType.INTERNET_OPEN_TYPE_PROXY, _config.ProxyAddress + ":" + _config.ProxyPort, "");
                break;
            }
        }

        #endregion

        #region Event Handlers

        /// <summary>tH[[hƔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        void MainForm_Load(object sender, EventArgs e)
        {
            // _E[hc[r[̏
            InitializeSaveFolderTreeView();

            // _E[hXg̏
            InitializeDownloadListView();

            // ^uuEȔ
            this.tabBrowser.SetSetting(_config.TabBrowserSetting);
            if (File.Exists(ClosedTabFilePath) == true)
            {
                if (tabBrowser.LoadClosedTabHistory(ClosedTabFilePath) == false)
                {
                    MessageBox.Show("ݒt@Cǂݍ߂܂łB", Application.ProductName);
                }
            }

            // API ̏
            InitiaizeNicoService();

            // Cɓݒ̓ǂݍ
            if (File.Exists(FavoriteFilePath))
            {
                FavoriteTreeView.FvLoadFavorite(FavoriteFilePath);
            }

            // ̏
            if (File.Exists(HistoryFilePath))
            {
                HistoryListView.Items.XmlDeserialize(HistoryFilePath);
            }

            // EBhȄԂ𕜋A
            RestoreWindowState();
        }

        /// <summary>tH[ŏɕ\Ƃɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void MainForm_Shown(object sender, EventArgs e)
        {
            // OC_CAO\
            using (LoginForm form = new LoginForm())
            {
                form.AlternativeConfig = _config;
                form.NicoApiClient = _nicoApi;
                form.ShowDialog(this);
            }

            if (_nicoApi.LoggedIn)
            {
                // OCς݂̏ꍇ͒fĂACẽ_E[hJn
                foreach (IDownloadItem item in DownloadListView.Items)
                {
                    if (item.State == DownloadItemState.Pause)
                    {
                        item.State = DownloadItemState.Waiting;
                    }
                }
            }
            else
            {
                // OCĂȂꍇ͒fĂACẽ_E[hLZ
                foreach (IDownloadItem item in DownloadListView.Items)
                {
                    if (item.State == DownloadItemState.Pause)
                    {
                        item.State = DownloadItemState.Cancelled;
                    }
                }
            }

            // N̐ݒ蓮s
            switch (_config.StartUpAction)
            {
            case StartUpAction.OpenPreviousTab:
                this.tabBrowser.RestoreTabsOnStartup(RestoreClosedTabFlags.OnExit);
                break;
            case StartUpAction.OpenLockTab:
                this.tabBrowser.RestoreTabsOnStartup(RestoreClosedTabFlags.OnExit | RestoreClosedTabFlags.OnlyLocked);
                break;
            case StartUpAction.OpenHomeUrl:
                this.tabBrowser.TbOpenNewTab(_config.HomeUrl);
                break;
            }

            // ^uPJĂȂ̓gbvy[WJ
            if (tabBrowser.TbTabCount == 0)
            {
                tabBrowser.TbOpenNewTab(_config.HomeUrl);
            }
        }

        /// <summary>Formꂽ̃CxgłB</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="FormClosedEventArgs"/>B</param>
        void MainForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            // ݒt@Cp̃tH_ꍇ͍쐬
            if (Directory.Exists(ConfigFolderPath) == false)
            {
                Directory.CreateDirectory(ConfigFolderPath);
            }

            // EBhȄԂۑ
            StoreWindowState();

            // ʂ̏Ԃۑ璼ɔ\ɂ
            Visible = false;

            // ŋߕ^u̕ۑ
            tabBrowser.TbHostApplicationExit();
            tabBrowser.SaveClosedTabHistory(ClosedTabFilePath);

            // AvP[Vݒ̕ۑ
            _config.TabBrowserSetting = tabBrowser.Setting;
            XmlSerialize(_config, ConfigFilePath);

            // Cɓ̕ۑ
            FavoriteTreeView.FvSaveFavorite(FavoriteFilePath);

            // ̕ۑ
            HistoryListView.Items.XmlSerialize(HistoryFilePath);

            // _E[hXg̕ۑ
            _downloadManager.XmlSerialize(DownloadFilePath);
        }

        #endregion

        #region Serialize

        /// <summary>IuWFNgXMLt@CfVACY܂B</summary>
        /// <typeparam name="T">fVACYf[^^B</typeparam>
        /// <param name="path">XML t@C̃pX\ stringB</param>
        /// <param name="root">XML t@C̃[gm[h\ stringB</param>
        /// <returns>fVACYŎ擾CX^XB</returns>
        public T XmlDeserialize<T>(string path, string rootName)
        {
            T result = default(T);

            try
            {
                result = SerializeHelper.XmlDeserialize<T>(path, false, false, new XmlRootAttribute(rootName));
            }
            catch
            {
            }

            return result;
        }

        /// <summary>CX^X XML `ŃVACY܂B</summary>
        /// <param name="source">VACYIuWFNgB</param>
        /// <param name="path">XML t@C̃pX\ stringB</param>
        /// <returns>VACYɐꍇ <see langword="true"/>AȊȌꍇ <see langword="false"/>B</returns>
        public bool XmlSerialize(object source, string path)
        {
            try
            {
                SerializeHelper.XmlSerialize(source, path);
                return true;
            }
            catch
            {
                return false;
            }
        }

        #endregion

        #region Methods

        /// <summary>w̃TCgANeBuȃ^uŕ\܂B</summary>
        /// <param name="url">TCg URL \ stringB</param>
        public void LocationUrl(string url)
        {
            tabBrowser.TbNavigate(url);
        }

        /// <summary>w̓t@C_E[h܂B</summary>
        /// <param name="url">y[W URL \ stringB</param>
        /// <param name="title">̃^Cg\ stringB</param>
        public void DownloadUrl(string url, string title)
        {
            VideoPageUrl pUrl = VideoPageUrlCreator.CreateUrl(url);

            if (pUrl is NicoVideoPageUrl)
            {
                NicoVideoPageUrl nicoUrl = (pUrl as NicoVideoPageUrl);
                string videoId = nicoUrl.VideoId;
                title = nicoUrl.VideoId ?? "Unknown title";
                string format = _config.SaveFullPathFormat;
                DownloadTarget target = DownloadTarget.Default;
                string itemKey = Path.Combine(_config.SaveFolderPath, videoId);
                IDownloadItem downItem = null;

                // Ƀ_E[hXgɑ݂ꍇ͒ǉɗp
                if (_downloadManager.Contains(itemKey) == true)
                {
                    downItem = _downloadManager[itemKey];
                    switch (downItem.State)
                    {
                    case DownloadItemState.Start:
                    case DownloadItemState.Waiting:
                    case DownloadItemState.Processing:
                    case DownloadItemState.Pause:
                        MessageBox.Show("Ƀ_E[ho^Ă܂B", Application.ProductName);
                        return;
                    }
                }

                // d`FbN
                if (ShowDownFileExistDialog(videoId) == false)
                {
                    return;
                }

                // _E[hACeo^
                if (downItem != null)
                {
                    _downloadManager.RemoveItem(itemKey);
                    _downloadManager.AddItem(itemKey, downItem);
                }
                else
                {
                    downItem = new NicoDownloadItem(videoId, title, format, target);
                    _downloadManager.AddItem(itemKey, downItem);
                }

                _downloadManager.Start(downItem);
                SaveFolderTreeView.SelectedNode = SaveFolderTreeView.Nodes[DownloadNodeKey];
            }
            else
            {
                MessageBox.Show("URL̃_E[h̓T|[g܂B", Application.ProductName);
            }
        }

        /// <summary>NicoApiClient ̃CX^X܂B</summary>
        private void InitiaizeNicoService()
        {
            _nicoApi.Invoker = this;
            _nicoApi.MaxExecution = _config.MaxDownloadConnections * 2;
            _nicoApi.SetTaskExecution(NicoRequestType.DownloadVideo, _config.MaxDownloadConnections);
            _nicoApi.SetTaskWaitTimeAll(1000);
            _nicoApi.SetTaskWaitTime(NicoRequestType.DownloadVideo, 3000);
            _nicoApi.SetRequestWaitTimeAll(250);
            _nicoApi.Interval = 1000;

            // API ƃuEU2RlNV킹őlݒ肷
            if (ServicePointManager.DefaultConnectionLimit < _nicoApi.MaxExecution + 2)
            {
                ServicePointManager.DefaultConnectionLimit = _nicoApi.MaxExecution + 2;
            }
        }

        /// <summary>_E[hXg܂B</summary>
        private void InitializeDownloadListView()
        {
            IDownloadItemCollection items = new NicoDownloadItemCollection(DownloadListView.Items);
            IDownloadView view = new NicoDownloadView(DownloadListView);
            _downloadManager = new NicoDownloadManager(_nicoApi, items);
            _downloadManager.RegisterView(view);
            _downloadManager.MaxRequest = _config.MaxDownloadConnections;

            if (File.Exists(DownloadFilePath) == true)
            {
                if (_downloadManager.XmlDeserialize(DownloadFilePath) == true)
                {
                    foreach (IDownloadItem item in DownloadListView.Items)
                    {
                        switch (item.State)
                        {
                        case DownloadItemState.Start:
                        case DownloadItemState.Waiting:
                        case DownloadItemState.Processing:
                            item.State = DownloadItemState.Pause;
                            break;
                        }
                    }
                }
            }

            _downloadManager.Start();
        }

        /// <summary>t@CĐ܂B</summary>
        /// <param name="path">t@C̃pX\ stringB</param>
        /// <returns>Đoꍇ <see langword="true"/>AȊȌꍇ <see langword="false"/>B</returns>
        private bool PlayVideoFile(string path)
        {
            if (string.Compare(Path.GetExtension(path), ".swf", true) == 0)
            {
                if (_config.UseSwfPlayer == true)
                {
                    Process.Start(_config.SwfPlayerPath, "\"" + path + "\"");
                    return true;
                }
                else
                {
                    return ShowWatchPageByAlternative(path);
                }
            }
            else
            {
                if (_config.UseOtherPlayer == true)
                {
                    Process.Start(_config.OtherPlayerPath, "\"" + path + "\"");
                    return true;
                }
                else
                {
                    return ShowWatchPageByAlternative(path);
                }
            }
        }

        /// <summary>w蓮̎y[W̃uEUŊJ܂B</summary>
        /// <param name="path">t@C̃pX\ stringB</param>
        /// <returns>\oꍇ <see langword="true"/>AȊȌꍇ <see langword="false"/>B</returns>
        private bool ShowWatchPageByDefaultBrowser(string path)
        {
            try
            {
                string videoId = NicoVideoFile.GetVideoId(path);
                if (videoId != "")
                {
                    Process.Start(string.Format(_nicoApi.Url.WatchInfo, videoId));
                    return true;
                }
            }
            catch { }

            return false;
        }

        /// <summary>w蓮̎y[W̃uEUŊJ܂B</summary>
        /// <param name="path">t@C̃pX\ stringB</param>
        /// <returns>\oꍇ <see langword="true"/>AȊȌꍇ <see langword="false"/>B</returns>
        private bool ShowWatchPageByAlternative(string path)
        {
            try
            {
                string videoId = NicoVideoFile.GetVideoId(path);
                if (videoId != "")
                {
                    tabBrowser.TbNavigate(string.Format(_nicoApi.Url.WatchInfo, videoId));
                    return true;
                }
            }
            catch { }

            return false;
        }

        /// <summary>d_E[hmF_CAO\܂B</summary>
        /// <param name="videoId"> ID \ stringB</param>
        /// <returns>_E[hKvꍇ <see langword="true"/>AȊȌꍇ <see langword="false"/>B</returns>
        private bool ShowDownFileExistDialog(string videoId)
        {
            List<NicoVideoFile> files = NicoVideoFile.FindVideoFiles(_config.SaveFolderPath, videoId, SearchOption.AllDirectories);
            if (files.Count == 0)
            {
                return true;
            }

            using (DownFileExistDialog dialog = new DownFileExistDialog())
            {
                dialog.Files = files;
                dialog.ShowDialog(this);

                switch (dialog.Action)
                {
                case DownFileExistDialogAction.Download:
                    return true;

                case DownFileExistDialogAction.Play:
                    if (PlayVideoFile(dialog.PlayVideoPath) == false)
                    {
                        MessageBox.Show("ID܂B", Application.ProductName);
                    }
                    return false;

                case DownFileExistDialogAction.Cancel:
                    return false;
                }
            }

            return false;
        }

        #endregion

        #region ToolStrip֘A

        #region +---- ToolStrip Event Handlers

        /// <summary></summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void MainToolStrip_Resize(object sender, EventArgs e)
        {
            int width = MainToolStrip.Width;
            foreach (ToolStripItem item in MainToolStrip.Items)
            {
                if (ToolStripUrlTextBox != item)
                {
                    width -= item.Width + 4;
                }
            }

            ToolStripUrlTextBox.Width = Math.Max(width, 50);
        }

        private void ToolStripBackButton_Click(object sender, EventArgs e)
        {
            tabBrowser.TbGoBack();
        }

        /// <summary></summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ToolStripBackButton_MouseDown(object sender, MouseEventArgs e)
        {
            if (tabBrowser.TbSelectedIsBrowser)
            {
                if (e.Button == MouseButtons.Right)
                {
                    tabBrowser.TbShowNavigateHistory(Cursor.Position, true);
                }
            }
        }

        /// <summary></summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ToolStripForwardButton_Click(object sender, EventArgs e)
        {
            tabBrowser.TbGoForward();
        }

        /// <summary></summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ToolStripForwardButton_MouseDown(object sender, MouseEventArgs e)
        {
            if (tabBrowser.TbSelectedIsBrowser)
            {
                if (e.Button == MouseButtons.Right)
                {
                    tabBrowser.TbShowNavigateHistory(Cursor.Position, false);
                }
            }
        }

        /// <summary></summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ToolStripAbortButton_Click(object sender, EventArgs e)
        {
            tabBrowser.TbStop();
        }

        /// <summary></summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ToolStripRefreshButton_Click(object sender, EventArgs e)
        {
            tabBrowser.TbRefresh();
        }

        /// <summary></summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ToolStripHomeButton_Click(object sender, EventArgs e)
        {
            tabBrowser.TbNavigate(_config.HomeUrl);
        }

        /// <summary></summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ToolStripFavoriteButton_Click(object sender, EventArgs e)
        {
            if (ToolStripFavoriteButton.Checked == true)
            {
                ShowFavoriteMenu.Checked = true;
                ShowFavorite2Menu.Checked = true;
                ShowHistoryMenu.Checked = false;
                ToolStripHistoryButton.Checked = false;

                SideBarTab.SelectedIndex = 0;
                AppearSidePanel(true);
            }
            else
            {
                ShowFavoriteMenu.Checked = false;
                ShowFavorite2Menu.Checked = false;
                AppearSidePanel(false);
            }
        }

        /// <summary></summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ToolStripHistoryButton_Click(object sender, EventArgs e)
        {
            if (ToolStripHistoryButton.Checked == true)
            {
                ShowHistoryMenu.Checked = true;
                ShowFavoriteMenu.Checked = false;
                ShowFavorite2Menu.Checked = false;
                ToolStripFavoriteButton.Checked = false;

                AppearSidePanel(true);
                SideBarTab.SelectedIndex = 1;
            }
            else
            {
                ShowHistoryMenu.Checked = false;
                AppearSidePanel(false);
            }
        }

        /// <summary></summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ToolStripDownloadListButton_Click(object sender, EventArgs e)
        {
            AppearUnderPanel(this.ToolStripDownloadListButton.Checked);
        }

        /// <summary></summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ToolStripDownloadButton_Click(object sender, EventArgs e)
        {
            DownloadUrl(tabBrowser.TbUrl, tabBrowser.TbTitle);
        }

        /// <summary></summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ToolStripSearchComboBox_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == '\r')
            {
                e.Handled = true;
                if (ToolStripSearchComboBox.Text != "")
                {
                    NavigateToSearchPage(ToolStripSearchComboBox.Text);
                }
            }
        }

        /// <summary></summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ToolStripSearchButton_Click(object sender, EventArgs e)
        {
            if (ToolStripSearchComboBox.Text != "")
            {
                string stxt = ToolStripSearchComboBox.Text;

                for (int i = 0; i < ToolStripSearchComboBox.Items.Count; i++)
                {
                    if (stxt.Equals((string)ToolStripSearchComboBox.Items[i]))
                    {
                        ToolStripSearchComboBox.Items.RemoveAt(i);
                        break;
                    }
                }
                while (ToolStripSearchComboBox.Items.Count >= ToolStripSearchComboBox.MaxDropDownItems)
                {
                    ToolStripSearchComboBox.Items.RemoveAt(ToolStripSearchComboBox.Items.Count - 1);
                }
                ToolStripSearchComboBox.Items.Insert(0, stxt);

                NavigateToSearchPage(stxt);
            }
        }

        /// <summary></summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ToolStripUrlTextBox_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == '\r')
            {
                e.Handled = true;
                if (ToolStripUrlTextBox.Text != "")
                {
                    NavigateByUrlTextbox();
                }
            }
        }

        /// <summary></summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ToolStripUrlButton_Click(object sender, EventArgs e)
        {
            NavigateByUrlTextbox();
        }

        #endregion

        /// <summary></summary>
        /// <param name="searchText"></param>
        private void NavigateToSearchPage(string searchText)
        {
            if ((searchText == null) || (searchText.Equals(String.Empty))) return;
            this.AddURLToComboBox(this.ToolStripSearchComboBox, searchText);
            this.tabBrowser.TbNavigate(_nicoApi.Url.GetKeywordVideoSearch(searchText));
        }

        /// <summary></summary>
        private void NavigateByUrlTextbox()
        {
            if (this.ToolStripUrlTextBox.Text != String.Empty)
            {
                this.tabBrowser.TbNavigate(this.ToolStripUrlTextBox.Text);
            }
        }

        /// <summary></summary>
        /// <param name="comboBox"></param>
        /// <param name="addText"></param>
        private void AddURLToComboBox(ToolStripComboBox comboBox, string addText)
        {
            if (comboBox.Items.Contains(addText)) comboBox.Items.RemoveAt(comboBox.Items.IndexOf(addText));

            comboBox.Items.Insert(0, addText);

            if (comboBox.Items.Count > comboBox.MaxDropDownItems)
            {
                comboBox.Items.RemoveAt(comboBox.Items.Count - 1);
            }
        }

        #endregion

        #region MainForm ԕۑp

        /// <summary>EBhȄԂۑ܂B</summary>
        private void StoreWindowState()
        {
            WindowStateValues state = new WindowStateValues();

            state.Location = Location;
            state.Size = Size;
            state.WindowState = WindowState;

            state.SidePanelWidth = SidePanel.Width;
            state.UnderPanelHeight = UnderPanel.Height;
            state.FolderTreeWidth = SaveFolderTreeView.Width;

            state.ShowFavoriteList = ShowFavoriteMenu.Checked;
            state.ShowHistoryList = ShowHistoryMenu.Checked;
            state.ShowFolderTree = ShowDownloadListMenu.Checked;

            state.DownloadListColumns = StoreColumnsState(DownloadListView);
            state.SaveFolderColumns = StoreColumnsState(SaveFolderListView);
            state.SearchResultColumns = StoreColumnsState(SearchResultListView);

            SerializeHelper.XmlSerialize(state, WindowStateFilePath);
        }

        /// <summary>Xgr[Jwb_̏Ԃ擾܂B</summary>
        /// <param name="listView">Ώۂ̃Xgr[\ <see cref="GkListView"/>B</param>
        /// <returns>Jwb_̏Ԃ\ <see cref="ColumnState">ColumnState[]</see>B</returns>
        private ColumnState[] StoreColumnsState(GkListView listView)
        {
            ColumnState[] result = new ColumnState[listView.Columns.Count];
            for (int i = 0; i < listView.Columns.Count; i++)
            {
                result[i].Width = listView.Columns[i].Width;
                result[i].DisplayIndex = listView.Columns[i].DisplayIndex;
            }
            return result;
        }

        /// <summary>EBhȄԂ𕜌܂B</summary>
        private void RestoreWindowState()
        {
            if (File.Exists(WindowStateFilePath) == true)
            {
                WindowStateValues state = SerializeHelper.XmlDeserialize<WindowStateValues>(WindowStateFilePath);

                WindowState = state.WindowState;
                Location = state.Location;
                Size = state.Size;

                SidePanel.Width = state.SidePanelWidth;
                UnderPanel.Height = state.UnderPanelHeight;
                SaveFolderTreeView.Width = state.FolderTreeWidth;

                if (state.ShowFavoriteList == true)
                {
                    ShowFavoriteMenu.Checked = true;
                    ShowFavoriteMenu_Click(ShowFavoriteMenu, new EventArgs());
                }

                if (state.ShowHistoryList == true)
                {
                    ShowHistoryMenu.Checked = true;
                    ShowHistoryMenu_Click(ShowHistoryMenu, new EventArgs());
                }

                if (state.ShowFolderTree == true)
                {
                    ShowDownloadListMenu.Checked = true;
                    ShowDownloadListMenu_Click(ShowDownloadListMenu, new EventArgs());
                }

                RestoreColumnsState(DownloadListView, state.DownloadListColumns);
                RestoreColumnsState(SaveFolderListView, state.SaveFolderColumns);
                RestoreColumnsState(SearchResultListView, state.SearchResultColumns);
            }
        }

        /// <summary>Xgr[Jwb_̏Ԃ𕜌܂B</summary>
        /// <param name="listView">Ώۂ̃Xgr[\ <see cref="GkListView"/>B</param>
        /// <param name="state">Jwb_̏Ԃ\ <see cref="ColumnState">ColumnState[]</see>B</param>
        private void RestoreColumnsState(GkListView listView, ColumnState[] state)
        {
            for (int i = 0; i < state.Length; i++)
            {
                listView.Columns[i].Width = state[i].Width;
                listView.Columns[i].DisplayIndex = state[i].DisplayIndex;
            }
        }

        /// <summary>Jwb_̏Ԃi[܂B</summary>
        [Serializable]
        [XmlType("ColumnStateRoot")]
        public struct ColumnState
        {
            #region Field

            /// <summary>Jwb_̕\ intB</summary>
            [XmlElement("Width", typeof(int), IsNullable = false)]
            public int Width;
            /// <summary>\\ intB</summary>
            [XmlElement("DisplayIndex", typeof(int), IsNullable = false)]
            public int DisplayIndex;

            #endregion
        }

        /// <summary>EBhȄԂi[܂B</summary>
        [Serializable]
        [XmlType("WindowStateValuesRoot")]
        public class WindowStateValues
        {
            #region Field

            /// <summary>tH[̈ʒu\ <see cref="Point"/>B</summary>
            [XmlElement("Location", typeof(Point), IsNullable = false)]
            private Point _location;
            /// <summary>tH[̃TCY\ <see cref="Size"/>B</summary>
            [XmlElement("Size", typeof(Size), IsNullable = false)]
            private Size _size;
            /// <summary>tH[̃EBhEԂ\ <see cref="FormWindowState"/>B</summary>
            [XmlElement("Size", typeof(Size), IsNullable = false)]
            private FormWindowState _windowState;

            /// <summary>[pl̕\ intB</summary>
            [XmlElement("SidePanelWidth", typeof(int), IsNullable = false)]
            private int _sidePanelWidth;
            /// <summary>[pl̍\ intB</summary>
            [XmlElement("UnderPanelHeight", typeof(int), IsNullable = false)]
            private int _underPanelHeight;
            /// <summary>tH_c[r[̕\ intB</summary>
            [XmlElement("FolderTreeWidth", typeof(int), IsNullable = false)]
            private int _folderTreeWidth;

            /// <summary>Cɓ̕\Ԃ\ boolB</summary>
            [XmlElement("ShowFavoriteList", typeof(bool), IsNullable = false)]
            private bool _showFavoriteList;
            /// <summary>̕\Ԃ\ boolB</summary>
            [XmlElement("ShowHistoryList", typeof(bool), IsNullable = false)]
            private bool _showHistoryList;
            /// <summary>tH_c[̕\Ԃ\ boolB</summary>
            [XmlElement("ShowFolderTree", typeof(bool), IsNullable = false)]
            private bool _showFolderTree;

            /// <summary>_E[hXgJwb_̏Ԃ\ ColumnState[]B</summary>
            [XmlElement("DownloadListColumns", typeof(ColumnState[]), IsNullable = false)]
            private ColumnState[] _downloadListColumns;
            /// <summary>ۑtH_Jwb_̏Ԃ\ ColumnState[]B</summary>
            [XmlElement("SaveFolderColumns", typeof(ColumnState[]), IsNullable = false)]
            private ColumnState[] _saveFolderColumns;
            /// <summary>ʃJwb_̏Ԃ\ ColumnState[]B</summary>
            [XmlElement("SearchResultColumns", typeof(ColumnState[]), IsNullable = false)]
            private ColumnState[] _searchResultColumns;

            #endregion

            #region Property

            /// <summary>tH[̈ʒu擾Eݒ肵܂B</summary>
            public Point Location
            {
                get { return _location; }
                set { _location = value; }
            }

            /// <summary>tH[̃TCY擾Eݒ肵܂B</summary>
            public Size Size
            {
                get { return _size; }
                set { _size = value; }
            }

            /// <summary>tH[̃EBhEԂ擾Eݒ肵܂B</summary>
            public FormWindowState WindowState
            {
                get { return _windowState; }
                set { _windowState = value; }
            }

            /// <summary>[pl̕擾Eݒ肵܂B</summary>
            public int SidePanelWidth
            {
                get { return _sidePanelWidth; }
                set { _sidePanelWidth = value; }
            }

            /// <summary>[pl̍擾Eݒ肵܂B</summary>
            public int UnderPanelHeight
            {
                get { return _underPanelHeight; }
                set { _underPanelHeight = value; }
            }

            /// <summary>tH_c[r[̕擾Eݒ肵܂B</summary>
            public int FolderTreeWidth
            {
                get { return _folderTreeWidth; }
                set { _folderTreeWidth = value; }
            }

            /// <summary>Cɓ̕\Ԃ擾Eݒ肵܂B</summary>
            public bool ShowFavoriteList
            {
                get { return _showFavoriteList; }
                set { _showFavoriteList = value; }
            }

            /// <summary>̕\Ԃ擾Eݒ肵܂B</summary>
            public bool ShowHistoryList
            {
                get { return _showHistoryList; }
                set { _showHistoryList = value; }
            }

            /// <summary>tH_c[̕\Ԃ擾Eݒ肵܂B</summary>
            public bool ShowFolderTree
            {
                get { return _showFolderTree; }
                set { _showFolderTree = value; }
            }

            /// <summary>_E[hXgJwb_̏Ԃ擾Eݒ肵܂B</summary>
            public ColumnState[] DownloadListColumns
            {
                get { return _downloadListColumns; }
                set { _downloadListColumns = value; }
            }

            /// <summary>ۑtH_Jwb_̏Ԃ擾Eݒ肵܂B</summary>
            public ColumnState[] SaveFolderColumns
            {
                get { return _saveFolderColumns; }
                set { _saveFolderColumns = value; }
            }

            /// <summary>ʃJwb_̏Ԃ擾Eݒ肵܂B</summary>
            public ColumnState[] SearchResultColumns
            {
                get { return _searchResultColumns; }
                set { _searchResultColumns = value; }
            }

            #endregion
        }

        #endregion
    }
}
