using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Alternative.Forms
{
    using WebServiceClient;
    using WebServiceClient.NicoVideo;

    /// <summary>OC@\񋟂܂B</summary>
    public partial class LoginForm : Form
    {
        #region Field

        /// <summary>AvP[V̐ݒ񋟂 <see cref="AlternativeConfig"/>B</summary>
        private AlternativeConfig _config;
        /// <summary>jRjR API փANZXi񋟂 <see cref="NicoApiClient"/>B</summary>
        private NicoApiClient _nicoApi;
        /// <summary>LoginStateAsync \bh̃^XN ID \ intB</summary>
        private int _taskId;

        #endregion

        #region Constructor

        /// <summary>CX^X܂B</summary>
        public LoginForm()
        {
            InitializeComponent();
        }

        #endregion

        #region Property

        /// <summary>AvP[V̐ݒݒ肵܂B</summary>
        public AlternativeConfig AlternativeConfig
        {
            set { _config = value; }
        }

        /// <summary>jRjR API փANZXNXݒ肵܂B</summary>
        public NicoApiClient NicoApiClient
        {
            set { _nicoApi = value; }
        }

        #endregion

        #region Method

        /// <summary>tH[ŏɕ\ꂽƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void LoginForm_Shown(object sender, EventArgs e)
        {
            _nicoApi.LoginStateCompleted += NicoApiClient_LoginStateCompleted;
            _nicoApi.LoginCompleted += NicoApiClient_LoginCompleted;

            if (_config.IsLocalProxyStartUp == true)
            {
                lblMessage.Text = "   [J vLVNĂ܂...";
                Process.Start(_config.LocalProxyPath, "");
                startUpTimer.Interval = _config.LocalProxyStartUpWaitSeconds * 1000;
                startUpTimer.Enabled = true;
            }
            else
            {
                startUpTimer_Tick(startUpTimer, new EventArgs());
            }
        }

        /// <summary>tH[Ƃɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="FormClosedEventArgs"/>B</param>
        private void LoginForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            _nicoApi.LoginStateCompleted -= NicoApiClient_LoginStateCompleted;
            _nicoApi.LoginCompleted -= NicoApiClient_LoginCompleted;
        }

        /// <summary>LZ{^ꂽƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void btnCancel_Click(object sender, EventArgs e)
        {
            if (_taskId != NicoApiClient.SyncId)
            {
                _nicoApi.Cancel(_taskId);
                _taskId = NicoApiClient.SyncId;
            }
        }

        /// <summary>^C}[Ɏw肳ꂽԂo߂Ɣ܂B</summary>
        /// <param name="sender">Cxg̔\ <see cref="object"/>B</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void startUpTimer_Tick(object sender, EventArgs e)
        {
            startUpTimer.Enabled = false;
            lblMessage.Text = "   OCԂmFĂ܂...";
            _taskId = _nicoApi.LoginStateAsync(null);
        }

        /// <summary>OCԂ̊mFƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ <see cref="NicoHttpRequest"/>B</param>
        /// <param name="e">Cxg\ <see cref="LoginStateCompletedEventArgs"/>B</param>
        void NicoApiClient_LoginStateCompleted(NicoHttpRequest sender, LoginStateCompletedEventArgs e)
        {
            if (e.Cancelled == true)
            {
                this.DialogResult = DialogResult.Cancel;
            }
            else if (e.Error != null)
            {
                lblMessage.Text = "OCԂmFł܂łB";
                btnCancel.Text = "";
            }
            else if (_nicoApi.LoggedIn == false)
            {
                if (_config.IsAutoLogin == true && _config.LoginMailAddress != "" && _config.LoginPassword != "")
                {
                    lblMessage.Text = "   OCĂ܂...";
                    _nicoApi.LoginAsync(_config.LoginMailAddress, _config.LoginPassword, null);
                }
                else
                {
                    this.DialogResult = DialogResult.OK;
                }
            }
            else
            {
                this.DialogResult = DialogResult.OK;
            }
        }

        /// <summary>OCƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ <see cref="NicoHttpRequest"/>B</param>
        /// <param name="e">Cxg\ <see cref="LoginCompletedEventArgs"/>B</param>
        void NicoApiClient_LoginCompleted(NicoHttpRequest sender, LoginCompletedEventArgs e)
        {
            if (e.Cancelled == true)
            {
                this.DialogResult = DialogResult.Cancel;
            }
            else if (e.LoggedIn == false)
            {
                lblMessage.Text = "OCł܂łB";
                btnCancel.Text = "";
            }
            else
            {
                this.DialogResult = DialogResult.OK;
            }
        }

        #endregion
    }
}