using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Alternative.Forms
{
    using WebServiceClient;

    public partial class InputNewTitleDialog : Form
    {
        #region Field

        /// <summary>V^Cg\ stringB</summary>
        private string _newTitle;

        #endregion

        #region Constructor

        /// <summary>CX^X܂B</summary>
        public InputNewTitleDialog()
        {
            InitializeComponent();
            ExplanationLabel.Text = string.Format("^Cg͂ĂB\n(͂^Cg {0} ^Oƒu܂)", NicoVideoFile.FileTitleFormat);
            _newTitle = "";
        }

        #endregion

        #region Property

        /// <summary>V^Cg擾Eݒ肵܂B</summary>
        public string NewTitle
        {
            get { return _newTitle; }
            set { _newTitle = value ?? ""; }
        }

        #endregion

        #region Event Handler

        /// <summary>tH[\Ƃɏlݒ肵܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void InputNewTitleDialog_VisibleChanged(object sender, EventArgs e)
        {
            if (this.Visible == true)
            {
                NewTitleTextBox.Text = _newTitle;
            }
        }

        /// <summary>^Cg̃eLXgύXƔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void NewTitleTextBox_TextChanged(object sender, EventArgs e)
        {
            OK.Enabled = (NewTitleTextBox.Text.Length > 0);
        }

        /// <summary>uOKv{^Ɣ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void OK_Click(object sender, EventArgs e)
        {
            string title = NewTitleTextBox.Text;

            if (title == "")
            {
                MessageBox.Show("^Cg͂ĂB", Application.ProductName);
                NewTitleTextBox.Focus();
                return;
            }

            int pos = PathHelper.IndexOfInvalidFileNameChars(title);
            if (pos != -1)
            {
                MessageBox.Show("t@CɎgpłȂ܂܂Ă܂B", Application.ProductName);
                NewTitleTextBox.Focus();
                NewTitleTextBox.SelectionStart = pos;
                NewTitleTextBox.SelectionLength = 1;
                return;
            }

            _newTitle = NewTitleTextBox.Text;
            this.DialogResult = DialogResult.OK;
        }

        #endregion
    }
}