using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
using System.IO;
using System.Threading;

namespace Alternative.Forms
{
    using WebServiceClient;
    using WebServiceClient.Forms;

    /// <summary>tH[Ȉ@̎ށB</summary>
    public enum DownFileExistDialogAction
    {
        #region Enum Members

        /// <summary>ȂB</summary>
        None,
        /// <summary>_E[hB</summary>
        Download,
        /// <summary>ĐB</summary>
        Play,
        /// <summary>LZB</summary>
        Cancel,

        #endregion
    }

    /// <summary>[Jɑ݂铮t@C_E[h悤ƂƂ</summary>
	public partial class DownFileExistDialog : Form
    {
        #region Field

        /// <summary>tH[Ȉ@\ <see cref="DialogAction"/>B</summary>
        private DownFileExistDialogAction _action;
        /// <summary>dt@C\ <see cref="List{T}">List&lt;NicoVideoFile&gt;</see>B</summary>
        private List<NicoVideoFile> _files;
        /// <summary>Đ铮t@C\ stringB</summary>
        private string _playVideoPath;

        #endregion

        #region Constructor

        /// <summary>CX^X܂B</summary>
        public DownFileExistDialog()
		{
			InitializeComponent();

            _files = new List<NicoVideoFile>();
            _playVideoPath = "";
        }

        #endregion

        #region Property

        /// <summary>tH[Ȉ@擾Eݒ肵܂B</summary>
        public DownFileExistDialogAction Action
        {
            get { return _action; }
            set { _action = value; }
        }

        /// <summary> ID dĂ铮t@C擾Eݒ肵܂B</summary>
        public List<NicoVideoFile> Files
        {
            get { return _files; }
            set { _files = value; }
        }

        /// <summary>Đ铮t@C擾܂(ǂݎp)B</summary>
        public string PlayVideoPath
        {
            get { return _playVideoPath; }
        }

        #endregion

        #region Event Handler

        /// <summary>tH[\Ƃɏlݒ肵܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void DownFileExistDialog_VisibleChanged(object sender, EventArgs e)
        {
            if (this.Visible == true)
            {
                FileFoundListBox.Items.Clear();
                foreach (NicoVideoFile file in _files)
                {
                    FileFoundListBox.Items.Add(file.LocalPath);
                }
                FileFoundListBox.SelectedIndex = 0;
            }
        }

        /// <summary>t@C̑IACeςƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void FileFoundListBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            NicoVideoFile file = _files[FileFoundListBox.SelectedIndex];
            FileSizeValueLabel.Text = string.Format("{0:N3} MB", MathHelper.Ceiling((decimal)file.LocalSize / 1024000, 3));
            LastDateValueLabel.Text = file.LastWriteTime.ToString("yyyy/MM/dd HH:mm:ss");
            ModeValueLabel.Text = (file.IsEconomy == true) ? "GRm~[" : "ʏ";
        }

        /// <summary>u_E[hv{^ꂽƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void DownloadButton_Click(object sender, EventArgs e)
        {
            _action = DownFileExistDialogAction.Download;
        }

        /// <summary>ut@CĐv{^ꂽƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void PlayButton_Click(object sender, EventArgs e)
        {
            _playVideoPath = (FileFoundListBox.SelectedItem as string);
            _action = DownFileExistDialogAction.Play;
        }

        /// <summary>uLZv{^ꂽƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void Cancel_Click(object sender, EventArgs e)
        {
            _action = DownFileExistDialogAction.None;
        }

        #endregion
    }
}