using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.IO;
using System.Windows.Forms;
using System.Xml;
using System.Xml.Serialization;

namespace Alternative.Forms
{
    using WebServiceClient;

    /// <summary>tH_쐬_CAOB</summary>
    public partial class CreateFolderDialog : Form
    {
        #region Field

        /// <summary>tH_쐬_CAO̐ݒ\ <see cref="CreateFolderInfo"/>B</summary>
        private CreateFolderInfo _info;

        #endregion

        #region Constructor

        /// <summary>CX^X܂B</summary>
        public CreateFolderDialog()
            : this(new CreateFolderInfo())
        {
        }

        /// <summary>CX^X܂B</summary>
        /// <param name="info">tH_쐬_CAO̐ݒ\ <see cref="CreateFolderInfo"/>B</param>
        public CreateFolderDialog(CreateFolderInfo info)
        {
            if (info == null)
            {
                throw new ArgumentNullException();
            }

            _info = info;

            InitializeComponent();
        }

        #endregion

        #region Property

        /// <summary>쐬tH_̐etH_擾Eݒ肵܂B</summary>
        public string ParentFolder
        {
            get { return _info.ParentFolder; }
            set { _info.ParentFolder = value ?? ""; }
        }

        /// <summary>\ɎgptH_擾Eݒ肵܂B</summary>
        public string DefaultFolderName
        {
            get { return _info.DefaultFolderName; }
            set { _info.DefaultFolderName = value ?? ""; }
        }

        /// <summary>V쐬tH_擾܂(ǂݎp)B</summary>
        public string NewFolder
        {
            get { return _info.NewFolder; }
        }

        /// <summary>쐬tH_̌擾܂(ǂݎp)B</summary>
        public List<string> NameHistory
        {
            get { return _info.NameHistory; }
        }

        /// <summary>tH_쐬_CAO̐ݒ擾܂(ǂݎp)B</summary>
        public CreateFolderInfo FolderInfo
        {
            get { return _info; }
        }

        #endregion

        #region Event Handler

        /// <summary>tH[\Ƃɏlݒ肵܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void CreateFolderDialog_VisibleChanged(object sender, EventArgs e)
        {
            if (Visible)
            {
                HistoryComboBox.Text = _info.DefaultFolderName;
                HistoryComboBox.Items.Clear();
                HistoryComboBox.Items.AddRange(_info.NameHistory.ToArray() );
            }
        }

        /// <summary>tH_̃eLXgύXƔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void HistoryComboBox_TextChanged(object sender, EventArgs e)
        {
            OK.Enabled = (string.IsNullOrEmpty(HistoryComboBox.Text) == false);
        }

        /// <summary>uOKv{^Ɣ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="EventArgs"/>B</param>
        private void OK_Click(object sender, EventArgs e)
        {
            string folderName = HistoryComboBox.Text;

            // tH_
            switch (PathHelper.ValidateFolderName(folderName))
            {
            case ValidatePathResult.LengthOver:
                MessageBox.Show("tH_܂B", Application.ProductName);
                HistoryComboBox.Focus();
                return;

            case ValidatePathResult.InvalidChar:
                MessageBox.Show("tH_ɎgpłȂ܂܂Ă܂B", Application.ProductName);
                HistoryComboBox.Focus();
                return;

            case ValidatePathResult.DeviceName:
                string deviceName = folderName.Split('.')[0];
                if (deviceName.Length > 1)
                {
                    MessageBox.Show(string.Format("tH_̐擪 \"{0}.\" ܂߂邱Ƃ͏o܂B", deviceName), Application.ProductName);
                }
                else
                {
                    MessageBox.Show(string.Format("tH_ \"{0}\" ɂ邱Ƃ͏o܂B", deviceName), Application.ProductName);
                }
                HistoryComboBox.Focus();
                return;
            }

            string path = Path.Combine(_info.ParentFolder, folderName);

            // pXŜ
            if (path.Length > PathHelper.MaxPathName)
            {
                MessageBox.Show("tH_܂B", Application.ProductName);
                HistoryComboBox.Focus();
                return;
            }

            if (Directory.Exists(path) == true)
            {
                MessageBox.Show("łɑ݂tH_łB", Application.ProductName);
                HistoryComboBox.Focus();
                return;
            }

            _info.NewFolder = HistoryComboBox.Text;
            this.DialogResult = DialogResult.OK;
        }

        #endregion
    }

    /// <summary>tH_쐬̐ݒ񋟂܂B</summary>
    [Serializable()]
    [XmlType("CreateFolderInfoRoot")]
    public class CreateFolderInfo
    {
        #region Constant

        /// <summary>ێtH_̍ő吔\ intB</summary>
        public const int MaxFolderNameHistory = 20;

        #endregion

        #region Field

        /// <summary>쐬tH_̐etH_\ stringB</summary>
        [XmlIgnore()]
        private string _parentFolder;
        /// <summary>\ɎgptH_\ stringB</summary>
        [XmlIgnore()]
        private string _defaultFolderName;
        /// <summary>V쐬tH_\ stringB</summary>
        [XmlIgnore()]
        private string _newFolder;
        /// <summary>쐬tH_̌\ <see cref="List{T}">List&lt;string&gt;</see>B</summary>
        [XmlElement("NameHistory", typeof(List<string>), IsNullable = false)]
        private List<string> _nameHistory;

        #endregion

        #region Constructor

        /// <summary>CX^X܂B</summary>
        public CreateFolderInfo()
        {
            _parentFolder = "";
            _newFolder = "";
            _nameHistory = new List<string>();
            _defaultFolderName = "";
        }

        #endregion

        #region Property

        /// <summary>VtH_擾Eݒ肷B</summary>
        public string NewFolder
        {
            get { return _newFolder; }
            set { _newFolder = value ?? ""; }
        }

        /// <summary>쐬tH_̐etH_擾Eݒ肷B</summary>
        public string ParentFolder
        {
            get { return _parentFolder; }
            set { _parentFolder = value ?? ""; }
        }


        /// <summary>쐬tH_̌擾܂(ǂݎp)B</summary>
        public List<string> NameHistory
        {
            get { return _nameHistory; }
        }

        /// <summary>\ɎgptH_擾Eݒ肷B</summary>
        public String DefaultFolderName
        {
            get { return _defaultFolderName; }
            set { _defaultFolderName = value ?? ""; }
        }

        #endregion

        #region Method

        /// <summary>tH_𐶐܂B</summary>
        public void CreateFolder()
        {
            if (_newFolder == "")
            {
                throw new InvalidOperationException("tH_͂Ă܂B");
            }

            Directory.CreateDirectory(Path.Combine(_parentFolder, _newFolder));

            // 쐬tH_𗚗ɒǉ
            if (_newFolder.Length > 0)
            {
                int newFolderIndex = _nameHistory.IndexOf(_newFolder);
                if (newFolderIndex != -1)
                {
                    _nameHistory.RemoveAt(newFolderIndex);
                }
                else if (_nameHistory.Count >= MaxFolderNameHistory)
                {
                    _nameHistory.RemoveAt(MaxFolderNameHistory - 1);
                }
                _nameHistory.Insert(0, _newFolder);
            }
        }

        #endregion
    }
}