using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Collections.Generic;
using System.Data;
using System.Drawing;
using System.IO;
using System.Text;
using System.Windows.Forms;

namespace Alternative
{
    using Windows;
    using WebServiceClient.Forms;
    using WebServiceClient.Text;

    #region NicoDownloadViewIndex

    /// <summary>Jwb_̃CfbNXB</summary>
    public sealed class NicoDownloadViewIndex
    {
        #region Constant

        /// <summary>^CgB</summary>
        public const int Title = 0;
        /// <summary>iB</summary>
        public const int Rate = 1;
        /// <summary>TCYB</summary>
        public const int Size = 2;
        /// <summary>c莞ԁB</summary>
        public const int TimeLife = 3;
        /// <summary>]x(KB/s)B</summary>
        public const int Speed = 4;
        /// <summary>[hB</summary>
        public const int Mode = 5;
        /// <summary>gqB</summary>
        public const int Type = 6;
        /// <summary>o^B</summary>
        public const int Registration = 7;
        /// <summary>tH_B</summary>
        public const int Folder = 8;

        #endregion
    }

    #endregion

    #region RetrieveDownloadItemEventArgs

    /// <summary>_E[hACe̗v񋟂܂B</summary>
    [DebuggerDisplay("ItemIndex = {ItemIndex}")]
    [TypeConverter(typeof(ExpandableObjectConverter))]
    public class RetrieveDownloadItemEventArgs : EventArgs
    {
        #region Field

        /// <summary>vACẽCfbNX\ intB</summary>
        protected int _itemIndex;
        /// <summary>񋟂ꂽ_E[hACe\ <see cref="IDownloadItem"/>B</summary>
        protected IDownloadItem _item;

        #endregion

        #region Constructor

        /// <summary>CX^X܂B</summary>
        /// <param name="itemIndex">vACẽCfbNX\ intB</param>
        public RetrieveDownloadItemEventArgs(int itemIndex)
        {
            _itemIndex = itemIndex;
            _item = null;
        }

        #endregion

        #region Property

        /// <summary>񋟂_E[hACe擾Eݒ肵܂B</summary>
        public IDownloadItem Item
        {
            get { return _item; }
            set { _item = value; }
        }

        /// <summary>vACẽCfbNX擾܂(ǂݎp)B</summary>
        public int ItemIndex
        {
            get { return _itemIndex; }
        }

        #endregion
    }

    #endregion

    #region DownloadItemEventArgs

    /// <summary>_E[hACe̕ύX񋟂܂B</summary>
    [DebuggerDisplay("Count = {Items.Length}, Index = {Index}")]
    [TypeConverter(typeof(ExpandableObjectConverter))]
    public class DownloadItemEventArgs : EventArgs
    {
        #region Field

        /// <summary>_E[hACẽCfbNX\ int[]B</summary>
        protected int[] _items;
        /// <summary>ύXsꂽʒu\ intB</summary>
        protected int _index;

        #endregion

        #region Constructor

        /// <summary>CX^X܂B</summary>
        /// <param name="items">_E[hACẽCfbNX\ int[]B</param>
        /// <param name="index">ύXsꂽʒu\ intB</param>
        public DownloadItemEventArgs(int[] items, int index)
        {
            _items = items;
            _index = index;
        }

        #endregion

        #region Property

        /// <summary>_E[hACẽCfbNX擾܂(ǂݎp)B</summary>
        public virtual int[] Items
        {
            get { return _items; }
        }

        /// <summary>ύXsꂽʒu擾܂(ǂݎp)B</summary>
        public int Index
        {
            get { return _index; }
        }

        #endregion
    }

    #endregion

    #region SortItemEventArgs

    /// <summary>_E[hACe̕בւ񋟂܂B</summary>
    [DebuggerDisplay("Count = {Items.Length}, Index = {Index}")]
    [TypeConverter(typeof(ExpandableObjectConverter))]
    public class SortItemEventArgs : EventArgs
    {
        #region Field

        /// <summary>בւstB[hʎq\ <see cref="DownloadItemFieldId"/>B</summary>
        protected DownloadItemFieldId _fieldId;
        /// <summary>\[g\ <see cref="SortOrder"/>B</summary>
        private SortOrder _sortOrder;

        #endregion

        #region Constructor

        /// <summary>CX^X܂B</summary>
        /// <param name="fieldId">בւstB[hʎq\ <see cref="DownloadItemFieldId"/>B</param>
        /// <param name="sortOrder">\[g\ <see cref="SortOrder"/>B</param>
        public SortItemEventArgs(DownloadItemFieldId fieldId, SortOrder sortOrder)
        {
            _fieldId = fieldId;
            _sortOrder = sortOrder;
        }

        #endregion

        #region Property

        /// <summary>בւstB[hʎq擾܂(ǂݎp)B</summary>
        public DownloadItemFieldId FieldId
        {
            get { return _fieldId; }
        }

        /// <summary>\[g擾܂(ǂݎp)B</summary>
        public SortOrder SortOrder
        {
            get { return _sortOrder; }
        }

        #endregion
    }

    #endregion

    #region Delegate

    /// <summary>_E[hACeKvȂƂɔ܂B</summary>
    /// <param name="sender">CxgIuWFNg\ objectB</param>
    /// <param name="e">Cxg\ <see cref="RetrieveDownloadItemEventArgs"/>B</param>
    public delegate void RetrieveDownloadItemEventHandler(object sender, RetrieveDownloadItemEventArgs e);

    /// <summary>_E[hACeύXƂɔ܂B</summary>
    /// <param name="sender">CxgIuWFNg\ objectB</param>
    /// <param name="e">Cxg\ <see cref="DownloadItemEventArgs"/>B</param>
    public delegate void DownloadItemEventHandler(object sender, DownloadItemEventArgs e);

    /// <summary>_E[hACeבւKvƂɔ܂B</summary>
    /// <param name="sender">CxgIuWFNg\ objectB</param>
    /// <param name="e">Cxg\ <see cref="SortItemEventArgs"/>B</param>
    public delegate void SortItemEventHandler(object sender, SortItemEventArgs e);

    #endregion

    #region IDownloadView

    public interface IDownloadView
    {
        #region Event

        /// <summary>_E[hACeKvȂƂɔ܂B</summary>
        event RetrieveDownloadItemEventHandler RetrieveDownloadItem;
        /// <summary>ACe폜Ƃɔ܂B</summary>
        event DownloadItemEventHandler ItemRemoved;
        /// <summary>ACeړƂɔ܂B</summary>
        event DownloadItemEventHandler ItemMoved;
        /// <summary>ACeבւKvƂɔ܂B</summary>
        event SortItemEventHandler ItemSort;

        #endregion

        #region Method

        /// <summary>r[XV܂B</summary>
        void Update();

        #endregion
    }

    #endregion

    #region NicoDownloadView

    /// <summary>[U[f֒ʒmNXłB</summary>
    public class NicoDownloadView : IDownloadView
    {
        #region Field

        /// <summary>zXg郊Xgr[\ <see cref="GkListView"/>B</summary>
        private GkListView _view;

        #endregion

        #region Constructor

        /// <summary>CX^X܂B</summary>
        /// <param name="listView">zXgRg[\ <see cref="GkListView"/>B</param>
        public NicoDownloadView(GkListView listView)
        {
            InitializeComponent(listView);
        }

        #endregion

        #region Event

        /// <summary>_E[hACeKvȂƂɔ܂B</summary>
        public event RetrieveDownloadItemEventHandler RetrieveDownloadItem;
        /// <summary>ACe폜Ƃɔ܂B</summary>
        public event DownloadItemEventHandler ItemRemoved;
        /// <summary>ACeړƂɔ܂B</summary>
        public event DownloadItemEventHandler ItemMoved;
        /// <summary>ACeבւKvƂɔ܂B</summary>
        public event SortItemEventHandler ItemSort;

        #endregion

        #region Method

        /// <summary>Rg[܂B</summary>
        /// <param name="listView">zXgRg[\ <see cref="GkListView"/>B</param>
        private void InitializeComponent(GkListView listView)
        {
            _view = listView;

            GkColumnHeader[] columnHeaders = new GkColumnHeader[typeof(NicoDownloadViewIndex).GetFields().Length];
            for (int i = 0; i < columnHeaders.Length; i++)
            {
                GkColumnHeader columnHeader = new GkColumnHeader();

                switch (i)
                {
                case NicoDownloadViewIndex.Title:
                    columnHeader.Text = "^Cg";
                    columnHeader.Width = 500;
                    break;

                case NicoDownloadViewIndex.Size:
                    columnHeader.Text = "TCY(MB)";
                    columnHeader.TextAlign = HorizontalAlignment.Right;
                    columnHeader.Width = 120;
                    break;

                case NicoDownloadViewIndex.Rate:
                    columnHeader.Text = "is";
                    columnHeader.Width = 100;
                    break;

                case NicoDownloadViewIndex.TimeLife:
                    columnHeader.Text = "c莞";
                    columnHeader.TextAlign = HorizontalAlignment.Right;
                    break;

                case NicoDownloadViewIndex.Speed:
                    columnHeader.Text = "]x(KB/s)";
                    columnHeader.TextAlign = HorizontalAlignment.Right;
                    columnHeader.Width = 120;
                    break;

                case NicoDownloadViewIndex.Mode:
                    columnHeader.Text = "[h";
                    columnHeader.Width = 80;
                    break;

                case NicoDownloadViewIndex.Type:
                    columnHeader.Text = "gq";
                    columnHeader.Width = 60;
                    break;

                case NicoDownloadViewIndex.Registration:
                    columnHeader.Text = "o^";
                    columnHeader.Width = 140;
                    break;

                case NicoDownloadViewIndex.Folder:
                    columnHeader.Text = "tH_";
                    columnHeader.Width = 300;
                    break;
                }

                columnHeaders[i] = columnHeader;
            }

            _view.Columns.Clear();
            _view.Columns.AddRange(columnHeaders);

            _view.ColumnClick += LV_ColumnClick;
            _view.KeyDown += LV_KeyDown;
            _view.VirtualItemMoved += LV_ItemMoved;
            _view.CustomDrawSubItem += LV_CustomDrawSubItem;
            _view.RetrieveVirtualItem += LV_RetrieveVirtualItem;
        }

        /// <summary>Xgr[ACe쐬܂B</summary>
        /// <param name="item">_E[hACe\ <see cref="IDownloadItem"/>B</param>
        /// <returns>쐬Xgr[ACe\ <see cref="GkListViewItem"/>B</returns>
        private GkListViewItem CreateListViewItem(IDownloadItem item)
        {
            if (item is GkListViewItem)
            {
                return (item as GkListViewItem);
            }
            else
            {
                IDownloadItem lvItem = new NicoDownloadItem(item.VideoId, item.Title, item.LocalPath, item.Target);

                lvItem.Type = item.Type;
                lvItem.RemotePath = item.RemotePath;
                lvItem.Size = item.Size;
                lvItem.DownloadedSize = item.DownloadedSize;
                lvItem.Mode = item.Mode;
                lvItem.State = item.State;
                lvItem.Registration = item.Registration;

                return (lvItem as GkListViewItem);
            }
        }

        #endregion

        #region IDownloadView

        /// <summary>r[XV܂B</summary>
        void IDownloadView.Update()
        {
            _view.Refresh();
        }

        #endregion

        #region ListView EventHandler

        /// <summary>NbNJɃ\[g܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="GkColumnClickEventArgs"/>B</param>
        private void LV_ColumnClick(object sender, GkColumnClickEventArgs e)
        {
            if (e.Button == MouseButtons.Left)
            {
                e.Column.ReversalSortOrder();

                if (ItemSort != null)
                {
                    DownloadItemFieldId fieldId = DownloadItemFieldId.None;

                    switch (e.Column.Index)
                    {
                    case NicoDownloadViewIndex.Title: fieldId = DownloadItemFieldId.Title; break;
                    case NicoDownloadViewIndex.Size: fieldId = DownloadItemFieldId.Size; break;
                    case NicoDownloadViewIndex.Rate: fieldId = DownloadItemFieldId.Rate; break;
                    case NicoDownloadViewIndex.TimeLife: fieldId = DownloadItemFieldId.TimeLife; break;
                    case NicoDownloadViewIndex.Speed: fieldId = DownloadItemFieldId.Speed; break;
                    case NicoDownloadViewIndex.Mode: fieldId = DownloadItemFieldId.Mode; break;
                    case NicoDownloadViewIndex.Type: fieldId = DownloadItemFieldId.Type; break;
                    case NicoDownloadViewIndex.Registration: fieldId = DownloadItemFieldId.Registration; break;
                    case NicoDownloadViewIndex.Folder: fieldId = DownloadItemFieldId.Folder; break;
                    }

                    ItemSort(this, new SortItemEventArgs(fieldId, e.Column.SortOrder));
                }
            }
        }

        /// <summary>Delete L[őI𒆂̃_E[hACe폜܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="KeyEventArgs"/>B</param>
        private void LV_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.Delete && ItemRemoved != null && _view.SelectedItems.Count > 0)
            {
                int[] items = new int[_view.SelectedItems.Count];
                for (int i = 0; i < items.Length; i++)
                {
                    items[i] = _view.SelectedItems[i].Index;
                }

                ItemRemoved(this, new DownloadItemEventArgs(items, _view.SelectedItems[0].Index));
            }
        }

        /// <summary>ACeړƂʒm܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="GkItemCollectionEditEventArgs"/>B</param>
        private void LV_ItemMoved(object sender, GkItemCollectionEditEventArgs e)
        {
            if (ItemMoved != null && _view.VirtualMode == true)
            {
                int[] items = new int[e.Items.Length];
                for (int i = 0; i < items.Length; i++)
                {
                    items[i] = e.Items[i].Index;
                }

                ItemMoved(this, new DownloadItemEventArgs(items, e.Index));
            }
        }

        /// <summary>_E[hACehbOhbvŕבւ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="GkItemDragEventArgs"/>B</param>
        private void LV_ItemDrag(object sender, GkItemDragEventArgs e)
        {
            if (_view.SelectedItems.Count > 0)
            {
                DataObject dataObj = new DataObject();

                if (_view.VirtualMode == false)
                {
                    if (_view.SelectedItems.Count == 1)
                    {
                        dataObj.SetData(typeof(GkListViewItem), _view.SelectedItems[0]);
                    }
                    else
                    {
                        dataObj.SetData(typeof(GkListViewItem[]), _view.SelectedItems.ToArray());
                    }
                }
                else
                {
                    if (_view.SelectedIndices.Count == 1)
                    {
                        dataObj.SetData(typeof(GkListViewItem), e.Item);
                    }
                    else
                    {
                        dataObj.SetData(typeof(GkListViewItem[]), _view.SelectedIndices.ToArray());
                    }
                }

                _view.DoDragDrop(dataObj, DragDropEffects.Copy | DragDropEffects.Move);
            }
        }

        /// <summary>JX^h[ŃTuACe`悵܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="GkListViewCustomDrawEventArgs"/>B</param>
        private void LV_CustomDrawSubItem(object sender, GkListViewCustomDrawEventArgs e)
        {
            if (e.SubItem.VisibleControl == false && e.SubItem.ListViewItem.Index % 2 != 0)
            {
                e.Result = GkListViewCustomDrawResult.CustonDraw;
                e.BackColor = Color.FromArgb(0xF0, 0xF0, 0xF0);
            }
        }

        /// <summary>zACeKvȂƂɃ[U[֗v܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="GkRetrieveVirtualItemEventArgs"/>B</param>
        private void LV_RetrieveVirtualItem(object sender, GkRetrieveVirtualItemEventArgs e)
        {
            if (RetrieveDownloadItem == null)
            {
                throw new InvalidOperationException();
            }
            else
            {
                RetrieveDownloadItemEventArgs args = new RetrieveDownloadItemEventArgs(e.ItemIndex);
                RetrieveDownloadItem(this, args);
                e.Item = CreateListViewItem(args.Item);
            }
        }

        #endregion
    }

    #endregion
}
