using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Text;
using System.Windows.Forms;

namespace Alternative
{
    using WebServiceClient;
    using WebServiceClient.Collections;
    using WebServiceClient.NicoVideo;

    /// <summary>Rec̃_E[h@\񋟂܂B</summary>
    public class NicoDownloadManager
    {
        #region Field

        /// <summary>jRjRAPIփANZXi񋟂 <see cref="NicoApiClient"/>B</summary>
        private NicoApiClient _nicoApi;
        /// <summary>_E[hACẽRNV\ <see cref="IDownloadItemCollection"/>B</summary>
        private IDownloadItemCollection _items;
        /// <summary>_E[hACẽ[U[C^[tF[X\ <see cref="IDownloadView">List&lt;IDownloadView&gt;</see>B</summary>
        private List<IDownloadView> _views;
        /// <summary>s\ȃ^XN\ intB</summary>
        private int _maxRequest;
        /// <summary>s̃^XN\ intB</summary>
        private int _execRequest;

        #endregion

        #region Constructor

        /// <summary>CX^X܂B</summary>
        /// <param name="nicoApi">jRjRAPIփANZXi񋟂 <see cref="NicoApiClient"/>B</param>
        /// <param name="items">_E[hACẽRNV\ <see cref="IDownloadItemCollection"/>B</param>
        public NicoDownloadManager(NicoApiClient nicoApi, IDownloadItemCollection items)
        {
            _nicoApi = nicoApi;
            _items = items;
            _views = new List<IDownloadView>();
            _maxRequest = 1;
            _execRequest = 0;

            _nicoApi.GetCommentBegin += NicoAPI_GetCommentBegin;
            _nicoApi.GetCommentProgress += NicoAPI_GetCommentProgress;
            _nicoApi.GetCommentCompleted += NicoAPI_GetCommentCompleted;
            _nicoApi.DownloadVideoBegin += NicoAPI_DownloadVideoBegin;
            _nicoApi.DownloadVideoProgress += NicoAPI_DownloadVideoProgress;
            _nicoApi.DownloadVideoCompleted += NicoAPI_DownloadVideoCompleted;
        }

        #endregion

        #region Property

        /// <summary>CfbNXɑΉl擾܂(ǂݎp)B</summary>
        /// <param name="index">lɑΉCfbNX([IW)\ intB</param>
        /// <returns>擾l\ <see cref="IDownloadItem"/>B</returns>
        public IDownloadItem this[int index]
        {
            get { return _items[index] as IDownloadItem; }
        }

        /// <summary>L[ɑΉl擾܂(ǂݎp)B</summary>
        /// <param name="videoId">lɑΉL[\ stringB</param>
        /// <returns>擾l\ <see cref="IDownloadItem"/>B</returns>
        public IDownloadItem this[string videoId]
        {
            get { return _items[videoId] as IDownloadItem; }
        }

        /// <summary>ACe擾܂(ǂݎp)B</summary>
        public int Count
        {
            get { return _items.Count; }
        }

        /// <summary>s\ȃ^XN擾Eݒ肵܂B</summary>
        public int MaxRequest
        {
            get { return _maxRequest; }
            set { _maxRequest = value; }
        }

        /// <summary>s̃^XN擾܂(ǂݎp)B</summary>
        public int ExecRequest
        {
            get { return _execRequest; }
        }

        #endregion

        #region Method

        /// <summary>[U[C^[tF[X̕\sr[ǉ܂B</summary>
        /// <param name="view">ǉr[\ <see cref="IDownloadView"/>B</param>
        public void RegisterView(IDownloadView view)
        {
            view.RetrieveDownloadItem += IDownloadView_ItemRetrieve;
            view.ItemMoved += IDownloadView_ItemMoved;
            view.ItemRemoved += IDownloadView_ItemRemoved;
            view.ItemSort += IDownloadView_SortItem;

            _views.Add(view);
        }

        /// <summary>ACeǉ܂B</summary>
        /// <param name="key">ACe̖O\ stringB</param>
        /// <param name="item">ǉACe\ <see cref="IDownloadItem"/>B</param>
        public void AddItem(string key, IDownloadItem item)
        {
            item.State = DownloadItemState.Pause;
            item.Registration = DateTime.Now;
            _items.Add(key, item);
        }

        /// <summary>ACe폜܂B</summary>
        /// <param name="key">폜ACe\ stringB</param>
        public void RemoveItem(string key)
        {
            _items.Remove(key);
        }

        /// <summary>ACeNA܂B</summary>
        public void Clear()
        {
            _nicoApi.CancelAll();
            _items.Clear();
        }

        /// <summary>w̓ ID ACẽ_E[hJn܂B</summary>
        public void Start()
        {
            lock (this)
            {
                if (_execRequest < _maxRequest)
                {
                    StartDownload(null);
                }
            }
        }

        /// <summary>w̃ACẽ_E[hJn܂B</summary>
        /// <param name="item">_E[hJnACe\ <see cref="IDownloadItem"/>B</param>
        public void Start(IDownloadItem item)
        {
            lock (this)
            {
                if (_execRequest < _maxRequest)
                {
                    StartDownload(item);
                }
                else
                {
                    item.State = DownloadItemState.Waiting;
                }
            }
        }

        /// <summary>w̃ACẽ_E[hJn܂B</summary>
        /// <param name="key">ACe̖O\ stringB</param>
        public void Start(string key)
        {
            if (_items.Contains(key) == true)
            {
                Start(_items[key]);
            }
        }

        /// <summary>w̓ ID ACẽ_E[h𒆎~܂B</summary>
        /// <param name="key">ACe̖O\ stringB</param>
        /// <returns>~ɐꍇ <see langword="true"/>AȊȌꍇ <see langword="false"/>B</returns>
        public bool Cancel(string key)
        {
            if (_items.Contains(key) == true)
            {
                IDownloadItem item = _items[key];
                if (_nicoApi.Cancel(item.TaskId) == false)
                {
                    item.State = DownloadItemState.Cancelled;
                }
                return true;
            }
            else
            {
                return false;
            }
        }

        /// <summary>ׂăACẽ_E[h𒆎~܂B</summary>
        public void CancelAll()
        {
            _nicoApi.CancelAll();
        }

        /// <summary>w̃L[邩ǂ擾܂B</summary>
        /// <param name="key">ACe̖O\ stringB</param>
        /// <returns>ACei[Ăꍇ <see langword="true"/>AȊȌꍇ <see langword="false"/>B</returns>
        public bool Contains(string key)
        {
            return _items.Contains(key);
        }

        /// <summary>CX^X XML `ŃVACY܂B</summary>
        /// <param name="path">XML t@C̃pX\ stringB</param>
        /// <returns>VACYɐꍇ <see langword="true"/>AȊȌꍇ <see langword="false"/>B</returns>
        public bool XmlSerialize(string path)
        {
            return _items.XmlSerialize(path);
        }

        /// <summary>VACY XML ɃRg[܂B</summary>
        /// <param name="path">XML t@C̃pX\ stringB</param>
        /// <returns>Rg[oꍇ <see langword="true"/>AȊȌꍇ <see langword="false"/>B</returns>
        public bool XmlDeserialize(string path)
        {
            try
            {
                _items.XmlDeserialize(path);
                return true;
            }
            catch
            {
                return false;
            }
        }

        /// <summary>_E[hJn܂B</summary>
        /// <param name="item">Jn_E[hACe\ <see cref="IDownloadItem"/>B</param>
        /// <remarks><paramref name="item"/>  <see langword="null"/> w肵ꍇ́A<see cref="IDownloadItem.State"/>  Waiting ̃ACeōłCfbNX̏ACẽ_E[hJn܂B</remarks>
        private void StartDownload(IDownloadItem item)
        {
            if (item == null)
            {
                for (int i = 0; i < _items.Count; i++)
                {
                    if (_items[i].State == DownloadItemState.Waiting)
                    {
                        item = _items[i];
                        break;
                    }
                }

                if (item == null)
                {
                    return;
                }
            }

            if ((item.Target & DownloadTarget.Video) == DownloadTarget.Video)
            {
                NicoThreadType thread = NicoThreadType.None;
                if ((item.Target & DownloadTarget.Comment) == DownloadTarget.Comment)
                {
                    thread = NicoThreadType.Default;
                }

                item.DownloadedSize = 0;
                item.State = DownloadItemState.Start;
                item.TaskId = _nicoApi.DownloadVideoAsync(item.VideoId, item.PathFormat, thread, true, true, item);
                _execRequest++;
                Debug.WriteLine(_execRequest.ToString());
            }
            else if ((item.Target & DownloadTarget.Comment) == DownloadTarget.Comment)
            {
                item.DownloadedSize = 0;
                item.State = DownloadItemState.Start;
                item.TaskId = _nicoApi.GetCommentAsync(item.VideoId, DateTime.MinValue, -1000, NicoThreadType.Default, item);
                _execRequest++;
                Debug.WriteLine(_execRequest.ToString());
            }
            else
            {
            }

            if (_execRequest < _maxRequest)
            {
                StartDownload(null);
            }
        }

        /// <summary>`\񋓎q֕ϊ܂B</summary>
        /// <param name="typeName">`\ strgingB</param>
        /// <returns>ϊ`\ <see cref="DownloadVideoType"/>B</returns>
        private DownloadVideoType ConvertVideoTypeName(string typeName)
        {
            switch (typeName.ToLower())
            {
            case "mp4": return DownloadVideoType.Mpeg4;
            case "swf": return DownloadVideoType.SWF;
            case "flv": return DownloadVideoType.FLV;
            default: return DownloadVideoType.None;
            }
        }

        #endregion

        #region IDownloadView EventHandler

        /// <summary>_E[hACeKvȂƂɔ܂B</summary>
        /// <param name="sender">CxgIuWFNg\ objectB</param>
        /// <param name="e">Cxg\ <see cref="RetrieveDownloadItemEventArgs"/>B</param>
        private void IDownloadView_ItemRetrieve(object sender, RetrieveDownloadItemEventArgs e)
        {
            e.Item = _items[e.ItemIndex];
        }

        /// <summary>_E[hACe폜Ƃɔ܂B</summary>
        /// <param name="sender">CxgIuWFNg\ objectB</param>
        /// <param name="e">Cxg\ <see cref="DownloadItemEventArgs"/>B</param>
        private void IDownloadView_ItemRemoved(object sender, DownloadItemEventArgs e)
        {
            _items.Remove(e.Items);
        }

        /// <summary>_E[hACeړƂɔ܂B</summary>
        /// <param name="sender">CxgIuWFNg\ objectB</param>
        /// <param name="e">Cxg\ <see cref="DownloadItemEventArgs"/>B</param>
        private void IDownloadView_ItemMoved(object sender, DownloadItemEventArgs e)
        {
            _items.Move(e.Items, e.Index);
        }

        /// <summary>_E[hACeבւKvƂɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="SortItemEventArgs"/>B</param>
        private void IDownloadView_SortItem(object sender, SortItemEventArgs e)
        {
            _items.Sort(e.FieldId, e.SortOrder);
        }

        #endregion

        #region NicoAPIClient EventHandler

        /// <summary>Rg̃_E[hJn钼Oɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="GetCommentProgressEventArgs"/>B</param>
        void NicoAPI_GetCommentBegin(NicoHttpRequest sender, GetCommentBeginEventArgs e)
        {
        }

        /// <summary>Rg̃_E[hɈԊuŔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="GetCommentProgressEventArgs"/>B</param>
        void NicoAPI_GetCommentProgress(NicoHttpRequest sender, GetCommentProgressEventArgs e)
        {
        }

        /// <summary>Rg̃_E[hƔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="GetCommentCompletedEventArgs"/>B</param>
        void NicoAPI_GetCommentCompleted(NicoHttpRequest sender, GetCommentCompletedEventArgs e)
        {
        }

        /// <summary>̃_E[hJn钼Oɔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="DownloadVideoBeginEventArgs"/>B</param>
        void NicoAPI_DownloadVideoBegin(NicoHttpRequest sender, DownloadVideoBeginEventArgs e)
        {
            IDownloadItem item = (sender.Tag as IDownloadItem);
            if (e.Cancelled == false)
            {
                item.Title = Path.GetFileNameWithoutExtension(e.Contents.FileName);
                item.Type = ConvertVideoTypeName(e.Contents.VideoInfo.Type);
                item.LocalPath = e.Contents.FullPath;
                item.State = DownloadItemState.Processing;
                item.Mode = (e.Contents.VideoInfo.IsEconomy == true) ? DownloadMode.Economy : DownloadMode.Normal;
            }
        }

        /// <summary>̃_E[hɈԊuŔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="DownloadVideoProgressEventArgs"/>B</param>
        void NicoAPI_DownloadVideoProgress(NicoHttpRequest sender, DownloadVideoProgressEventArgs e)
        {
            IDownloadItem item = (sender.Tag as IDownloadItem);
            item.DownloadTime = e.Contents.Milliseconds;
            item.CacheSize = e.Contents.CacheSize;
            item.Size = e.Contents.Size;
            item.DownloadedSize = e.Contents.DownloadedSize;
        }

        /// <summary>̃_E[hƔ܂B</summary>
        /// <param name="sender">Cxg̔\ objectB</param>
        /// <param name="e">Cxg\ <see cref="DownloadVideoCompletedEventArgs"/>B</param>
        void NicoAPI_DownloadVideoCompleted(NicoHttpRequest sender, DownloadVideoCompletedEventArgs e)
        {
            lock (this)
            {
                _execRequest--;
                IDownloadItem item = (sender.Tag as IDownloadItem);

                if (e.Cancelled == true)
                {
                    item.State = DownloadItemState.Cancelled;
                }
                else if (e.Error != null)
                {
                    item.State = DownloadItemState.Failed;
                }
                else
                {
                    item.DownloadTime = e.Contents.Milliseconds;
                    item.DownloadedSize = e.Contents.DownloadedSize;
                    item.State = DownloadItemState.Completed;

                    try
                    {
                        string commentPath = Path.ChangeExtension(e.Contents.FullPath, "xml");
                        NicoThread thread = e.Contents.Thread;

                        if (thread != null)
                        {
                            if (File.Exists(commentPath) == true)
                            {
                                thread.Merge(new NicoThread(commentPath));
                            }

                            string header = string.Format("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!-- BoonSutazioData={0} -->\n", e.Contents.VideoId);
                            string footer = "";

                            // Rgԍŕבւ
                            e.Contents.Thread.SortComment(delegate(IKeyValuePair<int, NicoCommentEntry> x, IKeyValuePair<int, NicoCommentEntry> y)
                            {
                                return (int)(x.Value.No - y.Value.No);
                            });

                            // {^ԍŕבւ
                            e.Contents.Thread.SortButton(delegate(IKeyValuePair<int, NicoButtonEntry> x, IKeyValuePair<int, NicoButtonEntry> y)
                            {
                                return (int)(x.Value.No - y.Value.No);
                            });

                            // XML t@C֏o
                            e.Contents.Thread.SaveThreadXml(NicoThreadType.All, commentPath, new UTF8Encoding(false), header, footer);
                        }
                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show("Rg̉͒ɃG[܂B\ñbZ[W̓eJւAB\n(_CAOANeBuȏԂ Ctrl + C L[ŃRs[ł܂)\n\n" + ex.Message, Application.ProductName);
                    }
                }

                if (_execRequest < _maxRequest)
                {
                    StartDownload(null);
                }
            }
        }

        #endregion
    }
}
