using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Windows.Forms;

namespace Alternative
{
    using WebServiceClient;
    using WebServiceClient.Collections;
    using WebServiceClient.Forms;
    using WebServiceClient.Text;

    #region IDownloadItemCollection

    /// <summary>_E[hACẽRNV񋟂܂B</summary>
    public interface IDownloadItemCollection
    {
        #region Property

        /// <summary>CfbNXɑΉl擾܂(ǂݎp)B</summary>
        /// <param name="index">lɑΉCfbNX([IW)\ intB</param>
        /// <returns>擾l\ <see cref="IDownloadItem"/>B</returns>
        IDownloadItem this[int index] { get; }

        /// <summary>L[ɑΉl擾܂(ǂݎp)B</summary>
        /// <param name="key">lɑΉL[\ stringB</param>
        /// <returns>擾l\ <see cref="IDownloadItem"/>B</returns>
        IDownloadItem this[string key] { get; }

        /// <summary>ACe擾܂(ǂݎp)B</summary>
        int Count { get; }

        #endregion

        #region Method

        /// <summary>ACeǉ܂B</summary>
        /// <param name="item">ǉACe\ stringB</param>
        /// <param name="item">ǉACe\ <see cref="IDownloadItem"/>B</param>
        void Add(string key, IDownloadItem value);

        /// <summary>w̃_E[hACe폜܂B</summary>
        /// <param name="item">_E[hACe\ <see cref="IDownloadItem"/>B</param>
        void Remove(IDownloadItem item);

        /// <summary>w̃CfbNX_E[hACe폜܂B</summary>
        /// <param name="index">_E[hACẽCfbNX\ intB</param>
        void Remove(int index);

        /// <summary>w̃CfbNX_E[hACe폜܂B</summary>
        /// <param name="indexes">_E[hACẽCfbNX\ int[]B</param>
        void Remove(int[] indexes);

        /// <summary>w̃L[_E[hACe폜܂B</summary>
        /// <param name="key">_E[hACẽL[\ stringB</param>
        void Remove(string key);

        /// <summary>_E[hACeړ܂B</summary>
        /// <param name="from">ړ̈ʒu\ intB</param>
        /// <param name="to">ړ̈ʒu\ intB</param>
        /// <remarks>
        /// <paramref name="to"/> ̈ʒuɂ_E[hACe̒Oɑ}܂B<br/>
        /// <paramref name="to"/>  0 ܂̓ACeȏ̒lw肵ꍇ͖֒ǉ܂B
        /// </remarks>
        void Move(int from, int to);

        /// <summary>_E[hACeړ܂B</summary>
        /// <param name="from">ړ̈ʒu\ int[]B</param>
        /// <param name="to">ړ̈ʒu\ intB</param>
        /// <remarks>
        /// <paramref name="to"/> ̈ʒuɂ_E[hACe̒Oɑ}܂B<br/>
        /// <paramref name="to"/>  0 ܂̓ACeȏ̒lw肵ꍇ͖֒ǉ܂B
        /// </remarks>
        void Move(int[] from, int to);

        /// <summary>_E[hACeNA܂B</summary>
        void Clear();

        /// <summary>w̃L[邩ǂ擾܂B</summary>
        /// <param name="key">i[Ă邩ׂL[\ stringB</param>
        /// <returns>ACei[Ăꍇ <see langword="true"/>AȊȌꍇ <see langword="false"/>B</returns>
        bool Contains(string key);

        /// <summary>_E[hACe\[g܂B</summary>
        /// <param name="fieldId">tB[hʎq\ <see cref="DownloadItemFieldId"/>B</param>
        /// <param name="sortOrder">\[g\ <see cref="SortOrder"/>B</param>
        void Sort(DownloadItemFieldId fieldId, SortOrder sortOrder);

        /// <summary>CX^X XML `ŃVACY܂B</summary>
        /// <param name="path">XML t@C̃pX\ stringB</param>
        /// <returns>VACYɐꍇ <see langword="true"/>AȊȌꍇ <see langword="false"/>B</returns>
        bool XmlSerialize(string path);

        /// <summary>VACY XML ɃRg[܂B</summary>
        /// <param name="path">XML t@C̃pX\ stringB</param>
        void XmlDeserialize(string path);

        #endregion
    }

    #endregion

    #region NicoDownloadItemCollection

    /// <summary>_E[hACẽRNV񋟂܂B</summary>
    public class NicoDownloadItemCollection : IDownloadItemCollection
    {
        #region Field

        /// <summary>Xgr[ACẽRNV\ <see cref="GkListView.IGkListViewItemCollection">IGkListViewItemCollection</see>B</summary>
        private GkListView.IGkListViewItemCollection _items;

        #endregion

        #region Constructor

        /// <summary>CX^X܂B</summary>
        /// <param name="items">Xgr[ACẽRNV\ <see cref="GkListView.IGkListViewItemCollection">IGkListViewItemCollection</see>B</param>
        public NicoDownloadItemCollection(GkListView.IGkListViewItemCollection items)
        {
            _items = items;
        }

        #endregion

        #region Method

        /// <summary>Xgr[ACe쐬܂B</summary>
        /// <param name="item">_E[hACe\ <see cref="IDownloadItem"/>B</param>
        /// <returns>쐬Xgr[ACe\ <see cref="NicoDownloadItem"/>B</returns>
        private NicoDownloadItem CreateListViewItem(IDownloadItem item)
        {
            if (item is NicoDownloadItem)
            {
                item.ResetDownloadState();
                item.Registration = item.Registration;
                return (item as NicoDownloadItem);
            }
            else
            {
                IDownloadItem lvItem = new NicoDownloadItem(item.VideoId, item.Title, item.LocalPath, item.Target);

                lvItem.Type = item.Type;
                lvItem.RemotePath = item.RemotePath;
                lvItem.Size = item.Size;
                lvItem.DownloadedSize = item.DownloadedSize;
                lvItem.Mode = item.Mode;
                lvItem.State = item.State;
                lvItem.Registration = item.Registration;

                return (lvItem as NicoDownloadItem);
            }
        }

        #endregion

        #region IDownloadItemCollection

        #region Property

        /// <summary>CfbNXɑΉl擾܂(ǂݎp)B</summary>
        /// <param name="index">lɑΉCfbNX([IW)\ intB</param>
        /// <returns>擾l\ <see cref="IDownloadItem"/>B</returns>
        IDownloadItem IDownloadItemCollection.this[int index]
        {
            get { return _items[index] as IDownloadItem; }
        }

        /// <summary>L[ɑΉl擾܂(ǂݎp)B</summary>
        /// <param name="videoId">lɑΉL[\ stringB</param>
        /// <returns>擾l\ <see cref="IDownloadItem"/>B</returns>
        IDownloadItem IDownloadItemCollection.this[string videoId]
        {
            get { return _items[videoId] as IDownloadItem; }
        }

        /// <summary>ACe擾܂(ǂݎp)B</summary>
        int IDownloadItemCollection.Count
        {
            get { return _items.Count; }
        }

        #endregion

        #region Methot

        /// <summary>ACeǉ܂B</summary>
        /// <param name="item">ǉACe\ stringB</param>
        /// <param name="item">ǉACe\ <see cref="IDownloadItem"/>B</param>
        void IDownloadItemCollection.Add(string key, IDownloadItem item)
        {
            GkListViewItem row = CreateListViewItem(item);
            _items.Add(key, row);
        }

        /// <summary>w̃_E[hACe폜܂B</summary>
        /// <param name="item">_E[hACe\ IDownloadItemB</param>
        void IDownloadItemCollection.Remove(IDownloadItem item)
        {
            _items.Remove(item as GkListViewItem);
        }

        /// <summary>w̃CfbNX_E[hACe폜܂B</summary>
        /// <param name="index">_E[hACẽCfbNX\ intB</param>
        void IDownloadItemCollection.Remove(int index)
        {
            _items.RemoveAt(index);
        }

        /// <summary>w̃CfbNX_E[hACe폜܂B</summary>
        /// <param name="indexes">_E[hACẽCfbNX\ int[]B</param>
        void IDownloadItemCollection.Remove(int[] indexes)
        {
            foreach (int index in indexes)
            {
                _items.RemoveAt(index);
            }
        }

        /// <summary>w̃L[_E[hACe폜܂B</summary>
        /// <param name="key">_E[hACẽL[\ stringB</param>
        void IDownloadItemCollection.Remove(string key)
        {
            _items.RemoveByKey(key);
        }

        /// <summary>_E[hACeړ܂B</summary>
        /// <param name="from">ړ̈ʒu\ intB</param>
        /// <param name="to">ړ̈ʒu\ intB</param>
        /// <remarks>
        /// <paramref name="to"/> ̈ʒuɂ_E[hACe̒Oɑ}܂B<br/>
        /// <paramref name="to"/>  0 ܂̓ACeȏ̒lw肵ꍇ͖֒ǉ܂B
        /// </remarks>
        void IDownloadItemCollection.Move(int from, int to)
        {
            _items.Move(from, to);
        }

        /// <summary>_E[hACeړ܂B</summary>
        /// <param name="from">ړ̈ʒu\ int[]B</param>
        /// <param name="to">ړ̈ʒu\ intB</param>
        /// <remarks>
        /// <paramref name="to"/> ̈ʒuɂ_E[hACe̒Oɑ}܂B<br/>
        /// <paramref name="to"/>  0 ܂̓ACeȏ̒lw肵ꍇ͖֒ǉ܂B
        /// </remarks>
        void IDownloadItemCollection.Move(int[] from, int to)
        {
            foreach (int index in from)
            {
                _items.Move(index, to);

                if (index > to)
                {
                    to++;
                }
            }
        }

        /// <summary>_E[hACeNA܂B</summary>
        void IDownloadItemCollection.Clear()
        {
            _items.Clear();
        }

        /// <summary>w̃L[邩ǂ擾܂B</summary>
        /// <param name="videoId">i[Ă邩ׂL[\ stringB</param>
        /// <returns>ACei[Ăꍇ <see langword="true"/>AȊȌꍇ <see langword="false"/>B</returns>
        bool IDownloadItemCollection.Contains(string videoId)
        {
            return _items.ContainsKey(videoId);
        }

        /// <summary>_E[hACe\[g܂B</summary>
        /// <param name="fieldId">tB[hʎq\ <see cref="DownloadItemFieldId"/>B</param>
        /// <param name="sortOrder">\[g\ <see cref="SortOrder"/>B</param>
        void IDownloadItemCollection.Sort(DownloadItemFieldId fieldId, SortOrder sortOrder)
        {
            GkListView view = _items.ListView;
            view.ListViewItemSorter = null;
            int columnIndex = -1;

            switch (fieldId)
            {
            case DownloadItemFieldId.Title: columnIndex = NicoDownloadViewIndex.Title; break;
            case DownloadItemFieldId.Size: columnIndex = NicoDownloadViewIndex.Size; break;
            case DownloadItemFieldId.Rate: columnIndex = NicoDownloadViewIndex.Rate; break;
            case DownloadItemFieldId.TimeLife: columnIndex = NicoDownloadViewIndex.TimeLife; break;
            case DownloadItemFieldId.Speed: columnIndex = NicoDownloadViewIndex.Speed; break;
            case DownloadItemFieldId.Mode: columnIndex = NicoDownloadViewIndex.Mode; break;
            case DownloadItemFieldId.Type: columnIndex = NicoDownloadViewIndex.Type; break;
            case DownloadItemFieldId.Registration: columnIndex = NicoDownloadViewIndex.Registration; break;
            case DownloadItemFieldId.Folder: columnIndex = NicoDownloadViewIndex.Folder; break;
            }

            switch (fieldId)
            {
            case DownloadItemFieldId.Title:         // ^Cg
                view.ListViewItemSorter = new ListViewItemComparerAsNatural(columnIndex, sortOrder, NaturalComparerOptions.Default, new char[] { '' });
                break;

            case DownloadItemFieldId.Size:          // TCY
                view.ListViewItemSorter = new GkListViewItemComparerAsAny(columnIndex, sortOrder, new GkListViewItemComparerAsAny.CustomCompare(delegate(GkListViewItem x, GkListViewItem y)
                {
                    return (x as NicoDownloadItem).Size.CompareTo((y as NicoDownloadItem).Size);
                }));
                break;

            case DownloadItemFieldId.Rate:          // i
                view.ListViewItemSorter = new GkListViewItemComparerAsAny(columnIndex, sortOrder, new GkListViewItemComparerAsAny.CustomCompare(delegate(GkListViewItem x, GkListViewItem y)
                {
                    return (x as NicoDownloadItem).Rate.CompareTo((y as NicoDownloadItem).Rate);
                }));
                break;

            case DownloadItemFieldId.TimeLife:     // c莞
                view.ListViewItemSorter = new GkListViewItemComparerAsAny(columnIndex, sortOrder, new GkListViewItemComparerAsAny.CustomCompare(delegate(GkListViewItem x, GkListViewItem y)
                {
                    return (x as NicoDownloadItem).TimeLife.CompareTo((y as NicoDownloadItem).TimeLife);
                }));
                break;

            case DownloadItemFieldId.Speed:         // ]x(KB/s)
                view.ListViewItemSorter = new GkListViewItemComparerAsAny(columnIndex, sortOrder, new GkListViewItemComparerAsAny.CustomCompare(delegate(GkListViewItem x, GkListViewItem y)
                {
                    return (x as NicoDownloadItem).Speed.CompareTo((y as NicoDownloadItem).Speed);
                }));
                break;

            case DownloadItemFieldId.Mode:          // [h
                view.ListViewItemSorter = new GkListViewItemComparerAsAny(columnIndex, sortOrder, new GkListViewItemComparerAsAny.CustomCompare(delegate(GkListViewItem x, GkListViewItem y)
                {
                    return (x as NicoDownloadItem).Mode.CompareTo((y as NicoDownloadItem).Mode);
                }));
                break;

            case DownloadItemFieldId.Type:          // gq
                view.ListViewItemSorter = new GkListViewItemComparerAsAny(columnIndex, sortOrder, new GkListViewItemComparerAsAny.CustomCompare(delegate(GkListViewItem x, GkListViewItem y)
                {
                    return (x as NicoDownloadItem).Type.CompareTo((y as NicoDownloadItem).Type);
                }));
                break;

            case DownloadItemFieldId.Registration:  // o^
                view.ListViewItemSorter = new ListViewItemComparerAsDateTime(columnIndex, sortOrder);
                break;

            case DownloadItemFieldId.Folder:        // tH_
                view.ListViewItemSorter = new ListViewItemComparerAsString(columnIndex, sortOrder);
                break;
            }
        }

        /// <summary>CX^X XML `ŃVACY܂B</summary>
        /// <param name="path">XML t@C̃pX\ stringB</param>
        /// <returns>VACYɐꍇ <see langword="true"/>AȊȌꍇ <see langword="false"/>B</returns>
        public bool XmlSerialize(string path)
        {
            try
            {
                _items.XmlSerialize(path, new UTF8Encoding(false));
                return true;
            }
            catch
            {
                return false;
            }
        }

        /// <summary>VACY XML ɃRg[܂B</summary>
        /// <param name="path">XML t@C̃pX\ stringB</param>
        public void XmlDeserialize(string path)
        {
            _items.XmlDeserialize(path);
        }

        #endregion

        #endregion
    }

    #endregion

    #region NicoDownloadVirtualItemCollection

    /// <summary>_E[hACẽRNV񋟂܂B</summary>
    public class NicoDownloadVirtualItemCollection : IDownloadItemCollection
    {
        #region Field

        /// <summary></summary>
        protected OrderedDictionary<string, IDownloadItem> _items;

        #endregion

        #region Constructor

        /// <summary>CX^X܂B</summary>
        public NicoDownloadVirtualItemCollection()
        {
            _items = new OrderedDictionary<string, IDownloadItem>();
        }

        #endregion

        #region Method

        /// <summary>Xgr[ACe쐬܂B</summary>
        /// <param name="item">_E[hACe\ <see cref="IDownloadItem"/>B</param>
        /// <returns>쐬Xgr[ACe\ <see cref="NicoDownloadItem"/>B</returns>
        private NicoDownloadItem CreateListViewItem(IDownloadItem item)
        {
            if (item is NicoDownloadItem)
            {
                return (item as NicoDownloadItem);
            }
            else
            {
                IDownloadItem lvItem = new NicoDownloadItem(item.VideoId, item.Title, item.LocalPath, item.Target);

                lvItem.Type = item.Type;
                lvItem.RemotePath = item.RemotePath;
                lvItem.Size = item.Size;
                lvItem.DownloadedSize = item.DownloadedSize;
                lvItem.Mode = item.Mode;
                lvItem.State = item.State;
                lvItem.Registration = item.Registration;

                return (lvItem as NicoDownloadItem);
            }
        }

        #endregion

        #region IDownloadItemCollection

        #region Property

        /// <summary>CfbNXɑΉl擾܂(ǂݎp)B</summary>
        /// <param name="index">lɑΉCfbNX([IW)\ intB</param>
        /// <returns>擾l\ <see cref="IDownloadItem"/>B</returns>
        IDownloadItem IDownloadItemCollection.this[int index]
        {
            get { return _items[index] as IDownloadItem; }
        }

        /// <summary>L[ɑΉl擾܂(ǂݎp)B</summary>
        /// <param name="videoId">lɑΉL[\ stringB</param>
        /// <returns>擾l\ <see cref="IDownloadItem"/>B</returns>
        IDownloadItem IDownloadItemCollection.this[string videoId]
        {
            get { return _items[videoId] as IDownloadItem; }
        }

        /// <summary>ACe擾܂(ǂݎp)B</summary>
        int IDownloadItemCollection.Count
        {
            get { return _items.Count; }
        }

        #endregion

        #region Methot

        /// <summary>ACeǉ܂B</summary>
        /// <param name="item">ǉACe\ stringB</param>
        /// <param name="item">ǉACe\ <see cref="IDownloadItem"/>B</param>
        void IDownloadItemCollection.Add(string key, IDownloadItem item)
        {
            NicoDownloadItem row = CreateListViewItem(item);
            row.Key = key;
            _items.Add(key, row);
        }

        /// <summary>w̃_E[hACe폜܂B</summary>
        /// <param name="item">_E[hACe\ IDownloadItemB</param>
        void IDownloadItemCollection.Remove(IDownloadItem item)
        {
            _items.Remove(item.Key);
        }

        /// <summary>w̃CfbNX_E[hACe폜܂B</summary>
        /// <param name="index">_E[hACẽCfbNX\ intB</param>
        void IDownloadItemCollection.Remove(int index)
        {
            _items.RemoveAt(index);
        }

        /// <summary>w̃CfbNX_E[hACe폜܂B</summary>
        /// <param name="indexes">_E[hACẽCfbNX\ int[]B</param>
        void IDownloadItemCollection.Remove(int[] indexes)
        {
            foreach (int index in indexes)
            {
                _items.RemoveAt(index);
            }
        }

        /// <summary>w̃L[_E[hACe폜܂B</summary>
        /// <param name="key">_E[hACẽL[\ stringB</param>
        void IDownloadItemCollection.Remove(string key)
        {
            _items.Remove(key);
        }

        /// <summary>_E[hACeړ܂B</summary>
        /// <param name="from">ړ̈ʒu\ intB</param>
        /// <param name="to">ړ̈ʒu\ intB</param>
        /// <remarks>
        /// <paramref name="to"/> ̈ʒuɂ_E[hACe̒Oɑ}܂B<br/>
        /// <paramref name="to"/>  0 ܂̓ACeȏ̒lw肵ꍇ͖֒ǉ܂B
        /// </remarks>
        void IDownloadItemCollection.Move(int from, int to)
        {
            _items.Move(from, to);
        }

        /// <summary>_E[hACeړ܂B</summary>
        /// <param name="from">ړ̈ʒu\ int[]B</param>
        /// <param name="to">ړ̈ʒu\ intB</param>
        /// <remarks>
        /// <paramref name="to"/> ̈ʒuɂ_E[hACe̒Oɑ}܂B<br/>
        /// <paramref name="to"/>  0 ܂̓ACeȏ̒lw肵ꍇ͖֒ǉ܂B
        /// </remarks>
        void IDownloadItemCollection.Move(int[] from, int to)
        {
            foreach (int index in from)
            {
                _items.Move(index, to);

                if (index > to)
                {
                    to++;
                }
            }
        }

        /// <summary>_E[hACeNA܂B</summary>
        void IDownloadItemCollection.Clear()
        {
            _items.Clear();
        }

        /// <summary>w̃L[邩ǂ擾܂B</summary>
        /// <param name="videoId">i[Ă邩ׂL[\ stringB</param>
        /// <returns>ACei[Ăꍇ <see langword="true"/>AȊȌꍇ <see langword="false"/>B</returns>
        bool IDownloadItemCollection.Contains(string videoId)
        {
            return _items.ContainsKey(videoId);
        }

        /// <summary>_E[hACe\[g܂B</summary>
        /// <param name="fieldId">tB[hʎq\ <see cref="DownloadItemFieldId"/>B</param>
        /// <param name="sortOrder">\[g\ <see cref="SortOrder"/>B</param>
        void IDownloadItemCollection.Sort(DownloadItemFieldId fieldId, SortOrder sortOrder)
        {
            int order = (sortOrder == SortOrder.Ascending) ? 1 : -1;

            switch (fieldId)
            {
            case DownloadItemFieldId.Title:         // ^Cg
                NaturalComparer titleComparer = new NaturalComparer(NaturalSortOrder.Ascending, NaturalComparerOptions.Default, new char[] { '' });
                _items.Sort(delegate(IKeyValuePair<string, IDownloadItem> x, IKeyValuePair<string, IDownloadItem> y)
                {
                    return titleComparer.Compare(x.Value.Title, y.Value.Title) * order;
                });
                break;

            case DownloadItemFieldId.Size:          // TCY
                _items.Sort(delegate(IKeyValuePair<string, IDownloadItem> x, IKeyValuePair<string, IDownloadItem> y)
                {
                    return x.Value.Size.CompareTo(y.Value.Size) * order;
                });
                break;

            case DownloadItemFieldId.Rate:          // i
                _items.Sort(delegate(IKeyValuePair<string, IDownloadItem> x, IKeyValuePair<string, IDownloadItem> y)
                {
                    return x.Value.Rate.CompareTo(y.Value.Rate) * order;
                });
                break;

            case DownloadItemFieldId.TimeLife:     // c莞
                _items.Sort(delegate(IKeyValuePair<string, IDownloadItem> x, IKeyValuePair<string, IDownloadItem> y)
                {
                    return x.Value.TimeLife.CompareTo(y.Value.TimeLife) * order;
                });
                break;

            case DownloadItemFieldId.Speed:         // ]x(KB/s)
                _items.Sort(delegate(IKeyValuePair<string, IDownloadItem> x, IKeyValuePair<string, IDownloadItem> y)
                {
                    return x.Value.Speed.CompareTo(y.Value.Speed) * order;
                });
                break;

            case DownloadItemFieldId.Mode:          // [h
                _items.Sort(delegate(IKeyValuePair<string, IDownloadItem> x, IKeyValuePair<string, IDownloadItem> y)
                {
                    return x.Value.Mode.CompareTo(y.Value.Mode) * order;
                });
                break;

            case DownloadItemFieldId.Type:          // gq
                _items.Sort(delegate(IKeyValuePair<string, IDownloadItem> x, IKeyValuePair<string, IDownloadItem> y)
                {
                    return x.Value.Type.CompareTo(y.Value.Type) * order;
                });
                break;

            case DownloadItemFieldId.Registration:  // o^
                _items.Sort(delegate(IKeyValuePair<string, IDownloadItem> x, IKeyValuePair<string, IDownloadItem> y)
                {
                    return x.Value.Registration.CompareTo(y.Value.Registration) * order;
                });
                break;

            case DownloadItemFieldId.Folder:        // tH_
                _items.Sort(delegate(IKeyValuePair<string, IDownloadItem> x, IKeyValuePair<string, IDownloadItem> y)
                {
                    return x.Value.LocalDirectory.CompareTo(y.Value.LocalDirectory) * order;
                });
                break;
            }
        }

        /// <summary>CX^X XML `ŃVACY܂B</summary>
        /// <param name="path">XML t@C̃pX\ stringB</param>
        /// <returns>VACYɐꍇ <see langword="true"/>AȊȌꍇ <see langword="false"/>B</returns>
        public bool XmlSerialize(string path)
        {
            try
            {
                SerializeHelper.XmlSerialize(_items, path, new UTF8Encoding(false));
                return true;
            }
            catch
            {
                return false;
            }
        }

        /// <summary>VACY XML ɃRg[܂B</summary>
        /// <param name="path">XML t@C̃pX\ stringB</param>
        public void XmlDeserialize(string path)
        {
            _items = SerializeHelper.XmlDeserialize<OrderedDictionary<string, IDownloadItem>>(path);
        }

        #endregion

        #endregion
    }

    #endregion
}
