using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Xml;
using System.Xml.Serialization;

namespace Alternative
{
    using WebServiceClient;
    using WebServiceClient.Forms;

    #region NicoDownloadItem

    /// <summary>ListView `̃_E[hACe񋟂܂B</summary>
    [Serializable()]
    public class NicoDownloadItem : GkListViewItem, IDownloadItem, IXmlSerializable
    {
        #region Field

        /// <summary>^XN ID \ intB</summary>
        protected int _taskId;
        /// <summary> ID \ stringB</summary>
        protected string _videoId;
        /// <summary>_E[h铮̎ނ\ <see cref="DownloadVideoType"/>B</summary>
        protected DownloadVideoType _type;
        /// <summary>[JpX̏\ stringB</summary>
        protected string _pathFormat;
        /// <summary>[gpX\ stringB</summary>
        protected string _remotePath;
        /// <summary>[JpX\ stringB</summary>
        protected string _localPath;
        /// <summary>t@C̃TCY\ longB</summary>
        protected long _size;
        /// <summary>_E[hς݂̃TCY\ longB</summary>
        protected long _downloadedSize;
        /// <summary>LbṼTCY\ longB</summary>
        protected long _cacheSize;
        /// <summary>_E[h[h\ <see cref="DownloadMode"/>B</summary>
        protected DownloadMode _mode;
        /// <summary>_E[hΏۂ̃Rec\ <see cref="DownloadTarget"/>B</summary>
        protected DownloadTarget _target;
        /// <summary>_E[hACȅԂ\ <see cref="DownloadItemState"/>B</summary>
        protected DownloadItemState _state;
        /// <summary>_E[hACe̓o^\ DateTimeB</summary>
        protected DateTime _registration;
        /// <summary>_E[hJňoߎ(~b)\ longB</summary>
        protected long _downloadTime;

        #endregion

        #region Constructor

        /// <summary>CX^X܂B</summary>
        private NicoDownloadItem()
        {
        }

        /// <summary>CX^X܂B</summary>
        /// <param name="videoId"> ID \ stringB</param>
        /// <param name="title">^Cg\ stringB</param>
        /// <param name="pathFormat">[JpX̏\ stringB</param>
        /// <param name="target">_E[hRec̎ނ\ <see cref="DownloadTarget"/>B</param>
        public NicoDownloadItem(string videoId, string title, string pathFormat, DownloadTarget target)
        {
            _videoId = videoId;
            base.Text = title;

            int count = typeof(NicoDownloadViewIndex).GetFields().Length;

            // TuACe̍쐬
            for (int i = 1; i < count; i++)
            {
                switch (i)
                {
                case NicoDownloadViewIndex.Rate:            // i
                    base.SubItems.Add(new GkListViewProgressBar(0, 0, 0, 1));
                    break;
                case NicoDownloadViewIndex.Size:            // TCY
                    base.SubItems.Add(new GkListViewItem.GkListViewSubItem(""));
                    break;
                case NicoDownloadViewIndex.TimeLife:        // c莞
                    base.SubItems.Add(new GkListViewItem.GkListViewSubItem(""));
                    break;
                case NicoDownloadViewIndex.Speed:           // ]x(KB/s)
                    base.SubItems.Add(new GkListViewItem.GkListViewSubItem(""));
                    break;
                case NicoDownloadViewIndex.Mode:            // [h
                    base.SubItems.Add(new GkListViewItem.GkListViewSubItem(""));
                    break;
                case NicoDownloadViewIndex.Type:            // gq
                    base.SubItems.Add(new GkListViewItem.GkListViewSubItem(""));
                    break;
                case NicoDownloadViewIndex.Registration:    // o^
                    base.SubItems.Add(new GkListViewItem.GkListViewSubItem(""));
                    break;
                case NicoDownloadViewIndex.Folder:          // tH_
                    base.SubItems.Add(new GkListViewItem.GkListViewSubItem(""));
                    break;
                }
            }

            _pathFormat = pathFormat;
            _target = target;
        }

        #endregion

        #region Property

        /// <summary>^XN ID 擾Eݒ肵܂B</summary>
        public int TaskId
        {
            get { return _taskId; }
            set { _taskId = value; }
        }

        /// <summary>ʎq擾Eݒ肵܂B</summary>
        public string Key
        {
            get { return base.Name; }
            set { base.Name = value; }
        }

        /// <summary> ID 擾܂(ǂݎp)B</summary>
        public string VideoId
        {
            get { return _videoId; }
        }

        /// <summary>^Cg擾Eݒ肵܂B</summary>
        public string Title
        {
            get { return base.Text; }
            set { base.Text = value; }
        }

        /// <summary>_E[h铮̎ނ擾Eݒ肵܂B</summary>
        public DownloadVideoType Type
        {
            get { return _type; }
            set
            {
                _type = value;
                base.SubItems[NicoDownloadViewIndex.Type].Text = ComponentHelper.GetEnumFieldDescription(value);
            }
        }

        /// <summary>[JpX̏擾܂(ǂݎp)B</summary>
        public string PathFormat
        {
            get { return _pathFormat; }
        }

        /// <summary>[gpX擾Eݒ肵܂B</summary>
        public string RemotePath
        {
            get { return _remotePath; }
            set { _remotePath = value; }
        }

        /// <summary>[JpX擾Eݒ肵܂B</summary>
        public string LocalPath
        {
            get { return _localPath; }
            set
            {
                _localPath = value;
                base.SubItems[NicoDownloadViewIndex.Folder].Text = Path.GetDirectoryName(value);
            }
        }

        /// <summary>[JfBNg擾܂(ǂݎp)B</summary>
        public string LocalDirectory
        {
            get { return base.SubItems[NicoDownloadViewIndex.Folder].Text; }
        }

        /// <summary>t@C̃TCY擾Eݒ肵܂B</summary>
        public long Size
        {
            get { return _size; }
            set
            {
                _size = value;
                base.SubItems[NicoDownloadViewIndex.Size].Text = string.Format("{0:N3} / {1:N3}", MathHelper.Ceiling((decimal)_downloadedSize / 1024000, 3), MathHelper.Ceiling((decimal)_size / 1024000, 3));
                (base.SubItems[NicoDownloadViewIndex.Rate] as GkListViewProgressBar).Maximum = value;
            }
        }

        /// <summary>_E[hς݂̃TCY擾Eݒ肵܂B</summary>
        public long DownloadedSize
        {
            get { return _downloadedSize; }
            set
            {
                _downloadedSize = value;
                base.SubItems[NicoDownloadViewIndex.Size].Text = string.Format("{0:N3} / {1:N3}", MathHelper.Ceiling((decimal)_downloadedSize / 1024000, 3), MathHelper.Ceiling((decimal)_size / 1024000, 3));
                (base.SubItems[NicoDownloadViewIndex.Rate] as GkListViewProgressBar).Value = value;
                if (_downloadTime > 0)
                {
                    base.SubItems[NicoDownloadViewIndex.TimeLife].Text = string.Format("{0:N0}b", this.TimeLife.TotalSeconds);
                    base.SubItems[NicoDownloadViewIndex.Speed].Text = string.Format("{0:N0}KB/s", this.Speed / 1024);
                }
                else
                {
                    base.SubItems[NicoDownloadViewIndex.TimeLife].Text = "";
                    base.SubItems[NicoDownloadViewIndex.Speed].Text = "";
                }
            }
        }

        /// <summary>LbṼTCY擾Eݒ肵܂B</summary>
        public long CacheSize
        {
            get { return _cacheSize; }
            set { _cacheSize = value; }
        }

        /// <summary>_E[h[h擾Eݒ肵܂B</summary>
        public DownloadMode Mode
        {
            get { return _mode; }
            set
            {
                _mode = value;
                base.SubItems[NicoDownloadViewIndex.Mode].Text = ComponentHelper.GetEnumFieldDescription(value);
            }
        }

        /// <summary>_E[hΏۂ̃Rec擾Eݒ肵܂B</summary>
        public DownloadTarget Target
        {
            get { return _target; }
            set { _target = value; }
        }

        /// <summary>_E[hACȅԂ擾Eݒ肵܂B</summary>
        public DownloadItemState State
        {
            get { return _state; }
            set
            {
                _state = value;
                GkListViewProgressBar bar = (base.SubItems[NicoDownloadViewIndex.Rate] as GkListViewProgressBar);
                bar.Text = ComponentHelper.GetEnumFieldDescription(value);
                if (value == DownloadItemState.Processing)
                {
                    bar.VisibleControl = true;
                }
                else
                {
                    bar.VisibleControl = false;
                    base.SubItems[NicoDownloadViewIndex.TimeLife].Text = "";
                }
            }
        }

        /// <summary>_E[hACe̓o^擾Eݒ肵܂B</summary>
        public DateTime Registration
        {
            get { return _registration; }
            set
            {
                _registration = value;
                base.SubItems[NicoDownloadViewIndex.Registration].Text = value.ToString("yyyy/MM/dd HH:mm:ss");
            }
        }

        /// <summary>_E[hJňoߎ(~b)擾Eݒ肵܂B</summary>
        public long DownloadTime
        {
            get { return _downloadTime; }
            set { _downloadTime = value; }
        }

        /// <summary>_E[h̐i擾܂(ǂݎp)B</summary>
        public double Rate
        {
            get { return (_size <= 0) ? 0 : _downloadedSize / _size; }
        }

        /// <summary>_E[h̓]x(byte/sec)擾܂(ǂݎp)B</summary>
        public double Speed
        {
            get { return (_downloadedSize - _cacheSize) / Math.Max((double)_downloadTime / 1000, 1); }
        }

        /// <summary>_E[h܂łɕKvȎԂ擾܂(ǂݎp)B</summary>
        public TimeSpan TimeLife
        {
            get { return new TimeSpan((long)((double)(_size - _downloadedSize) * _downloadTime * 10000 / _downloadedSize)); }
        }

        #endregion

        #region Method

        /// <summary>_E[h̏ԂZbg܂B</summary>
        public void ResetDownloadState()
        {
            _size = 0;
            _downloadedSize = 0;
            _cacheSize = 0;
            _downloadTime = 0;
        }

        #endregion

        #region IXmlSerializable Intaface

        /// <summary>̃vpeB͗\񂳂Ă܂B</summary>
        /// <returns> <see langword="null"/> Ԃ܂B</returns>
        System.Xml.Schema.XmlSchema IXmlSerializable.GetSchema()
        {
            return null;
        }

        /// <summary>XML `ŃVACYꂽɃCX^X܂B</summary>
        /// <param name="reader">fVACYIuWFNg XML \ <see cref="XmlReader"/>B</param>
        /// <remarks>fVACYɂ TKey  TValue ɃftHgRXgN^KvłB</remarks>
        void IXmlSerializable.ReadXml(XmlReader reader)
        {
            if (reader.IsEmptyElement == false)
            {
                using (XmlHelper.ReadStartElement(reader))
                {
                    XmlDeserialize(reader);
                }
            }
        }

        /// <summary>CX^X XML `ŃVACY܂B</summary>
        /// <param name="writer">VACY XML \ <see cref="XmlWriter"/>B</param>
        /// <remarks>fVACYɂ TKey  TValue ɃftHgRXgN^KvłB</remarks>
        void IXmlSerializable.WriteXml(XmlWriter writer)
        {
            XmlSerialize(writer);
        }

        /// <summary>XML `ŃVACYꂽɃCX^X܂B</summary>
        /// <param name="reader">fVACYIuWFNg XML \ <see cref="XmlReader"/>B</param>
        /// <remarks>fVACYɂ TKey  TValue ɃftHgRXgN^KvłB</remarks>
        protected override void XmlDeserialize(XmlReader reader)
        {
            XmlSerializer longSerializer = new XmlSerializer(typeof(long));
            XmlSerializer stringSerializer = new XmlSerializer(typeof(string));
            XmlSerializer datetimeSerializer = new XmlSerializer(typeof(DateTime));

            base.XmlDeserialize(reader);

            using (XmlHelper.ReadStartElement(reader, "Key"))
            {
                base.Name = (string)stringSerializer.Deserialize(reader);
            }

            using (XmlHelper.ReadStartElement(reader, "VideoId"))
            {
                _videoId = (string)stringSerializer.Deserialize(reader);
            }

            using (XmlHelper.ReadStartElement(reader, "Title"))
            {
                this.Title = (string)stringSerializer.Deserialize(reader);
            }

            using (XmlHelper.ReadStartElement(reader, "Type"))
            {
                this.Type = (DownloadVideoType)(new XmlSerializer(typeof(DownloadVideoType))).Deserialize(reader);
            }

            using (XmlHelper.ReadStartElement(reader, "PathFormat"))
            {
                _pathFormat = (string)stringSerializer.Deserialize(reader);
            }

            using (XmlHelper.ReadStartElement(reader, "RemotePath"))
            {
                this.RemotePath = (string)stringSerializer.Deserialize(reader);
            }

            using (XmlHelper.ReadStartElement(reader, "LocalPath"))
            {
                this.LocalPath = (string)stringSerializer.Deserialize(reader);
            }

            using (XmlHelper.ReadStartElement(reader, "Size"))
            {
                this.Size = (long)longSerializer.Deserialize(reader);
            }

            using (XmlHelper.ReadStartElement(reader, "DownloadedSize"))
            {
                this.DownloadedSize = (long)longSerializer.Deserialize(reader);
            }

            using (XmlHelper.ReadStartElement(reader, "CacheSize"))
            {
                this.CacheSize = (long)longSerializer.Deserialize(reader);
            }

            using (XmlHelper.ReadStartElement(reader, "Mode"))
            {
                this.Mode = (DownloadMode)(new XmlSerializer(typeof(DownloadMode))).Deserialize(reader);
            }

            using (XmlHelper.ReadStartElement(reader, "Target"))
            {
                this.Target = (DownloadTarget)(new XmlSerializer(typeof(DownloadTarget))).Deserialize(reader);
            }

            using (XmlHelper.ReadStartElement(reader, "State"))
            {
                DownloadItemState state = (DownloadItemState)(new XmlSerializer(typeof(DownloadItemState))).Deserialize(reader);
                switch (state)
                {
                case DownloadItemState.Start:
                case DownloadItemState.Processing:
                    this.State = DownloadItemState.Waiting;
                    break;

                default:
                    this.State = state;
                    break;
                }
                
            }

            using (XmlHelper.ReadStartElement(reader, "Registration"))
            {
                this.Registration = (DateTime)datetimeSerializer.Deserialize(reader);
            }
        }

        /// <summary>CX^X XML `ŃVACY܂B</summary>
        /// <param name="writer">VACY XML \ <see cref="XmlWriter"/>B</param>
        /// <remarks>fVACYɂ TKey  TValue ɃftHgRXgN^KvłB</remarks>
        protected override void XmlSerialize(XmlWriter writer)
        {
            XmlSerializer longSerializer = new XmlSerializer(typeof(long));
            XmlSerializer stringSerializer = new XmlSerializer(typeof(string));
            XmlSerializer datetimeSerializer = new XmlSerializer(typeof(DateTime));

            base.XmlSerialize(writer);

            using (XmlHelper.WriteStartElement(writer, "Key"))
            {
                stringSerializer.Serialize(writer, base.Name);
            }

            using (XmlHelper.WriteStartElement(writer, "VideoId"))
            {
                stringSerializer.Serialize(writer, _videoId);
            }

            using (XmlHelper.WriteStartElement(writer, "Title"))
            {
                stringSerializer.Serialize(writer, base.Text);
            }

            using (XmlHelper.WriteStartElement(writer, "Type"))
            {
                (new XmlSerializer(typeof(DownloadVideoType))).Serialize(writer, _type);
            }

            using (XmlHelper.WriteStartElement(writer, "PathFormat"))
            {
                stringSerializer.Serialize(writer, _pathFormat);
            }

            using (XmlHelper.WriteStartElement(writer, "RemotePath"))
            {
                stringSerializer.Serialize(writer, _remotePath);
            }

            using (XmlHelper.WriteStartElement(writer, "LocalPath"))
            {
                stringSerializer.Serialize(writer, _localPath);
            }

            using (XmlHelper.WriteStartElement(writer, "Size"))
            {
                longSerializer.Serialize(writer, _size);
            }

            using (XmlHelper.WriteStartElement(writer, "DownloadedSize"))
            {
                longSerializer.Serialize(writer, _downloadedSize);
            }

            using (XmlHelper.WriteStartElement(writer, "CacheSize"))
            {
                longSerializer.Serialize(writer, _cacheSize);
            }

            using (XmlHelper.WriteStartElement(writer, "Mode"))
            {
                (new XmlSerializer(typeof(DownloadMode))).Serialize(writer, _mode);
            }

            using (XmlHelper.WriteStartElement(writer, "Target"))
            {
                (new XmlSerializer(typeof(DownloadTarget))).Serialize(writer, _target);
            }

            using (XmlHelper.WriteStartElement(writer, "State"))
            {
                (new XmlSerializer(typeof(DownloadItemState))).Serialize(writer, _state);
            }

            using (XmlHelper.WriteStartElement(writer, "Registration"))
            {
                datetimeSerializer.Serialize(writer, _registration);
            }
        }

        #endregion
    }

    #endregion

    #region NicoDownloadVirtualItem

    /// <summary>z ListView `̃_E[hACe񋟂܂B</summary>
    [Serializable()]
    public class NicoDownloadVirtualItem : IDownloadItem, IXmlSerializable
    {
        #region Field

        /// <summary>^XN ID \ intB</summary>
        protected int _taskId;
        /// <summary>ACe\ stringB</summary>
        protected string _key;
        /// <summary> ID \ stringB</summary>
        protected string _videoId;
        /// <summary>^Cg\ stringB</summary>
        protected string _title;
        /// <summary>_E[h铮̎ނ\ <see cref="DownloadVideoType"/>B</summary>
        protected DownloadVideoType _type;
        /// <summary>[JpX̏\ stringB</summary>
        protected string _pathFormat;
        /// <summary>[gpX\ stringB</summary>
        protected string _remotePath;
        /// <summary>[JpX\ stringB</summary>
        protected string _localPath;
        /// <summary>t@C̃TCY\ longB</summary>
        protected long _size;
        /// <summary>_E[hς݂̃TCY\ longB</summary>
        protected long _downloadedSize;
        /// <summary>LbṼTCY\ longB</summary>
        protected long _cacheSize;
        /// <summary>_E[h[h\ <see cref="DownloadMode"/>B</summary>
        protected DownloadMode _mode;
        /// <summary>_E[hΏۂ̃Rec\ <see cref="DownloadTarget"/>B</summary>
        protected DownloadTarget _target;
        /// <summary>_E[hACȅԂ\ <see cref="DownloadItemState"/>B</summary>
        protected DownloadItemState _state;
        /// <summary>_E[hACe̓o^\ DateTimeB</summary>
        protected DateTime _registration;
        /// <summary>_E[hJňoߎ(~b)\ longB</summary>
        protected long _downloadTime;

        #endregion

        #region Constructor

        /// <summary>CX^X܂B</summary>
        /// <param name="videoId"> ID \ stringB</param>
        /// <param name="title">^Cg\ stringB</param>
        /// <param name="pathFormat">[JpX̏\ stringB</param>
        /// <param name="target">_E[hRec̎ނ\ <see cref="DownloadTarget"/>B</param>
        public NicoDownloadVirtualItem(string videoId, string title, string pathFormat, DownloadTarget target)
        {
            _videoId = videoId;
            _title = title;
            _pathFormat = pathFormat;
            _target = target;
        }

        #endregion

        #region Property

        /// <summary>^XN ID 擾Eݒ肵܂B</summary>
        public int TaskId
        {
            get { return _taskId; }
            set { _taskId = value; }
        }

        /// <summary>ʎq擾Eݒ肵܂B</summary>
        public string Key
        {
            get { return _key; }
            set { _key = value; }
        }

        /// <summary> ID 擾܂(ǂݎp)B</summary>
        public string VideoId
        {
            get { return _videoId; }
        }

        /// <summary>^Cg擾Eݒ肵܂B</summary>
        public string Title
        {
            get { return _title; }
            set { _title = value; }
        }

        /// <summary>_E[h铮̎ނ擾Eݒ肵܂B</summary>
        public DownloadVideoType Type
        {
            get { return _type; }
            set { _type = value; }
        }

        /// <summary>[JpX̏擾܂B</summary>
        public string PathFormat
        {
            get { return _pathFormat; }
        }

        /// <summary>[gpX擾Eݒ肵܂B</summary>
        public string RemotePath
        {
            get { return _remotePath; }
            set { _remotePath = value; }
        }

        /// <summary>[JpX擾Eݒ肵܂B</summary>
        public string LocalPath
        {
            get { return _localPath; }
            set { _localPath = value; }
        }

        /// <summary>[JfBNg擾܂(ǂݎp)B</summary>
        public string LocalDirectory
        {
            get { return Path.GetDirectoryName(_localPath); }
        }

        /// <summary>t@C̃TCY擾Eݒ肵܂B</summary>
        public long Size
        {
            get { return _size; }
            set { _size = value; }
        }

        /// <summary>_E[hς݂̃TCY擾Eݒ肵܂B</summary>
        public long DownloadedSize
        {
            get { return _downloadedSize; }
            set { _downloadedSize = value; }
        }

        /// <summary>LbṼTCY擾Eݒ肵܂B</summary>
        public long CacheSize
        {
            get { return _cacheSize; }
            set { _cacheSize = value; }
        }

        /// <summary>_E[h[h擾Eݒ肵܂B</summary>
        public DownloadMode Mode
        {
            get { return _mode; }
            set { _mode = value; }
        }

        /// <summary>_E[hΏۂ̃Rec擾Eݒ肵܂B</summary>
        public DownloadTarget Target
        {
            get { return _target; }
            set { _target = value; }
        }

        /// <summary>_E[hACȅԂ擾Eݒ肵܂B</summary>
        public DownloadItemState State
        {
            get { return _state; }
            set { _state = value; }
        }

        /// <summary>_E[hACe̓o^擾Eݒ肵܂B</summary>
        public DateTime Registration
        {
            get { return _registration; }
            set { _registration = value; }
        }

        /// <summary>_E[hJňoߎ(~b)擾Eݒ肵܂B</summary>
        public long DownloadTime
        {
            get { return _downloadTime; }
            set { _downloadTime = value; }
        }

        /// <summary>_E[h̐i擾܂(ǂݎp)B</summary>
        public double Rate
        {
            get { return (_size <= 0) ? 0 : _downloadedSize / _size; }
        }

        /// <summary>_E[h̓]x(byte/sec)擾܂(ǂݎp)B</summary>
        public double Speed
        {
            get { return (_downloadedSize - _cacheSize) / Math.Min(_downloadTime / 1000, 1); }
        }

        /// <summary>_E[h܂łɕKvȎԂ擾܂(ǂݎp)B</summary>
        public TimeSpan TimeLife
        {
            get { return new TimeSpan((int)((double)(_size - _downloadedSize) * _downloadTime * 10000 / _downloadedSize)); }
        }

        #endregion

        #region Method

        /// <summary>_E[h̏ԂZbg܂B</summary>
        public void ResetDownloadState()
        {
            _size = 0;
            _downloadedSize = 0;
            _cacheSize = 0;
            _downloadTime = 0;
        }

        #endregion

        #region IXmlSerializable Intaface

        /// <summary>̃vpeB͗\񂳂Ă܂B</summary>
        /// <returns> <see langword="null"/> Ԃ܂B</returns>
        System.Xml.Schema.XmlSchema IXmlSerializable.GetSchema()
        {
            return null;
        }

        /// <summary>XML `ŃVACYꂽɃCX^X܂B</summary>
        /// <param name="reader">fVACYIuWFNg XML \ <see cref="XmlReader"/>B</param>
        /// <remarks>fVACYɂ TKey  TValue ɃftHgRXgN^KvłB</remarks>
        void IXmlSerializable.ReadXml(XmlReader reader)
        {
            if (reader.IsEmptyElement == false)
            {
                using (XmlHelper.ReadStartElement(reader))
                {
                    XmlDeserialize(reader);
                }
            }
        }

        /// <summary>CX^X XML `ŃVACY܂B</summary>
        /// <param name="writer">VACY XML \ <see cref="XmlWriter"/>B</param>
        /// <remarks>fVACYɂ TKey  TValue ɃftHgRXgN^KvłB</remarks>
        void IXmlSerializable.WriteXml(XmlWriter writer)
        {
            XmlSerialize(writer);
        }

        /// <summary>XML `ŃVACYꂽɃCX^X܂B</summary>
        /// <param name="reader">fVACYIuWFNg XML \ <see cref="XmlReader"/>B</param>
        /// <remarks>fVACYɂ TKey  TValue ɃftHgRXgN^KvłB</remarks>
        protected virtual void XmlDeserialize(XmlReader reader)
        {
            XmlSerializer longSerializer = new XmlSerializer(typeof(long));
            XmlSerializer stringSerializer = new XmlSerializer(typeof(string));
            XmlSerializer datetimeSerializer = new XmlSerializer(typeof(DateTime));

            using (XmlHelper.ReadStartElement(reader, "Key"))
            {
                _key = (string)stringSerializer.Deserialize(reader);
            }

            using (XmlHelper.ReadStartElement(reader, "VideoId"))
            {
                _videoId = (string)stringSerializer.Deserialize(reader);
            }

            using (XmlHelper.ReadStartElement(reader, "Title"))
            {
                this.Title = (string)stringSerializer.Deserialize(reader);
            }

            using (XmlHelper.ReadStartElement(reader, "Type"))
            {
                this.Type = (DownloadVideoType)(new XmlSerializer(typeof(DownloadVideoType))).Deserialize(reader);
            }

            using (XmlHelper.ReadStartElement(reader, "PathFormat"))
            {
                _pathFormat = (string)stringSerializer.Deserialize(reader);
            }

            using (XmlHelper.ReadStartElement(reader, "RemotePath"))
            {
                this.RemotePath = (string)stringSerializer.Deserialize(reader);
            }

            using (XmlHelper.ReadStartElement(reader, "LocalPath"))
            {
                this.LocalPath = (string)stringSerializer.Deserialize(reader);
            }

            using (XmlHelper.ReadStartElement(reader, "Size"))
            {
                this.Size = (long)longSerializer.Deserialize(reader);
            }

            using (XmlHelper.ReadStartElement(reader, "DownloadedSize"))
            {
                this.DownloadedSize = (long)longSerializer.Deserialize(reader);
            }

            using (XmlHelper.ReadStartElement(reader, "CacheSize"))
            {
                this.CacheSize = (long)longSerializer.Deserialize(reader);
            }

            using (XmlHelper.ReadStartElement(reader, "Mode"))
            {
                this.Mode = (DownloadMode)(new XmlSerializer(typeof(DownloadMode))).Deserialize(reader);
            }

            using (XmlHelper.ReadStartElement(reader, "Target"))
            {
                this.Target = (DownloadTarget)(new XmlSerializer(typeof(DownloadTarget))).Deserialize(reader);
            }

            using (XmlHelper.ReadStartElement(reader, "State"))
            {
                DownloadItemState state = (DownloadItemState)(new XmlSerializer(typeof(DownloadItemState))).Deserialize(reader);
                switch (state)
                {
                case DownloadItemState.Start:
                case DownloadItemState.Processing:
                    this.State = DownloadItemState.Waiting;
                    break;

                default:
                    this.State = state;
                    break;
                }

            }

            using (XmlHelper.ReadStartElement(reader, "Registration"))
            {
                this.Registration = (DateTime)datetimeSerializer.Deserialize(reader);
            }
        }

        /// <summary>CX^X XML `ŃVACY܂B</summary>
        /// <param name="writer">VACY XML \ <see cref="XmlWriter"/>B</param>
        /// <remarks>fVACYɂ TKey  TValue ɃftHgRXgN^KvłB</remarks>
        protected virtual void XmlSerialize(XmlWriter writer)
        {
            XmlSerializer longSerializer = new XmlSerializer(typeof(long));
            XmlSerializer stringSerializer = new XmlSerializer(typeof(string));
            XmlSerializer datetimeSerializer = new XmlSerializer(typeof(DateTime));

            using (XmlHelper.WriteStartElement(writer, "Key"))
            {
                stringSerializer.Serialize(writer, _key);
            }

            using (XmlHelper.WriteStartElement(writer, "VideoId"))
            {
                stringSerializer.Serialize(writer, this.VideoId);
            }

            using (XmlHelper.WriteStartElement(writer, "Title"))
            {
                stringSerializer.Serialize(writer, this.Title);
            }

            using (XmlHelper.WriteStartElement(writer, "Type"))
            {
                (new XmlSerializer(typeof(DownloadVideoType))).Serialize(writer, this.Type);
            }

            using (XmlHelper.WriteStartElement(writer, "PathFormat"))
            {
                stringSerializer.Serialize(writer, this.PathFormat);
            }

            using (XmlHelper.WriteStartElement(writer, "RemotePath"))
            {
                stringSerializer.Serialize(writer, this.RemotePath);
            }

            using (XmlHelper.WriteStartElement(writer, "LocalPath"))
            {
                stringSerializer.Serialize(writer, this.LocalPath);
            }

            using (XmlHelper.WriteStartElement(writer, "Size"))
            {
                longSerializer.Serialize(writer, this.Size);
            }

            using (XmlHelper.WriteStartElement(writer, "DownloadedSize"))
            {
                longSerializer.Serialize(writer, this.DownloadedSize);
            }

            using (XmlHelper.WriteStartElement(writer, "CacheSize"))
            {
                longSerializer.Serialize(writer, this.CacheSize);
            }

            using (XmlHelper.WriteStartElement(writer, "Mode"))
            {
                (new XmlSerializer(typeof(DownloadMode))).Serialize(writer, this.Mode);
            }

            using (XmlHelper.WriteStartElement(writer, "Target"))
            {
                (new XmlSerializer(typeof(DownloadTarget))).Serialize(writer, this.Target);
            }

            using (XmlHelper.WriteStartElement(writer, "State"))
            {
                (new XmlSerializer(typeof(DownloadItemState))).Serialize(writer, this.State);
            }

            using (XmlHelper.WriteStartElement(writer, "Registration"))
            {
                datetimeSerializer.Serialize(writer, this.Registration);
            }
        }

        #endregion
    }

    #endregion
}
