﻿using System;
using System.ComponentModel;

namespace Alternative
{
    #region Enumration

    /// <summary>ダウンロードする動画の種類。</summary>
    public enum DownloadVideoType
    {
        #region Enum Members

        /// <summary>なし。</summary>
        [Description("")]
        None,
        /// <summary>FLV(FlashVideo)。</summary>
        [Description("flv")]
        FLV,
        /// <summary>MPEG-4。</summary>
        [Description("mp4")]
        Mpeg4,
        /// <summary>SWF(Shockwave Flash)。</summary>
        [Description("swf")]
        SWF,

        #endregion
    }

    /// <summary>ダウンロードモード。</summary>
    public enum DownloadMode
    {
        #region Enum Members

        /// <summary>なし。</summary>
        [Description("")]
        None,
        /// <summary>エコノミーモード。</summary>
        [Description("エコノミー")]
        Economy,
        /// <summary>通常。</summary>
        [Description("通常")]
        Normal,

        #endregion
    }

    /// <summary>ダウンロード対象のコンテンツ。</summary>
    [Flags]
    public enum DownloadTarget : uint
    {
        #region Enum Members

        /// <summary>なし。</summary>
        None = 0,
        /// <summary>動画。</summary>
        Video = 1,
        /// <summary>コメント。</summary>
        Comment = 2,
        /// <summary>すべて。</summary>
        All = Video | Comment,
        /// <summary>既定値。</summary>
        Default = Video | Comment,

        #endregion
    }

    /// <summary>ダウンロードアイテムの状態。</summary>
    public enum DownloadItemState
    {
        #region Enum Members

        /// <summary>なし。</summary>
        [Description("")]
        None,
        /// <summary>待機中。</summary>
        [Description("ダウンロード待ち")]
        Waiting,
        /// <summary>開始。</summary>
        [Description("ダウンロード開始")]
        Start,
        /// <summary>実行中。</summary>
        [Description("ダウンロード中")]
        Processing,
        /// <summary>完了。</summary>
        [Description("ダウンロード済み")]
        Completed,
        /// <summary>一時停止。</summary>
        [Description("一時停止")]
        Pause,
        /// <summary>中止。</summary>
        [Description("キャンセル")]
        Cancelled,
        /// <summary>失敗。</summary>
        [Description("エラー")]
        Failed,

        #endregion
    }

    /// <summary>ダウンロードアイテムのフィールド識別子。</summary>
    public enum DownloadItemFieldId
    {
        #region Enum Members

        /// <summary>なし。</summary>
        None,
        /// <summary>タイトル。</summary>
        Title,
        /// <summary>状態。</summary>
        State,
        /// <summary>動画サイズ。</summary>
        Size,
        /// <summary>進捗。</summary>
        Rate,
        /// <summary>残り時間。</summary>
        TimeLife,
        /// <summary>転送速度(KB/s)。</summary>
        Speed,
        /// <summary>モード。</summary>
        Mode,
        /// <summary>拡張子。</summary>
        Type,
        /// <summary>登録日時。</summary>
        Registration,
        /// <summary>フォルダ。</summary>
        Folder,

        #endregion
    }

    #endregion

    #region IDownloadItem

    /// <summary>ダウンロードアイテム情報を提供します。</summary>
    public interface IDownloadItem
    {
        #region Property

        /// <summary>タスク ID を取得・設定します。</summary>
        int TaskId { get; set; }

        /// <summary>識別子を取得・設定します。</summary>
        string Key { get; set; }

        /// <summary>動画 ID を取得します(読み取り専用)。</summary>
        string VideoId { get; }

        /// <summary>動画タイトルを取得・設定します。</summary>
        string Title { get; set; }

        /// <summary>ダウンロードする動画の種類を取得・設定します。</summary>
        DownloadVideoType Type { get; set; }

        /// <summary>ローカルパスの書式を取得します(読み取り専用)。</summary>
        string PathFormat { get; }

        /// <summary>リモートパスを取得・設定します。</summary>
        string RemotePath { get; set; }

        /// <summary>ローカルパスを取得・設定します。</summary>
        string LocalPath { get; set; }

        /// <summary>ローカルディレクトリを取得します(読み取り専用)。</summary>
        string LocalDirectory { get; }

        /// <summary>動画ファイルのサイズを取得・設定します。</summary>
        long Size { get; set; }

        /// <summary>ダウンロード済みのサイズを取得・設定します。</summary>
        long DownloadedSize { get; set; }

        /// <summary>キャッシュのサイズを取得・設定します。</summary>
        long CacheSize { get; set; }

        /// <summary>ダウンロードモードを取得・設定します。</summary>
        DownloadMode Mode { get; set; }

        /// <summary>ダウンロード対象のコンテンツを取得・設定します。</summary>
        DownloadTarget Target { get; set; }

        /// <summary>ダウンロードアイテムの状態を取得・設定します。</summary>
        DownloadItemState State { get; set; }

        /// <summary>ダウンロードアイテムの登録日時を取得・設定します。</summary>
        DateTime Registration { get; set; }

        /// <summary>ダウンロード開始からの経過時間(ミリ秒)を取得・設定します。</summary>
        long DownloadTime { get; set; }

        /// <summary>ダウンロードの進捗率を取得します(読み取り専用)。</summary>
        double Rate { get; }

        /// <summary>ダウンロードの転送速度(byte/sec)を取得します(読み取り専用)。</summary>
        double Speed { get; }

        /// <summary>ダウンロード完了までに必要な時間を取得します(読み取り専用)。</summary>
        TimeSpan TimeLife { get; }

        #endregion

        #region Method

        /// <summary>ダウンロード中の状態をリセットします。</summary>
        void ResetDownloadState();

        #endregion
    }

    #endregion
}
