using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;
using System.Diagnostics;
using System.IO;

using System.Drawing;
using System.Windows.Forms;
using System.Xml.Serialization;
using System.ComponentModel;

namespace Alternative.Controls.Favorite
{
	/// <summary>
	/// Cɓf[^\<see cref="System.Windows.Forms.TreeNode"/>̊gNXłB
	/// CX^X́A<see cref="CreateFolderNode"/>A<see cref="CreatePageNode"/>쐬܂B
	/// </summary>
	[DebuggerDisplay("{Title}, NodeType=[{NodeType}], Nodes={Nodes.Count}")]
	[Serializable]
	public class FavoriteNode : TreeNode
	{
		#region Const / Static
		/// <summary>
		/// <see cref="Name"/>vpeB\IDł
		/// </summary>
		protected const string SK_NAME_S = "Code";
		/// <summary>
		/// <see cref="Title"/>vpeB\IDł
		/// </summary>
		protected const string SK_TITLE_S = "Title";
		/// <summary>
		/// <see cref="Url"/>vpeB\IDł
		/// </summary>
		protected const string SK_URL_S = "Url";
		/// <summary>
		/// <see cref="Comment"/>vpeB\IDł
		/// </summary>
		protected const string SK_COMMENT_S = "Comm";
		/// <summary>
		/// <see cref="ImageKey"/>vpeB\IDł
		/// </summary>
		protected const string SK_IMGKEY_S = "Icon";
		/// <summary>
		/// <see cref="IsExpanded"/>vpeB\IDł
		/// </summary>
		protected const string SK_EXPAND_B = "Expa";
		/// <summary>
		/// <see cref="NodeType"/>vpeB\IDł
		/// </summary>
		protected const string SK_TYPE_FNT = "Type";
		/// <summary>
		/// <see cref="Nodes.Count"/>vpeB\IDł
		/// </summary>
		protected const string SK_CHILDREN_I = "Count";
		/// <summary>
		/// <see cref="Nodes"/>vpeB\IDł
		/// </summary>
		protected const string SK_NODE_ME = "Node";

		/// <summary>
		/// y[Wvf\<see cref="FavoriteNode"/>쐬܂B
		/// </summary>
		/// <param name="title">\^Cg</param>
		/// <param name="url">֘AtURL</param>
		/// <param name="comment">Rg</param>
		/// <returns>쐬ꂽm[h̃CX^X</returns>
		public static FavoriteNode CreatePageNode(string title, string url, string comment)
		{
			FavoriteNode node = new FavoriteNode();
			node.Title = title;
			node.Url = url;
			node.Comment = comment;
			node.NodeType = FavoriteNodeType.Page;
			node.Name = "FVN" + DateTime.Now.Ticks;
			node.ImageKey = GlobalImages.IKEY_A_PAGE;
			node.SelectedImageKey = GlobalImages.IKEY_A_PAGE;
			return node;
		}
		/// <summary>
		/// tH_vf\<see cref="FavoriteNode"/>쐬܂B
		/// </summary>
		/// <param name="title">\^Cg</param>
		/// <param name="comment">Rg</param>
		/// <returns>쐬ꂽm[h̃CX^X</returns>
		public static FavoriteNode CreateFolderNode(string title, string comment)
		{
			FavoriteNode node = new FavoriteNode();
			node.Title = title;
			node.Comment = comment;
			node.NodeType = FavoriteNodeType.Folder;
			node.Name = "FVN" + DateTime.Now.Ticks;
			node.ImageKey = GlobalImages.IKEY_A_FOLDER;
			node.SelectedImageKey = GlobalImages.IKEY_A_FOLDER;
			return node;
		}

		#endregion

		#region Constructor

		/// <summary>
		/// ̃NX̃RXgN^łB
		/// </summary>
		protected FavoriteNode(SerializationInfo info, StreamingContext context)
		{
			this.Deserialize(info, context);
		}
		/// <summary>
		/// ̃NX̃RXgN^łB
		/// </summary>
		protected FavoriteNode()
		{
			this.Text = String.Empty;
			this._url = String.Empty;
			this._comment = String.Empty;
			this.NodeType = FavoriteNodeType.Page;
			this.setToolTip();
		}

		#endregion

		#region Field
		string _url;
		string _comment;
		FavoriteNodeType _type;
		#endregion

		#region Property
		/// <summary>
		/// \^Cg擾Eݒ肵܂B<see cref="Text"/>vpeBƓłB
		/// </summary>
		public string Title
		{
			get { return this.Text; }
			set { this.Text = value; }
		}
		/// <summary>
		/// ֘AtꂽURL擾Eݒ肵܂B
		/// </summary>
		public string Url
		{
			get
			{
				if((this.NodeType & FavoriteNodeType._Navigatable) == FavoriteNodeType._Navigatable)
					return this._url;
				else return String.Empty;
			}
			set { this._url = value; this.setToolTip(); }
		}
		/// <summary>
		/// ̃m[h̊TȂǂ܂ރRg擾Eݒ肵܂B
		/// </summary>
		public string Comment
		{
			get { return this._comment; }
			set { this._comment = value; this.setToolTip(); }
		}
		/// <summary>
		/// ̃m[h̎ނ擾Eݒ肵܂B
		/// </summary>
		public FavoriteNodeType NodeType
		{
			get { return this._type; }
			set { this._type = value; }
		}
		/// <summary>
		/// ̃m[hqvfpӂ邩ǂ擾܂B
		/// </summary>
		public bool IsContainer
		{
			get { return (this.NodeType & FavoriteNodeType._NodeContainer) == FavoriteNodeType._NodeContainer; }
		}
		/// <summary>
		/// ̃m[hɊ֘AtꂽURLgpł邩ǂ擾܂B
		/// </summary>
		public bool IsNavigatable
		{
			get { return (this.NodeType & FavoriteNodeType._Navigatable) == FavoriteNodeType._Navigatable; }
		}
		/// <summary>
		/// m[hҏWی삳Ă邩ǂ擾܂B
		/// ̒l<value>true</value>̏ꍇAUI^CgȂǂ̒lύXł܂B
		/// </summary>
		public bool IsProtected
		{
			get { return (this.NodeType & FavoriteNodeType._Protected) == FavoriteNodeType._Protected; }
		}
		/// <summary>
		/// m[ḧʒuŒ肳Ă邩ǂ擾܂B
		/// ̒l<value>true</value>̏ꍇAUID&DȂǂŃm[h̐ȇΈʒuύXł܂B
		/// </summary>
		public bool IsFixed
		{
			get { return (this.NodeType & FavoriteNodeType._Fixed) == FavoriteNodeType._Fixed; }
		}
		#endregion

		#region Methods

		/// <summary>
		/// <see cref="ToolTipText"/>XV܂B
		/// </summary>
		private void setToolTip()
		{
			this.ToolTipText = String.IsNullOrEmpty(this._comment) ?
				this._url : this._comment;
			
		}

		/// <summary>
		/// w肵<see cref="System.Runtime.Serialization.SerializationInfo"/>ɁÃNX̃IuWFNg̏o܂B
		/// </summary>
		/// <param name="si">̃NX̃IuWFNg<see cref="System.Runtime.Serialization.SerializationInfo"/></param>
		/// <param name="context">VÃXg[̏Ԃ\<see cref="System.Runtime.Serialization.StreamingContext"/></param>
		protected override void Serialize(SerializationInfo si, StreamingContext context)
		{
			si.AddValue(SK_TYPE_FNT, this.NodeType, typeof(FavoriteNodeType));
			si.AddValue(SK_TITLE_S, this.Title);
			si.AddValue(SK_URL_S, this.Url);
			si.AddValue(SK_COMMENT_S, this.Comment);
			si.AddValue(SK_IMGKEY_S, this.ImageKey);
			si.AddValue(SK_EXPAND_B, this.IsExpanded);
			si.AddValue(SK_NAME_S, this.Name);
			si.AddValue(SK_CHILDREN_I, this.Nodes.Count);
			if(this.Nodes.Count > 0)
			{
				for(int i = 0; i < this.Nodes.Count; ++i)
				{
					si.AddValue(SK_NODE_ME + i, this.Nodes[i], typeof(FavoriteNode));
				}
			}
		}
		/// <summary>
		/// w肵<see cref="System.Runtime.Serialization.SerializationInfo"/>ÃNX̃IuWFNg̏o܂B
		/// </summary>
		/// <param name="serializationInfo">̃NX̃IuWFNg<see cref="System.Runtime.Serialization.SerializationInfo"/></param>
		/// <param name="context">tVÃXg[̏Ԃ\<see cref="System.Runtime.Serialization.StreamingContext"/></param>
		protected override void Deserialize(SerializationInfo serializationInfo, StreamingContext context)
		{
			SerializationInfoEnumerator enumerator = serializationInfo.GetEnumerator();
			int children = -1;
			while(enumerator.MoveNext())
			{
				SerializationEntry curr = enumerator.Current;
				switch(curr.Name)
				{
					case SK_TITLE_S:
						this.Title = (string)curr.Value;
						break;
					case SK_TYPE_FNT:
						this.NodeType = (FavoriteNodeType)curr.Value;
						break;
					case SK_URL_S:
						this.Url = curr.Value as string;
						break;
					case SK_COMMENT_S:
						this.Comment = (string)curr.Value;
						break;
					case SK_EXPAND_B:
						if(serializationInfo.GetBoolean(SK_EXPAND_B)) { this.Expand(); }
						break;
					case SK_IMGKEY_S:
						this.ImageKey = (string)curr.Value;
						this.SelectedImageKey = this.ImageKey;
						break;
					case SK_NAME_S:
						this.Name = curr.Value as string;
						break;
					case SK_CHILDREN_I:
						children = serializationInfo.GetInt32(SK_CHILDREN_I);
						break;
				}
			}
			if(children > 0)
			{
				FavoriteNode[] nodes = new FavoriteNode[children];
				for(int i = 0; i < children; ++i)
				{
					nodes[i] = (FavoriteNode)serializationInfo.GetValue(SK_NODE_ME + i, typeof(FavoriteNode));
				}
				this.Nodes.AddRange(nodes);
			}
			this.setToolTip();
		}

		#endregion
	}


	[Flags]
	public enum FavoriteNodeType : byte
	{
		Root = 0xE1,
		Group = 0x31,
		Folder = 0x21,
		Page = 0x11,

		_Protected = 0x80,
		_Fixed = 0x40,
		_NodeContainer = 0x20,
		_Navigatable = 0x10,

		_NodeBase = 0x01,
	}
}
