using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Text.RegularExpressions;

namespace Alternative.Controls.Favorite
{
	public partial class EditDialog : Form
	{

		public EditDialog()
		{
			InitializeComponent();
		}

		public DialogResult ShowDialog(IWin32Window owner, FavoriteNode node)
		{
			return this.ShowDialog(owner, node, false);
		}
		public DialogResult ShowDialog(IWin32Window owner, FavoriteNode node, bool autoFixValue)
		{
			if(node == null || (node.NodeType & FavoriteNodeType._Protected) == FavoriteNodeType._Protected)
			{
				return DialogResult.Cancel;
			}

			if(node.IsNavigatable)
			{
				this.ContainsUrl = true;
				this.UrlText = node.Url;
			}
			else
			{
				this.ContainsUrl = false;
				this.UrlText = String.Empty;
			}
			this.TitleText = node.Title;
			this.CommentText = node.Comment;

			DialogResult res = base.ShowDialog(owner);
			if(autoFixValue && res == DialogResult.OK)
			{
				node.Title = this.TitleText;
				node.Url = this.UrlText;
				node.Comment = this.CommentText;
			}

			return res;
		}


		public string UrlText
		{
			get { return this.txtUrl.Text; }
			set { this.txtUrl.Text = value ?? String.Empty; }
		}
		public string TitleText
		{
			get { return this.txtTitle.Text; }
			set { this.txtTitle.Text = value ?? String.Empty; }
		}
		public string CommentText
		{
			get { return this.txtComment.Text; }
			set { this.txtComment.Text = value ?? String.Empty; }
		}


		public bool ContainsUrl
		{
			get { return this.txtUrl.Enabled; }
			set { this.txtUrl.Enabled = value; }
		}

		#region Accept 

		private void accept_Dialog()
		{
			if(this.txtTitle.Text.Length > 0)
			{
				if((!this.txtUrl.Enabled) || this.txtUrl.Text.Length > 0)
				{
					this.DialogResult = DialogResult.OK;
				}
				else
				{
                    MessageBox.Show("URLɂ邱Ƃ͂ł܂B", Application.ProductName);
				}
			}
			else
			{
                MessageBox.Show("^Cgɂ邱Ƃ͂ł܂B", Application.ProductName);
			}
		}

		private void btnOK_Click(object sender, EventArgs e)
		{
			this.accept_Dialog();
		}

		private void Accept_on_EnterKeyDown(object sender, KeyEventArgs e)
		{
			if(e.KeyCode == Keys.Enter)
			{
				this.accept_Dialog();
			}
		}

		#endregion


	}
}