using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using WebServiceClient.Collections;

namespace Alternative.Controls.Favorite
{
		internal partial class AddItemDialog : Form
		{
			private FavoriteTreeView _owner;

			public AddItemDialog(FavoriteTreeView owner)
			{
				this._owner = owner;
				InitializeComponent();
				this.treeTarget.ImageList = GlobalImages.GlobalListA;
			}


			internal ImageList ImageListOnTree
			{
				get { return this.treeTarget.ImageList; }
				set { this.treeTarget.ImageList = value; }
			}

			public DialogResult ShowDialog(IWin32Window owner, string title, string url, string comment)
			{
				this.constructTreeOnlyFolder(this._owner.RootNode);
				this.IsForFolder = false;
				this.txtTitle.Text = title ?? String.Empty;
				this.txtUrl.Text = url ?? String.Empty;
				this.txtComment.Text = comment ?? String.Empty;
				DialogResult d = this.ShowDialog(owner);
				return d;
			}
			public DialogResult ShowDialog(IWin32Window owner, string title, string comment)
			{
				this.constructTreeOnlyFolder(this._owner.RootNode);
				this.IsForFolder = true;
				this.txtTitle.Text = title ?? String.Empty;
				this.txtUrl.Text = String.Empty;
				this.txtComment.Text = comment ?? String.Empty;
				DialogResult d = this.ShowDialog(owner);
				return d;
			}

			#region Internal

			private void constructTreeOnlyFolder(FavoriteNode root)
			{
				this.treeTarget.BeginUpdate();
				this.treeTarget.Nodes.Clear();
				lock(this._owner)
				{
					this.treeTarget.Nodes.Add(this.constructTree_subroutine(root));
				}
				this.treeTarget.EndUpdate();
			}
			private TreeNode constructTree_subroutine(FavoriteNode current)
			{
				if(current.IsContainer)
				{
					TreeNode tn = this.favFolderToTreeNode(current);
					foreach(FavoriteNode node in current.Nodes)
					{
						TreeNode nd2 = this.constructTree_subroutine(node);
						if(nd2 != null) { tn.Nodes.Add(nd2); }
					}
					tn.Expand();
					return tn;
				}
				else return null;
			}

			private TreeNode favFolderToTreeNode(FavoriteNode node)
			{
				TreeNode tn = new TreeNode(node.Title);
				tn.ImageKey = node.ImageKey;
				tn.SelectedImageKey = node.ImageKey;
				tn.Tag = node;
				return tn;
			}

			#endregion

			#region Property

			public bool IsForFolder
			{
				get { return !this.txtUrl.Enabled; }
				set { this.txtUrl.Enabled = !value; }
			}
			public string TitleText
			{
				get { return this.txtTitle.Text; }
				set { this.txtTitle.Text = value; }
			}
			public string UrlText
			{
				get { return this.txtUrl.Text; }
				set { this.txtUrl.Text = value; }
			}
			public string CommentText
			{
				get { return this.txtComment.Text; }
				set { this.txtComment.Text = value; }
			}
			public FavoriteNode Selected
			{
				get
				{
					if(this.treeTarget.SelectedNode != null)
					{
						return this.treeTarget.SelectedNode.Tag as FavoriteNode;
					}
					else { return null; }
				}
			}

			#endregion

			private void btnCreateFolder_Click(object sender, EventArgs e)
			{
				string title = "NewFolder";

				using(TextDialog dialog = new TextDialog())
				{
					dialog.Value = title;
					if(dialog.ShowDialog(this) == DialogResult.OK)
					{
						if(String.IsNullOrEmpty(dialog.Value)) { title = dialog.Value; }
						TreeNode tgtNode = this.treeTarget.SelectedNode;
						FavoriteNode target = tgtNode.Tag as FavoriteNode;
						TreeNode newNode = null;
						FavoriteNode folder = this._owner.FvAddFolder(title, String.Empty, target);
						if(folder != null)
						{
							newNode = this.favFolderToTreeNode(folder);
							if(target == null)
							{
								this.treeTarget.Nodes.Add(newNode);
							}
							else
							{
								tgtNode.Nodes.Add(newNode);
							}

							if(newNode.Parent != null)
							{
								newNode.Expand();
							}
						}
					}
				}
			}


			#region Accept 

			private void accept_Dialog()
			{
				if(this.txtTitle.Text.Length > 0)
				{
					if(!this.txtUrl.Enabled || this.txtUrl.Text.Length > 0)
					{
						this.DialogResult = DialogResult.OK;
					}
					else
					{
                        MessageBox.Show("URLɂ邱Ƃ͂ł܂B", Application.ProductName);
					}
				}
				else
				{
                    MessageBox.Show("^Cgɂ邱Ƃ͂ł܂B", Application.ProductName);
				}
			}

			private void Accept_on_EnterKeyDown(object sender, KeyEventArgs e)
			{
				if(e.KeyCode == Keys.Enter)
				{
					this.accept_Dialog();
				}
			}

			private void btnOK_Click(object sender, EventArgs e)
			{
				this.accept_Dialog();
			}

			#endregion

		}


}