using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.Net;
using System.Runtime.InteropServices;
using System.Threading;
using AxSHDocVw;
using mshtml;

namespace Alternative.Controls.Browsers
{
    using Windows;
    using Alternative.Win32;
    using Alternative.Functions.BrowserExtension;

    /// <summary>
	/// AxWebBrowserzXguEURg[łB
	/// </summary>
	public class WebBrowserAx : UserControl, ITbPageControl
	{
		#region ###  Constant / Static Field  ###
		/// <summary>VEBhEŊJtargetFrame</summary>
		public const string BLANK_TGT = "_blank";

		/// <summary><seealso cref="OLEClientSite"/>̃tB[h</summary>
		private static IOleClientSite pOleClientSite;

		/// <summary>WebBrowserAxNXLĎgp<see cref="IOleClientSite"/>擾Eݒ肵܂B
		/// CX^XRXgN^珉Ƃ̒lnullłȂ΁A㊷ClientSitegp悤ɂȂ܂B</summary>
		public static IOleClientSite OLEClientSite
		{
			get { return pOleClientSite; }
			set
			{
				pOleClientSite = value;
				System.Diagnostics.Trace.WriteLine("WebBrowserAx::OLEClientSite replaced to " + (value != null ? value.GetType().FullName : "null"));
			}
		}

		#endregion

		#region #########   Field   #########

		/// <summary>uEU</summary>
		private AxWebBrowser _browser;
		/// <summary>߂Eiނ̗ǗIuWFNg</summary>
		private ExHtmlHistory _history;
		/// <summary>uEŰ@\𐧌IuWFNg</summary>
		private InternetSecurityManager _ism;

		/// <summary><see cref="CanGoBack"/>vpeB̓tB[hłB</summary>
		private bool _canGoBack = false;
		/// <summary><see cref="CanGoForward"/>vpeB̓tB[hłB</summary>
		private bool _canGoFore = false;

		/// <summary>VInternet Explorer_Server̃EBhEv[W[JȂ悤ێtB[hłB</summary>
		private WindowProcDelegate _del_windowproc = null;
		/// <summary>Internet Explorer_Server̃ftHg̃EBhEv[W[ւ̃|C^</summary>
		private IntPtr _pIEWindowDefProc = IntPtr.Zero;
		/// <summary>DocumentTitle擾̂߂̒pobt@B</summary>
		private string _pagetitle = String.Empty;

		/// <summary>DelayedActionDocumentCompletedgK̃Gg[B</summary>
		private List<DelayedAction> _actionsOnCompleted;

		private DocHostUIHandler _pUIHandler;

		#endregion

		#region ++++ Constructor / Initializer ++++

		/// <summary>̃NX̃RXgN^łB</summary>
		/// <exception cref="System.Runtime.InteropServices.ExternalException">COM̏ԂsȂƂɔ܂B</exception>
		public WebBrowserAx()
		{
			this.InitializeComponent();
			this._pUIHandler = null;
			this.Silent = false;
			//if(OLEClientSite != null)
			//{
			//    IOleObject obj = this.Ocx as IOleObject;
			//    obj.SetClientSite(OLEClientSite);
			//}
			_history = new ExHtmlHistory(this);
			object app = _browser.Application;
			_ism = new InternetSecurityManager(app);
			int p = Marshal.ReleaseComObject(app);

			this._actionsOnCompleted = new List<DelayedAction>(2);
		}

		~WebBrowserAx()
		{
			this.Dispose(false);
		}

		private void InitializeComponent()
		{
			this.SuspendLayout();

			_browser = new AxWebBrowser();
			_browser.BeginInit();
			_browser.Dock = DockStyle.Fill;
			// Attach Events
			_browser.BeforeNavigate2 += new DWebBrowserEvents2_BeforeNavigate2EventHandler(browser_BeforeNavigate2);
			_browser.NavigateComplete2 += new DWebBrowserEvents2_NavigateComplete2EventHandler(browser_NavigateComplete2);
			_browser.NavigateError += new DWebBrowserEvents2_NavigateErrorEventHandler(browser_NavigateError);
			_browser.ProgressChange += new DWebBrowserEvents2_ProgressChangeEventHandler(browser_ProgressChange);
			_browser.DownloadComplete += new EventHandler(browser_DownloadComplete);
			_browser.DocumentComplete += new DWebBrowserEvents2_DocumentCompleteEventHandler(browser_DocumentComplete);
			_browser.NewWindow2 += new DWebBrowserEvents2_NewWindow2EventHandler(browser_NewWindow2);
			_browser.StatusTextChange += new DWebBrowserEvents2_StatusTextChangeEventHandler(browser_StatusTextChange);
			_browser.TitleChange += new DWebBrowserEvents2_TitleChangeEventHandler(browser_TitleChange);
			_browser.WindowClosing += new DWebBrowserEvents2_WindowClosingEventHandler(browser_WindowClosing);
			_browser.PreviewKeyDown += new PreviewKeyDownEventHandler(browser_PreviewKeyDown);
			_browser.CommandStateChange += new DWebBrowserEvents2_CommandStateChangeEventHandler(browser_CommandStateChange);

			this.Controls.Add(_browser);

			this.Dock = DockStyle.Fill;

			_browser.EndInit();


			this.initializeNaviHistory();
			this.ResumeLayout(false);

		}
		/// <summary>̃NX̃EBhEv[W[AV̂ւƒu܂B</summary>
		private void set_WindowProcedure()
		{
			if(_del_windowproc != null)
			{
				InnerLogger.LOut("WindowProcedure is already replaced.", InnerLogger.ErrorLevel.L1_ERROR);
				return;
			}
			IntPtr pHWND_IEServer = IntPtr.Zero;
			IntPtr pHWND_SHDocVw = IntPtr.Zero;

            pHWND_SHDocVw = NativeMethods.GetWindow(_browser.Handle, GW.CHILD);
			if(pHWND_SHDocVw != IntPtr.Zero)
			{
                pHWND_IEServer = NativeMethods.GetWindow(pHWND_SHDocVw, GW.CHILD);

				// Vv[W[쐬
				_del_windowproc = new WindowProcDelegate(this.BeforeIEWndProc);
				IntPtr ptr_func = Marshal.GetFunctionPointerForDelegate(_del_windowproc);
				// v[W[̓ւEftHg̃v[W[̃AhXێ
                _pIEWindowDefProc = NativeMethods.SetWindowLong(pHWND_IEServer, GWL.WNDPROC, ptr_func);
				// ւɎsꍇɍ쐬v[W[j
				if(_pIEWindowDefProc == IntPtr.Zero)
				{
					_del_windowproc = null;
				}
			}
		}
		/// <summary>̃NX̃EBhEv[W[AftHĝ̂ɒu܂B</summary>
		private void reset_WindowProdure()
		{
			if(_del_windowproc == null) { return; }
			if(_browser == null) { return; }

			IntPtr pHWND_IEServer = IntPtr.Zero;
			IntPtr pHWND_SHDocVw = IntPtr.Zero;

            pHWND_SHDocVw = NativeMethods.GetWindow(_browser.Handle, GW.CHILD);
			if(pHWND_SHDocVw != IntPtr.Zero)
			{
                pHWND_IEServer = NativeMethods.GetWindow(pHWND_SHDocVw, GW.CHILD);
				if(_pIEWindowDefProc != IntPtr.Zero)
				{
                    NativeMethods.SetWindowLong(pHWND_IEServer, GWL.WNDPROC, _pIEWindowDefProc);
				}
				_del_windowproc = null;
			}
			pHWND_IEServer = IntPtr.Zero;
			pHWND_SHDocVw = IntPtr.Zero;
		}

		#endregion

		#region - Properties / Methods Access Proxy -

		/// <summary>
		/// ɂȂActiveXIuWFNgւ̎QƂ擾܂B
		/// AxWebBrowser.GetOcx() ւ̃ANZXłB
		/// </summary>
		public object Ocx
		{
			get { return _browser.GetOcx(); }
		}
		/// <summary>
		/// ɂȂActiveXIuWFNg̎QƂ擾܂B
		/// AxWebBrowser.Application ւ̃ANZXłB
		/// </summary>
		public object Application
		{
			get { return _browser.Application; }
		}
		/// <summary>
		/// AxWebBrowser::RegisterAsBrowser
		/// </summary>
		public bool RegisterAsBrowser
		{
			get { return _browser.RegisterAsBrowser; }
			set { _browser.RegisterAsBrowser = value; }
		}

		/// <summary>
		/// uEŨrV[Ԃ擾܂B
		/// </summary>
		public bool IsBusy
		{
			get { return _browser.Busy; }
		}
		/// <summary>
		/// uEUŕ\̃y[WURL擾܂B
		/// </summary>
		public string Url
		{
			get { return _browser.LocationURL; }
		}
		/// <summary>
		/// uEUŕ\̃y[W̃^Cg擾܂B
		/// </summary>
		public string DocumentTitle
		{
			get { lock(_pagetitle) { return _pagetitle; } }
		}
		/// <summary>
		/// uEUŕ\StatusText擾܂B
		/// </summary>
		public string StatusText
		{
			get { return _browser.StatusText; }
		}
		/// <summary>
		/// ItCԂ擾Eݒ肵܂B
		/// </summary>
		public bool Offline
		{
			get { return _browser.Offline; }
			set { _browser.Offline = value; }
		}
		/// <summary>
		/// Sʃ[h̏Ԃ擾Eݒ肵܂B
		/// </summary>
		public bool FullScreen
		{
			get { return _browser.FullScreen; }
			set { _browser.FullScreen = value; }
		}
		/// <summary>
		/// ׂẴ_CAO}TCg[h̏Ԃ擾Eݒ肵܂B
		/// </summary>
		public bool Silent
		{
			get { return _browser.Silent; }
			set { _browser.Silent = value; }
		}
		/// <summary>
		/// uEUReadyState擾Eݒ肵܂B
		/// </summary>
		public WebBrowserReadyState ReadyState
		{
			get { return (WebBrowserReadyState)_browser.ReadyState; }
		}
		/// <summary>
		/// uEUDOMIuWFNg擾܂B
		/// </summary>
		public object Document
		{
			get { return _browser.Document; }
		}

		/// <summary>
		/// uEU̖߂鑀삪Lǂ擾܂B
		/// </summary>
		public bool CanGoBack
		{
			get { return _canGoBack; }
		}
		/// <summary>
		/// uEU̐iޑ삪Lǂ擾܂B
		/// </summary>
		public bool CanGoForward
		{
			get { return _canGoFore; }
		}

		/// <summary>
		/// AxWebBrowser::ClientToWindowւ̃ANZXłB
		/// </summary>
		/// <param name="x">XW</param>
		/// <param name="y">YW</param>
		/// <returns>Point</returns>
		public Point ClientToWindow(int x, int y)
		{
			int xret = x;
			int yret = y;
			_browser.ClientToWindow(ref xret, ref yret);
			return new Point(xret, yret);
		}
		public void Exec(SHDocVw.OLECMDID cmd, SHDocVw.OLECMDEXECOPT opt)
		{
			_browser.ExecWB(cmd, opt);
		}

		#endregion

		#region ------  Properties / Other -------
		
		/// <summary>uEÜړǗIuWFNgւ̎QƂ擾܂B</summary>
		/// <seealso cref="Browser.Controls.Browsers.ExHtmlHistory"/>
		public ExHtmlHistory History
		{
			get { return _history; }
		}

		/// <summary>uEŨZLeBxǗIuWFNgւ̎QƂ擾܂B</summary>
		/// <seealso cref="Browser.Controls.Browsers.InternetSecurityManager"/>
		public InternetSecurityManager SecurityManager
		{
			get { return _ism; }
		}

		/// <summary>IɃRg[NCAg̈𖳌Aɂ̃Rg[̂ĕ`悷悤ɂ܂B
		/// UserControl::Refreshւ̃ANZXłB</summary>
		public void RefreshControl()
		{
			base.Refresh();
		}

		/// <summary>zXgRg[ɃbNv𔭍s܂B̃bZ[ẂA<see cref="TbMessagePosted"/>CxgʂďʃzXgɑ܂B</summary>
		/// <param name="locked">bNꍇtrueBAbNꍇfalse</param>
		public void RequireLock(bool locked)
		{
			TbMessagePostEventArgs e = locked ?
				TbMessagePostEventArgs.GetForRequireLock() 
				: TbMessagePostEventArgs.GetForRequireUnlock();
			this.OnMessagePosted(e);
		}


		#region +--  NavigateHistory

		/// <summary>gxÕ|bvAbvj[</summary>
		private ContextMenuStrip ctxNaviHistory;
		/// <summary>gxÕ|bvAbvj[pACeB</summary>
		private ToolStripMenuItem[] tsmiHistory;
		/// <summary>|bvAbṽgxO̒T\tO</summary>
		private bool _frg_travellog_isback = false;
		/// <summary>gxÕ|bvAbvɕ\őGg[B</summary>
		private int _frg_travellog_maxshow = 5;

		/// <summary>u߂Eiށv̗̈ꗗ|bvAbvj[\܂B</summary>
		/// <param name="screenPos">j[\XN[W</param>
		/// <param name="isBackHistory">u߂v̏ꍇtrueAuiށv̏ꍇfalse</param>
		public void ShowNavigateHistory(Point screenPos, bool isBackHistory)
		{
			if(this.History != null)
			{
				TravelLogEntry[] entry = this.History.EnumEntries(
					isBackHistory ? TLENUMF.TLEF_RELATIVE_BACK : TLENUMF.TLEF_RELATIVE_FORE, this.tsmiHistory.Length);
				if(entry != null && entry.Length > 0)
				{
					int i;
					for(i = 0; i < entry.Length; ++i)
					{
						this.tsmiHistory[i].ImageIndex = isBackHistory ? 0 : 1;
						this.tsmiHistory[i].Text = entry[i].Title;
						this.tsmiHistory[i].Tag = entry[i].Url;
						this.tsmiHistory[i].Visible = true;
					}
					while(i < this.tsmiHistory.Length)
					{
						this.tsmiHistory[i].Visible = false;
						this.tsmiHistory[i].Tag = null;
						++i;
					}
					this._frg_travellog_isback = isBackHistory;
					this.ctxNaviHistory.Show(screenPos);
				}
			}
		}

		private void initializeNaviHistory()
		{
			this.ctxNaviHistory = new ContextMenuStrip();
			this.ctxNaviHistory.ImageList = new ImageList();
			this.ctxNaviHistory.ShowCheckMargin = false;
			this.ctxNaviHistory.ShowItemToolTips = true;
			this.ctxNaviHistory.ItemClicked += new ToolStripItemClickedEventHandler(ctxNaviHistory_ItemClicked);

			this.tsmiHistory = new ToolStripMenuItem[this._frg_travellog_maxshow];
			for(int i = 0; i < this.tsmiHistory.Length; ++i)
			{
				this.tsmiHistory[i] = new ToolStripMenuItem();
				this.tsmiHistory[i].Name = i.ToString();
				this.tsmiHistory[i].ImageIndex = 0;
				this.tsmiHistory[i].Height = 18;
				this.tsmiHistory[i].Visible = false;
			}
			this.ctxNaviHistory.Items.AddRange(this.tsmiHistory);
		}

		void ctxNaviHistory_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
		{
			int cindex = this.ctxNaviHistory.Items.IndexOf(e.ClickedItem);
			if(cindex >= 0)
			{
				this.History.TravelTo((cindex + 1) * (this._frg_travellog_isback ? -1 : 1));
			}
		}

		#endregion

		#endregion

		#region --------  Browser Navigation  --------

		/// <summary>
		/// wURLɈړ܂B
		/// </summary>
		/// <param name="url">ړURL</param>
		public void Navigate(string url)
		{
			object url_ = url as object;
			_browser.Navigate2(ref url_);
		}
		/// <summary>
		/// wURLɈړ܂
		/// </summary>
		/// <param name="url">ړURL</param>
		/// <param name="frame">^[Qbgt[</param>
		public void Navigate(string url, string frame)
		{
			object url_ = url as object;
			object frame_ = frame as object;
			object frags_ = 0;
			object post_ =  "";
			object head_ = "";
			_browser.Navigate2(ref url_, ref frags_, ref frame_, ref post_, ref head_);
		}
		/// <summary>
		/// wURLɈړ܂B
		/// </summary>
		/// <param name="url">ړURL</param>
		/// <param name="frags"><see cref="BrowserNavConstants"/>̒l</param>
		/// <param name="frame">^[Qbgt[</param>
		/// <param name="postdata">POST̏ꍇɎwBnull̏ꍇGET</param>
		/// <param name="headers">wb_[f[^̎wB</param>
		public void Navigate(string url, BrowserNavConstants frags, string frame, object postdata, object headers)
		{
			object url_ = url as object;
			object frame_ = frame as object;
			object frags_ = frags as object;
			object post_ = postdata as object;
			object head_ = headers as object;
			_browser.Navigate2(ref url_, ref frags_, ref frame_, ref post_, ref head_);
		}
		/// <summary>
		/// \̃y[Wēǂݍ݂܂B
		/// </summary>
		/// <remarks>
		/// ̃\bh́AUserControl::RefreshB܂B
		/// UserControl::RefreshKvȏꍇ́ARefreshControl\bh痘pł܂B
		/// </remarks>
		public new void Refresh()
		{
			if(!String.IsNullOrEmpty(this.Url))
			{
				_browser.Refresh2();
				// this.clearEditorKeys();
			}
		}
		/// <summary>
		/// ۗ̃irQ[VLZA
		/// obNOEh TEhAj[VȂǂ̓Iȃy[WvfׂĒ~܂
		/// </summary>
		public void Stop()
		{
			_browser.Stop();
		}
		/// <summary>
		/// irQ[VɑÕy[WꍇɁAÕy[Wɖ߂܂B
		/// </summary>
		public void GoBack()
		{
			_browser.GoBack();
		}
		/// <summary>
		/// irQ[VɎ̃y[WꍇɁÃy[WɈړ܂B
		/// </summary>
		public void GoForward()
		{
			_browser.GoForward();
		}
		/// <summary>
		/// ݂ Internet Explorer ̃z[ y[WɈړ܂B
		/// </summary>
		public void GoHome()
		{
			_browser.GoHome();
		}
		/// <summary>
		/// ݂ Internet Explorer ̌y[WɈړ܂B
		/// </summary>
		public void GoSearch()
		{
			_browser.GoSearch();
		}
		/// <summary>
		/// AxWebBrowser::Quit
		/// </summary>
		public void Quit()
		{
			_browser.Quit();
		}

		#endregion

		#region ---------  Browser Events  ------------

		#region +--  Event Objects

		/// <summary>WebTCgł̃}EXL,R,M{^ꂽɔ܂B
		/// XButton1,2̕ߑ<see cref="System.Windows.Forms.Control.MouseDown" />CxgsĂB</summary>
		/// <seealso cref="WebBrowserMouseMessageEventArgs"/>
		/// <seealso cref="System.Windows.Forms.Control.MouseDown"/>
		public event EventHandler<WebBrowserMouseMessageEventArgs> BrowserMouseDown;

		/// <summary><see href="CanGoBack" />vpeB̒lύXꂽꍇɔ܂B</summary>
		/// <seealso cref="CanGoForwardChanged"/>
		/// <seealso cref="CanGoBack"/>
		public event EventHandler CanGoBackChanged;
		/// <summary><see href="CanGoForward" />vpeB̒lύXꂽꍇɔ܂B</summary>
		/// <seealso cref="CanGoBackChanged"/>
		public event EventHandler CanGoForwardChanged;
		/// <summary>uEUVhLgɈړOɔ܂B</summary>
		/// <seealso cref="WebBrowserBeforeNavigateEventArgs"/>
		public event EventHandler<WebBrowserBeforeNavigateEventArgs> BeforeNavigate;
		/// <summary>uEUVhLgVEBhEŊJƂ鎞ɔ܂B</summary>
		/// <seealso cref="WebBrowserBeforeNewWindowEventArgs"/>
		public event EventHandler<WebBrowserBeforeNewWindowEventArgs> BeforeNewWindow;
		/// <summary>uEUVhLgւ̈ړɔ܂B</summary>
		/// <seealso cref="System.Windows.Forms.WebBrowserNavigatedEventArgs"/>
		public event WebBrowserNavigatedEventHandler Navigated;
		/// <summary>uEU̐Vy[Wւ̈ړsɔ܂B</summary>
		/// <seealso cref="WebBrowserNavigateErrorEventArgs"/>
		public event EventHandler<WebBrowserNavigateErrorEventArgs> NavigateError;
		/// <summary>uEUhLg̕\ɕKvȂׂĂ̗vf_E[hɔ܂B
		/// Vy[WɈړꍇ́ÃCxg܂ŃuEUDOM@\ɃANZXł܂B</summary>
		/// <seealso cref="DocumentCompleted"/>
		public event EventHandler DownloadCompleted;
		/// <summary>uEUhLg̕\ɕKvȂׂĂ̏ɔ܂B
		/// ēǂݍ݂găy[WXVꍇɂ͔ȂƂɒӂĂB</summary>
		/// <seealso cref="WebBrowserDocumentCompletedEventHandler"/>
		/// <seealso cref="System.Windows.Forms.WebBrowser.DocumentCompleted"/>
		public event WebBrowserDocumentCompletedEventHandler DocumentCompleted;
		/// <summary>uEUStatusTextύXꂽɔ܂B</summary>
		/// <seealso cref="System.Windows.Forms.WebBrowser.StatusTextChanged"/>
		/// <seealso cref="StatusText"/>
		public event EventHandler StatusTextChanged;
		/// <summary>\̃hLg̃^CgύXꂽɔ܂B</summary>
		/// <seealso cref="DocumentTitle"/>
		/// <seealso cref="System.Windows.Forms.WebBrowser.DocumentTitleChanged"/>
		public event EventHandler DocumentTitleChanged;
		/// <summary>ړƂȂhLg̃_E[h̐is󋵂Ɋւ񂪍XVꂽƂɔ܂B</summary>
		/// <seealso cref="System.Windows.Forms.WebBrowser.ProgressChanged"/>
		public event WebBrowserProgressChangedEventHandler ProgressChanged;
		/// <summary>uEUXNvgȂǂŕꂽɔ܂B
		/// Cxg̕ߑ͏o܂ALZ͏o܂B</summary>
		/// <seealso cref="WebBrowserWindowClosingEventArgs"/>
		public event EventHandler<WebBrowserWindowClosingEventArgs> WindowClosing;
		/// <summary>̃IuWFNgAzXgւ̃bZ[WMsۂɔ܂B</summary>
		public event TbMessagePostEventHandler MessagePosted;

		/// <summary>IFJp̓CxgB</summary>
		private event ITbDisplayEventHandler _evt_DisplayTextChanged;

		#endregion

		#region +--  Event Triggers

		/// <summary><see cref="CanGoBackChanged"/>Cxg̃gKłB</summary>
		/// <param name="sender">WebBrowserAxNX̃CX^X</param>
		/// <param name="e">EventArgs</param>
		protected void OnCanGoBackChanged(object sender, EventArgs e)
		{
			if(this.CanGoBackChanged != null)
			{
				this.CanGoBackChanged(sender, e);
			}
		}
		/// <summary><see cref="CanGoForward"/>Cxg̃gKłB</summary>
		/// <param name="sender">WebBrowserAxNX̃CX^X</param>
		/// <param name="e">EventArgs</param>
		protected void OnCanGoForwardChanged(object sender, EventArgs e)
		{
			if(this.CanGoForwardChanged != null)
			{
				this.CanGoForwardChanged(sender, e);
			}
		}
		/// <summary><see cref="BeforeNavigate"/>Cxg̃gKłB</summary>
		/// <param name="sender">WebBrowserAxNX̃CX^X</param>
		/// <param name="e"><see cref="AxSHDocVw.DWebBrowserEvents2_BeforeNavigate2Event"/></param>
		protected void OnBeforeNavigate(object sender, DWebBrowserEvents2_BeforeNavigate2Event e)
		{
			if(this.BeforeNavigate != null)
			{
				//InnerLogger.Out("before " + this.History.GetCount(TLENUMF.TLEF_ABSOLUTE).ToString() + " = " + e.uRL as String);
				WebBrowserBeforeNavigateEventArgs ev = new WebBrowserBeforeNavigateEventArgs(e);
				this.BeforeNavigate(sender, ev);
				ev.Release();
			}
		}
		/// <summary><see cref="BeforeNewWindow"/>Cxg̃gKłB</summary>
		/// <param name="sender">WebBrowserAxNX̃CX^X</param>
		/// <param name="e"><see cref="AxSHDocVw.DWebBrowserEvents2_NewWindow2Event"/></param>
		protected void OnBeforeNewWindow(object sender, DWebBrowserEvents2_NewWindow2Event e)
		{
			if(this.BeforeNewWindow != null)
			{
				WebBrowserBeforeNewWindowEventArgs ev = new WebBrowserBeforeNewWindowEventArgs(e);
				this.BeforeNewWindow(sender, ev);
				ev.Release();
			}
		}
		/// <summary><see cref="Navigated"/>Cxg̃gKłB</summary>
		/// <param name="sender">WebBrowserAxNX̃CX^X</param>
		/// <param name="e"><see cref="AxSHDocVw.DWebBrowserEvents2_NavigateComplete2Event"/></param>
		protected void OnNavigated(object sender, DWebBrowserEvents2_NavigateComplete2Event e)
		{
			if(this.Navigated != null)
			{
				WebBrowserNavigatedEventArgs ev = new WebBrowserNavigatedEventArgs(new Uri(e.uRL as string));
				this.Navigated(sender, ev);
			}
		}
		/// <summary><see cref="NavigateError"/>Cxg̃gKłB</summary>
		/// <param name="sender">WebBrowserAxNX̃CX^X</param>
		/// <param name="e"><see cref="AxSHDocVw.DWebBrowserEvents2_NavigateErrorEvent"/></param>
		protected void OnNavigateError(object sender, DWebBrowserEvents2_NavigateErrorEvent e)
		{
			if(this.NavigateError != null)
			{
				WebBrowserNavigateErrorEventArgs ev = new WebBrowserNavigateErrorEventArgs(e);
				this.NavigateError(sender, ev);
				ev.Release();
			}
		}
		/// <summary><see cref="DownloadCompleted"/>Cxg̃gKłB</summary>
		/// <param name="sender">WebBrowserAxNX̃CX^X</param>
		/// <param name="e">EventArgs</param>
		protected void OnDownloadCompleted(object sender, EventArgs e)
		{
			if(this.DownloadCompleted != null)
			{
				this.DownloadCompleted(sender, e);
			}

		}
		/// <summary><see cref="DocumentCompleted"/>Cxg̃gKłB</summary>
		/// <param name="sender">WebBrowserAxNX̃CX^X</param>
		/// <param name="e"><see cref="AxSHDocVw.DWebBrowserEvents2_DocumentCompleteEvent"/></param>
		protected void OnDocumentCompleted(object sender, DWebBrowserEvents2_DocumentCompleteEvent e)
		{
			if(this.DocumentCompleted != null)
			{
				Uri uri = null;
				if(Uri.TryCreate(e.uRL as string, UriKind.Absolute, out uri))
				{
					WebBrowserDocumentCompletedEventArgs ev = new WebBrowserDocumentCompletedEventArgs(uri);
					this.DocumentCompleted(sender, ev);
					this.OnDocumentCompletedActionTrigger(e.uRL as string);
					//InnerLogger.Out("comple " + this.History.GetCount(TLENUMF.TLEF_ABSOLUTE).ToString() + " = " + e.uRL as String);
				}
			}
		}
		/// <summary><see cref="StatusTextChanged"/>Cxg̃gKłB</summary>
		/// <param name="sender">WebBrowserAxNX̃CX^X</param>
		/// <param name="e"><see cref="AxSHDocVw.DWebBrowserEvents2_StatusTextChangeEvent"/></param>
		protected void OnStatusTextChanged(object sender, DWebBrowserEvents2_StatusTextChangeEvent e)
		{
			if(this.StatusTextChanged != null)
			{
				this.StatusTextChanged(sender, new EventArgs());
			}
		}
		/// <summary><see cref="DocumentTitleChanged"/>Cxg̃gKłB</summary>
		/// <param name="sender">WebBrowserAxNX̃CX^X</param>
		/// <param name="e"><see cref="AxSHDocVw.DWebBrowserEvents2_TitleChangeEvent"/></param>
		protected void OnDocumentTitleChanged(object sender, DWebBrowserEvents2_TitleChangeEvent e)
		{
			if(this.DocumentTitleChanged != null)
			{
				this.DocumentTitleChanged(sender, new EventArgs());
			}
		}
		/// <summary><see cref="ProgressChanged"/>Cxg̃gKłB</summary>
		/// <param name="sender">WebBrowserAxNX̃CX^X</param>
		/// <param name="e"><see cref="AxSHDocVw.DWebBrowserEvents2_ProgressChangeEvent"/></param>
		protected void OnProgressChanged(object sender, DWebBrowserEvents2_ProgressChangeEvent e)
		{
			if(this.ProgressChanged != null)
			{
				WebBrowserProgressChangedEventArgs ev = new WebBrowserProgressChangedEventArgs(e.progress, e.progressMax);
				this.ProgressChanged(sender, ev);
			}
		}
		/// <summary><see cref="WindowClosing"/>Cxg̃gKłB</summary>
		/// <param name="sender">WebBrowserAxNX̃CX^X</param>
		/// <param name="e"><see cref="AxSHDocVw.DWebBrowserEvents2_WindowClosingEvent"/></param>
		protected void OnWindowClosing(object sender, DWebBrowserEvents2_WindowClosingEvent e)
		{
			if(this.WindowClosing != null)
			{
				WebBrowserWindowClosingEventArgs ev = new WebBrowserWindowClosingEventArgs(e);
				this.WindowClosing(sender, ev);
				ev.Release();
			}
		}
		/// <summary><see cref="MessagePosted"/>Cxg̃gKłB</summary>
		/// <param name="e"><see cref="TbMessagePostEventArgs"/></param>
		protected void OnMessagePosted(TbMessagePostEventArgs e)
		{
			if(this.MessagePosted != null)
			{
				this.MessagePosted(this, e);
			}
		}

		#endregion

		#region +--  AxWebBrowser Event Handlers

		void browser_NewWindow2(object sender, DWebBrowserEvents2_NewWindow2Event e)
		{
			this.OnBeforeNewWindow(this, e);
		}
		void browser_BeforeNavigate2(object sender, DWebBrowserEvents2_BeforeNavigate2Event e)
		{
			this.OnBeforeNavigate(this, e);
		}
		void browser_NavigateComplete2(object sender, DWebBrowserEvents2_NavigateComplete2Event e)
		{
			if(_del_windowproc == null) { this.set_WindowProcedure(); } // gpɃv[W̍ւ
			this.OnNavigated(this, e);

			if(this._evt_DisplayTextChanged != null)
			{
				this._evt_DisplayTextChanged(this as ITbPageControl, new ITbDisplayEventArgs(ITbDisplayEventType.Url, e.uRL as string));
			}
			// this.clearEditorKeys();
		}
		void browser_NavigateError(object sender, DWebBrowserEvents2_NavigateErrorEvent e)
		{
			this.OnNavigateError(this, e);
		}
		void browser_ProgressChange(object sender, DWebBrowserEvents2_ProgressChangeEvent e)
		{
			this.OnProgressChanged(this, e);
		}
		void browser_DownloadComplete(object sender, EventArgs e)
		{
			this.OnDownloadCompleted(this, e);
		}

		void browser_DocumentComplete(object sender, DWebBrowserEvents2_DocumentCompleteEvent e)
		{
			IHTMLDocument2 pDocument = null;
			try
			{
				if(this._pUIHandler == null) { this._pUIHandler = new DocHostUIHandler(this); }
				pDocument = this.Document as IHTMLDocument2;
				ICustomDoc pCustomDoc = pDocument as ICustomDoc;
				if(pCustomDoc != null)
				{
					pCustomDoc.SetUIHandler(this._pUIHandler);
				}
			}
			finally { if(pDocument != null) { Marshal.ReleaseComObject(pDocument); pDocument = null; } }
			this.OnDocumentCompleted(this, e);
		}
		void browser_TitleChange(object sender, DWebBrowserEvents2_TitleChangeEvent e)
		{
			lock(_pagetitle)
			{
				_pagetitle = e.text;
			}
			this.OnDocumentTitleChanged(this, e);
			if(this._evt_DisplayTextChanged != null)
			{
				this._evt_DisplayTextChanged(this as ITbPageControl, new ITbDisplayEventArgs(ITbDisplayEventType.Title, e.text));
			}
		}
		void browser_StatusTextChange(object sender, DWebBrowserEvents2_StatusTextChangeEvent e)
		{
			this.OnStatusTextChanged(this, e);
			if(this._evt_DisplayTextChanged != null)
			{
				this._evt_DisplayTextChanged(this as ITbPageControl, new ITbDisplayEventArgs(ITbDisplayEventType.StatusText, e.text));
			}
		}
		void browser_WindowClosing(object sender, DWebBrowserEvents2_WindowClosingEvent e)
		{
			this.OnWindowClosing(this, e);
		}
		void browser_PreviewKeyDown(object sender, PreviewKeyDownEventArgs e)
		{
			this.OnPreviewKeyDown(e);
		}
		void browser_CommandStateChange(object sender, DWebBrowserEvents2_CommandStateChangeEvent e)
		{
			switch(e.command)
			{
				case CommandState.NavigateForward:
					_canGoFore = e.enable;
					this.OnCanGoForwardChanged(this, new EventArgs());
					break;
				case CommandState.NavigateBack:
					_canGoBack = e.enable;
					this.OnCanGoBackChanged(this, new EventArgs());
					break;
			}
		}

		#endregion


		#region DelayedAction

		/// <summary>DocumentCompletedgKƂ<see cref="DelayedAction"/>s܂B</summary>
		/// <param name="url">DocumentCompleted𔭐URL</param>
		protected void OnDocumentCompletedActionTrigger(string url)
		{
			DelayedActOption option = new DelayedActOption(NavigateState.DocumentCompleted, url, this.DocumentTitle);
			this.DelayedActionTrigger(option);
		}

		/// <summary><see cref="DelayedAction"/>s܂B</summary>
		/// <param name="option">DelayedActionsۂ̏</param>
		private void DelayedActionTrigger(DelayedActOption option)
		{
			if(this._actionsOnCompleted != null
				&& this._actionsOnCompleted.Count > 0)
			{
				DelayedAction action = null;
				int cursor = 0;
				while(cursor < this._actionsOnCompleted.Count)
				{
					option.AutoUnregister = true;
					option.CallNextAction = false;
					action = this._actionsOnCompleted[cursor];
					action.Action(this, option);
					if(option.AutoUnregister)
					{
						this._actionsOnCompleted.RemoveAt(cursor);
					}
					else { ++cursor; }
					if(!option.CallNextAction) { break; }
				}
			}
		}
		/// <summary>uEU<see cref="DelayedAction"/>o^܂B</summary>
		/// <param name="action">o^<see cref="DelayedAction"/>IuWFNg</param>
		/// <param name="targetTrigger">o^̃gK\<see cref="NavigateState"/></param>
		/// <returns>o^IuWFNg܂߂āAw肵gKɌݓo^Ă<see cref="DelayedAction"/>̐B</returns>
		/// <exception cref="ArgumentNullException">actionNULL̍ۂɔ܂B</exception>
		/// <exception cref="NotSupportedException">gpłȂgKw肵ꍇɔ܂B</exception>
		internal protected int RegisterDelayedAction(DelayedAction action, NavigateState targetTrigger)
		{
			if(action == null) { throw new ArgumentNullException("Set Null to DelayedAction"); }
			switch(targetTrigger)
			{
				case NavigateState.DocumentCompleted:
					this._actionsOnCompleted.Add(action);
					return this._actionsOnCompleted.Count;
				default:
					throw new NotSupportedException("݂DelayedActiongK͗pł܂B");
			}
		}

		#endregion


		/// <summary>InternetExplorerServer ftHg̃v[W[ĂяoOɁAbZ[W擾ď܂B</summary>
		/// <param name="hWnd">bZ[WMEBhẼnhw肵܂B </param>
		/// <param name="message">bZ[Ww肵܂B </param>
		/// <param name="wParam">bZ[W̒ǉw肵܂B̃p[^̈Ӗ́AMsg p[^̒lɂĈقȂ܂B</param>
		/// <param name="mParam">bZ[W̒ǉw肵܂B̃p[^̈Ӗ́AMsg p[^̒lɂĈقȂ܂B</param>
		/// <returns>bZ[W̌ʂԂ܂B߂l̈Ӗ́AMꂽbZ[WɂĈقȂ܂B</returns>
		private IntPtr BeforeIEWndProc(IntPtr hWnd, int message, IntPtr wParam, IntPtr mParam)
		{
			if(message == 0x207) // WM_MBUTTONDOWN
			{
				if(this.BrowserMouseDown != null)
				{
					int i32mParam = mParam.ToInt32();
					int i32wP = wParam.ToInt32();

					WebBrowserMouseMessageEventArgs arg = new WebBrowserMouseMessageEventArgs(
						MouseButtons.Middle, 1, i32mParam & 0x0000FFFF, i32mParam >> 16, 0,
						(i32wP & 0x8) == 0x8, (i32wP & 0x4) == 0x4);
					this.BrowserMouseDown(this, arg);
					if(arg.CancelMessage)
					{
                        return NativeMethods.CallWindowProc(IntPtr.Zero, hWnd, message, wParam, mParam);
					}
				}
			}
			else if(message == 0x201) // WM_L/RBUTTONDOWN
			{
				if(this.BrowserMouseDown != null)
				{
					int i32mParam = mParam.ToInt32();
					int i32wP = wParam.ToInt32();
					MouseButtons btn = MouseButtons.None;
					if((i32wP & 0x1) == 0x1) { btn |= MouseButtons.Left; }
					if((i32wP & 0x2) == 0x2) { btn |= MouseButtons.Right; }
					WebBrowserMouseMessageEventArgs arg = new WebBrowserMouseMessageEventArgs(
						btn, 1, i32mParam & 0x0000FFFF, i32mParam >> 16, 0,
						(i32wP & 0x8) == 0x8, (i32wP & 0x4) == 0x4);
					this.BrowserMouseDown(this, arg);
					if(arg.CancelMessage)
					{
                        return NativeMethods.CallWindowProc(IntPtr.Zero, hWnd, message, wParam, mParam);
					}
				}
			}
            return NativeMethods.CallWindowProc(_pIEWindowDefProc, hWnd, message, wParam, mParam);
		}
		/// <summary>EBhEbZ[W܂B</summary>
		/// <param name="m"></param>
		protected override void WndProc(ref Message m)
		{
			if(m.Msg == 0x210)//WM_NOTIFY
			{
				int iwParam = m.WParam.ToInt32();
				if(LOWORD(iwParam) == 0x20B) // WM_XBUTTONDOWN
				{
					int ipoint = m.LParam.ToInt32();
					MouseButtons btn = MouseButtons.None;
					switch(HIWORD(iwParam))
					{
						case (0x1): { btn |= MouseButtons.XButton1; break; }
						case (0x2): { btn |= MouseButtons.XButton2; break; }
					}
					MouseEventArgs arg = new MouseEventArgs(
						btn, 1, LOWORD(ipoint), HIWORD(ipoint), 0);
					this.OnMouseDown(arg);
				}
			}
			base.WndProc(ref m);
		}
		/// <summary>̃Rg[}EXCxg𔭐鎞Ɏgp郁\bh\܂B</summary>
		/// <param name="e"></param>
		delegate void MouseDownEventDelegate(MouseEventArgs e);
		/// <summary>MouseEventArgs}EXCxg󂯎āA<see cref="MouseDown"/>Cxg𔭐܂B</summary>
		/// <param name="e"></param>
		private void async_mousedown(MouseEventArgs e)
		{
			this.BeginInvoke(new MouseDownEventDelegate(this.OnMouseDown), new object[] { e });
		}

		/// <summary><see cref="Int32"/>A16bitiPjuj𔲂o<see cref="Int16"/>ƂĕԂ܂B</summary>
		/// <param name="dword"></param>
		/// <returns>16biti1juj</returns>
		private static short HIWORD(int dword)
		{
			return (short)(dword >> 16);
		}
		/// <summary><see cref="Int32"/>A16bitiPjuj𔲂o<see cref="Int16"/>ƂĕԂ܂B</summary>
		/// <param name="dword"></param>
		/// <returns>16biti1juj</returns>
		private static short LOWORD(int dword)
		{
			return (short)(dword & 0xFFFF);
		}

		#endregion

		#region I/F **** ITbPageControl o

		string ITbPageControl.DisplayUrl
		{
			get
			{
				string url = null;
				try { url = this.Url; } catch { }
				return url ?? String.Empty;
			}
		}
		string ITbPageControl.DisplayTitle
		{
			get
			{
				string tmp = null;
				try { tmp = this.DocumentTitle; }
				catch { }
				return tmp ?? String.Empty;
			}
		}
		string ITbPageControl.DisplayStatusText
		{
			get
			{
				string tmp = null;
				try { tmp = this.StatusText; }
				catch { }
				return tmp ?? String.Empty;
			}
		}

		bool ITbPageControl.Navigate(string url)
		{
			this.Navigate(url);
			return true;
		}
		bool ITbPageControl.IsWebBrowser
		{
			get { return true; }
		}
		WebBrowserAx ITbPageControl.AsBrowser
		{
			get { return this; }
		}
		Control ITbPageControl.AsControl
		{
			get { return this as Control; }
		}
		void ITbPageControl.ReleaseControl()
		{
			if(_browser != null)
			{
				this.Dispose(true);
			}
		}
		event ITbDisplayEventHandler ITbPageControl.DisplayTextChanged
		{
			add { this._evt_DisplayTextChanged += value; }
			remove { this._evt_DisplayTextChanged -= value; }
		}
		
		#endregion

		protected override void Dispose(bool disposing)
		{
			try
			{
				this.reset_WindowProdure();

				if(disposing)
				{
					if(this._pUIHandler != null)
					{
						this._pUIHandler.Dispose();
						this._pUIHandler = null;
					}
					if(_browser != null)
					{
						this.Silent = true;
						_browser.Stop();
						_browser.Dispose();
						_browser = null;
					}
					if(this._actionsOnCompleted != null) { this._actionsOnCompleted.Clear(); this._actionsOnCompleted = null; }
					if(_history != null) { _history.Dispose(); _history = null; }
					_ism = null;
				}
			}
			finally
			{
				base.Dispose(disposing);
			}
		}

		#region ==== Inner Class Definitions ====

		delegate IntPtr WindowProcDelegate(IntPtr hWnd, int message, IntPtr wParam, IntPtr mParam);
		static class CommandState
		{
			public const int UpdateCommands		= -1;
			public const int NavigateForward	= 0x00000001;
			public const int NavigateBack		= 0x00000002;
		}

		#endregion
	}
}
