﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Alternative.Controls.Browsers
{
	/// <summary>TabBrowserControlからタブをD&amp;Dされた時のデータを表します。</summary>
	/// <seealso cref="TabBrowserControl"/>
	public class TabBrowserDragDropData : MarshalByRefObject
	{
		/// <summary>
		/// ドラッグされたタブで開かれているUrl
		/// </summary>
		public string Url;
		/// <summary>
		/// ドラッグされたタブで開かれているページのタイトル
		/// </summary>
		public string Title;
		/// <summary>
		/// ドラッグされたタブのインデックス位置
		/// </summary>
		public int Index;

		/// <summary>
		/// このクラスのコンストラクタ
		/// </summary>
		/// <param name="index">タブのインデックス</param>
		public TabBrowserDragDropData(int index) : this(index, String.Empty, String.Empty) { }
		/// <summary>
		/// このクラスのコンストラクタ
		/// </summary>
		/// <param name="index">タブのインデックス</param>
		/// <param name="url">タブで開いているURL</param>
		/// <param name="title">タブで開いているページのタイトル</param>
		public TabBrowserDragDropData(int index, string url, string title)
		{
			this.Index = index;
			this.Url = url;
			this.Title = title;
		}
	}
}
