using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Security.Permissions;
using System.Text.RegularExpressions;
using System.Web;
using System.Windows.Forms;
using System.Xml.Serialization;
using mshtml;

namespace Alternative.Controls.Browsers
{
    using Alternative.Win32;
    using Alternative.Functions;
    using Alternative.Functions.BrowserExtension;

    /// <summary>^uuEŰ@\񋟂܂B</summary>
    /// <remarks>
    /// ̃NX́Aȉ̃t@Cst@C̃fBNgɏo͂܂B
    /// ̃t@C㏑̂ŁAӂĂB
    /// <para>./closedtab.xml</para>
    /// </remarks>
    /// <seealso cref="ITbPageControl"/>
    /// <seealso cref="WebBrowserAx"/>
    /// <seealso cref="TabBrowserSetting"/>
    /// <seealso cref="InnerLogger"/>
    /// <seealso cref="InternetSecurityManager"/>
    /// <seealso cref="ExHtmlHistory"/>
    /// <seealso cref="mshtml"/>
    [PermissionSet(SecurityAction.LinkDemand, Name = "FullTrust")]
    public class TabBrowserControl : UserControl
    {
        #region Constant & Static Members

        const int IMGIDX_TAB_NORMAL = -1;
        const int IMGIDX_TAB_LOCKED = 0;

        const int TAB_HEIGHT = 20;

        #region +--  Const for Special Navigation

        const string SpLink_DownLink_Head = @"http://boon/?";
        const string SpLink_DownLink_Compatible_Head = @"http://boon/";
        const string SpLink_Favorite_Head = @"http://favorite.boon/?";
        const string SpLink_AboutInfo_Head = @"http://about.boon/";
        const string SpLink_Config_Head = @"http://config.boon/";

        const string URLACT_F_Favorite = "favorite";
        const string URLACT_F_About = "about";
        const string URLACT_F_Config = "config";
        const string URLACT_F_Download = "download";

        #endregion

        #endregion


        #region ######  Field  ######

        #region +--  Display Component

        /// <summary>Rg[㕔̃^u</summary>
        TabControl _tab;
        /// <summary>̃Rg[ۗLĂy[WRg[̃RNV</summary>
        List<ITbPageControl> _pages;
        /// <summary>ׂẴy[WRg[ڂĂA\̈Rg[</summary>
        Panel _screen;
        /// <summary>̃CX^XŎgpĂݒ</summary>
        TabBrowserSetting _setting;

        #endregion

        #region +--  Local Frags & Temporaries

        /// <summary>̃NX̓IuWFNg</summary>
        private object _sync;
        bool _silentmode;
        /// <summary>}EXANZX̃^[QbgƂȂĂ^ũCfbNX</summary>
        private int _frg_tabTarget;
        private int _frg_mousedown_m_counter;
        /// <summary>DragDrop̃f[^i[</summary>
        private TabBrowserDragDropData _dd_data;
        private bool _frg_dd_active;

        #endregion

        #endregion


        #region Constructor / Initializer

        /// <summary>̃NX̃RXgN^łBftHgݒgp܂B</summary>
        public TabBrowserControl()
        {
            this._setting = new TabBrowserSetting();
            this._sync = new object();
            this._frg_tabTarget = -1;
            this._frg_mousedown_m_counter = 0;
            this._dd_data = null;
            this._frg_dd_active = false;
            this._silentmode = false;
            this._documentEditor = new IHtmlDocumentEditor[] { new NicovideoDownloadHtmlEditor() };

            this._tab = new TabControl();
            this._screen = new Panel();
            this._pages = new List<ITbPageControl>();

            // this
            this.Dock = DockStyle.Fill;
            this.Size = new Size(400, 400);
            // tabControl
            this._tab.Size = new Size(400, TAB_HEIGHT);
            this._tab.ShowToolTips = true;
            this._tab.Multiline = false;
            this._tab.MinimumSize = new Size(50, 20);
            this._tab.AllowDrop = true;

            this._tab.ImageList = new ImageList();
            this._tab.ImageList.ImageSize = new Size(4, 4);
            this._tab.ImageList.Images.Add(global::Alternative.Properties.Resources.tabLocked);
            // _screen
            this._screen.Size = new Size(400, 380);
            this._screen.Location = new Point(0, 20);
            this._screen.AllowDrop = true;

            // event
            this.SizeChanged += new EventHandler(TabBrowser_SizeChanged);
            this.MouseClick += new MouseEventHandler(TabBrowser_MouseClick);
            this.MouseDoubleClick += new MouseEventHandler(TabBrowser_MouseDoubleClick);

            this._tab.SelectedIndexChanged += new EventHandler(tab_SelectedIndexChanged);
            this._tab.MouseDoubleClick += new MouseEventHandler(tab_MouseDoubleClick);
            this._tab.MouseWheel += new MouseEventHandler(tab_MouseWheel);
            this._tab.MouseDown += new MouseEventHandler(tab_MouseDown);
            this._tab.MouseUp += new MouseEventHandler(tab_MouseUp);
            this._tab.MouseMove += new MouseEventHandler(tab_MouseMove);
            this._tab.DragDrop += new DragEventHandler(tab_DragDrop);
            this._tab.DragEnter += new DragEventHandler(tab_DragEnter);
            this._tab.DragOver += new DragEventHandler(tab_DragOver);
            this._tab.PreviewKeyDown += new PreviewKeyDownEventHandler(tab_PreviewKeyDown);

            this.Controls.Add(this._tab);
            this.Controls.Add(this._screen);
            this.initializeContextMenu();
            this.initializePageList();
            this.initialize_LinkSubMenu();
            this.initiaizeClosedHistory();

            this._tab.ContextMenuStrip = this.contextMenuStrip100_ForTab;
        }


        #endregion


        #region Event Handlers (Private only)

        #region +--  BaseControl Event Hander

        void tab_SelectedIndexChanged(object sender, EventArgs e)
        {
            this.set_visible(this.TbSelectedIndex);
            this.OnSelectedIndexChanged(sender, e);
        }

        void tab_DragOver(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(typeof(TabBrowserDragDropData)))
            {
                e.Effect = e.AllowedEffect & DragDropEffects.Move;
            }
            else if (e.Data.GetDataPresent(DataFormats.UnicodeText))
            {
                e.Effect = e.AllowedEffect & DragDropEffects.Link;
            }
            else if (e.Data.GetDataPresent(DataFormats.Text))
            {
                e.Effect = e.AllowedEffect & DragDropEffects.Link;
            }
            else if (e.Data.GetDataPresent(Identify.UniformResourceLocator))
            {
                e.Effect = e.AllowedEffect & DragDropEffects.Link;
            }
            else { e.Effect = DragDropEffects.None; }
        }

        void tab_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(typeof(TabBrowserDragDropData)))
            {
                e.Effect = e.AllowedEffect & DragDropEffects.Move;
            }
            else if (e.Data.GetDataPresent(DataFormats.UnicodeText))
            {
                e.Effect = e.AllowedEffect & DragDropEffects.Link;
            }
            else if (e.Data.GetDataPresent(DataFormats.Text))
            {
                e.Effect = e.AllowedEffect & DragDropEffects.Link;
            }
            else if (e.Data.GetDataPresent(Identify.UniformResourceLocator))
            {
                e.Effect = e.AllowedEffect & DragDropEffects.Link;
            }
        }

        void tab_DragDrop(object sender, DragEventArgs e)
        {
            Point pt = this._tab.PointToClient(new Point(e.X, e.Y));
            int tgt = this.get_tabIndexByLocation(pt);

            if (e.Data.GetDataPresent(typeof(TabBrowserDragDropData)))
            {
                TabBrowserDragDropData data = (TabBrowserDragDropData)e.Data.GetData(typeof(TabBrowserDragDropData));
                int source = data.Index;
                if (this.InRange(tgt) && this.InRange(source))
                {
                    this.movPageControl(source, tgt);
                    this.TbSelectedIndex = tgt;
                }
            }
            else
            {
                string url = null;
                if (e.Data.GetDataPresent(DataFormats.UnicodeText))
                {
                    url = e.Data.GetData(DataFormats.UnicodeText) as string;
                }
                else if (e.Data.GetDataPresent(DataFormats.Text)) // URLD&D󂯓B
                {
                    url = (string)e.Data.GetData(DataFormats.Text);
                }
                else if (e.Data.GetDataPresent(Identify.UniformResourceLocator)) // UrlD&D󂯓
                {
                    url = e.Data.GetData(Identify.UniformResourceLocator) as string;
                }

                if (url != null)
                {
                    Uri u = null;
                    if (Uri.TryCreate(url, UriKind.Absolute, out u))
                    {
                        ITbPageControl page = this.TbGetControl(tgt);
                        if (page.Navigate(u.AbsoluteUri))
                        {
                            page.AsBrowser.Navigate(u.AbsoluteUri, String.Empty);
                        }
                        else
                        {
                            this.TbOpenNewTab(u.AbsoluteUri, tgt + 1, true);
                        }
                    }
                }
            }
        }

        void tab_MouseDown(object sender, MouseEventArgs e)
        {
            this._frg_tabTarget = this.get_tabIndexByLocation(e.Location);
            if (this.InRange(this._frg_tabTarget)) // InRange
            {
                if (e.Button == MouseButtons.Left)
                {
                    this._frg_dd_active = false;
                    this._dd_data = null;
                }
                else if (e.Button == MouseButtons.Middle)
                {
                    if (this._frg_mousedown_m_counter++ == 0)
                    {
                        this.invoke_TbClickAction(this.Setting.TabMouseDownM, this._frg_tabTarget);
                    }
                }
            }
            else // OutRange
            {
            }
        }
        void tab_MouseMove(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left && (!this._frg_dd_active) && this._frg_tabTarget >= 0)
            {
                if (this._dd_data == null)
                {
                    ITbPageControl page;
                    page = this.TbGetControl(this._frg_tabTarget);
                    this._dd_data = new TabBrowserDragDropData(this._frg_tabTarget, page.DisplayUrl, page.DisplayTitle);
                }
                else if (this.get_tabIndexByLocation(e.Location) != this._frg_tabTarget)
                {
                    this._frg_dd_active = true;
                    DataObject d_obj = new DataObject();
                    string url = this._dd_data.Url;
                    d_obj.SetText(url);
                    d_obj.SetData(this._dd_data);
                    d_obj.SetData(new Uri(url));
                    byte[] strbyte = System.Text.Encoding.ASCII.GetBytes(url + "\0");
                    if (strbyte.Length > 1)
                    {
                        System.IO.MemoryStream ms = new System.IO.MemoryStream(strbyte);
                        d_obj.SetData(Identify.UniformResourceLocator, ms);
                    }
                    DragDropEffects dde = DragDropEffects.All;
                    this.DoDragDrop(d_obj, dde);
                    this._dd_data = null;
                }
            }
        }
        void tab_MouseUp(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left)
            {
                this._dd_data = null;
                this._frg_dd_active = false;
            }
            else if (e.Button == MouseButtons.Middle)
            {
                this._frg_mousedown_m_counter = 0;
            }
            else if (e.Button == MouseButtons.Right)
            {
                this._frg_tabTarget = this.get_tabIndexByLocation(e.Location);
            }
        }
        void tab_MouseWheel(object sender, MouseEventArgs e)
        {
            if (this.Setting.EnableTabWheel && this.TbTabCount > 1)
            {
                if (this.get_tabIndexByLocation(e.Location) >= 0)
                {
                    int delta_unit = SystemInformation.MouseWheelScrollDelta;
                    int tmp = (this.TbTabCount + this.TbSelectedIndex - e.Delta / delta_unit);

                    if (this._setting.TabWheelRotate || (this.TbTabCount <= tmp && tmp < this.TbTabCount * 2))
                    {
                        this.TbSelectedIndex = tmp % this.TbTabCount;
                    }
                }
            }
        }
        void tab_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left)
            {
                int index = this.get_tabIndexByLocation(e.Location);
                if (this.InRange(index))
                    this.invoke_TbClickAction(this.Setting.TabDoubleClickL, index);
            }
        }

        void tab_PreviewKeyDown(object sender, PreviewKeyDownEventArgs e)
        {
            this.OnPreviewKeyDown(e);
        }


        void TabBrowser_SizeChanged(object sender, EventArgs e)
        {
            this.SuspendLayout();
            this.adjust_size();
            this.ResumeLayout(false);
            this.Invalidate();
        }
        void TabBrowser_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Left)
            {
                this.invoke_TbClickAction2(this.Setting.TabEmptyDoubleClickL);
            }
        }
        void TabBrowser_MouseClick(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Middle)
            {
                this.invoke_TbClickAction2(this.Setting.TabEmptyWheelClick);
            }
            else if (e.Button == MouseButtons.Right)
            {
                this.invoke_TbClickAction2(this.Setting.TabEmptyClickR);
            }
        }

        #endregion


        #region +--  Browser Event Handlers

        /// <summary>uEBhEJvu^uJv̕ῗB</summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void browser_BeforeNewWindow(object sender, WebBrowserBeforeNewWindowEventArgs e)
        {
            this.OnBeforeNewTab(sender, e);
            if (!e.Cancel)
            {
                ITbPageControl page = sender as ITbPageControl;
                int senderindex = this._pages.IndexOf(page);
                if (senderindex < 0)
                {
                    InnerLogger.LOut("BeforeNewWindow : sender RNVɑ݂܂", InnerLogger.ErrorLevel.L2_WARNING);
                    senderindex = this.TbSelectedIndex;
                }
                WebBrowserAx newbrowser = this.create_browser();
                try
                {
                    this.addPageControl(newbrowser as ITbPageControl, senderindex + 1);

                    e.ppDisp = newbrowser.Application;
                    newbrowser.RegisterAsBrowser = true;
                }
                catch (Exception exep)
                {
                    MessageBox.Show(exep.Message, Application.ProductName);
                    e.Cancel = true;
                }
            }
        }

        /// <summary>URLւ̃irQ[ĝӂ邢͂B</summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void browser_BeforeNavigate(object sender, WebBrowserBeforeNavigateEventArgs e)
        {
            this.OnBeforeNavigate(sender, e);
            if (!e.Cancel)
            {
                Match mt = CommonRequestProvider.RxRequestUrl.Match(e.Url);
                if (mt.Success) // BOONURLł URL Action
                {
                    InnerLogger.LOut("urlaction-delected:@" + e.Url, InnerLogger.ErrorLevel.L5_LOG);
                    e.Cancel = true;
                    Group g = mt.Groups["function"];
                    switch (g.Value)
                    {
                    case "":
                        {
                            string p = mt.Groups["params"].Value;
                            bool ok = false;
                            if (mt.Groups["withquery"].Success)
                            {
                                InnerLogger.LOut("url-action:function=download", InnerLogger.ErrorLevel.L4_NOTIFY);
                                // W̓_E[hpURLɂ_E[h [http://boon/?url=http...]
                                p = e.Url;
                                ok = true;
                            }
                            else if (NicoVideoPageUrl.IsVideoID(p))
                            {
                                InnerLogger.LOut("url-action:function=download/alternative", InnerLogger.ErrorLevel.L4_NOTIFY);
                                // BOON`ł̃jRjR_E[h [http://boon/sm0000]
                                p = this.make_downlink_from_movieID(p);
                                ok = true;
                            }
                            if (ok) // _E[h̋ʕ
                            {
                                MovieDownloadRequiredEventArgs arg = MovieDownloadRequiredEventArgs.FromRequestUrl(p);
                                if (arg != null) { this.OnMovieDownloadRequired(sender, arg); }
                                else { InnerLogger.LOut("Error:: Invalid Format DownRequest.", InnerLogger.ErrorLevel.L2_WARNING); }
                            }
                            else
                            {
                                InnerLogger.LOut("url-action:function=download/NGXg̕ϊɎs", InnerLogger.ErrorLevel.L2_WARNING);
                            }
                            break;
                        }
                    case URLACT_F_Download: // BOONzXgANZXiURLANVjɂ_E[h
                        {
                            InnerLogger.LOut("url-action:function=download-ex", InnerLogger.ErrorLevel.L4_NOTIFY);
                            MovieDownloadRequiredEventArgs arg = MovieDownloadRequiredEventArgs.FromRequestUrl(e.Url);
                            if (arg != null) { this.OnMovieDownloadRequired(sender, arg); }
                            else { InnerLogger.LOut("Error:: Invalid Format DownRequest.", InnerLogger.ErrorLevel.L2_WARNING); }
                            break;
                        }
                    case URLACT_F_Favorite:
                        {
                            InnerLogger.LOut("url-action:function=favorite", InnerLogger.ErrorLevel.L4_NOTIFY);
                            break;
                        }
                    case URLACT_F_Config:
                        {
                            InnerLogger.LOut("url-action:function=config", InnerLogger.ErrorLevel.L4_NOTIFY);
                            break;
                        }
                    case URLACT_F_About:
                        {
                            InnerLogger.LOut("url-action:function=about", InnerLogger.ErrorLevel.L4_NOTIFY);
                            break;
                        }
                    default:
                        {
                            InnerLogger.LOut("url-action:T|[gĂȂNGXg", InnerLogger.ErrorLevel.L3_ALART);
                            break;
                        }
                    }
                }
                else // ʏURLłBeforeirQ[g
                {
                    int index = this.TbGetIndexByEventSender(sender as ITbPageControl);
                    bool locked = this.TbGetIsLocked(index);
                    if (locked && (this.Setting.LockedTabBehavior & LockedTabBehaviors.NavigateOnNew) == LockedTabBehaviors.NavigateOnNew)
                    {
                        InnerLogger.LOut("befnav_lockedtab_redirect", InnerLogger.ErrorLevel.L5_LOG);
                        e.Cancel = true;
                        this.TbOpenNewTab(e.Url, index + 1, true);
                    }
                }
            }
            else
            {
                InnerLogger.LOut("nav_canceled:@tabbrowser::befnav-evt", InnerLogger.ErrorLevel.L5_LOG);
            }
        }

        /// <summary>SecurityManageȑXV͂B</summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void browser_Navigated(object sender, WebBrowserNavigatedEventArgs e)
        {
            WebBrowserAx browser = sender as WebBrowserAx;
            if (browser.SecurityManager != null)
            {
                browser.SecurityManager.NavigateToPage(browser.Url);
                InnerLogger.LOut("IISM-setzoneby:" + browser.Url, InnerLogger.ErrorLevel.L5_LOG);
                InnerLogger.LOut("IISM-currentzone:" + browser.SecurityManager.CurrentZone, InnerLogger.ErrorLevel.L5_LOG);
            }
            this.OnNavigated(sender, e);
        }
        void browser_ProgressChanged(object sender, WebBrowserProgressChangedEventArgs e)
        {
            this.OnProgressChanged(sender, e);
        }

        /// <summary>HtmlDocumentEditorւ̃fBXpb`͂B</summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void browser_DownloadCompleted(object sender, EventArgs e)
        {
            this.OnDownloadCompleted(sender, e);
            WebBrowserAx b = sender as WebBrowserAx;
            this.call_HtmlDocumentEditor(b.Url, HtmlEditTrigger.OnDownloadCompleted, b);
        }


        /// <summary>HtmlDocumentEditorւ̃fBXpb`͂B</summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void browser_DocumentCompleted(object sender, WebBrowserDocumentCompletedEventArgs e)
        {
            this.OnDocumentCompleted(sender, e);
            WebBrowserAx b = sender as WebBrowserAx;
            this.call_HtmlDocumentEditor(b.Url, HtmlEditTrigger.OnDocumentCompleted, b);
        }

        void browser_CanGoForwardChanged(object sender, EventArgs e)
        {
            this.OnCanGoForwardChanged(sender, e);
        }
        void browser_CanGoBackChanged(object sender, EventArgs e)
        {
            this.OnCanGoBackChanged(sender, e);
        }

        void browser_NavigateError(object sender, WebBrowserNavigateErrorEventArgs e)
        {
            this.OnNavigateError(sender, e);
        }
        /// <summary>y[W̊J͂</summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void browser_WindowClosing(object sender, WebBrowserWindowClosingEventArgs e)
        {
            int index = this._pages.IndexOf((sender as ITbPageControl));
            if (0 <= index)
            {
                this.act_before_close(index);
                InnerLogger.LOut("br-closing_by_script:index=" + index, InnerLogger.ErrorLevel.L4_NOTIFY);
                this.remPageControl(index).ReleaseControl();
            }
        }
        void browser_PreviewKeyDown(object sender, PreviewKeyDownEventArgs e)
        {
            this.OnPreviewKeyDown(e);
        }

        /// <summary>zC[NbNŃNJ͂ŁB</summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void browser_BrowserMouseDown(object sender, WebBrowserMouseMessageEventArgs e)
        {
            if (e.Button == MouseButtons.Middle) // Open NewTab by HLink
            {
                WebBrowserAx browser = sender as WebBrowserAx;
                ComReleaseList R = new ComReleaseList();

                try
                {
                    IHTMLAnchorElement pAnchor = TryGetElementFromPosition<IHTMLAnchorElement>(browser, e.Location, ref R);

                    if (pAnchor != null)
                    {
                        string href = pAnchor.href;
                        InnerLogger.LOut("TGE,href=" + href, InnerLogger.ErrorLevel.L4_NOTIFY);
                        if (href != null && href.Length != 0)
                        {
                            e.CancelMessage = true; // IEɃ}EXbZ[W`Ȃ悤ɂ
                            Uri u = null;
                            Uri.TryCreate(href, UriKind.RelativeOrAbsolute, out u);
                            this.TbOpenNewTab(u.AbsoluteUri, this.TbSelectedIndex + 1, true);
                        }
                    }
                }
                finally { R.Release(true); }
            }
            else if (e.CtrlKey && e.Button == MouseButtons.Left)
            {
                WebBrowserAx browser = sender as WebBrowserAx;
                ComReleaseList R = new ComReleaseList();
                try
                {
                    string pageUrl;
                    IHTMLAnchorElement pAnchor = TryGetElementFromPosition<IHTMLAnchorElement>(browser, e.Location, out pageUrl, ref R);

                    if (pAnchor != null)
                    {
                        string href = pAnchor.href;
                        string target = pAnchor.target;
                        Keys key = AnchorMenuPopupEventArgs.Code_LinkExByMouse;
                        key |= Control.ModifierKeys;

                        AnchorMenuPopupEventArgs args = new AnchorMenuPopupEventArgs(href, target, browser.Url, e.Location, key);
                        this.OnAnchorMenuPopup(sender, args);

                        if (args.Cancel == false
                            && String.IsNullOrEmpty(href) == false)
                        {
                            e.CancelMessage = true;
                            if (NicoVideoPageUrl.IsWatchPage(href))
                            {
                                InnerLogger.LOut("TGC-OK with href=" + href, InnerLogger.ErrorLevel.L4_NOTIFY);
                                this.ctxLinkSubMenu.Tag = href;
                                this.ctxLinkSubMenu.Show(Cursor.Position);
                            }
                            else
                            {
                                InnerLogger.LOut("TGC-NG with href=" + href, InnerLogger.ErrorLevel.L4_NOTIFY);
                            }
                        }

                    }
                }
                finally { R.Release(true); }
            }
        }

        /// <summary>}EXXButtonɑ΂锽</summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void browser_MouseDown(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.XButton1)
            {
                this.TbGoBack();
            }
            else if (e.Button == MouseButtons.XButton2)
            {
                this.TbGoForward();
            }
        }

        /// <summary>^u̕\^CgҏW͂ŏ܂B</summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void page_DisplayTextChanged(ITbPageControl sender, ITbDisplayEventArgs e)
        {
            if ((e.EventType & ITbDisplayEventType.Title) == ITbDisplayEventType.Title)
            {
                int index = this._pages.IndexOf(sender);
                if (this.InRange(index))
                {
                    string beforeTitle = e.Data ?? String.Empty;
                    string afterTitle = beforeTitle;
                    string url = sender.DisplayUrl;
                    try
                    {
                        if (this.Setting.EnableRegexEditTitle)
                        {
                            ReadOnlyCollection<EditTitleInfo> editors = null;
                            int limit = 60;
                            lock (this._sync)
                            {
                                editors = this._setting.EditTitleInfos;
                                limit = this._setting.EditTitle_MaxLength;
                            }
                            if (limit <= 0) { limit = 60; } // 60ȏ͕\ȂB

                            foreach (EditTitleInfo edit in editors)
                            {
                                if (edit.Enabled)
                                {
                                    if (Regex.IsMatch(url, edit.Entry.Pattern, edit.Entry.Options))
                                    {
                                        afterTitle = Regex.Replace(afterTitle, edit.Replacer.Pattern, edit.Replacer.Replace, edit.Replacer.Options);
                                    }
                                }
                            }

                            if (limit < afterTitle.Length)
                            {
                                afterTitle = afterTitle.Substring(0, limit) + "...";
                            }
                        }
                        string limitedUrl = (url.Length >= 80) ? url.Substring(0, 77) + "..." : url;
                        this._tab.TabPages[index].ToolTipText = afterTitle + (limitedUrl.Length != 0 ? "\n" + limitedUrl : "");
                        this._tab.TabPages[index].Text = afterTitle;
                    }
                    catch (Exception ex) { Tool.WarningWriteLine(null, "^u\^Cg̕ҏWɃG[B{0}", ex.Message); }
                }
                this.OnDisplayTitleChanged(sender, e);
            }
            if ((e.EventType & ITbDisplayEventType.Url) == ITbDisplayEventType.Url)
            {
                this.OnDisplayUrlChanged(sender, e);
            }
            if ((e.EventType & ITbDisplayEventType.StatusText) == ITbDisplayEventType.StatusText)
            {
                this.OnDisplayStatusTextChanged(sender, e);
            }
        }

        void browser_MessagePosted(object sender, TbMessagePostEventArgs e)
        {
            int index = this.TbGetIndexByEventSender((ITbPageControl)sender);
            if (index >= 0)
            {
                switch (e.Message)
                {
                case TbMessagePostEventArgs.MessageRequireLock:
                    this.TbSetIsLocked(index, true);
                    break;
                case TbMessagePostEventArgs.MessageRequireUnlock:
                    this.TbSetIsLocked(index, false);
                    break;
                }
            }
        }

        #endregion

        #endregion


        #region Events & Event Triggers (Public)

        #region +--  Event Fields

        /// <summary>t@C̃_E[hvɔ܂B
        /// sender͂̃NX̃CX^XłB</summary>
        public event EventHandler<MovieDownloadRequiredEventArgs> MovieDownloadRequired;
        /// <summary>TbSelectedIndexvpeBύXꂽɔ܂B
        /// sender͂̃NX̃CX^XłB</summary>
        public event EventHandler TbSelectedIndexChanged;
        /// <summary>TbTabCountvpeB̒lωɔ܂
        /// sender͂̃NX̃CX^XłB</summary>
        public event EventHandler TbTabCountChanged;

        /// <summary>uEUV^uJƂ鎞ɔ܂B
        /// sender<see cref="WebBrowserAx"/>NX̃CX^XłB</summary>
        public event EventHandler<WebBrowserBeforeNewWindowEventArgs> TbBeforeNewTab;
        /// <summary>Rg[Ɋ܂܂uEÛꂩŔCxgBeforeNavigate`B܂B
        /// sender<see cref="WebBrowserAx"/>NX̃CX^XłB</summary>
        public event EventHandler<WebBrowserBeforeNavigateEventArgs> TbBeforeNavigate;
        /// <summary>Rg[Ɋ܂܂uEÛꂩŔNavigatedCxg`B܂B
        /// sender<see cref="WebBrowserAx"/>NX̃CX^XłB</summary>
        public event WebBrowserNavigatedEventHandler TbNavigated;
        /// <summary>Rg[Ɋ܂܂uEÛꂩŔProgressChangedCxg`B܂B
        /// sender<see cref="WebBrowserAx"/>NX̃CX^XłB</summary>
        public event WebBrowserProgressChangedEventHandler TbProgressChanged;
        /// <summary>uEUy[W̕\ɕKvȂׂẴt@CIɔ܂
        /// sender<see cref="WebBrowserAx"/>NX̃CX^XłB</summary>
        public event EventHandler TbDownloadCompleted;
        /// <summary>Rg[Ɋ܂܂uEÛꂩŔDocumentCompletedCxg`B܂B
        /// sender<see cref="WebBrowserAx"/>NX̃CX^XłB</summary>
        public event WebBrowserDocumentCompletedEventHandler TbDocumentCompleted;
        /// <summary>Rg[Ɋ܂܂uEÛꂩŔNavigateErrorCxg`B܂B
        /// sender<see cref="WebBrowserAx"/>NX̃CX^XłB</summary>
        public event EventHandler<WebBrowserNavigateErrorEventArgs> TbNavigateError;
        /// <summary>Rg[Ɋ܂܂uEÛꂩŔCanGoBackChangedCxg`B܂B
        /// sender<see cref="WebBrowserAx"/>NX̃CX^XłB</summary>
        public event EventHandler TbCanGoBackChanged;
        /// <summary>Rg[Ɋ܂܂uEÛꂩŔCanGoForwardChangedCxg`B܂B
        /// sender<see cref="WebBrowserAx"/>NX̃CX^XłB</summary>
        public event EventHandler TbCanGoForwardChanged;

        /// <summary>̃Rg[\ĂURL̒lύXꂽɔ܂B
        /// ^u̐؂ւɂ͔ȂׁA<see cref="TbSelectedIndexChanged"/>ƕėpĂB
        /// sender<see cref="ITbPageControl"/>CX^XłB</summary>
        public event ITbDisplayEventHandler TbDisplayUrlChanged;
        /// <summary>̃Rg[\Ă^Cg̒lύXꂽɔ܂B
        /// ^u̐؂ւɂ͔ȂׁA<see cref="TbSelectedIndexChanged"/>ƕėpĂB
        /// sender<see cref="ITbPageControl"/>CX^XłB</summary>
        public event ITbDisplayEventHandler TbDisplayTitleChanged;
        /// <summary>̃Rg[\ĂXe[^XeLXg̒lύXꂽɔ܂B
        /// ^u̐؂ւɂ͔ȂׁA<see cref="TbSelectedIndexChanged"/>ƕėpĂB
        /// sender<see cref="ITbPageControl"/>CX^XłB</summary>
        public event ITbDisplayEventHandler TbDisplayStatusTextChanged;

        /// <summary>ǉ̏̃NX̃zXgRg[ɓ`B܂B
        /// sender͂̃NX̃CX^XłB</summary>
        public event EventHandler<TbCallCommandEventArgs> TbCallCommand;

        /// <summary>Nɑ΂ēȃ|bvAbvj[\悤Ƃۂɔ܂B
        /// sender<see cref="WebBrowserAx"/>NX̃CX^XłB</summary>
        public event AnchorMenuPopupEventHandler TbAnchorMenuPopup;

        #endregion

        #region +--  Event Triggers

        /// <summary><see cref="MovieDownloadRequired"/>Cxg𔭐܂B</summary>
        /// <seealso cref="MovieDownloadRequired"/>
        protected void OnMovieDownloadRequired(object sender, MovieDownloadRequiredEventArgs e)
        {
            if (this.MovieDownloadRequired != null)
            {
                this.MovieDownloadRequired(sender, e);
            }
        }
        /// <summary><see cref="TbSelectedIndexChanged"/>Cxg𔭐܂B</summary>
        /// <seealso cref="TbSelectedIndexChanged"/>
        protected void OnSelectedIndexChanged(object sender, EventArgs e)
        {
            if (this.TbSelectedIndexChanged != null)
            {
                this.TbSelectedIndexChanged(sender, e);
            }
        }
        /// <summary><see cref="TbTabCountChanged"/>Cxg𔭐܂B</summary>
        /// <seealso cref="TbTabCountChanged"/>
        protected void OnTabCountChanged(object sender, EventArgs e)
        {
            this.adjust_size();
            if (this.TbTabCountChanged != null)
            {
                this.TbTabCountChanged(sender, e);
            }
        }

        /// <summary><see cref="TbBeforeNewTab"/>Cxg𔭐܂B</summary>
        /// <seealso cref="TbBeforeNewTab"/>
        protected void OnBeforeNewTab(object sender, WebBrowserBeforeNewWindowEventArgs e)
        {
            if (this.TbBeforeNewTab != null)
            {
                this.TbBeforeNewTab(sender, e);
            }
        }
        /// <summary><see cref="TbBeforeNavigate"/>Cxg𔭐܂B</summary>
        /// <seealso cref="TbBeforeNavigate"/>
        protected void OnBeforeNavigate(object sender, WebBrowserBeforeNavigateEventArgs e)
        {
            if (this.TbBeforeNavigate != null)
            {
                this.TbBeforeNavigate(sender, e);
            }
        }
        /// <summary><see cref="TbNavigated"/>Cxg𔭐܂B</summary>
        /// <seealso cref="TbNavigated"/>
        protected void OnNavigated(object sender, WebBrowserNavigatedEventArgs e)
        {
            if (this.TbNavigated != null)
            {
                this.TbNavigated(sender, e);
            }
        }
        /// <summary><see cref="TbProgressChanged"/>Cxg𔭐܂B</summary>
        /// <seealso cref="TbProgressChanged"/>
        protected void OnProgressChanged(object sender, WebBrowserProgressChangedEventArgs e)
        {
            if (this.TbProgressChanged != null)
            {
                this.TbProgressChanged(sender, e);
            }
        }
        /// <summary><see cref="TbDownloadCompleted"/>Cxg𔭐܂B</summary>
        /// <seealso cref="TbDownloadCompleted"/>
        protected void OnDownloadCompleted(object sender, EventArgs e)
        {
            if (this.TbDownloadCompleted != null)
            {
                this.TbDownloadCompleted(sender, e);
            }
        }
        /// <summary><see cref="TbDocumentCompleted"/>Cxg𔭐܂B</summary>
        /// <seealso cref="TbDocumentCompleted"/>
        protected void OnDocumentCompleted(object sender, WebBrowserDocumentCompletedEventArgs e)
        {
            if (this.TbDocumentCompleted != null)
            {
                this.TbDocumentCompleted(sender, e);
            }
        }
        /// <summary><see cref="TbNavigateError"/>Cxg𔭐܂B</summary>
        /// <seealso cref="TbNavigateError"/>
        protected void OnNavigateError(object sender, WebBrowserNavigateErrorEventArgs e)
        {
            if (this.TbNavigateError != null)
            {
                this.TbNavigateError(sender, e);
            }
        }
        /// <summary><see cref="TbCanGoBackChanged"/>Cxg𔭐܂B</summary>
        /// <seealso cref="TbCanGoBackChanged"/>
        protected void OnCanGoBackChanged(object sender, EventArgs e)
        {
            if (this.TbCanGoBackChanged != null)
            {
                this.TbCanGoBackChanged(sender, e);
            }
        }
        /// <summary><see cref="TbCanGoForwardChanged"/>Cxg𔭐܂B</summary>
        /// <seealso cref="TbCanGoForwardChanged"/>
        protected void OnCanGoForwardChanged(object sender, EventArgs e)
        {
            if (this.TbCanGoForwardChanged != null)
            {
                this.TbCanGoForwardChanged(sender, e);
            }
        }

        /// <summary><see cref="TbDisplayUrlChanged"/>Cxg𔭐܂B</summary>
        /// <seealso cref="TbDisplayUrlChanged"/>
        protected void OnDisplayUrlChanged(ITbPageControl sender, ITbDisplayEventArgs e)
        {
            if (this.TbDisplayUrlChanged != null)
            {
                this.TbDisplayUrlChanged(sender, e);
            }
        }
        /// <summary><see cref="TbDisplayTitleChanged"/>Cxg𔭐܂B</summary>
        /// <seealso cref="TbDisplayTitleChanged"/>
        protected void OnDisplayTitleChanged(ITbPageControl sender, ITbDisplayEventArgs e)
        {
            if (this.TbDisplayTitleChanged != null)
            {
                this.TbDisplayTitleChanged(sender, e);
            }
        }
        /// <summary><see cref="TbDisplayStatusTextChanged"/>Cxg𔭐܂B</summary>
        /// <seealso cref="TbDisplayStatusTextChanged"/>
        protected void OnDisplayStatusTextChanged(ITbPageControl sender, ITbDisplayEventArgs e)
        {
            if (this.TbDisplayStatusTextChanged != null)
            {
                this.TbDisplayStatusTextChanged(sender, e);
            }
        }
        /// <summary><see cref="TbCallCommand"/>Cxg𔭐܂B</summary>
        /// <seealso cref="TbCallCommand"/>
        protected void OnCallCommand(object sender, TbCallCommandEventArgs e)
        {
            if (this.TbCallCommand != null)
            {
                this.TbCallCommand(sender, e);
            }
        }

        protected void OnAnchorMenuPopup(object sender, AnchorMenuPopupEventArgs e)
        {
            if (this.TbAnchorMenuPopup != null)
            {
                this.TbAnchorMenuPopup(sender, e);
            }
        }

        #endregion

        #endregion


        #region Page Accessor (Public)

        #region +--  Access to Pages

        /// <summary>ݑIĂ^ũCfbNX擾Eݒ肵܂B
        /// I̒l-1łB</summary>
        public int TbSelectedIndex
        {
            get { return this._tab.SelectedIndex; }
            set { this._tab.SelectedIndex = value; }
        }

        /// <summary>݂̃^u擾܂B</summary>
        public int TbTabCount
        {
            get { return this._tab.TabCount; }
        }

        /// <summary>ݑIĂy[WɃANZXC^[tF[X擾܂B
        /// I̒lnullłB</summary>
        /// <seealso cref="ITbPageControl"/>
        public ITbPageControl TbSelectedControl
        {
            get
            {
                if (this.InRange(this.TbSelectedIndex)) { return this._pages[this.TbSelectedIndex]; }
                else { return null; }
            }
        }

        /// <summary>ݑIĂuEU擾܂B
        /// IEuEUȊOIĂꍇ̒lnullłB</summary>
        /// <seealso cref="WebBrowserAx"/>
        public WebBrowserAx TbSelectedBrowser
        {
            get
            {
                if (this.InRange(this.TbSelectedIndex)) { return this._pages[this.TbSelectedIndex].AsBrowser; }
                else { return null; }
            }
        }

        /// <summary>w肵CfbNXɂy[WɃANZX邽߂̃C^[tF[X擾܂B
        /// ͈͊ÕCfbNXw肵̒lnullłB</summary>
        /// <param name="index">擾y[W̃CfbNX</param>
        /// <returns>y[W<see cref="ITbPageControl"/>C^[tF[X</returns>
        /// <seealso cref="ITbPageControl"/>
        public ITbPageControl TbGetControl(int index)
        {
            if (this.InRange(index)) { return this._pages[index]; }
            else { return null; };
        }

        /// <summary>w肵CfbNXɂuEU擾܂B
        /// CfbNX͈͊OA̓y[WuEUłȂꍇ̒lnullłB</summary>
        /// <param name="index">擾uEŨCfbNX</param>
        /// <returns>擾uEUIuWFNgBnull</returns>
        /// <seealso cref="WebBrowserAx"/>
        public WebBrowserAx TbGetBrowser(int index)
        {
            if (this.InRange(index)) { return this._pages[index].AsBrowser; }
            else { return null; }
        }

        /// <summary>ݑIĂy[WuEUł邩ǂ擾܂B</summary>
        /// <seealso cref="TbIsBrowser"/>
        public bool TbSelectedIsBrowser
        {
            get
            {
                if (this.InRange(this.TbSelectedIndex))
                {
                    return this.TbSelectedControl.IsWebBrowser;
                }
                else { return false; }
            }
        }

        /// <summary>w肳ꂽCfbNX̃y[WuEUł邩ǂԂ܂B
        /// sȃCfbNX̏ꍇ͏falseԂ܂B</summary>
        /// <param name="index">y[W̃CfbNX</param>
        /// <returns>uEUłTrue</returns>
        /// <seealso cref="TbSelectedIsBrowser"/>
        public bool TbIsBrowser(int index)
        {
            if (this.InRange(index))
            {
                return this._pages[index].IsWebBrowser;
            }
            else { return false; }
        }

        /// <summary>̃NX̃CxgŎ󂯎senderIuWFNgAΉCfbNXl擾܂B</summary>
        /// <param name="sender"><see cref="ITbPageControl"/>IuWFNgB</param>
        /// <returns>l̃CfbNX</returns>
        public int TbGetIndexByEventSender(ITbPageControl sender)
        {
            return this._pages.IndexOf(sender);
        }

        /// <summary>w肵^ü̗\Rectangle擾܂B
        /// CfbNXȌꍇ͗O܂B</summary>
        /// <param name="index">Ώۂ̃^ũCfbNX</param>
        /// <returns>^uRectangleBAAClientWn</returns>
        /// <seealso cref="System.Windows.Forms.TabControl.GetTabRect"/>
        public Rectangle TbGetTabRect(int index)
        {
            return this._tab.GetTabRect(index);
        }

        /// <summary>CfbNXly[WRNV͈͓̔ł邩ǂ𒲂ׂ܂B</summary>
        /// <param name="index">ׂCfbNXl</param>
        /// <returns>͈͓łtrue</returns>
        public bool InRange(int index)
        {
            return (0 <= index) && (index < this.TbTabCount);
        }

        #endregion

        #region +--  Controls of Pages

        /// <summary><see cref="ITbPageControl"/>J<see cref="System.Windows.Forms.Control"/>gpāAV^uɊJ܂B</summary>
        /// <param name="control">ITbPageControlJSystem.Windows.Forms.Control</param>
        /// <param name="index">}CfbNX</param>
        /// <returns>ꍇtrue</returns>
        /// <seealso cref="ITbPageControl"/>
        public bool TbOpenNewTab(ITbPageControl control, int index)
        {
            bool res = false;
            if (control is Control)
            {
                try { this.addPageControl(control, index); res = true; }
                catch (Exception e) { InnerLogger.LOut(e.Message, InnerLogger.ErrorLevel.L2_WARNING); }
            }
            else
            {
                InnerLogger.LOut("nꂽIuWFNg͗LSystem.Windows.Forms.Controlł͂܂B", InnerLogger.ErrorLevel.L0_CRITICAL);
            }
            return res;
        }

        /// <summary>V^uŃuEUJ܂B</summary>
        /// <param name="url">uEUJURL</param>
        /// <returns>true</returns>
        public bool TbOpenNewTab(string url)
        {
            return this.TbOpenNewTab(url, this.TbTabCount, true);
        }

        /// <summary>V^uŃuEUJ܂B</summary>
        /// <param name="url">uEUJURL</param>
        /// <param name="index">VJ^uindex</param>
        /// <param name="focus">̃^uIꍇtrue</param>
        /// <returns>true</returns>
        public bool TbOpenNewTab(string url, int index, bool focus)
        {
            bool res = false;
            if (url.StartsWith("javascript:"))
            {
                MessageBox.Show("javascript̃XL[gpĐV^uJƂ܂B\ñNł͖̂̑łB", "V^uJ", MessageBoxButtons.OK, MessageBoxIcon.Error, MessageBoxDefaultButton.Button1);
                return res;
            }
            WebBrowserAx browser = this.create_browser();
            if (browser != null)
            {
                try
                {
                    this.addPageControl(browser as ITbPageControl, index);
                    res = true;
                }
                catch (Exception e) { InnerLogger.LOut(e.Message, InnerLogger.ErrorLevel.L2_WARNING); }

                if (!url.Equals("about:blank", StringComparison.OrdinalIgnoreCase))
                {
                    DelayedRedirectAction action = new DelayedRedirectAction(url);
                    if (action != null) { browser.RegisterDelayedAction(action, NavigateState.DocumentCompleted); }
                    browser.Navigate("about:blank");
                }
                else { browser.Navigate(url); }
            }
            else { MessageBox.Show("pł^ȕɒB܂B", Application.ProductName); }
            return res;
        }

        /// <summary>w肵^u܂B</summary>
        /// <param name="index">^ũCfbNX</param>
        /// <exception cref="ArgumentOutOfRangeException">w肳ꂽCfbNX͈͊ÔƂɔ܂B</exception>
        public void TbClose(int index)
        {
            this.TbClose(index, false);
        }

        /// <summary>w肵CfbNXʒũ^u܂B</summary>
        /// <param name="index">^ũCfbNX</param>
        /// <param name="ignoreLock">bNꂽ^ułꍇtrue</param>
        /// <exception cref="ArgumentOutOfRangeException">w肳ꂽCfbNX͈͊ÔƂɔ܂B</exception>
        public void TbClose(int index, bool ignoreLock)
        {
            if (this.InRange(index))
            {
                bool locked = this.getIsLocked(index);
                if (ignoreLock || this.get_canCloseTab(index))
                {
                    this.act_before_close(index);
                    ITbPageControl page = this.remPageControl(index);
                    string url = page.DisplayUrl;
                    string title = page.DisplayTitle;
                    if (page.IsWebBrowser)
                    {
                        if (url != null && url.Length != 0)
                        {
                            this.set_closedTabHistory(page.AsBrowser, false, locked);
                        }
                    }
                    page.ReleaseControl();
                }
            }
            else { throw new IndexOutOfRangeException("nꂽl̓RNV̗LȃCfbNXł͂܂"); }
        }

        /// <summary><para>w肵y[WvfɑΉĂ^u܂B</para>
        /// ̃IuWFNg̃y[WRNVɈœnꂽy[W݂Ȃꍇ͖܂B</summary>
        /// <param name="page">폜y[W</param>
        public void TbClose(ITbPageControl page)
        {
            int index = this._pages.IndexOf(page);
            if (index >= 0)
            {
                this.TbClose(index);
            }
            else
            {
                throw new ArgumentException("̃IuWFNg̓Rg[ɑ݂܂");
            }
        }

        /// <summary>ׂẴ^u܂B鑀삪oȂԂ̃^u͖܂B</summary>
        /// <seealso cref="TbClose"/>
        public void TbClear()
        {
            this.TbClear(false);
        }

        /// <summary>ׂẴ^u܂B^ubNĂ̓wł܂B</summary>
        /// <param name="ignoreLock">bNꂽ^uꍇtrue</param>
        public void TbClear(bool ignoreLock)
        {
            for (int i = 0; i < this.TbTabCount; ++i)
            {
                this.TbClose(i, ignoreLock);
            }
        }

        /// <summary>w肵^ũCfbNXύX܂B</summary>
        /// <param name="source">ʒuύX^ũCfbNXl</param>
        /// <param name="tgt">ύX̃^ũCfbNXl</param>
        /// <exception cref="System.IndexOutOfRangeException">̒l͈͊ÔƂɔ܂</exception>
        public void TbChangeIndex(int source, int tgt)
        {
            if (this.InRange(source) && this.InRange(tgt))
            {
                this.movPageControl(source, tgt);
            }
        }

        #endregion

        #endregion


        #region Browsing Navigation Methods / Property (Public)

        /// <summary><para>\̃^uŐVURLɈړ܂B
        /// Iꂽ^uA̓irQ[gȂ^ułꍇ͎ŐV^uJ܂B</para>
        /// sURLnꂽꍇ̓<see cref="InnerLogger.ErrorLevel.L3_ALART"/>łB</summary>
        /// <param name="url">ړURL</param>
        public void TbNavigate(string url)
        {
            Uri u = null;
            if (Uri.TryCreate(url, UriKind.Absolute, out u)) { this.TbNavigate(u); }
            else
            {
                InnerLogger.LOut("URL`sł", InnerLogger.ErrorLevel.L3_ALART);
            }
        }

        /// <summary><para>\̃^uŐVURLɈړ܂B
        /// Iꂽ^uA̓irQ[gȂ^ułꍇ͎ŐV^uJ܂B</para></summary>
        /// <param name="url">ړURL</param>
        public void TbNavigate(Uri url)
        {
            this.TbNavigate(url, true);
        }

        /// <summary><para>\̃^uŐVURLɈړ܂B
        /// Iꂽ^uA̓irQ[gȂ^ułꍇ͎ŐV^uJ܂B</para>
        /// </summary>
        /// <param name="url">ړURL</param>
        /// <param name="focusOn">V^uJꂽꍇɁÃ^uIꍇtrue</param>
        public void TbNavigate(Uri url, bool focusOn)
        {
            ITbPageControl page = this.TbSelectedControl;
            if (page != null)
            {
                if (!page.Navigate(url.AbsoluteUri))
                {
                    this.TbOpenNewTab(url.AbsoluteUri);
                }
            }
            else
            {
                this.TbOpenNewTab(url.AbsoluteUri, this.TbSelectedIndex + 1, true);
            }
        }

        /// <summary>w肳ꂽURLOuEUɓn܂B</summary>
        /// <param name="url">OuEUɓnURL</param>
        public void TbNavigateExternal(string url)
        {
            Uri u = null;
            if (Uri.TryCreate(url, UriKind.Absolute, out u))
            {
                try
                {
                    if (String.IsNullOrEmpty(this.Setting.BrowserPath)) { Process.Start(u.AbsoluteUri); }
                    else
                    {
                        if (System.IO.File.Exists(this.Setting.BrowserPath))
                        {
                            ProcessStartInfo psi = new ProcessStartInfo();
                            psi.FileName = this.Setting.BrowserPath;
                            psi.Arguments = u.AbsoluteUri;
                            Process.Start(psi);
                        }
                        else
                        {
                            MessageBox.Show("ݒ肳ꂽʒuɂ͊OuEUł܂łB\n"
                                         + "pXł邱ƂmF邩AݒɂĂB", Application.ProductName);
                        }
                    }
                }
                catch (Exception e) { InnerLogger.LOut(String.Format("Exception:{0}", e.Message), InnerLogger.ErrorLevel.L2_WARNING); }
            }
        }

        /// <summary><para>\̃uEUŕ\̃y[Wēǂݍ݂܂B</para>
        /// ̎_ŗLȑŖꍇ͖܂B</summary>
        public void TbRefresh()
        {
            this.TbRefresh(this.TbSelectedIndex);
        }

        /// <summary><para>w肵uEUŕ\̃y[Wēǂݍ݂܂B</para>
        /// ̎_ŗLȑŖꍇ͖܂B</summary>
        /// <param name="index">ēǂݍ݂suEŨCfbNX</param>
        public void TbRefresh(int index)
        {
            if (this.TbIsBrowser(index))
            {
                if (!this.getIsLocked(index)) // Not Locked
                {
                    this.TbGetBrowser(index).Refresh();
                }
                else if ((this.Setting.LockedTabBehavior & LockedTabBehaviors.ReloadOnNew) == LockedTabBehaviors.ReloadOnNew)
                {
                    // Locked & Reload on new
                    this.TbOpenNewTab(this.TbGetBrowser(index).Url, index + 1, false);
                }
                else
                {
                    this.setIsLocked(index, false);
                    this.TbGetBrowser(index).Refresh();
                    this.setIsLocked(index, true);
                }
            }
        }

        /// <summary>ׂẴuEUōēǂݍ݂s܂B
        /// bNꂽ^û݂w肷邱Ƃo܂B</summary>
        /// <param name="lockedTabOnly">bNꂽ^û݂ōēǂݍ݂ꍇtrue</param>
        public void TbRefreshAll(bool lockedTabOnly)
        {
            for (int i = 0; i < this.TbTabCount; ++i)
            {
                if (!lockedTabOnly || this.TbGetIsLocked(i))
                {
                    this.TbRefresh(i);
                }
            }
        }

        /// <summary><para>\̃uEUŕۗ̃irQ[VLZA
        /// Aj[VȂǂ̓Iȃy[Wvf𒆒f܂B</para>
        /// ̎_ŗLȑŖꍇ͖܂B</summary>
        public void TbStop()
        {
            this.TbStop(this.TbSelectedIndex);
        }

        /// <summary><para>w肵uEUŕۗ̃irQ[VLZA
        /// Aj[VȂǂ̓Iȃy[Wvf𒆒f܂B</para>
        /// ̎_ŗLȑŖꍇ͖܂B</summary>
        /// <param name="index">Ώۂ̃uEŨCfbNX</param>
        public void TbStop(int index)
        {
            if (this.TbIsBrowser(index))
            {
                this.TbGetBrowser(index).Stop();
            }
        }

        /// <summary>ׂẴuEUɑ΂āAۗ̃irQ[VLZAAj[VȂǂ̓Iȃy[Wvf𒆒f܂B</summary>
        /// <seealso cref="TbStop"/>
        public void TbStopAll()
        {
            foreach (WebBrowserAx browser in this._pages)
            {
                browser.Stop();
            }
        }

        /// <summary>\̃uEUŁAu߂vs܂B̎_Ŗȑłꍇ͖܂B</summary>
        /// <seealso cref="TbGoForward"/>
        /// <seealso cref="TbCanGoBack"/>
        public void TbGoBack()
        {
            if (this.TbCanGoBack)
                this.TbSelectedBrowser.GoBack();
        }

        /// <summary>\̃uEUŁAuiށvs܂B̎_Ŗȑłꍇ͖܂B</summary>
        /// <seealso cref="TbGoBack"/>
        /// <seealso cref="TbCanGoForward"/>
        public void TbGoForward()
        {
            if (this.TbCanGoForward)
                this.TbSelectedBrowser.GoForward();
        }

        /// <summary>\̃uEUŁu߂v삪\ǂ擾܂B
        /// uEUIĂȂꍇ͏falseԂ܂B</summary>
        /// <seealso cref="TbCanGoForward"/>
        public bool TbCanGoBack
        {
            get
            {
                if (this.TbSelectedIsBrowser)
                {
                    return this.TbSelectedBrowser.CanGoBack;
                }
                return false;
            }
        }

        /// <summary>\̃uEUŁuiށv삪\ǂ擾܂B
        /// uEUIĂȂꍇ͏falseԂ܂B</summary>
        /// <seealso cref="TbCanGoBack"/>
        public bool TbCanGoForward
        {
            get
            {
                if (this.TbSelectedIsBrowser) { return this.TbSelectedBrowser.CanGoForward; }
                return false;
            }
        }

        #endregion


        #region Other Properties (Public)

        /// <summary>NɊJ^uw肵܂B
        /// ̃\bh́AKzXgtH[Load^C~Oȍ~ŌĂяoĂB</summary>
        /// <param name="flags">^u̎ނ\<see cref="RestoreClosedTabFlags"/></param>
        public void RestoreTabsOnStartup(RestoreClosedTabFlags flags)
        {
            if ((flags & RestoreClosedTabFlags.OnExit) == RestoreClosedTabFlags.OnExit)
            {
                int index = 0;
                bool onlylocked = (flags & RestoreClosedTabFlags.OnlyLocked) == RestoreClosedTabFlags.OnlyLocked;
                bool restoreTravelLog = (flags & RestoreClosedTabFlags.NoNavigateHistory) == RestoreClosedTabFlags.NoNavigateHistory;

                this.SuspendLayout();
                try
                {
                    while (index < this._closedTabHistory.Count)
                    {
                        if (this._closedTabHistory[index].ClosedOnExit)
                        {
                            if (onlylocked && !this._closedTabHistory[index].LockedTab)
                            {
                                ++index; // Do nothing and go next, when Tab was not locked & OpenLockedOnly.
                            }
                            else
                            {
                                if (restoreTravelLog)
                                {
                                    this.TbOpenNewTab(this._closedTabHistory[index].Url, 0, false);// Restore travel log.
                                }
                                else
                                {
                                    this.TbOpenNewTab(this._closedTabHistory[index], 0, false);// Don't restore travel log.
                                }
                                this._closedTabHistory.RemoveAt(index);
                            }
                        }
                        else { break; }
                    }
                }
                catch { }
                finally { this.ResumeLayout(true); }
            }
        }

        /// <summary>̃\bh́ÃRg[鎞ɌĂяoĂB
        /// ׂẴ^uAIs܂B</summary>
        public void TbHostApplicationExit()
        {
            int index = 0;
            foreach (ClosedTabData data in this._closedTabHistory)
            {
                data.ClosedOnExit = false;
            }
            while (index < this.TbTabCount)
            {
                this.TbCloseOnExit(index);
            }
        }

        /// <summary>̃IuWFNg̐ݒXV܂B
        /// nꂽ<see cref="TabBrowserSetting"/>IuWFNg͎SealedԂɂȂ܂B</summary>
        /// <seealso cref="TabBrowserSetting"/>
        public void SetSetting(TabBrowserSetting setting)
        {
            lock (this._sync)
            {
                if (!setting.IsSealed) { setting.SealInstance(); }
                this._setting = setting;
                this.attach_settings();
            }
        }

        /// <summary>̃IuWFNg̐ݒ擾܂B</summary>
        /// <seealso cref="TabBrowserSetting"/>
        public TabBrowserSetting Setting
        {
            get { lock (this._sync) { return this._setting; } }
        }

        /// <summary>\̃y[WURL擾܂B
        /// ȏꍇ<see cref="System.String.Empty"/>Ԃ܂B</summary>
        public string TbUrl
        {
            get
            {
                if (this.TbSelectedIndex >= 0)
                    return this.TbSelectedControl.DisplayUrl;
                else
                    return String.Empty;
            }
        }

        /// <summary><para>\̃y[W̃^Cg擾܂B
        /// ȏꍇ<see cref="System.String.Empty"/>Ԃ܂B</para>
        /// 擾^CǵAy[W̕ҏWÕ^CgɂȂ܂B
        /// ^uɕ\Ă^Cg擾ꍇ<see cref="TbGetTitle"/>gp܂B</summary>
        /// <seealso cref="TbGetTitle"/>
        /// <seealso cref="TbGetTabTitle"/>
        /// <seealso cref="TabBrowserSetting.EnableEditTitle"/>
        /// <seealso cref="TabBrowserSetting.EditTitle_MatchPattern"/>
        /// <seealso cref="TabBrowserSetting.EditTitle_ReplacePattern"/>
        public string TbTitle
        {
            get
            {
                if (this.TbSelectedIndex >= 0)
                    return this.TbSelectedControl.DisplayTitle;
                else
                    return String.Empty;
            }
        }

        /// <summary>\̃y[W̃Xe[^XeLXg擾܂B
        /// ȏꍇ<see cref="System.String.Empty"/>Ԃ܂B</summary>
        public string TbStatusText
        {
            get
            {
                if (this.TbSelectedIndex >= 0)
                    return this.TbSelectedControl.DisplayStatusText;
                else
                    return String.Empty;
            }
        }

        /// <summary><para>w肵CfbNX̃y[W̃^Cg擾܂B
        /// ȏꍇ<see cref="System.String.Empty"/>Ԃ܂B</para>
        /// 擾^CǵAҏWÕy[W̃^CgɂȂ܂B
        /// ^uɕ\Ă^Cg擾ꍇ<see cref="TbGetTitle"/>gp܂B</summary>
        /// <param name="index">擾y[Wvf̃CfbNXl</param>
        /// <returns>̃y[W^Cg</returns>
        /// <seealso cref="TbTitle"/>
        /// <seealso cref="TbGetTabTitle"/>
        /// <seealso cref="TabBrowserSetting.EnableEditTitle"/>
        /// <seealso cref="TabBrowserSetting.EditTitle_MatchPattern"/>
        /// <seealso cref="TabBrowserSetting.EditTitle_ReplacePattern"/>
        public string TbGetTitle(int index)
        {
            if (this.InRange(index))
            {
                return this.TbGetControl(index).DisplayTitle;
            }
            else return String.Empty;
        }

        /// <summary><para>w肵CfbNX̃^uŕ\̃^Cg擾܂B
        /// \^Cg̕ҏWLȏꍇA̒l͕ҏWO̒lłB
        /// ȏꍇ<see cref="System.String.Empty"/>Ԃ܂B</para></summary>
        /// <param name="index">擾y[Wvf̃CfbNXl</param>
        /// <returns>̃y[W^Cg</returns>
        public string TbGetTabTitle(int index)
        {
            if (this.InRange(index))
            {
                return this._tab.TabPages[index].Text;
            }
            else return String.Empty;
        }

        /// <summary>\̃uEŨirQ[gǗIuWFNgւ̎QƂ擾܂B
        /// ȏꍇnullԂ܂B</summary>
        /// <seealso cref="ExHtmlHistory"/>
        public ExHtmlHistory TbNavigateHistory
        {
            get
            {
                WebBrowserAx b = this.TbSelectedBrowser;
                return b != null ? b.History : null;
            }
        }

        /// <summary>ׂẴuEU<see cref="WebBrowserAx.Silent"/>擾Eݒ肵܂B</summary>
        /// <see cref="WebBrowserAx.Silent"/>
        public bool TbSilentMode
        {
            get { return this._silentmode; }
            set
            {
                this._silentmode = value;
                foreach (WebBrowserAx browser in this._pages)
                {
                    browser.Silent = this._silentmode;
                }
            }
        }

        /// <summary>NbNɂĊJꂽReLXgj[̃^[Qbg擾܂B
        /// ʏAOANZXKv͂܂B</summary>
        public int TbContextMenuTargetIndex
        {
            get { return this._frg_tabTarget; }
        }

        /// <summary>w肵^ũbNԂ擾܂B</summary>
        /// <param name="index">Ώۂ̃^ũCfbNX</param>
        /// <returns>bNĂtrue</returns>
        /// <exception cref="IndexOutOfRangeException">nꂽCfbNX͈͊ÔƂɔ܂B</exception>
        /// <seealso cref="TbSetIsLocked"/>
        /// <seealso cref="TabBrowserSetting.LockedTabBehavior"/>
        public bool TbGetIsLocked(int index)
        {
            return this.getIsLocked(index);
        }

        /// <summary>w肵^ũbNԂݒ肵܂B</summary>
        /// <param name="index">Ώۂ̃^ũCfbNX</param>
        /// <param name="locktab">Vw肷郍bN</param>
        /// <returns>bNĂtrue</returns>
        /// <exception cref="IndexOutOfRangeException">nꂽCfbNX͈͊ÔƂɔ܂B</exception>
        /// <seealso cref="TbSetIsLocked"/>
        /// <seealso cref="TabBrowserSetting.LockedTabBehavior"/>
        public void TbSetIsLocked(int index, bool locktab)
        {
            this.setIsLocked(index, locktab);
            this._tab.Invalidate();
        }

        /// <summary>\̃uEŨirQ[g|bvAbvj[ŕ\܂B
        /// ̑삪ȏꍇ͉N܂B</summary>
        /// <param name="screenPos">j[\XN[W</param>
        /// <param name="isGoBack">߂ɕ\ꍇtrueAiޕ̏ꍇfalse</param>
        public void TbShowNavigateHistory(Point screenPos, bool isGoBack)
        {
            if (isGoBack ? this.TbCanGoBack : this.TbCanGoForward)
            {
                this.TbSelectedBrowser.ShowNavigateHistory(screenPos, isGoBack);
            }
        }

        /// <summary>HTMLhLgGfB^<see cref="Alternative.Functions.IHtmlDocumentEditor"/>̋@\IɎs܂B
        /// _E[hȏԂŃGfB^sꍇɎgp܂B</summary>
        public void TbInvokeDocumentEditor()
        {
            WebBrowserAx browser = this.TbSelectedBrowser;
            try
            {
                if (browser != null)
                {
                    this.call_HtmlDocumentEditor(this.TbUrl, HtmlEditTrigger.UserRequested, browser);
                }
            }
            catch (Exception e) { Trace.WriteLine(e); }
        }

        #endregion


        #region ********  Inner Methods  *********

        /// <summary><see cref="CloseTabData"/>̏ɐV^uJ܂B</summary>
        /// <param name="data">Jy[W̏i[<see cref="CloseTabData"/></param>
        /// <param name="index">^uJʒu</param>
        /// <param name="focus">J^uIꍇtrue</param>
        /// <returns>ȂJꂽꍇtrueԂ܂B</returns>
        private bool TbOpenNewTab(ClosedTabData data, int index, bool focus)
        {
            bool res = false;
            int max = this.Setting.MaxHistoryTrace;
            WebBrowserAx browser = this.create_browser();
            if (browser != null)
            {
                try
                {
                    this.addPageControl(browser as ITbPageControl, index);
                    DelayedAction action = new RestoreWindowDelayedAction(data, max);
                    browser.RegisterDelayedAction(action, NavigateState.DocumentCompleted);
                    browser.Navigate(RestoreWindowDelayedAction.RestoreFirstNavigateUrl);
                    res = true;
                }
                catch (Exception e)
                {
                    InnerLogger.LOut(e.Message, InnerLogger.ErrorLevel.L2_WARNING);
                    browser.Dispose();
                    res = false;
                }
            }
            else { MessageBox.Show("pł^ȕɒB܂B", Application.ProductName); }
            return res;
        }

        /// <summary>AvP[V̏IɃ^uׂɗpӂĂA<see cref="TbClose"/>̓ʔłłB</summary>
        /// <param name="index">^ũCfbNX</param>
        private void TbCloseOnExit(int index)
        {
            if (this.InRange(index))
            {
                bool locked = this.getIsLocked(index);
                ITbPageControl page = this.remPageControl(index);
                string url = page.DisplayUrl;
                string title = page.DisplayTitle;
                if (page.IsWebBrowser)
                {
                    if (url != null && url.Length != 0)
                    {
                        this.set_closedTabHistory(page.AsBrowser, true, locked);
                    }
                }
                page.ReleaseControl();
            }
            else { throw new IndexOutOfRangeException("nꂽl̓RNV̗LȃCfbNXł͂܂"); }
        }


        #region +--  Add / Remove Page

        /// <summary><see cref="ITbPageControl"/><see cref="System.Windows.Forms.Control"/>ɑO{ăy[WXgɒǉ܂B</summary>
        /// <param name="control">ǉ<see cref="System.Windows.Forms.Control"/>pA<see cref="ITbPageControl"/>IuWFNg</param>
        private void addPageControl(ITbPageControl control)
        {
            this.addPageControl(control, this.TbSelectedIndex + 1);
        }

        /// <summary><see cref="ITbPageControl"/><see cref="System.Windows.Forms.Control"/>ɑO{ăy[WXgɒǉ܂B</summary>
        /// <param name="control">ǉ<see cref="System.Windows.Forms.Control"/>pA<see cref="ITbPageControl"/>IuWFNg</param>
        /// <param name="index">ǉCfbNXʒu</param>
        private void addPageControl(ITbPageControl control, int index)
        {
            if (control == null)
            {
                throw new ArgumentNullException("nullɂ邱Ƃ͏o܂B", "control");
            }
            else if (this.TbTabCount >= this.Setting.MaxTabCount)
            {
                InnerLogger.LOut("Lȃ^ȕ𒴂鐔̃^uJƂ͏o܂", InnerLogger.ErrorLevel.L1_ERROR);
            }
            else
            {
                TabPage tp = new TabPage(control.DisplayTitle);
                Control cnt = control.AsControl;
                if (!this._pages.Contains(control))
                {
                    tp.Tag = cnt;
                    cnt.Visible = false;
                    lock (this._pages)
                    {
                        this._tab.TabPages.Insert(index, tp);
                        this._screen.Controls.Add(cnt);
                        this._pages.Insert(index, control);
                    }
                    this.set_visible(this.TbSelectedIndex);
                    tp = null;
                    cnt = null;
                    this.OnTabCountChanged(this, new EventArgs());
                }
                else { throw new ArgumentException("͊ɃRNVɊ܂܂Ă܂", "control"); }
            }
        }

        /// <summary>y[WRNVw肵CfbNX<see cref="ITbPageControl"/>菜܂B</summary>
        /// <param name="index">RNV菜y[W̃CfbNX</param>
        /// <returns>RNV菜ꂽ<see cref="ITbPageControl"/></returns>
        /// <exception cref="IndexOutOfRangeException">RNV͈̔͊O̒lnꂽꍇɔ܂B</exception>
        /// <exception cref="TeContradictionException">Ń^uƃy[W̑Ήꂽꍇɔ܂B</exception>
        private ITbPageControl remPageControl(int index)
        {
            ITbPageControl page = this._pages[index];
            TabPage tp = this._tab.TabPages[index];
            Control cnt = page.AsControl;
            if (index < this._tab.TabCount)
            {
                if (tp.Tag.Equals(cnt) && this._screen.Controls.Contains(cnt))
                {
                    lock (this._pages)
                    {
                        this._screen.Controls.Remove(cnt);
                        this._pages.Remove(page);
                        this._tab.TabPages.Remove(tp);
                    }
                    tp.Tag = null;
                    tp.Dispose();
                    this.OnTabCountChanged(this, new EventArgs());
                }
                else { throw new TeContradictionException(); }
            }
            tp = null;
            cnt = null;
            return page;
        }

        /// <summary>w肵^ũCfbNXlύX܂BύX͐VCfbNXʒuւ̑}ɂčs܂B</summary>
        /// <param name="fromIndex">ύX^ũCfbNX</param>
        /// <param name="newIndex">^u̐VCfbNX</param>
        /// <exception cref="IndexOutOfRangeException">RNV͈̔͊O̒lnꂽꍇɔ܂B</exception>
        private void movPageControl(int fromIndex, int newIndex)
        {
            ITbPageControl from = this._pages[fromIndex];
            if (0 <= newIndex && newIndex < this._pages.Count)
            {
                if (fromIndex < 0) { throw new ArgumentOutOfRangeException("movPageControl : ̓RNV͈̔͊Oł"); }
                if (fromIndex < this._tab.TabCount)
                {
                    TabPage tp = this._tab.TabPages[fromIndex];
                    Control cnt = from.AsControl;
                    if (tp.Tag.Equals(cnt) && this._screen.Controls.Contains(cnt))
                    {
                        lock (this._pages)
                        {
                            this._screen.Controls.SetChildIndex(cnt, newIndex);
                            this._tab.TabPages.Remove(tp);
                            this._pages.Remove(from);
                            this._pages.Insert(newIndex, from);
                            this._tab.TabPages.Insert(newIndex, tp);
                        }
                    }
                    tp = null;
                    cnt = null;
                }
            }
            from = null;
        }


        /// <summary>̃NXŎgp<see cref="WebBrowserAx"/>̃CX^X쐬܂B</summary>
        /// <returns>Cxgݒ̌qȂǂ<see cref="WebBrowserAx"/>Anull</returns>
        private WebBrowserAx create_browser()
        {
            if (this.TbTabCount >= this.Setting.MaxTabCount)
            {
                MessageBox.Show("\\ȃ^uő吔𒴂Ă܂", Application.ProductName);
                return null;
            }
            WebBrowserAx browser = new WebBrowserAx();
            browser.Visible = false;
            browser.Silent = this._silentmode;
            browser.BeforeNewWindow += new EventHandler<WebBrowserBeforeNewWindowEventArgs>(browser_BeforeNewWindow);
            browser.BeforeNavigate += new EventHandler<WebBrowserBeforeNavigateEventArgs>(browser_BeforeNavigate);
            browser.Navigated += new WebBrowserNavigatedEventHandler(browser_Navigated);
            browser.ProgressChanged += new WebBrowserProgressChangedEventHandler(browser_ProgressChanged);
            browser.DownloadCompleted += new EventHandler(browser_DownloadCompleted);
            browser.DocumentCompleted += new WebBrowserDocumentCompletedEventHandler(browser_DocumentCompleted);
            browser.NavigateError += new EventHandler<WebBrowserNavigateErrorEventArgs>(browser_NavigateError);
            browser.WindowClosing += new EventHandler<WebBrowserWindowClosingEventArgs>(browser_WindowClosing);
            browser.PreviewKeyDown += new PreviewKeyDownEventHandler(browser_PreviewKeyDown);
            browser.CanGoBackChanged += new EventHandler(browser_CanGoBackChanged);
            browser.CanGoForwardChanged += new EventHandler(browser_CanGoForwardChanged);
            browser.BrowserMouseDown += new EventHandler<WebBrowserMouseMessageEventArgs>(browser_BrowserMouseDown);
            browser.MouseDown += new MouseEventHandler(browser_MouseDown);
            browser.MessagePosted += new TbMessagePostEventHandler(browser_MessagePosted);

            this.prepair_for_attach_page(browser as ITbPageControl);

            browser.SecurityManager.AutoSecurity = this._setting.EnableAutoSecurity;
            browser.SecurityManager.UrlZoneA = this._setting.UntrustZoneMatch;
            browser.SecurityManager.SecurityFlagsZoneA = this._setting.DefaultSecurityUntrust;
            browser.SecurityManager.UrlZoneB = this._setting.TrustZoneMatch;
            browser.SecurityManager.SecurityFragsZoneB = this._setting.DefaultSecurityTrust;
            browser.SecurityManager.DefaultSecurityFlags = this._setting.DefaultSecurity;
            browser.SecurityManager.MySecurityFlags = this._setting.DefaultSecurity;
            return browser;
        }

        /// <summary>݊JĂ邷ׂẴy[Wɑ΂Đݒ̕ύXʒm܂B
        /// ey[Wɑ΂<see cref="attach_setting_browser"/>ŌĂяo܂B</summary>
        private void attach_settings()
        {
            lock (this._sync)
            {
                foreach (ITbPageControl page in this._pages)
                {
                    this.attach_setting_browser(page.AsBrowser);
                    this.OnDisplayTitleChanged(page, new ITbDisplayEventArgs(ITbDisplayEventType.Title, page.DisplayTitle));
                }
            }
        }

        /// <summary><see cref="WebBrowserAx"/>ɑ΂Đݒ̕ύXʒm܂B
        /// ̃\bh<see cref="attach_setting"/>Ăяo܂B</summary>
        /// <param name="browser">Ώۂ<see cref="WebBrowserAx"/></param>
        private void attach_setting_browser(WebBrowserAx browser)
        {
            if (browser != null)
            {
                browser.SecurityManager.AutoSecurity = this._setting.EnableAutoSecurity;
                browser.SecurityManager.MySecurityFlags = this._setting.DefaultSecurity;
                browser.SecurityManager.SecurityFlagsZoneA = this._setting.DefaultSecurityUntrust;
                browser.SecurityManager.SecurityFragsZoneB = this._setting.DefaultSecurityTrust;
                browser.SecurityManager.UrlZoneA = this._setting.UntrustZoneMatch;
                browser.SecurityManager.UrlZoneB = this._setting.TrustZoneMatch;
                browser.SecurityManager.DefaultSecurityFlags = this._setting.DefaultSecurity;
            }
        }

        /// <summary><see cref="ITbPageControl"/>̃Rg[ŎgpۂɕKvȑOs܂B</summary>
        /// <param name="page">Ώۂ<see cref="ITbPageControl"/></param>
        /// <returns>ȂKpłꍇtrue</returns>
        private bool prepair_for_attach_page(ITbPageControl page)
        {
            page.DisplayTextChanged += new ITbDisplayEventHandler(page_DisplayTextChanged);
            return true;
        }

        /// <summary>\̃^uꂽ<see cref="TbSelectedIndex"/>̒lsɂȂ̂hׁA
        /// ݒɉāA炩߂̒lύX܂B</summary>
        /// <param name="index">悤ƂĂ^u</param>
        private void act_before_close(int index)
        {
            if (this.TbSelectedIndex == index)
            {
                if (index == 0) // ԍ̃^u  ̂܂index=0L[v
                {
                }
                else if (index == this.TbTabCount - 1) // ԉẼ^u  I
                {
                    this.TbSelectedIndex = this.TbSelectedIndex - 1;
                }
                else // ȊO  ݒɂāAI炷B
                {
                    this.TbSelectedIndex = this.TbSelectedIndex + (this.Setting.FocusRightWhenFocusedClosed ? 1 : -1);
                }
            }
        }

        /// <summary>w肵^uʏ́uvŕĂǂ₢킹܂BʏtrueԂ܂B
        /// falseƂȂ̂́AbNꂽ^uȂݒɂĂ鎞ȂǂłB</summary>
        /// <param name="index">Ԃ擾^ũCfbNX</param>
        /// <returns>ʏ</returns>
        private bool get_canCloseTab(int index)
        {
            return
                (!this.TbGetIsLocked(index)) ||
                ((this.Setting.LockedTabBehavior & LockedTabBehaviors.IgnoreClose) != LockedTabBehaviors.IgnoreClose);
        }

        #endregion


        /// <summary>w肵CfbNX̃^ũbNԂ擾܂B^ubN̎Bׂ̃\bhłB
        /// private\bhɕtA̐`FbN܂</summary>
        /// <param name="index">Ԃ擾^ũCfbNX</param>
        /// <returns>bNĂ<value>true</value></returns>
        private bool getIsLocked(int index)
        {
            return this._tab.TabPages[index].ImageIndex == IMGIDX_TAB_LOCKED;
        }

        /// <summary>w肵CfbNX̃^ũbNԂݒ肵܂B^ubN̎Bׂ̃\bhłB
        /// private\bhɕtA̐`FbNA^u̍ĕ`w܂B</summary>
        /// <param name="index">Ԃݒ肷^ũCfbNX</param>
        /// <param name="locktab">Vw肷郍bNԁBbNꍇ<see cref="true"/></param>
        private void setIsLocked(int index, bool locktab)
        {
            this._tab.TabPages[index].ImageIndex = (locktab ? IMGIDX_TAB_LOCKED : IMGIDX_TAB_NORMAL);
        }

        /// <summary>TabControlɃ[Jȃ}EXW}EX̉̃^ũCfbNX擾܂B
        /// K^u擾łȂꍇ<value>-1</value>Ԃ܂B</summary>
        /// <param name="ptLocal">TabControl猩[JW</param>
        /// <returns>nꂽWɑΉ^ũCfbNXlB<value>-1</value></returns>
        private int get_tabIndexByLocation(Point ptLocal)
        {
            int index = -1;
            for (int i = 0; i < this._tab.TabCount; ++i)
            {
                if (this._tab.GetTabRect(i).Contains(ptLocal))
                {
                    index = i;
                    break;
                }
            }
            return index;
        }

        /// <summary>̃^uIꂽA^uɑΉRg[݂̂\悤ɕύX܂B</summary>
        /// <param name="index">\Rg[Ɋ֘Atꂽ^ũCfbNX</param>
        private void set_visible(int index)
        {
            if (this.InRange(index))
            {
                int i = 0;
                this._screen.SuspendLayout();
                this._pages[index].AsControl.Visible = true;
                foreach (ITbPageControl control in this._pages)
                {
                    //Control ctrl = control.AsControl;
                    if (index != i++) control.AsControl.Visible = false;
                }
                this._screen.ResumeLayout(true);
            }
            else if (this.TbTabCount != 0)
            {
                throw new ArgumentException("set_visible : OutOfRange");
            }
        }

        /// <summary>^u0ǂ𒲂ׁA\C܂B
        /// <para>^u0ł΃^uRg[ʑŜɍLA1ȏȂʏ̏Ԃɖ߂܂B</para></summary>
        private void adjust_size()
        {
            int w = this.ClientSize.Width,
                h = this.ClientSize.Height;
            if (this.TbTabCount != 0)
            {
                this._tab.Width = w;
                this._tab.Height = TAB_HEIGHT;
                this._screen.Size = new Size(w, h - this._tab.Height);
                this._screen.Location = new Point(0, this._tab.Bottom);
            }
            else
            {
                this._tab.Width = w;
                this._tab.Height = h;
                this._screen.Location = new Point(0, this._tab.Bottom);
            }
        }


        #region +--  TbActions Invokers

        /// <summary>̃^uɍpNbNANV\<see cref="TbTabClickAction"/>s܂B</summary>
        /// <param name="action">s<see cref="TbTabClickAction"/></param>
        /// <param name="tabindex">Ώۂ̃^ũCfbNX</param>
        private void invoke_TbClickAction(TbTabClickAction action, int tabindex)
        {
            switch (action)
            {
            case TbTabClickAction.CloseTab:
                if (this.get_canCloseTab(tabindex))
                    this.TbClose(tabindex);
                break;
            case TbTabClickAction.LockTab:
                this.TbSetIsLocked(tabindex, !this.TbGetIsLocked(tabindex));
                break;
            case TbTabClickAction.Reload:
                this.TbRefresh(tabindex);
                break;
            }
        }

        /// <summary>̃^uɊ֌WȂŜɍpNbNANV\<see cref="TbTabClickAction2"/>s܂B</summary>
        /// <param name="action">s<see cref="TbTabClickAction"/></param>
        private void invoke_TbClickAction2(TbTabClickAction2 action)
        {
            switch (action)
            {
            case TbTabClickAction2.OpenBlank:
                this.TbOpenNewTab("about:blank", this.TbTabCount, true);
                break;
            case TbTabClickAction2.OpenMyUrl:
                break;
            case TbTabClickAction2.ShowPageListMenu:
                this.ctxMenuPageList.Show(Cursor.Position);
                break;
            case TbTabClickAction2.ShowRecentClosedMenu:
                this.ctxCloseHistory.Show(Cursor.Position);
                break;
            }
        }

        #endregion

        #endregion


        #region ********  Document Editor (Private only)  ********

        private IHtmlDocumentEditor[] _documentEditor;

        private void call_HtmlDocumentEditor(string url, HtmlEditTrigger trigger, WebBrowserAx pBrowser)
        {
            if (this._documentEditor != null)
            {
                IHTMLDocument2 pDocument = null;
                try
                {
                    for (int i = 0; i < this._documentEditor.Length; ++i)
                    {
                        try
                        {
                            if (this._documentEditor[i].IsSupported(url, trigger))
                            {
                                if (pDocument == null) { pDocument = pBrowser.Document as IHTMLDocument2; }
                                if (this._documentEditor[i].EditDocument(url, trigger, pDocument)) { break; }
                            }
                        }
                        catch (UnauthorizedAccessException) { Tool.WarningWriteLine(null, "HTMLEDITORG[𔭐܂BhLgւ̃ANZXɎs܂Bindex={0}", i); }
                        catch (COMException e) { Tool.WarningWriteLine(null, "HtmlEditorG[𔭐܂Bindex={0}, msg={1}", i, e.Message); }
                        catch (Exception e) { Tool.WarningWriteLine(null, "HtmlEditorO𔭐܂Bindex={0}, msg={1}", i, e.Message); }
                    }
                }
                finally { if (pDocument != null) { Marshal.ReleaseComObject(pDocument); pDocument = null; } }
            }
        }

        /// <summary>
        /// IDAjRjRp̓_E[hNւƕϊ܂B
        /// </summary>
        /// <param name="movieid">ID\</param>
        /// <returns>boonURIŒ`ꂽANGXg\URL</returns>
        private string make_downlink_from_movieID(string movieid)
        {
            NicoVideoPageUrl watchurl = NicoVideoPageUrl.CreateFromVideoID(movieid);
            if (watchurl != null)
            {
                return CommonRequestProvider.CreateRequest(watchurl.Location);
            }
            return String.Empty;
        }

        #endregion


        #region CtxMenu : contextMenuStrip100 for TabControl

        #region +--  MenuEvent Handlers

        private void toolStripMenuItem101_CloseTab_Click(object sender, EventArgs e)
        {
            this.TbClose(this.TbContextMenuTargetIndex);
        }
        private void toolStripMenuItem102_CloseAllTabs_Click(object sender, EventArgs e)
        {
            this.TbClear(false);
        }
        private void toolStripMenuItem103_OpenNewTab_Click(object sender, EventArgs e)
        {
            this.TbOpenNewTab("about:blank");
        }
        private void toolStripMenuItem103_OpenExtenalBrowser_Click(object sender, EventArgs e)
        {
            string url;
            WebBrowserAx browser = this.TbGetBrowser(this.TbContextMenuTargetIndex);
            if (browser != null)
            {
                try
                {
                    System.IO.FileInfo bpath = new System.IO.FileInfo(this.Setting.BrowserPath);
                    if (bpath.Exists && bpath.Extension.Equals(".exe", StringComparison.OrdinalIgnoreCase))
                    {
                        url = browser.Url;
                        System.Diagnostics.ProcessStartInfo psi = new System.Diagnostics.ProcessStartInfo();
                        psi.FileName = bpath.FullName;
                        psi.Arguments = url;
                        System.Diagnostics.Process.Start(psi);
                    }
                    else
                    {
                        MessageBox.Show("OuEUɎw肳ꂽst@C܂B", Application.ProductName);
                    }
                }
                catch (Exception ex)
                {
                    MessageBox.Show(ex.Message, Application.ProductName);
                }
            }
        }
        private void toolStripMenuItem104_Refresh_Click(object sender, EventArgs e)
        {
            this.TbSelectedBrowser.Refresh();
        }
        private void toolStripMenuItem105_RefreshAllLockedTabs_Click(object sender, EventArgs e)
        {
            for (int i = 0; i < TbTabCount; i++)
            {
                if (this.TbGetIsLocked(i))
                {
                    if ((this._setting.LockedTabBehavior & LockedTabBehaviors.ReloadOnNew) != LockedTabBehaviors.ReloadOnNew)
                    {
                        this.TbSetIsLocked(i, false);
                    }
                    this.TbGetBrowser(i).Refresh();
                    this.TbSetIsLocked(i, true);
                }
            }
        }
        private void toolStripMenuItem106_RefreshAllTabs_Click(object sender, EventArgs e)
        {
            int tooMuchTabs = 3;
            if (this.TbTabCount >= tooMuchTabs)
            {
                if (MessageBox.Show("\̃^uxɍXV悤ƂĂ܂B\n̑͑傫ȕׂSz܂B\n\n{Ɏs܂H"
                , "\ׂ̂Ẵ^u̍XV", MessageBoxButtons.OKCancel, MessageBoxIcon.Warning)
                    == DialogResult.Cancel)
                {
                    return;
                }
            }
            for (int i = 0; i < this.TbTabCount; i++)
            {
                if (this.TbIsBrowser(i))
                    this.TbGetBrowser(i).Refresh();
            }
        }
        private void toolStripMenuItem107_LockThisTab_Click(object sender, EventArgs e)
        {
            this.TbSetIsLocked(this.TbContextMenuTargetIndex, !this.TbGetIsLocked(this.TbContextMenuTargetIndex));
        }
        private void toolStripMenuItem108_CopyTitleAndUrl_Click(object sender, EventArgs e)
        {
            Clipboard.SetText(
                this.TbGetControl(this.TbContextMenuTargetIndex).DisplayTitle
                + "\n" +
                this.TbGetControl(this.TbContextMenuTargetIndex).DisplayUrl);
        }
        private void toolStripMenuItem109_CopyTitle_Click(object sender, EventArgs e)
        {
            Clipboard.SetText(this.TbGetControl(this.TbContextMenuTargetIndex).DisplayTitle);
        }
        private void toolStripMenuItem110_CopyUrl_Click(object sender, EventArgs e)
        {
            Clipboard.SetText(this.TbGetControl(this.TbContextMenuTargetIndex).DisplayUrl);
        }
        private void toolStripMenuItem112_SecuritySettings_DropDownItemClicked(object sender, ToolStripItemClickedEventArgs e)
        {
            if (e.ClickedItem.Equals(this.toolStripMenuItem112_01_CurrentZone))
            {
                return;
            }
            ToolStripMenuItem tsmi = e.ClickedItem as ToolStripMenuItem;
            if (tsmi != null)
            {
                tsmi.Checked = !tsmi.Checked;
                if (!tsmi.Equals(this.toolStripMenuItem112_00_AutoSecurity))
                {
                    this.toolStripMenuItem112_00_AutoSecurity.Checked = false;
                }
            }
            this.set_security_from_menu(this.TbContextMenuTargetIndex);
        }

        private void toolStripMenuItem112_SecuritySettings_DropDownOpening(object sender, EventArgs e)
        {
            this.load_security_to_menu(this.TbContextMenuTargetIndex);
        }

        #endregion

        #region +--  Menu internal called routines

        /// <summary>ReLXgj܂BRXgN^ŌĂяo܂B</summary>
        private void initializeContextMenu()
        {
            this.contextMenuStrip100_ForTab = new System.Windows.Forms.ContextMenuStrip();
            this.toolStripMenuItem101_CloseTab = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripMenuItem102_CloseAllTabs = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator101 = new System.Windows.Forms.ToolStripSeparator();
            this.toolStripMenuItem103_OpenNewTab = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripMenuItem103_OpenExtenalBrowser = new ToolStripMenuItem();
            this.toolStripMenuItem103_TabPageList = new ToolStripMenuItem();
            this.toolStripSeparator102 = new System.Windows.Forms.ToolStripSeparator();
            this.toolStripMenuItem104_Refresh = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripMenuItem105_RefreshAllLockedTabs = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripMenuItem106_RefreshAllTabs = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator103 = new System.Windows.Forms.ToolStripSeparator();
            this.toolStripMenuItem107_LockThisTab = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator104 = new System.Windows.Forms.ToolStripSeparator();
            this.toolStripMenuItem108_CopyTitleAndUrl = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripMenuItem109_CopyTitle = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripMenuItem110_CopyUrl = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripMenuItem112_SecuritySettings = new ToolStripMenuItem();
            this.toolStripSeparator112_1 = new ToolStripSeparator();
            this.toolStripMenuItem112_00_AutoSecurity = new ToolStripMenuItem();
            this.toolStripMenuItem112_01_CurrentZone = new ToolStripMenuItem();
            this.toolStripMenuItem112_02_EnableScript = new ToolStripMenuItem();
            this.toolStripMenuItem112_03_EnableJava = new ToolStripMenuItem();
            this.toolStripMenuItem112_04_EnableActiveXExec = new ToolStripMenuItem();
            this.toolStripMenuItem112_05_EnableActiveXDownload = new ToolStripMenuItem();
            // 
            // contextMenuStrip100_ForTab
            // 
            this.contextMenuStrip100_ForTab.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
				this.toolStripMenuItem101_CloseTab,
				this.toolStripMenuItem102_CloseAllTabs,
			    this.toolStripSeparator101,
				this.toolStripMenuItem103_OpenNewTab,
				this.toolStripMenuItem103_OpenExtenalBrowser,
				this.toolStripMenuItem103_TabPageList,
				this.toolStripSeparator102,
				this.toolStripMenuItem104_Refresh,
				this.toolStripMenuItem105_RefreshAllLockedTabs,
				this.toolStripMenuItem106_RefreshAllTabs,
				this.toolStripSeparator103,
				this.toolStripMenuItem107_LockThisTab,
				this.toolStripMenuItem112_SecuritySettings,
				this.toolStripSeparator104,
				this.toolStripMenuItem108_CopyTitleAndUrl,
				this.toolStripMenuItem109_CopyTitle,
				this.toolStripMenuItem110_CopyUrl});

            this.contextMenuStrip100_ForTab.Name = "contextMenuStrip100_ForTab";
            this.contextMenuStrip100_ForTab.Size = new System.Drawing.Size(261, 248);
            this.contextMenuStrip100_ForTab.Opening += new CancelEventHandler(contextMenuStrip100_ForTab_Opening);
            // 
            // toolStripMenuItem101_CloseTab
            // 
            this.toolStripMenuItem101_CloseTab.Name = "toolStripMenuItem101_CloseTab";
            this.toolStripMenuItem101_CloseTab.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.W)));
            this.toolStripMenuItem101_CloseTab.Size = new System.Drawing.Size(260, 22);
            this.toolStripMenuItem101_CloseTab.Text = "(&C)";
            this.toolStripMenuItem101_CloseTab.Click += new System.EventHandler(this.toolStripMenuItem101_CloseTab_Click);
            // 
            // toolStripMenuItem102_CloseAllTabs
            // 
            this.toolStripMenuItem102_CloseAllTabs.Name = "toolStripMenuItem102_CloseAllTabs";
            this.toolStripMenuItem102_CloseAllTabs.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.T)));
            this.toolStripMenuItem102_CloseAllTabs.Size = new System.Drawing.Size(260, 22);
            this.toolStripMenuItem102_CloseAllTabs.Text = "ׂẴ^u(&A)";
            this.toolStripMenuItem102_CloseAllTabs.Click += new System.EventHandler(this.toolStripMenuItem102_CloseAllTabs_Click);
            // 
            // toolStripSeparator101
            // 
            this.toolStripSeparator101.Name = "toolStripSeparator101";
            this.toolStripSeparator101.Size = new System.Drawing.Size(257, 6);
            // 
            // toolStripMenuItem103_OpenNewTab
            // 
            this.toolStripMenuItem103_OpenNewTab.Name = "toolStripMenuItem103_OpenNewTab";
            this.toolStripMenuItem103_OpenNewTab.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.T)));
            this.toolStripMenuItem103_OpenNewTab.Size = new System.Drawing.Size(260, 22);
            this.toolStripMenuItem103_OpenNewTab.Text = "V^uJ(&N)";
            this.toolStripMenuItem103_OpenNewTab.Click += new System.EventHandler(this.toolStripMenuItem103_OpenNewTab_Click);
            //
            // toolStripMenuItem103_OpenExtenalBrowser
            //
            this.toolStripMenuItem103_OpenExtenalBrowser.Name = "toolStripMenuItem103_OpenExternalBrowser";
            this.toolStripMenuItem103_OpenExtenalBrowser.Text = "OuEUŊJ";
            this.toolStripMenuItem103_OpenExtenalBrowser.Size = new Size(260, 22);
            this.toolStripMenuItem103_OpenExtenalBrowser.Click += new EventHandler(toolStripMenuItem103_OpenExtenalBrowser_Click);
            //
            // toolStripMenuItem103_TabPageList
            //
            this.toolStripMenuItem103_TabPageList.Name = "toolStripMenuItem103_TabPageList";
            this.toolStripMenuItem103_TabPageList.Size = new Size(260, 22);
            this.toolStripMenuItem103_TabPageList.Text = "JĂ^üꗗ";
            this.toolStripMenuItem103_TabPageList.DropDownItemClicked += new ToolStripItemClickedEventHandler(this.ctxMenuPageList_ItemClicked);
            // 
            // toolStripSeparator102
            // 
            this.toolStripSeparator102.Name = "toolStripSeparator102";
            this.toolStripSeparator102.Size = new System.Drawing.Size(257, 6);
            // 
            // toolStripMenuItem104_Refresh
            // 
            this.toolStripMenuItem104_Refresh.Name = "toolStripMenuItem104_Refresh";
            this.toolStripMenuItem104_Refresh.ShortcutKeys = System.Windows.Forms.Keys.F5;
            this.toolStripMenuItem104_Refresh.Size = new System.Drawing.Size(260, 22);
            this.toolStripMenuItem104_Refresh.Text = "ŐV̏ɍXV(&R)";
            this.toolStripMenuItem104_Refresh.Click += new System.EventHandler(this.toolStripMenuItem104_Refresh_Click);
            // 
            // toolStripMenuItem105_RefreshAllLockedTabs
            // 
            this.toolStripMenuItem105_RefreshAllLockedTabs.Name = "toolStripMenuItem105_RefreshAllLockedTabs";
            this.toolStripMenuItem105_RefreshAllLockedTabs.ShortcutKeys = ((System.Windows.Forms.Keys)((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.F5)));
            this.toolStripMenuItem105_RefreshAllLockedTabs.Size = new System.Drawing.Size(260, 22);
            this.toolStripMenuItem105_RefreshAllLockedTabs.Text = "ׂẴbN^uXV(&O)";
            this.toolStripMenuItem105_RefreshAllLockedTabs.Click += new System.EventHandler(this.toolStripMenuItem105_RefreshAllLockedTabs_Click);
            // 
            // toolStripMenuItem106_RefreshAllTabs
            // 
            this.toolStripMenuItem106_RefreshAllTabs.Name = "toolStripMenuItem106_RefreshAllTabs";
            this.toolStripMenuItem106_RefreshAllTabs.ShortcutKeys = ((System.Windows.Forms.Keys)(((System.Windows.Forms.Keys.Control | System.Windows.Forms.Keys.Shift)
                        | System.Windows.Forms.Keys.F5)));
            this.toolStripMenuItem106_RefreshAllTabs.Size = new System.Drawing.Size(260, 22);
            this.toolStripMenuItem106_RefreshAllTabs.Text = "ׂẴ^uXV(&E)";
            this.toolStripMenuItem106_RefreshAllTabs.Click += new System.EventHandler(this.toolStripMenuItem106_RefreshAllTabs_Click);
            // 
            // toolStripSeparator103
            // 
            this.toolStripSeparator103.Name = "toolStripSeparator103";
            this.toolStripSeparator103.Size = new System.Drawing.Size(257, 6);
            // 
            // toolStripMenuItem107_LockThisTab
            // 
            this.toolStripMenuItem107_LockThisTab.Name = "toolStripMenuItem107_LockThisTab";
            this.toolStripMenuItem107_LockThisTab.Size = new System.Drawing.Size(260, 22);
            this.toolStripMenuItem107_LockThisTab.Text = "̃^ubN(&L)";
            this.toolStripMenuItem107_LockThisTab.Click += new System.EventHandler(this.toolStripMenuItem107_LockThisTab_Click);
            this.toolStripMenuItem107_LockThisTab.CheckOnClick = true;
            // 
            // toolStripSeparator104
            // 
            this.toolStripSeparator104.Name = "toolStripSeparator104";
            this.toolStripSeparator104.Size = new System.Drawing.Size(257, 6);
            // 
            // toolStripMenuItem108_CopyTitleAndUrl
            // 
            this.toolStripMenuItem108_CopyTitleAndUrl.Name = "toolStripMenuItem108_CopyTitleAndUrl";
            this.toolStripMenuItem108_CopyTitleAndUrl.Size = new System.Drawing.Size(260, 22);
            this.toolStripMenuItem108_CopyTitleAndUrl.Text = "^CgURLRs[(&B)";
            this.toolStripMenuItem108_CopyTitleAndUrl.Click += new System.EventHandler(this.toolStripMenuItem108_CopyTitleAndUrl_Click);
            // 
            // toolStripMenuItem109_CopyTitle
            // 
            this.toolStripMenuItem109_CopyTitle.Name = "toolStripMenuItem109_CopyTitle";
            this.toolStripMenuItem109_CopyTitle.Size = new System.Drawing.Size(260, 22);
            this.toolStripMenuItem109_CopyTitle.Text = "^CgRs[(&T)";
            this.toolStripMenuItem109_CopyTitle.Click += new System.EventHandler(this.toolStripMenuItem109_CopyTitle_Click);
            // 
            // toolStripMenuItem110_CopyUrl
            // 
            this.toolStripMenuItem110_CopyUrl.Name = "toolStripMenuItem110_CopyUrl";
            this.toolStripMenuItem110_CopyUrl.Size = new System.Drawing.Size(260, 22);
            this.toolStripMenuItem110_CopyUrl.Text = "URLRs[(&U)";
            this.toolStripMenuItem110_CopyUrl.Click += new System.EventHandler(this.toolStripMenuItem110_CopyUrl_Click);
            //
            // toolStripMenuItem112_SecuritySettings ++
            //
            this.toolStripMenuItem112_SecuritySettings.Name = "toolStripMenuItem112_SecuritySettings";
            this.toolStripMenuItem112_SecuritySettings.Text = "ZLeB̐ݒ";
            this.toolStripMenuItem112_SecuritySettings.Size = new Size(260, 22);
            this.toolStripMenuItem112_SecuritySettings.DropDownItems.AddRange(new ToolStripItem[]{
				this.toolStripMenuItem112_01_CurrentZone,
				this.toolStripMenuItem112_00_AutoSecurity,
				this.toolStripSeparator112_1,
				this.toolStripMenuItem112_02_EnableScript,
				this.toolStripMenuItem112_03_EnableJava,
				this.toolStripMenuItem112_04_EnableActiveXExec,
				this.toolStripMenuItem112_05_EnableActiveXDownload });
            this.toolStripMenuItem112_SecuritySettings.DropDownOpening += new EventHandler(toolStripMenuItem112_SecuritySettings_DropDownOpening);
            this.toolStripMenuItem112_SecuritySettings.DropDownItemClicked += new ToolStripItemClickedEventHandler(toolStripMenuItem112_SecuritySettings_DropDownItemClicked);

            this.toolStripMenuItem112_01_CurrentZone.AutoToolTip = true;
            this.toolStripMenuItem112_01_CurrentZone.CheckOnClick = false;
            this.toolStripMenuItem112_01_CurrentZone.Size = new Size(260, 20);
            this.toolStripMenuItem112_01_CurrentZone.TextAlign = ContentAlignment.MiddleCenter;

            this.toolStripMenuItem112_00_AutoSecurity.CheckOnClick = true;
            this.toolStripMenuItem112_00_AutoSecurity.Text = "ZLeBݒ肷";
            this.toolStripMenuItem112_00_AutoSecurity.Name = "toolStripMenuItem112_00_AutoSecurity";

            this.toolStripMenuItem112_02_EnableScript.CheckOnClick = true;
            this.toolStripMenuItem112_02_EnableScript.Text = "XNvg̎gp";
            this.toolStripMenuItem112_02_EnableScript.Name = "toolStripMenuItem112_02_EnableScript";

            this.toolStripMenuItem112_03_EnableJava.CheckOnClick = true;
            this.toolStripMenuItem112_03_EnableJava.Text = "JAVA̎s";
            this.toolStripMenuItem112_03_EnableJava.Name = "toolStripMenuItem112_03_EnableJava";

            this.toolStripMenuItem112_04_EnableActiveXExec.CheckOnClick = true;
            this.toolStripMenuItem112_04_EnableActiveXExec.Text = "ActiveX̎s";
            this.toolStripMenuItem112_04_EnableActiveXExec.Name = "toolStripMenuItem112_04_EnableActiveXExec";

            this.toolStripMenuItem112_05_EnableActiveXDownload.CheckOnClick = true;
            this.toolStripMenuItem112_05_EnableActiveXDownload.Text = "ActiveX̃_E[h";
            this.toolStripMenuItem112_05_EnableActiveXDownload.Name = "toolStripMenuItem112_05_EnableActiveXDownload";


        }

        /// <summary><see cref="contextMenuStrip100_ForTab"/>J鎞ɌĂяoA^[QbgƂȂ^uɉ
        /// j[̕\e𒲐܂B</summary>
        /// <param name="sender"><see cref="contextMenuStrip100_ForTab"/></param>
        /// <param name="e">Cxgf[^</param>
        private void contextMenuStrip100_ForTab_Opening(object sender, CancelEventArgs e)
        {
            int index = this.TbContextMenuTargetIndex;
            if (!this.InRange(index))
            {
                index = this.TbSelectedIndex;
            }
            if (index < 0) { e.Cancel = true; }
            else
            {
                this.setCtxMenu100VisiblesForBrowser(this.TbIsBrowser(index));
                this.toolStripMenuItem107_LockThisTab.Checked = this.TbGetIsLocked(index);
                this.toolStripMenuItem103_TabPageList.DropDownItems.Clear();
                this.get_PageListMenu(this.toolStripMenuItem103_TabPageList.DropDownItems, true);
            }
        }

        /// <summary>ReLXgj[ɁAw肵CfbNX̃uEŨZLeBݒǂݏo܂B</summary>
        /// <param name="index">ݒǂݍރuEŨCfbNX</param>
        private void load_security_to_menu(int index)
        {
            SecurityFlags frag = SecurityFlags.None;
            WebBrowserAx browser = this.TbGetBrowser(index);
            if (browser != null)
            {
                int key = browser.SecurityManager.CurrentZone;
                switch (key)
                {
                case InternetSecurityManager.SEC_INDEX_DEF:
                    frag = browser.SecurityManager.DefaultSecurityFlags;
                    this.toolStripMenuItem112_00_AutoSecurity.Checked = true;
                    this.toolStripMenuItem112_01_CurrentZone.Text = "ʂ̃GA";
                    this.toolStripMenuItem112_01_CurrentZone.BackColor = Color.LimeGreen;
                    break;
                case InternetSecurityManager.SEC_INDEX_MY:
                    frag = browser.SecurityManager.MySecurityFlags;
                    this.toolStripMenuItem112_00_AutoSecurity.Checked = false;
                    this.toolStripMenuItem112_01_CurrentZone.Text = "ύXꂽZLeB";
                    this.toolStripMenuItem112_01_CurrentZone.BackColor = Color.Yellow;
                    break;
                case InternetSecurityManager.SEC_INDEX_A:
                    frag = browser.SecurityManager.SecurityFlagsZoneA;
                    this.toolStripMenuItem112_00_AutoSecurity.Checked = true;
                    this.toolStripMenuItem112_01_CurrentZone.Text = "x̃GA";
                    this.toolStripMenuItem112_01_CurrentZone.BackColor = Color.Orange;
                    break;
                case InternetSecurityManager.SEC_INDEX_B:
                    frag = browser.SecurityManager.SecurityFragsZoneB;
                    this.toolStripMenuItem112_00_AutoSecurity.Checked = true;
                    this.toolStripMenuItem112_01_CurrentZone.Text = "MĂGA";
                    this.toolStripMenuItem112_01_CurrentZone.BackColor = Color.SkyBlue;
                    break;
                default:
                    throw new Exception("SecurityZone:`KeygpĂ܂");
                }
                this.toolStripMenuItem112_02_EnableScript.Checked = (frag & SecurityFlags.Script) == SecurityFlags.Script;
                this.toolStripMenuItem112_03_EnableJava.Checked = (frag & SecurityFlags.JAVA) == SecurityFlags.JAVA;
                this.toolStripMenuItem112_04_EnableActiveXExec.Checked = (frag & SecurityFlags.AxExecute) == SecurityFlags.AxExecute;
                this.toolStripMenuItem112_05_EnableActiveXDownload.Checked = (frag & SecurityFlags.AxDownload) == SecurityFlags.AxDownload;
            }
        }

        /// <summary>ReLXgj[̃ZLeBݒ̏ԂAw肵CfbNX̃uEUɓKp܂B</summary>
        /// <param name="index">ݒKpuEŨCfbNX</param>
        private void set_security_from_menu(int index)
        {
            WebBrowserAx browser = this.TbGetBrowser(index);
            if (browser != null)
            {
                browser.SecurityManager.AutoSecurity = this.toolStripMenuItem112_00_AutoSecurity.Checked;
                browser.SecurityManager.MySecurityFlags =
                    (this.toolStripMenuItem112_02_EnableScript.Checked ? SecurityFlags.Script : SecurityFlags.None) |
                    (this.toolStripMenuItem112_03_EnableJava.Checked ? SecurityFlags.JAVA : SecurityFlags.None) |
                    (this.toolStripMenuItem112_04_EnableActiveXExec.Checked ? SecurityFlags.AxExecute : SecurityFlags.None) |
                    (this.toolStripMenuItem112_05_EnableActiveXDownload.Checked ? SecurityFlags.AxDownload : SecurityFlags.None);
                browser.SecurityManager.NavigateToPage(browser.Url);
            }
        }

        /// <summary><see cref="contextMenuStrip100_ForTab"/>̊eACe̕\E\p[^[ɂĐ؂ւ܂B</summary>
        /// <param name="isForBrowser">JΏۂuEURg[ł邩ǂ</param>
        private void setCtxMenu100VisiblesForBrowser(bool isForBrowser)
        {
            this.toolStripMenuItem101_CloseTab.Visible = true;
            this.toolStripMenuItem102_CloseAllTabs.Visible = true;
            this.toolStripSeparator101.Visible = true;
            this.toolStripMenuItem103_OpenNewTab.Visible = true;
            this.toolStripMenuItem103_OpenExtenalBrowser.Visible = isForBrowser;
            this.toolStripMenuItem103_TabPageList.Visible = true;
            this.toolStripSeparator102.Visible = true;
            this.toolStripMenuItem104_Refresh.Visible = isForBrowser;
            this.toolStripMenuItem105_RefreshAllLockedTabs.Visible = isForBrowser;
            this.toolStripMenuItem106_RefreshAllTabs.Visible = isForBrowser;
            this.toolStripSeparator103.Visible = isForBrowser;
            this.toolStripMenuItem107_LockThisTab.Visible = true;
            this.toolStripSeparator104.Visible = true;
            this.toolStripMenuItem108_CopyTitleAndUrl.Visible = isForBrowser;
            this.toolStripMenuItem109_CopyTitle.Visible = isForBrowser;
            this.toolStripMenuItem110_CopyUrl.Visible = isForBrowser;
            this.toolStripMenuItem112_SecuritySettings.Visible = isForBrowser;
            this.toolStripSeparator112_1.Visible = isForBrowser;
            this.toolStripMenuItem112_00_AutoSecurity.Visible = isForBrowser;
            this.toolStripMenuItem112_01_CurrentZone.Visible = isForBrowser;
            this.toolStripMenuItem112_02_EnableScript.Visible = isForBrowser;
            this.toolStripMenuItem112_03_EnableJava.Visible = isForBrowser;
            this.toolStripMenuItem112_04_EnableActiveXExec.Visible = isForBrowser;
            this.toolStripMenuItem112_05_EnableActiveXDownload.Visible = isForBrowser;
        }

        #endregion

        #region +--  Fields (MenuItem Defines)

        private System.Windows.Forms.ContextMenuStrip contextMenuStrip100_ForTab;
        private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem101_CloseTab;
        private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem102_CloseAllTabs;
        private System.Windows.Forms.ToolStripSeparator toolStripSeparator101;
        private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem103_OpenNewTab;
        private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem103_OpenExtenalBrowser;
        private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem103_TabPageList;
        private System.Windows.Forms.ToolStripSeparator toolStripSeparator102;
        private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem104_Refresh;
        private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem105_RefreshAllLockedTabs;
        private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem106_RefreshAllTabs;
        private System.Windows.Forms.ToolStripSeparator toolStripSeparator103;
        private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem107_LockThisTab;
        private System.Windows.Forms.ToolStripSeparator toolStripSeparator104;
        private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem108_CopyTitleAndUrl;
        private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem109_CopyTitle;
        private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem110_CopyUrl;

        private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem112_SecuritySettings;
        private System.Windows.Forms.ToolStripMenuItem toolStripMenuItem112_00_AutoSecurity;
        private ToolStripMenuItem toolStripMenuItem112_01_CurrentZone;
        private ToolStripSeparator toolStripSeparator112_1;
        private ToolStripMenuItem toolStripMenuItem112_02_EnableScript;
        private ToolStripMenuItem toolStripMenuItem112_03_EnableJava;
        private ToolStripMenuItem toolStripMenuItem112_04_EnableActiveXExec;
        private ToolStripMenuItem toolStripMenuItem112_05_EnableActiveXDownload;

        #endregion

        #endregion


        #region CtxMenu : PageList / u\̃y[Wꗗv

        /// <summary><see cref="ctxMenuPageList"/>̊֘Ao܂B</summary>
        private void initializePageList()
        {
            this.ctxMenuPageList = new ContextMenuStrip();
            this.tsctxmenuSeparate1 = new ToolStripSeparator();
            this.tsctxmenuSeparate2 = new ToolStripSeparator();
            this.tsctxmenuSeparate1.Name = "-1";
            this.tsctxmenuSeparate2.Name = "-1";

            this.ctxMenuPageList.ItemClicked += new ToolStripItemClickedEventHandler(ctxMenuPageList_ItemClicked);
            this.ctxMenuPageList.Opening += new CancelEventHandler(ctxMenuPageList_Opening);
            this.tsmiPageLists = new List<ToolStripMenuItem>(32);
            for (int i = 0; i < this.Setting.MaxTabCount; i++)
            {
                tsmiPageLists.Add(new ToolStripMenuItem());
                tsmiPageLists[i].Name = i.ToString();
            }
            this.tsmiPageListOpenNewTab = new ToolStripMenuItem();
            tsmiPageListOpenNewTab.Text = "V^uJ";
            tsmiPageListOpenNewTab.Name = "-10";
            //tsmiPageListOpenNewTab.Image = SystemIcons.Application.ToBitmap();
            tsmiPageListOpenNewTab.ShowShortcutKeys = true;
        }

        /// <summary>\̃y[Wꗗ擾܂B</summary>
        /// <param name="target_">ꗗj[̒ǉ</param>
        /// <param name="useTitle_">\URLgpꍇfalse</param>
        /// <returns>ǉꂽj[̐</returns>
        private int get_PageListMenu(ToolStripItemCollection target_, bool useTitle_)
        {
            int i = -1;
            while (++i < this.TbTabCount)
            {
                tsmiPageLists[i].Text = useTitle_ ?
                    this.TbGetControl(i).DisplayTitle
                    : this.TbGetControl(i).DisplayUrl;
                tsmiPageLists[i].Checked = this.TbSelectedIndex == i;
                target_.Add(tsmiPageLists[i]);
            }
            return i;
        }

        #region +--  Item Event Handlers

        /// <summary><see cref="ctxMenuPageList"/>\ۂɌĂяoAItem𒲐܂B</summary>
        /// <param name="sender"><see cref="ctxMenuPageList"/></param>
        /// <param name="e"></param>
        void ctxMenuPageList_Opening(object sender, CancelEventArgs e)
        {
            bool useTitle_ = true;
            this.ctxMenuPageList.Items.Clear();
            this.ctxMenuPageList.Items.Add(tsmiPageListOpenNewTab);
            this.ctxMenuPageList.Items.Add(tsctxmenuSeparate1);
            this.get_PageListMenu(this.ctxMenuPageList.Items, useTitle_);
        }

        /// <summary><see cref="ctxMenuPageList"/>̗vfNbNꂽ̏łB</summary>
        /// <param name="sender"><see cref="ctxMenuPageList"/></param>
        /// <param name="e">Cxgf[^i[<see cref="ToolStripItemClickedEventArgs"/></param>
        void ctxMenuPageList_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
        {
            int tgt;
            if (Int32.TryParse(e.ClickedItem.Name, out tgt))
            {
                if (0 <= tgt && tgt < this.TbTabCount)
                {
                    this.TbSelectedIndex = tgt;
                }
                else if (tgt == -10)
                {
                    this.TbOpenNewTab("about:blank");
                }
            }
        }

        #endregion

        #region +--  Fields (MenuItem Defines)

        /// <summary>
        /// u\̃y[WꗗvReLXgj[
        /// </summary>
        private ContextMenuStrip ctxMenuPageList;
        /// <summary>
        /// <see cref="ctxMenuPageList"/>̐擪Ɋi[<see cref="ToolStripMenuItem"/>
        /// </summary>
        private ToolStripMenuItem tsmiPageListOpenNewTab;
        /// <summary>
        /// <see cref="ctxMenuPageList"/>Ɋi[<see cref="ToolStripMenuItem"/>̃RNV
        /// </summary>
        private List<ToolStripMenuItem> tsmiPageLists;
        /// <summary>
        /// <see cref="ctxMenuPageList"/>ŎgpZp[^[
        /// </summary>
        private ToolStripSeparator tsctxmenuSeparate1 = new ToolStripSeparator();
        /// <summary>
        /// <see cref="ctxMenuPageList"/>ŎgpZp[^[
        /// </summary>
        private ToolStripSeparator tsctxmenuSeparate2 = new ToolStripSeparator();

        #endregion

        #endregion


        #region CtxMenu : RecentClosed / uŋߕ^uv

        /// <summary>ŋߕ^ũ^CgURL擾܂B</summary>
        /// <param name="offset">Ōɕ^u0Ƃ̒l</param>
        /// <returns>KeyɃ^CgAValueUrlPair</returns>
        public ClosedTabData GetRecentClosed(int offset)
        {
            if (0 <= offset && offset < this._closedTabHistory.Count)
            {
                return this._closedTabHistory[offset];
            }
            else { throw new ArgumentException("TabBrowser::GetRecentClosed̈sł"); }
        }

        /// <summary>ŋߕ^uƂĕێĂ闚̐擾܂</summary>
        public int RecentClosedTabCount
        {
            get { return this._closedTabHistory.Count; }
        }

        /// <summary><see cref="ctxCloseHistory"/>̊֘Ao܂B</summary>
        private void initiaizeClosedHistory()
        {
            this._closedTabHistory = new List<ClosedTabData>(this._setting.MaxCloseTabHistory);
            this.ctxCloseHistory = new ContextMenuStrip();
            this.ctxCloseHistory.ShowItemToolTips = true;
            this.ctxCloseHistory.ShowCheckMargin = false;
            this.ctxCloseHistory.ShowImageMargin = false;
            this.ctxCloseHistory.MaximumSize = new Size(400, 800);

            this.tsmiCloseHistoryHeader = new ToolStripMenuItem();
            this.tsmiCloseHistoryHeader.Text = "ŋߕ^üꗗ";
            this.tsmiCloseHistoryHeader.Enabled = false;

            this.tsmiCloseHistory = new List<ToolStripMenuItem>(this._setting.MaxCloseTabHistory);
            for (int i = 0; i < this.tsmiCloseHistory.Capacity; i++)
            {
                ToolStripMenuItem mn = new ToolStripMenuItem();
                mn.Name = i.ToString();
                this.tsmiCloseHistory.Add(mn);
            }
            this.ctxCloseHistory.Opening += new CancelEventHandler(ctxCloseHistory_Opening);
            this.ctxCloseHistory.ItemClicked += new ToolStripItemClickedEventHandler(ctxCloseHistory_ItemClicked);
        }

        /// <summary>ŋߕ^ut@Cǂݍ݂܂B</summary>
        /// <param name="xmlpath">XMLt@C̃pX</param>
        /// <returns>ɓǂݍ񂾏ꍇtrue</returns>
        public bool LoadClosedTabHistory(string xmlpath)
        {
            try
            {
                _closedTabHistory = WebServiceClient.SerializeHelper.XmlDeserialize<List<ClosedTabData>>(xmlpath, false);
                return true;
            }
            catch
            {
                return false;
            }
        }

        /// <summary>ŋߕ^ut@Cɕۑ܂B</summary>
        /// <param name="xmlpath">XMLt@C̕ۑ̃pX</param>
        /// <returns>ɕۑꍇtrue</returns>
        public bool SaveClosedTabHistory(string xmlpath)
        {
            try
            {
                WebServiceClient.SerializeHelper.XmlSerialize(_closedTabHistory, xmlpath);
                return true;
            }
            catch
            {
                return false;
            }
        }

        /// <summary><see cref="WebBrowserAx"/>ہÃ\bhĂяoA
        /// <see cref="closedTabHistory"/>Ɂuŋߕ^uv̏ǉ܂</summary>
        /// <param name="browser">uEUIuWFNg</param>
        /// <param name="onExit">AvP[VIɌĂяoꂽꍇɂ̂truenĂB</param>
        /// <param name="isLocked">^ubNĂꍇtruenĂB</param>
        private void set_closedTabHistory(WebBrowserAx browser, bool onExit, bool isLocked)
        {
            while (0 < this._closedTabHistory.Count && this.Setting.MaxCloseTabHistory <= this._closedTabHistory.Count)
            {
                this._closedTabHistory.RemoveAt(this._closedTabHistory.Count - 1);
            }
            ClosedTabData data = new ClosedTabData(browser, onExit, isLocked);
            this._closedTabHistory.Insert(0, data);
        }

        /// <summary>łÂ^u̗폜܂B</summary>
        private void remove_latestClosedTabHistory()
        {
            this._closedTabHistory.RemoveAt(0);
        }

        /// <summary>łV^u̗擾܂B</summary>
        /// <returns></returns>
        private ClosedTabData get_latestClosedTabHistory()
        {
            if (this._closedTabHistory.Count > 0)
            {
                return this._closedTabHistory[0];
            }
            else { return null; }
        }

        #region +--  Menu Event Handlers

        /// <summary><see cref="ctxCloseHistory"/>J鎞ɌĂяoAItem𒲐܂B</summary>
        /// <param name="sender"><see cref="ctxCloseHistory"/></param>
        /// <param name="e">Cxg̃f[^i[<see cref="CancelEventArgs"/></param>
        void ctxCloseHistory_Opening(object sender, CancelEventArgs e)
        {
            this.ctxCloseHistory.Items.Clear();
            this.ctxCloseHistory.Items.Add(tsmiCloseHistoryHeader);
            this.ctxCloseHistory.Items.Add(tsctxmenuSeparate2);
            for (int i = 0; i < this._closedTabHistory.Count; i++)
            {
                this.tsmiCloseHistory[i].Text = _closedTabHistory[i].Title;
                this.tsmiCloseHistory[i].ToolTipText = _closedTabHistory[i].Url;
                this.ctxCloseHistory.Items.Add(this.tsmiCloseHistory[i]);
            }
        }

        /// <summary><see cref="ctxCloseHistory"/>ItemNbNꂽ̏łB</summary>
        /// <param name="sender"><see cref="ctxCloseHistory"/></param>
        /// <param name="e">Cxg̃f[^i[<see cref="ToolStripItemClickedEventArgs"/></param>
        void ctxCloseHistory_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
        {
            int tgt;
            if (Int32.TryParse(e.ClickedItem.Name, out tgt) && tgt >= 0)
            {
                if (this.TbOpenNewTab(this._closedTabHistory[tgt], this.TbSelectedIndex + 1, true))
                {
                    this._closedTabHistory.RemoveAt(tgt);
                }
            }
        }

        #endregion

        #region +--  Fields (MenuItem Defines)

        /// <summary>
        /// uŋߕ^uvj[
        /// </summary>
        ContextMenuStrip ctxCloseHistory;
        /// <summary>
        /// <see cref="ctxCloseHistory"/>̐擪̃ACe
        /// </summary>
        ToolStripMenuItem tsmiCloseHistoryHeader;
        /// <summary>
        /// <see cref="ctxCloseHistory"/>Ɋi[<see cref="ToolStripMenuItem"/>̃RNV
        /// </summary>
        List<ToolStripMenuItem> tsmiCloseHistory;
        //List<KeyValuePair<string, string>> closedTabHistory;
        List<ClosedTabData> _closedTabHistory;

        #endregion

        #endregion


        #region CtxMenu : nCp[Npv`j[

        #region +--  Fields (MenuItem Defines)

        /// <summary>nCp[NpTuj[B
        /// \OɕKTagɃNURLstringƂĊi[邱ƁB</summary>
        private ContextMenuStrip ctxLinkSubMenu;
        /// <summary><see cref="ctxLinkSubMenu"/>̃ACëBuJv</summary>
        private ToolStripMenuItem tsmiLinkSub_01_Navigate;
        /// <summary><see cref="ctxLinkSubMenu"/>̃ACëuV^uŊJv</summary>
        private ToolStripMenuItem tsmiLinkSub_02_NavigateNew;
        /// <summary><see cref="ctxLinkSubMenu"/>̃ACëu_E[hv</summary>
        private ToolStripMenuItem tsmiLinkSub_11_Download;
        /// <summary><see cref="ctxLinkSubMenu"/>̃ACëu_E[hۗo^v</summary>
        private ToolStripMenuItem tsmiLinkSub_12_DownloadReserve;
        /// <summary><see cref="ctxLinkSubMenu"/>̃ACëu_E[hgo^v</summary>
        private ToolStripMenuItem tsmiLinkSub_21_DownloadExt;
        /// <summary><see cref="ctxLinkSubMenu"/>ŎgptHg</summary>
        private Font _fontTsmiSmall;

        #endregion

        /// <summary>
        /// <see cref="ctxLinkSubMenu"/>֘ÃtB[h܂B
        /// </summary>
        private void initialize_LinkSubMenu()
        {
            this._fontTsmiSmall = new Font(this.Font.FontFamily, 9f, FontStyle.Regular);

            this.ctxLinkSubMenu = new ContextMenuStrip();
            this.ctxLinkSubMenu.RenderMode = ToolStripRenderMode.ManagerRenderMode;
            this.ctxLinkSubMenu.ItemClicked += new ToolStripItemClickedEventHandler(ctxLinkSubMenu_ItemClicked);
            this.ctxLinkSubMenu.Opening += new CancelEventHandler(ctxLinkSubMenu_Opening);

            this.tsmiLinkSub_01_Navigate = new ToolStripMenuItem();
            this.tsmiLinkSub_02_NavigateNew = new ToolStripMenuItem();
            this.tsmiLinkSub_11_Download = new ToolStripMenuItem();
            this.tsmiLinkSub_12_DownloadReserve = new ToolStripMenuItem();
            this.tsmiLinkSub_21_DownloadExt = new ToolStripMenuItem();

            this.tsmiLinkSub_01_Navigate.Text = "J";
            this.tsmiLinkSub_01_Navigate.Font = this._fontTsmiSmall;
            this.tsmiLinkSub_01_Navigate.DisplayStyle = ToolStripItemDisplayStyle.Text;
            this.tsmiLinkSub_01_Navigate.TextImageRelation = TextImageRelation.Overlay;

            this.tsmiLinkSub_02_NavigateNew.Text = "V^uŊJ";
            this.tsmiLinkSub_02_NavigateNew.Font = this._fontTsmiSmall;
            this.tsmiLinkSub_02_NavigateNew.DisplayStyle = ToolStripItemDisplayStyle.Text;
            this.tsmiLinkSub_02_NavigateNew.TextImageRelation = TextImageRelation.Overlay;

            this.tsmiLinkSub_11_Download.Text = "_E[h";
            this.tsmiLinkSub_11_Download.Font = this._fontTsmiSmall;
            this.tsmiLinkSub_11_Download.DisplayStyle = ToolStripItemDisplayStyle.Text;
            this.tsmiLinkSub_11_Download.TextImageRelation = TextImageRelation.Overlay;

            this.tsmiLinkSub_12_DownloadReserve.Text = "_E[hۗo^";
            this.tsmiLinkSub_12_DownloadReserve.Font = this._fontTsmiSmall;
            this.tsmiLinkSub_12_DownloadReserve.DisplayStyle = ToolStripItemDisplayStyle.Text;
            this.tsmiLinkSub_12_DownloadReserve.TextImageRelation = TextImageRelation.Overlay;

            this.tsmiLinkSub_21_DownloadExt.Text = "Oςă_E[h";
            this.tsmiLinkSub_21_DownloadExt.Font = this._fontTsmiSmall;
            this.tsmiLinkSub_21_DownloadExt.DisplayStyle = ToolStripItemDisplayStyle.Text;
            this.tsmiLinkSub_21_DownloadExt.TextImageRelation = TextImageRelation.Overlay;

            this.ctxLinkSubMenu.Items.AddRange(new ToolStripItem[]{
				this.tsmiLinkSub_01_Navigate,
				this.tsmiLinkSub_02_NavigateNew,
				this.tsmiLinkSub_11_Download,
				this.tsmiLinkSub_12_DownloadReserve,
				this.tsmiLinkSub_21_DownloadExt
			});
        }

        /// <summary><see cref="ctxLinkSubMenu"/>J鎞ɌĂяoANeɂĕ\؂ւ܂B</summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void ctxLinkSubMenu_Opening(object sender, CancelEventArgs e)
        {
            string url = this.ctxLinkSubMenu.Tag as string;
            if (String.IsNullOrEmpty(url)) { e.Cancel = true; }
            else if (!NicoVideoPageUrl.IsWatchPage(url))
            {
                this.tsmiLinkSub_11_Download.Visible = false;
                this.tsmiLinkSub_12_DownloadReserve.Visible = false;
                this.tsmiLinkSub_21_DownloadExt.Visible = false;
            }
            else
            {
                this.tsmiLinkSub_11_Download.Visible = true;
                this.tsmiLinkSub_12_DownloadReserve.Visible = true;
                this.tsmiLinkSub_21_DownloadExt.Visible = true;
            }
        }

        /// <summary><see cref="ctxLinkSubMenu"/>ItemNbNꂽ̏łB</summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        void ctxLinkSubMenu_ItemClicked(object sender, ToolStripItemClickedEventArgs e)
        {
            string url = this.ctxLinkSubMenu.Tag as string;
            this.ctxLinkSubMenu.Tag = null;

            if (String.IsNullOrEmpty(url))
            {
                this.ctxLinkSubMenu.Hide();
                return;
            }


            if (e.ClickedItem.Equals(this.tsmiLinkSub_01_Navigate)) // J
            {
                this.TbSelectedBrowser.Navigate(url);
            }
            else if (e.ClickedItem.Equals(this.tsmiLinkSub_02_NavigateNew)) // V^uŊJ
            {
                this.TbOpenNewTab(url, this.TbSelectedIndex + 1, true);
            }
            else
            {
                NicoVideoPageUrl pageUrl;
                if (NicoVideoPageUrl.TryCreate(url, out pageUrl))
                {
                    string downloadLink = this.make_downlink_from_movieID(pageUrl.VideoId);
                    MovieDownloadRequiredEventArgs mdr_args = null;

                    if (e.ClickedItem.Equals(this.tsmiLinkSub_11_Download)) // _E[h
                    {
                        mdr_args = MovieDownloadRequiredEventArgs.FromVideoPageUrl(pageUrl.Location);
                    }
                    else if (e.ClickedItem.Equals(this.tsmiLinkSub_12_DownloadReserve))// ۗo^
                    {
                        mdr_args = MovieDownloadRequiredEventArgs.FromVideoPageUrl(pageUrl.Location, MovieDownloadRequiredEventArgs.Options.Reserved);
                    }
                    if (e.ClickedItem.Equals(this.tsmiLinkSub_21_DownloadExt))
                    {
                        mdr_args = MovieDownloadRequiredEventArgs.FromVideoPageUrl(pageUrl.Location, MovieDownloadRequiredEventArgs.Options.CustomMode);
                    }
                    if (mdr_args != null)
                    {
                        InnerLogger.LOut("linkmenu:require-download/arg= " + mdr_args.Url, InnerLogger.ErrorLevel.L4_NOTIFY);
                        this.OnMovieDownloadRequired(this.TbSelectedBrowser, mdr_args);
                    }
                }
            }
            this.ctxLinkSubMenu.Hide();
        }

        #endregion


        #region MSHTML Helper Methods

        /// <summary>w肳ꂽGgʂɂItZbglGgǂAnꂽvf̃ItZbgʒuvZ܂B</summary>
        /// <param name="site">ItZbglvZGg</param>
        /// <param name="release">ŐV蓖ĂꂽCOMIuWFNgi[邽߂̊JpXgBnullnƐV쐬܂B</param>
        /// <returns>vZꂽItZbglB</returns>
        /// <exception cref="ArgumentNullException"><paramref name="site"/>nullnƔ܂B</exception>
        private static Size CalcElementOffset(IHTMLElement site, ref ComReleaseList release)
        {
            if (site == null) { throw new ArgumentNullException(); }
            if (release == null) { release = new ComReleaseList(); }

            int paddingX = 0,
                paddingY = 0;
            IHTMLElement pOffsetCurrent = site;
            IHTMLElement2 pParent = null;

            // Walk up dom from frame element for sum-up offet size.
            do
            {
                paddingX += pOffsetCurrent.offsetLeft;
                paddingY += pOffsetCurrent.offsetTop;
                pParent = release.Push<IHTMLElement2>(pOffsetCurrent.parentElement);
                if (pParent != null)
                {
                    paddingX -= pParent.scrollLeft;
                    paddingY -= pParent.scrollTop;
                }
                pOffsetCurrent = release.Push<IHTMLElement>(pOffsetCurrent.offsetParent);
            }
            while (pOffsetCurrent != null);
            return new Size(paddingX, paddingY);
        }

        /// <summary>WebBrowserAx̃NCAgWw肵C^[tF[X<typeparamref name="T"/>Gg܂B
        /// ̗vf擾łȂꍇnullԂ܂B
        /// <para><typeparamref name="T"/><see cref="MSHTML.IFrameBase2"/>łȂAt[vfꍇ͎IɃt[܂B</para></summary>
        /// <typeparam name="E">GgC^[tF[X̌^B</typeparam>
        /// <param name="browser">ɎgpWebBrowserAx̃CX^X</param>
        /// <param name="clientPos">Ggʒui<paramref name="browser"/>'s client coordinatesj</param>
        /// <param name="release">ŐV蓖ĂꂽCOMIuWFNgi[邽߂̊JpXgBnullnƐV쐬܂B</param>
        /// <returns>GgBłȂꍇnullԂ܂B</returns>
        private static E TryGetElementFromPosition<E>(WebBrowserAx browser, Point clientPos, ref ComReleaseList release)
            where E : class
        {
            E pFound = null;
            const int fixX = 0;
            const int fixY = 0;
            try
            {
                Point ptTarget = browser.ClientToWindow(clientPos.X, clientPos.Y);
                ptTarget.X -= fixX;
                ptTarget.Y -= fixY;
                IHTMLDocument2 pDocument = release.Push<IHTMLDocument2>(browser.Document);
                IHTMLElement pPointed = release.Push<IHTMLElement>(pDocument.elementFromPoint(ptTarget.X, ptTarget.Y));

                #region +--+--[ Sub routine : When pointed element is frame. ]

                IHTMLFrameBase2 pFrame = pPointed as IHTMLFrameBase2;
                while (pFrame != null)
                {
                    Size szOffset = CalcElementOffset(pPointed, ref release);
                    IHTMLWindow2 pFrameWindow = release.Push<IHTMLWindow2>(pFrame.contentWindow);
                    IHTMLDocument2 pCurrentDocument = pDocument;

                    if (pFrameWindow != null)
                    {
                        pFrameWindow.focus();
                        SHDocVw.IWebBrowser2 pFrameBrowser =
                            release.Push<SHDocVw.IWebBrowser2>(
                            release.Push<IHTMLElement>(pDocument.activeElement));
                        pDocument = release.Push<IHTMLDocument2>(pFrameBrowser.Document);
                        if (pDocument != null)
                        {
                            ptTarget.X -= szOffset.Width;
                            ptTarget.Y -= szOffset.Height;
                            pPointed = release.Push<IHTMLElement>(pDocument.elementFromPoint(ptTarget.X, ptTarget.Y));
                            pFrame = pPointed as IHTMLFrameBase2;
                        }
                    }
                }

                #endregion

                pFound = pPointed as E;
                while (pFound == null && pPointed != null)
                {
                    pPointed = release.Push<IHTMLElement>(pPointed.parentElement);
                    pFound = pPointed as E;
                }
            }
            catch (Exception e) { pFound = null; InnerLogger.Out(e.ToString()); }

            return pFound;
        }
        /// <summary>WebBrowserAx̃NCAgWw肵C^[tF[X<typeparamref name="T"/>Gg܂B
        /// ̗vf擾łȂꍇnullԂ܂B
        /// <para><typeparamref name="T"/><see cref="MSHTML.IFrameBase2"/>łȂAt[vfꍇ͎IɃt[܂B</para></summary>
        /// <typeparam name="E">GgC^[tF[X̌^B</typeparam>
        /// <param name="browser">ɎgpWebBrowserAx̃CX^X</param>
        /// <param name="clientPos">Ggʒui<paramref name="browser"/>'s client coordinatesj</param>
        /// <param name="release">ŐV蓖ĂꂽCOMIuWFNgi[邽߂̊JpXgBnullnƐV쐬܂B</param>
        /// <returns>GgBłȂꍇnullԂ܂B</returns>
        private static E TryGetElementFromPosition<E>(WebBrowserAx browser, Point clientPos, out string foundAt, ref ComReleaseList release)
            where E : class
        {
            foundAt = browser.Url;
            E pFound = null;
            const int fixX = 0;
            const int fixY = 0;
            try
            {
                Point ptTarget = browser.ClientToWindow(clientPos.X, clientPos.Y);
                ptTarget.X -= fixX;
                ptTarget.Y -= fixY;
                IHTMLDocument2 pDocument = release.Push<IHTMLDocument2>(browser.Document);
                IHTMLElement pPointed = release.Push<IHTMLElement>(pDocument.elementFromPoint(ptTarget.X, ptTarget.Y));

                #region +--+--[ Sub routine : When pointed element is frame. ]

                IHTMLFrameBase2 pFrame = pPointed as IHTMLFrameBase2;
                while (pFrame != null)
                {
                    Size szOffset = CalcElementOffset(pPointed, ref release);
                    IHTMLWindow2 pFrameWindow = release.Push<IHTMLWindow2>(pFrame.contentWindow);
                    IHTMLDocument2 pCurrentDocument = pDocument;

                    if (pFrameWindow != null)
                    {
                        pFrameWindow.focus();
                        SHDocVw.IWebBrowser2 pFrameBrowser =
                            release.Push<SHDocVw.IWebBrowser2>(
                            release.Push<IHTMLElement>(pDocument.activeElement));
                        foundAt = pFrameBrowser.LocationURL;
                        pDocument = release.Push<IHTMLDocument2>(pFrameBrowser.Document);
                        if (pDocument != null)
                        {
                            ptTarget.X -= szOffset.Width;
                            ptTarget.Y -= szOffset.Height;
                            pPointed = release.Push<IHTMLElement>(pDocument.elementFromPoint(ptTarget.X, ptTarget.Y));
                            pFrame = pPointed as IHTMLFrameBase2;
                        }
                    }
                }

                #endregion

                pFound = pPointed as E;
                while (pFound == null && pPointed != null)
                {
                    pPointed = release.Push<IHTMLElement>(pPointed.parentElement);
                    pFound = pPointed as E;
                }
            }
            catch (Exception e) { pFound = null; InnerLogger.Out(e.ToString()); }

            return pFound;
        }

        #endregion
    }
}



