using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using System.Runtime.CompilerServices;

namespace Alternative.Controls.Browsers
{
	/// <summary>TabBrowserSetting̒lύXׂGUIiłB : UserControlp</summary>
	public partial class TabBrowserSettingPage : UserControl
	{
		/// <summary>ݒXgA܂B</summary>
		private TabBrowserSetting _setting = null;


		#region Constructor / Initializer

		/// <summary>̃NX̃RXgN^B
		/// gpOSetSettingData𗘗pāAf[^i[ĂB</summary>
		public TabBrowserSettingPage()
		{
			InitializeComponent();
			this.initialize();
		}

		/// <summary>RXgN^ɂČĂяo鏉\bhłB</summary>
		private void initialize()
		{
			string[] items = new string[]{
				"Ȃ",
				"^ubN",
				"^u",
				"^uēǍ"
			};
			string[] items2 = new string[4]{
				"Ȃ",
				"V^uJ",
				"\̃y[Wꗗ",
				"ŋߕ^uꗗ"
			};
			
			this.tab_cmb_doubleclick.Items.AddRange((object[])items.Clone());
			this.tab_cmb_wheelclick.Items.AddRange((object[])items.Clone());

			this.tab_cmb_extabrightclick.Items.AddRange((object[])items2.Clone());
			this.tab_cmb_extabdoubleclick.Items.AddRange((object[])items2.Clone());
			this.tab_cmb_extabwheelclick.Items.AddRange(items2);

			this.man_txt_maxclosedgfhistory.Tag = new int[] { 0, 10 } as object;
			this.man_txt_maxclosedtabs.Tag = new int[] { 0, 20 } as object;
			this.dis_txt_titlemaxchars.Tag = new int[] { 0, 60 } as object;

			// ̈זB
			this.man_txt_maxclosedgfhistory.Enabled = false;
		}

		#endregion


		/// <summary>̃Rg[ɐݒKp܂B</summary>
		/// <param name="setting">Kp<see cref="TabBrowserSetting"/></param>
		/// <returns>trueB</returns>
		[MethodImpl(MethodImplOptions.Synchronized)]
		public bool SetSettingData(TabBrowserSetting setting)
		{
			try
			{
				this._setting = setting;
				// Tab
				this.Px_TabDoubleClick = setting.TabDoubleClickL;
				this.Px_TabEmptyClickM = setting.TabEmptyWheelClick;
				this.Px_TabEmptyClickR = setting.TabEmptyClickR;
				this.Px_TabEmptyDoubleClickL = setting.TabEmptyDoubleClickL;
				this.Px_TabMouseDownM = setting.TabMouseDownM;

				this.Px_TabWheelRotate = setting.TabWheelRotate;
				this.Px_EnableTabWheel = setting.EnableTabWheel;
				this.Px_FocusOnClickOpen = setting.FocusOnCenterClickOpen;
				this.Px_FocusRightWhenFocusedClosed = setting.FocusRightWhenFocusedClosed;

				this.Px_LockedTabBehavior = setting.LockedTabBehavior;

				// Disp
				this.Px_EnableRegexEditTitle = setting.EnableRegexEditTitle;
				this.Px_EditTitleInfo = setting.EditTitleInfos;
				this.Px_EditTitleMaxLength = setting.EditTitle_MaxLength;
				this.Px_EditTitleSimpleRemove = setting.EditTitleSimpleRemove;
	
				// Sec
				this.Px_TrustZoneMatch = setting.TrustZoneMatch;
				this.Px_UntrustZoneMatch = setting.UntrustZoneMatch;
				this.Px_DefaultZoneSecurity = setting.DefaultSecurity;
				this.Px_TrustZoneSecurity = setting.DefaultSecurityTrust;
				this.Px_UntrustZoneSecurity = setting.DefaultSecurityUntrust;
				// man
				this.Px_MaxClosedTabs = setting.MaxCloseTabHistory;
				this.Px_MaxHistoryTrace = setting.MaxHistoryTrace;
				this.Px_MaxTabCount = setting.MaxTabCount;
			}
			catch(Exception e)
			{
				System.Diagnostics.Trace.WriteLine(String.Format("TabBrowserSettingPage::SetSettingData / ݒ̓KpɎs\nMessage = {0}", e.Message));
				return false;
			}
			// enables
			this.sec_rad_editTargetTrust.Checked = true;
			this._setting = setting;

			return true;
		}

		/// <summary>̃Rg[ɂč쐬ꂽݒ擾܂B
		/// ̃\bh́AsꍇnullԂƂ܂B
		/// <para>̃\bh́AȑOɌĂяoꂽSetSettingDataɂĕۑꂽl㏑܂B</para></summary>
		/// <param name="canceled">truew肵ꍇAŌ<see cref="SetSettingData"/><see cref="TabBrowserSetting"/>IuWFNgւ̎QƂԂ܂</param>
		/// <returns>쐬ꂽ<see cref="TabBrowserSetting"/>Bsꍇnull</returns>
		[MethodImpl(MethodImplOptions.Synchronized)]
		public TabBrowserSetting GetSettingData(bool canceled)
		{
			if(canceled) { return this._setting; }

			TabBrowserSetting setting = new TabBrowserSetting();
			try
			{
				// react
				setting.TabDoubleClickL = this.Px_TabDoubleClick;
				setting.TabEmptyClickR = this.Px_TabEmptyClickR;
				setting.TabEmptyDoubleClickL = this.Px_TabEmptyDoubleClickL;
				setting.TabEmptyWheelClick = this.Px_TabEmptyClickM;
				setting.EnableTabWheel = this.Px_EnableTabWheel;
				setting.FocusOnCenterClickOpen = this.Px_FocusOnClickOpen;
				setting.TabWheelRotate = this.Px_TabWheelRotate;
				
				// dis
				setting.EnableRegexEditTitle = this.Px_EnableRegexEditTitle;
				setting.EditTitleSimpleRemove = this.Px_EditTitleSimpleRemove;
				setting.EditTitleInfos = this.Px_EditTitleInfo;
				setting.EditTitle_MaxLength = this.Px_EditTitleMaxLength;

				// sec
				setting.TrustZoneMatch = this.Px_TrustZoneMatch;
				setting.UntrustZoneMatch = this.Px_UntrustZoneMatch;
				setting.DefaultSecurity = this.Px_DefaultZoneSecurity;
				setting.DefaultSecurityTrust = this.Px_TrustZoneSecurity;
				setting.DefaultSecurityUntrust = this.Px_UntrustZoneSecurity;

				// man
				setting.MaxTabCount = this.Px_MaxTabCount;
				setting.MaxCloseTabHistory = this.Px_MaxClosedTabs;
				setting.MaxHistoryTrace = this.Px_MaxHistoryTrace;
				setting.BrowserPath = this.Px_ExternalBrowserPath;
			}
			catch(Exception e)
			{
				System.Diagnostics.Trace.WriteLine(String.Format("TabBrowserSettingPage::GetSettingData / ݒ̓KpɎs\nMessage = {0}", e.Message));
				return null;
			}
			setting.SealInstance();
			return setting;
		}


		#region Event Handlers

		/// <summary>TextBox̕񂪁ASingleLine̐K\NXɕϊł邩Validate</summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtbox_regexsl_Validating(object sender, CancelEventArgs e)
		{
			try
			{
				string txt = (sender as TextBox).Text;
				if(txt.Contains("\n"))
				{
                    MessageBox.Show("s܂ރp^[w肷邱Ƃ͏o܂B", Application.ProductName);
					e.Cancel = true;
				}
				Regex r = new Regex(txt, RegexOptions.Singleline);
				r = null;
			}
			catch
			{
				e.Cancel = true;
                MessageBox.Show("K\Ɏw肳ꂽ񂪕słB", Application.ProductName);
			}
		}

		/// <summary>TextBox̕񂪁AInt32ɕϊł邩Validate
		/// TagvpeBint[2]Ă΁A[0]=min`[1]=max̊Ԃɒl܂Ă邩Ƀ`FbN</summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void txtbox_intval_Validating(object sender, CancelEventArgs e)
		{
			int vl = -1;
			TextBox txtb = sender as TextBox;
			if(Int32.TryParse(txtb.Text, out vl))
			{
				int[] minmax = txtb.Tag as int[];
				if(minmax != null
					&& (vl < minmax[0] || minmax[1] < vl))
				{
					e.Cancel = true;
                    MessageBox.Show("le͈͓ɂ܂B", Application.ProductName);
				}
			}
			else
			{
				e.Cancel = true;
                MessageBox.Show("l͂ĉB", Application.ProductName);
			}
			txtb = null;
		}

		#endregion


		#region Private Properties (Corresponde to TabBrowserSetting Class)

		#region +--  Group(Reaction)

		private TbTabClickAction Px_TabMouseDownM
		{
			get { return this.conv_TbTabAction_index(this.tab_cmb_wheelclick.SelectedIndex); }
			set { this.tab_cmb_wheelclick.SelectedIndex = this.conv_TbTabAction_index(value); }
		}

		private TbTabClickAction Px_TabDoubleClick
		{
			get { return this.conv_TbTabAction_index(this.tab_cmb_doubleclick.SelectedIndex); }
			set { this.tab_cmb_doubleclick.SelectedIndex = this.conv_TbTabAction_index(value); }
		}

		private TbTabClickAction2 Px_TabEmptyDoubleClickL
		{
			get { return this.conv_TbTabAction2_index(this.tab_cmb_extabdoubleclick.SelectedIndex); }
			set { this.tab_cmb_extabdoubleclick.SelectedIndex = this.conv_TbTabAction2_index(value); }
		}

		private TbTabClickAction2 Px_TabEmptyClickR
		{
			get { return this.conv_TbTabAction2_index(this.tab_cmb_extabrightclick.SelectedIndex); }
			set { this.tab_cmb_extabrightclick.SelectedIndex = this.conv_TbTabAction2_index(value); }
		}

		private TbTabClickAction2 Px_TabEmptyClickM
		{
			get { return this.conv_TbTabAction2_index(this.tab_cmb_extabwheelclick.SelectedIndex); }
			set { this.tab_cmb_extabwheelclick.SelectedIndex = this.conv_TbTabAction2_index(value); }
		}

		private int conv_TbTabAction_index(TbTabClickAction act)
		{
			switch(act)
			{
				case TbTabClickAction.None: return 0;
				case TbTabClickAction.LockTab: return 1;
				case TbTabClickAction.CloseTab: return 2;
				case TbTabClickAction.Reload: return 3;
				default: return 0;
			}
		}
		private TbTabClickAction conv_TbTabAction_index(int index)
		{
			switch(index)
			{
				case 0: return TbTabClickAction.None;
				case 1: return TbTabClickAction.LockTab;
				case 2: return TbTabClickAction.CloseTab;
				case 3: return TbTabClickAction.Reload;
				default: return TbTabClickAction.None;
			}
		}

		private int conv_TbTabAction2_index(TbTabClickAction2 act)
		{
			switch(act)
			{
				case TbTabClickAction2.None: return 0;
				case TbTabClickAction2.OpenBlank: return 1;
				case TbTabClickAction2.ShowPageListMenu: return 2;
				case TbTabClickAction2.ShowRecentClosedMenu: return 3;
				default: return 0;
			}
		}
		private TbTabClickAction2 conv_TbTabAction2_index(int index)
		{
			switch(index)
			{
				case 0: return TbTabClickAction2.None;
				case 1: return TbTabClickAction2.OpenBlank;
				case 2: return TbTabClickAction2.ShowPageListMenu;
				case 3:return TbTabClickAction2.ShowRecentClosedMenu;
				default:return TbTabClickAction2.None;
			}
		}

		#endregion


		#region +--  Group(Reaction2)

		private bool Px_FocusOnClickOpen
		{
			get { return this.tab_chk_focuswheelopened.Checked; }
			set { this.tab_chk_focuswheelopened.Checked = value; }
		}
		private bool Px_FocusRightWhenFocusedClosed
		{
			get { return true; }
			set { }
		}
		private bool Px_EnableTabWheel
		{
			get { return this.tab_chk_wheelontab.Checked; }
			set { this.tab_chk_wheelontab.Checked = (this.tab_chk_rotatewheel.Enabled = value); }
		}
		private bool Px_TabWheelRotate
		{
			get { return this.tab_chk_rotatewheel.Checked; }
			set { this.tab_chk_rotatewheel.Checked = value; }
		}

		private void tab_chk_wheelontab_CheckedChanged(object sender, EventArgs e)
		{
			this.tab_chk_rotatewheel.Enabled = this.tab_chk_wheelontab.Checked;
		}

		#endregion


		#region +--  Group(Security1)

		public SecurityFlags Px_DefaultZoneSecurity
		{
			get
			{
				SecurityFlags flag = SecurityFlags.None;
				if(this.sec_chk_commonscript.Checked) { flag |= SecurityFlags.Script; }
				if(this.sec_chk_commonactivex.Checked) { flag |= SecurityFlags.AxExecute; }
				return flag;
			}
			set
			{
				this.sec_chk_commonscript.Checked = (value & SecurityFlags.Script) == SecurityFlags.Script;
				this.sec_chk_commonactivex.Checked = (value & SecurityFlags.AxExecute) == SecurityFlags.AxExecute;
			}
		}

		public SecurityFlags Px_TrustZoneSecurity
		{
			get
			{
				SecurityFlags flag = SecurityFlags.None;
				if(this.sec_chk_trustscript.Checked) { flag |= SecurityFlags.Script; }
				if(this.sec_chk_trustactivex.Checked) { flag |= SecurityFlags.AxExecute; }
				return flag;
			}
			set
			{
				this.sec_chk_trustscript.Checked = (value & SecurityFlags.Script) == SecurityFlags.Script;
				this.sec_chk_trustactivex.Checked = (value & SecurityFlags.AxExecute) == SecurityFlags.AxExecute;
			}
		}

		private SecurityFlags Px_UntrustZoneSecurity
		{
			get
			{
				return SecurityFlags.None;
			}
			set { }
		}

		#endregion


		#region +--  Group(Security2)

		private RegexInfoEditDialog _rieDialog;

		private ReadOnlyCollection<RegexInfo> Px_TrustZoneMatch
		{
			get
			{
				ListView.ListViewItemCollection col = this.sec_list_Trust.Items;
				RegexInfo[] rxi = new RegexInfo[col.Count];
				int cur = 0;
				foreach(ListViewItem item in col)
				{
					rxi[cur++] = (RegexInfo)item.Tag;
				}
				return new ReadOnlyCollection<RegexInfo>(rxi);
			}
			set
			{
				this.sec_list_Trust.Items.Clear();
				if(value != null)
				{
					foreach(RegexInfo rxi in value)
					{
						ListViewItem item = this.GetItem(rxi);
						if(item != null)
						{
							this.sec_list_Trust.Items.Add(item);
						}
					}
				}
			}
		}
		private ReadOnlyCollection<RegexInfo> Px_UntrustZoneMatch
		{
			get
			{
				ListView.ListViewItemCollection col = this.sec_list_Danger.Items;
				RegexInfo[] rxi = new RegexInfo[col.Count];
				int cur = 0;
				foreach(ListViewItem item in col)
				{
					rxi[cur++] = (RegexInfo)item.Tag;
				}
				return new ReadOnlyCollection<RegexInfo>(rxi);
			}
			set
			{
				this.sec_list_Danger.Items.Clear();
				if(value != null)
				{
					foreach(RegexInfo rxi in value)
					{
						ListViewItem item = this.GetItem(rxi);
						if(item != null)
						{
							this.sec_list_Danger.Items.Add(item);
						}
					}
				}
			}
		}

		#region +--+--  Methods

		private ListViewItem GetItem(RegexInfo info)
		{
			ListViewItem item = new ListViewItem(info.Name);
			item.Checked = info.Enabled;
			item.Tag = info;
			return item;
		}

		private void AppendItem(ListViewItem item, RegexInfo info)
		{
			item.Tag = info;
			item.Text = info.Name;
			item.Checked = info.Enabled;
		}

		private bool EditOnDialog(RegexInfo info, out RegexInfo newinfo)
		{
			if(this._rieDialog == null) { this._rieDialog = new RegexInfoEditDialog(); }
			return (this._rieDialog.ShowDialogAndEdit(this, info, out newinfo) == DialogResult.OK);
		}

		#endregion

		#region +--+--  Event Handler

		private void sec_btn_RxUp_Click(object sender, EventArgs e)
		{
			int index;

			if(this.sec_rad_editTargetTrust.Checked)
			{
				if(0 < this.sec_list_Trust.SelectedItems.Count)
				{
					ListViewItem item = this.sec_list_Trust.SelectedItems[0];

					if((index = item.Index) > 0)
					{
						this.sec_list_Trust.Items.Remove(item);
						this.sec_list_Trust.Items.Insert(index - 1, item);
					}
				}
			}
			else if(this.sec_rad_editTargetDanger.Checked)
			{
				if(0 < this.sec_list_Danger.SelectedItems.Count)
				{
					ListViewItem item = this.sec_list_Danger.SelectedItems[0];

					if((index = item.Index) > 0)
					{
						this.sec_list_Danger.Items.Remove(item);
						this.sec_list_Danger.Items.Insert(index - 1, item);
					}
				}
			}
		}

		private void sec_btn_RxDown_Click(object sender, EventArgs e)
		{
			int index;
			int count;

			if(this.sec_rad_editTargetTrust.Checked)
			{
				if(0 < (count = this.sec_list_Trust.SelectedItems.Count))
				{
					ListViewItem item = this.sec_list_Trust.SelectedItems[0];

					if((index = item.Index) < count - 1)
					{
						this.sec_list_Trust.Items.Remove(item);
						this.sec_list_Trust.Items.Insert(index + 1, item);
					}
				}
			}
			else if(this.sec_rad_editTargetDanger.Checked)
			{
				if(0 < (count = this.sec_list_Danger.SelectedItems.Count))
				{
					ListViewItem item = this.sec_list_Danger.SelectedItems[0];

					if((index = item.Index) < count - 1)
					{
						this.sec_list_Danger.Items.Remove(item);
						this.sec_list_Danger.Items.Insert(index + 1, item);
					}
				}
			}
		}

		private void sec_btn_RxEdit_Click(object sender, EventArgs e)
		{
			if(this.sec_rad_editTargetTrust.Checked)
			{
				if(this.sec_list_Trust.SelectedItems.Count > 0)
				{
					ListViewItem item = this.sec_list_Trust.SelectedItems[0];
					RegexInfo rxi = item.Tag as RegexInfo;
					if(this.EditOnDialog(rxi, out rxi))
					{
						this.AppendItem(item, rxi);
					}
				}
			}
			else if(this.sec_rad_editTargetDanger.Checked)
			{
				if(this.sec_list_Danger.SelectedItems.Count > 0)
				{
					ListViewItem item = this.sec_list_Danger.SelectedItems[0];
					RegexInfo rxi = item.Tag as RegexInfo;
					if(this.EditOnDialog(rxi, out rxi))
					{
						this.AppendItem(item, rxi);
					}
				}
			}
		}

		private void sec_btn_RxDelete_Click(object sender, EventArgs e)
		{
			if(this.sec_rad_editTargetTrust.Checked)
			{
				if(this.sec_list_Trust.SelectedItems.Count > 0)
				{
					ListViewItem item = this.sec_list_Trust.SelectedItems[0];
					if(MessageBox.Show(this, "ȉ̍ڂ폜܂B\n\nE" + item.Text,
						"ACe폜̊mF", MessageBoxButtons.OKCancel, MessageBoxIcon.Warning, MessageBoxDefaultButton.Button2)
						== DialogResult.OK)
					{
						this.sec_list_Trust.Items.Remove(item);
						item.Tag = null;
					}
				}
			}
			else if(this.sec_rad_editTargetDanger.Checked)
			{
				if(this.sec_list_Danger.SelectedItems.Count > 0)
				{
					ListViewItem item = this.sec_list_Danger.SelectedItems[0];
					if(MessageBox.Show(this, "ȉ̍ڂ폜܂B\n\nE" + item.Text,
						"ACe폜̊mF", MessageBoxButtons.OKCancel, MessageBoxIcon.Warning, MessageBoxDefaultButton.Button2)
						== DialogResult.OK)
					{
						this.sec_list_Danger.Items.Remove(item);
						item.Tag = null;
					}
				}
			}
		}

		private void sec_btn_RxNew_Click(object sender, EventArgs e)
		{
			if(this.sec_rad_editTargetTrust.Checked)
			{
				ListViewItem item = this.GetItem(new RegexInfo());
				this.sec_list_Trust.Items.Add(item);
			}
			else if(this.sec_rad_editTargetDanger.Checked)
			{
				ListViewItem item = this.GetItem(new RegexInfo());
				this.sec_list_Danger.Items.Add(item);
			}
		}

		private void sec_list_ItemChecked(object sender, ItemCheckedEventArgs e)
		{
			RegexInfo ri = e.Item.Tag as RegexInfo;
			if(ri != null)
			{
				ri.Enabled = e.Item.Checked;
				this.AppendItem(e.Item, ri);
			}
		}

		#endregion

		#endregion


		#region +--  Group(Display1)

		private RegexReplaceInfoEditDialog _rrieDialog;

		private bool Px_EnableRegexEditTitle
		{
			get { return this.dis_rad_UseRegex.Checked; }
			set { this.dis_rad_UseRegex.Checked = value; }
		}
		private string Px_EditTitleSimpleRemove
		{
			get { return this.dis_txt_EasyRemove.Text; }
			set { this.dis_txt_EasyRemove.Text = value; }
		}

		public int Px_EditTitleMaxLength
		{
			get
			{
				int val = 0;
				if(!Int32.TryParse(this.dis_txt_titlemaxchars.Text, out val)) { return 60; }
				return Math.Min(Math.Max(val, 0), 60);
			}
			set
			{
				this.dis_txt_titlemaxchars.Text = Math.Min(60, Math.Max(0 ,value)).ToString();
			}
		}

		#region +--+--  Handlers

		private void dis_rad_UseMode_CheckedChanged(object sender, EventArgs e)
		{
			bool flag = this.Px_EnableRegexEditTitle;
			
			this.dis_txt_EasyRemove.Enabled = !flag;
			this.dis_group_RxDetail.Enabled = flag;
			this.dis_lb_DetailIsNext.Enabled = flag;
		}

		private void dis_lb_DetailIsNext_Click(object sender, EventArgs e)
		{
			this.tabControl_Setting.SelectedTab = this.tabPage_Disp2;
		}

		#endregion

		#endregion


		#region +--  Group(Display2)

		#region +--+--  Methods

		private ReadOnlyCollection<EditTitleInfo> Px_EditTitleInfo
		{
			get
			{
				ListView.ListViewItemCollection col = this.dis_list_Rx.Items;
				EditTitleInfo[] etis = new EditTitleInfo[col.Count];
				int cur = 0;
				foreach(ListViewItem item in col)
				{
					etis[cur++] = (EditTitleInfo)item.Tag;
				}
				return new ReadOnlyCollection<EditTitleInfo>(etis);
			}
			set
			{
				this.dis_list_Rx.Items.Clear();
				if(value != null)
				{
					foreach(EditTitleInfo eti in value)
					{
						ListViewItem item = this.GetItem(eti);
						if(item != null)
						{
							this.dis_list_Rx.Items.Add(item);
						}
					}
				}
			}
		}

		private ListViewItem GetItem(EditTitleInfo info)
		{
			ListViewItem item = new ListViewItem(info.Name);
			item.Tag = info;
			item.Checked = info.Enabled;
			return item;
		}

		private void AppendItem(ListViewItem item, EditTitleInfo info)
		{
			item.Tag = info;
			item.Text = info.Name;
			item.Checked = info.Enabled;
		}

		private bool EditOnDialog(RegexReplaceInfo info, out RegexReplaceInfo newinfo)
		{
			if(this._rrieDialog == null) { this._rrieDialog = new RegexReplaceInfoEditDialog(); }
			return (this._rrieDialog.ShowDialogAndEdit(this, info, out newinfo) == DialogResult.OK);
		}

		#endregion

		#region +--+--  Handler

		private void dis_btn_RxUp_Click(object sender, EventArgs e)
		{
			ListView.SelectedListViewItemCollection sels = this.dis_list_Rx.SelectedItems;
			if(sels.Count > 0)
			{
				ListViewItem item = sels[0];
				int index = item.Index;
				if(index > 0)
				{
					this.dis_list_Rx.Items.Remove(item);
					this.dis_list_Rx.Items.Insert(index - 1, item);
				}
			}
		}

		private void dis_btn_RxDown_Click(object sender, EventArgs e)
		{
			ListView.SelectedListViewItemCollection sels = this.dis_list_Rx.SelectedItems;
			if(sels.Count > 0)
			{
				ListViewItem item = sels[0];
				int index = item.Index;
				if(index < this.dis_list_Rx.Items.Count - 1)
				{
					this.dis_list_Rx.Items.Remove(item);
					this.dis_list_Rx.Items.Insert(index + 1, item);
				}
			}
		}

		private void dis_btn_RxEditEntry_Click(object sender, EventArgs e)
		{
			ListView.SelectedListViewItemCollection sels = this.dis_list_Rx.SelectedItems;
			if(sels.Count > 0)
			{
				ListViewItem item = sels[0];
				EditTitleInfo eti = item.Tag as EditTitleInfo;
				RegexInfo rxi = eti.Entry;
				if(this.EditOnDialog(rxi, out rxi))
				{
					eti = new EditTitleInfo(rxi.Name, eti.Enabled, rxi, eti.Replacer);
					this.AppendItem(item, eti);
				}
			}
		}

		private void dis_btn_RxEditReplace_Click(object sender, EventArgs e)
		{
			ListView.SelectedListViewItemCollection sels = this.dis_list_Rx.SelectedItems;
			if(sels.Count > 0)
			{
				ListViewItem item = sels[0];
				EditTitleInfo eti = item.Tag as EditTitleInfo;
				RegexReplaceInfo rxi = eti.Replacer;
				if(this.EditOnDialog(rxi, out rxi))
				{
					eti = new EditTitleInfo(rxi.Name, eti.Enabled, eti.Entry, rxi);
					this.AppendItem(item, eti);
				}
			}
		}

		private void dis_btn_RxDelete_Click(object sender, EventArgs e)
		{
			ListView.SelectedListViewItemCollection sels = this.dis_list_Rx.SelectedItems;
			if(sels.Count > 0)
			{
				ListViewItem item = sels[0];
				if(MessageBox.Show(this, "ȉ̍ڂ폜܂B\n\nE" + item.Text,
					"ACe폜̊mF", MessageBoxButtons.OKCancel, MessageBoxIcon.Warning, MessageBoxDefaultButton.Button2)
					== DialogResult.OK)
				{
					this.sec_list_Danger.Items.Remove(item);
					item.Tag = null;
				}
			}
		}

		private void dis_btn_RxNew_Click(object sender, EventArgs e)
		{
			EditTitleInfo eti = new EditTitleInfo("<No Title>", false, new RegexInfo(), new RegexReplaceInfo());
			ListViewItem item = this.GetItem(eti);
			this.dis_list_Rx.Items.Add(item);
		}

		private void dis_list_Rx_ItemChecked(object sender, ItemCheckedEventArgs e)
		{
			EditTitleInfo eti = e.Item.Tag as EditTitleInfo;
			if(eti != null)
			{
				eti.Enabled = e.Item.Checked;
				this.AppendItem(e.Item, eti);
			}
		}

		#endregion

		#endregion


		#region +--  Group(Manage)

		private int Px_MaxTabCount
		{
			get { return ParseTextBox(this.man_txt_MaxTabs, 1, 32, 32); }
			set { this.man_txt_MaxTabs.Text = value.ToString(); }
		}
		private int Px_MaxClosedTabs
		{
			get { return ParseTextBox(this.man_txt_maxclosedtabs, 0, 20, 5); }
			set { this.man_txt_maxclosedtabs.Text = value.ToString(); }
		}

		private int Px_MaxHistoryTrace
		{
			get { return ParseTextBox(this.man_txt_maxclosedgfhistory, 0, 10, 5); }
			set { this.man_txt_maxclosedgfhistory.Text = value.ToString(); }
		}
		private string Px_ExternalBrowserPath
		{
			get { return this.man_txt_browserpath.Text; }
			set { this.man_txt_browserpath.Text = value; }
		}

		private LockedTabBehaviors Px_LockedTabBehavior
		{
			get { return LockedTabBehaviors.BoonCompatible; }
			set { }
		}

		#region +--+--  Handler

		/// <summary>OuEU̎Qƃ{^̃nh</summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void man_btn_browserref_Click(object sender, EventArgs e)
		{
			OpenFileDialog ofd = new OpenFileDialog();
			ofd.Multiselect = false;
			ofd.Filter = "exet@C (*.exe)|*.exe";
			ofd.FilterIndex = 0;
			ofd.CheckFileExists = true;
			ofd.FileOk += new CancelEventHandler(ofd_FileOk);
			if(ofd.ShowDialog() == DialogResult.OK)
			{
				this.man_txt_browserpath.Text = ofd.FileName;
			}
			ofd.Dispose();
			ofd = null;
		}
		
		/// <summary>̃Av̋NpXw肵ꍇAbort</summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		void ofd_FileOk(object sender, CancelEventArgs e)
		{
			if(Application.ExecutablePath == (sender as OpenFileDialog).FileName)
			{
                MessageBox.Show("̃t@C͎wł܂B", Application.ProductName);
				e.Cancel = true;
			}
		}

		#endregion

		#endregion

		#endregion


		/// <summary><see cref="System.Windows.Forms.TextBox"/>TextvpeB𐮐lƂĕ]擾܂Bl̏Ɖwł܂B</summary>
		/// <param name="tbox">ǂݏoTextBox</param>
		/// <param name="min">lƂĕ]ۂ̍ŏlB</param>
		/// <param name="max">lƂĕ]ۂ̍őlB</param>
		/// <param name="defval">l̎擾ɎsۂɕԂlB</param>
		/// <returns></returns>
		private static int ParseTextBox(TextBox tbox, int min, int max, int defval)
		{
			int val = 0;
			if(Int32.TryParse(tbox.Text, out val))
			{
				return Math.Min(max, Math.Max(min, val));
			}
			return defval;
        }

	}

}
