using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections.ObjectModel;
using System.Runtime.Serialization;
using System.Xml.Serialization;

namespace Alternative.Controls.Browsers
{

	/// <summary><see cref="TabBrowserControl"/>ŗpłݒłB
	/// <see cref="SealInstance"/>ĂяoꂽƁÃNXׂ̂ẴvpeB͎擾݂̂T|[g܂B</summary>
	/// <seealso cref="TabBrowserControl"/>
	/// <seealso cref="TabBrowserSettingPage"/>
	[Serializable]
	public class TabBrowserSetting : ISerializable
	{
		#region Field

		private bool _sealed = false;

		private int _max_tab_count;
		private int _max_history_trace;
		private int _max_close_tab_history;

		private bool _enable_Rxedit_title;
		private string _editTitleSimpleRemove;
		private ReadOnlyCollection<EditTitleInfo> _editTitleInfo;
		private ReadOnlyCollection<RegexInfo> _trustzone_Match;
		private ReadOnlyCollection<RegexInfo> _untrustzone_Match;
		private int _edit_title_maxlength;

		private string _browser_path;
		private LockedTabBehaviors _locked_tab_behavior;

		private bool _enable_auto_security;
		private SecurityFlags _default_security;
		private SecurityFlags _default_security_trust;
		private SecurityFlags _default_security_untrust;

		private bool _focus_centerclickopen;
		private bool _focus_right_focusedclosed;
		private bool _enable_tabwheel;
		private bool _tabwheel_rotate;
		private TbTabClickAction _ontab_m_down;
		private TbTabClickAction _ontab_l_dclick;
		private TbTabClickAction2 _outtab_l_dclick;
		private TbTabClickAction2 _outtab_wheelclick;
		private TbTabClickAction2 _outtab_r_click;

		private void Assert() { if(this._sealed) { throw new MethodAccessException("TabBrowserSettingCX^X͊ɕύXłȂԂɂȂĂ܂B"); } }

		#endregion

		#region Default Values (Static Constant)

		#region +--  For Management

		/// <summary>^uJƂ̏oő吔B</summary>
		public static int Default_MaxTabCount
		{
			get { return 32; }
		}
		/// <summary>Ōɕ^uŕ闚̍ő吔擾܂</summary>
		public static int Default_MaxHistoryTrace
		{
			get { return 5; }
		}
		/// <summary>Ōɕ^uێő吔ł</summary>
		public static int Default_MaxCloseTabHistory
		{
			get { return 10; }
		}

		/// <summary>bNꂽ^u̐U镑ł
		/// ݂܂Lł͂܂</summary>
		public static LockedTabBehaviors Default_LockedTabBehavior
		{
			get { return LockedTabBehaviors.BoonCompatible; }
		}

		/// <summary>OuEU̎st@C̃tpXł</summary>
		public static string Default_BrowserPath
		{
			get { return String.Empty; }
		}


		#endregion

		#region +--  For Security

		/// <summary>irQ[gɁAURLɂZLeBGAgp邩ǂł
		/// V^uJɎw肳܂</summary>
		public static bool Default_EnableAutoSecurity
		{
			get { return true; }
		}

		/// <summary>V^uJƂ̃ftHg̃ZLeBԂł</summary>
		public static SecurityFlags Default_DefaultSecurity
		{
			get { return SecurityFlags.Script; }
		}
		/// <summary>TrustZoneUrlɃ}b`URL̃TCgŃftHgɎgpZLeBԂł</summary>
		public static SecurityFlags Default_DefaultSecurityTrust
		{
			get { return SecurityFlags.Script | SecurityFlags.AxExecute; }
		}
		/// <summary>UntrustZoneUrlɃ}b`URL̃TCgŃftHgɎgpZLeBԂł</summary>
		public static SecurityFlags Default_DefaultSecurityUntrust
		{
			get { return SecurityFlags.None; }
		}

		/// <summary>MURL\K\ł</summary>
		public static ReadOnlyCollection<RegexInfo> Default_TrustZoneMatch
		{
			get
			{
				return new ReadOnlyCollection<RegexInfo>(new RegexInfo[]{
					new RegexInfo("Niconico Server", @"^https?://[^\.\s]+\.nicovideo.jp/", RegexOptions.IgnoreCase, true),
				});
			}
		}
		/// <summary>ZLeBׂURL\K\ł</summary>
		public static ReadOnlyCollection<RegexInfo> Default_UntrustZoneMatch
		{
			get
			{
				return new ReadOnlyCollection<RegexInfo>(new RegexInfo[]{});
			}
		}

		#endregion

		#region +--  For Display

		/// <summary>K\gpy[W^Cg\ύXsǂ擾܂</summary>
		public static bool Default_EnableRegexEditTitle
		{
			get { return true; }
		}

		/// <summary>Vvȕ\^Cg폜p̕擾܂B</summary>
		public static string Default_EditTitleSimpleRemove
		{
			get { return "]jRjR()"; }
		}

		/// <summary>y[W^Cg\ύX̎̍ŏIIȍő啶</summary>
		public static int Default_EditTitle_MaxLength
		{
			get { return 0; }
		}

		/// <summary>K\ɂ^CgҏWp̐K\jbgꗗ</summary>
		public static ReadOnlyCollection<EditTitleInfo> Default_EditTitleInfos
		{
			get
			{
				return new ReadOnlyCollection<EditTitleInfo>(new EditTitleInfo[]{
					new EditTitleInfo("jRjȐI[폜", true, 
						@"https?://[^\.\s]+\.nicovideo.jp/", RegexOptions.Singleline,
						@"(?<title>.+)(]jRjR(|`)\(.+\)|]NICO NICO DOUGA\(.+\)).*", @"${title}",RegexOptions.Singleline),
				});
			}
		}

		#endregion

		#region +--  For Reaction / Action

		/// <summary>zC[NbNŊJ^uɃtH[JX܂</summary>
		public static bool Default_FocusOnCenterClickOpen
		{
			get { return false; }
		}
		/// <summary>tH[JX̂^uƂɉEփtH[JXڂ܂</summary>
		public static bool Default_FocusRightWhenFocusedClosed
		{
			get { return true; }
		}
		/// <summary>^ũzC[őI^uɕύX܂</summary>
		public static bool Default_EnableTabWheel
		{
			get { return true; }
		}
		/// <summary>^ũzC[őI^uύXƂA[[փ[e[V܂</summary>
		public static bool Default_TabWheelRotate
		{
			get { return false; }
		}
		/// <summary>^uzC[NbN̓</summary>
		public static TbTabClickAction Default_TabMouseDownM
		{
			get { return TbTabClickAction.CloseTab; }
		}
		/// <summary>^u_uNbN̓</summary>
		public static TbTabClickAction Default_TabDoubleClickL
		{
			get { return  TbTabClickAction.LockTab; }
		}
		/// <summary>^ůO_uNbN̓</summary>
		public static TbTabClickAction2 Default_TabEmptyDoubleClickL
		{
			get { return TbTabClickAction2.OpenBlank; }
		}
		/// <summary>^ůOzC[NbN̓</summary>
		public static TbTabClickAction2 Default_TabEmptyWheelClick
		{
			get { return TbTabClickAction2.ShowRecentClosedMenu; }
		}
		/// <summary>^ůOENbNƂ̓</summary>
		public static TbTabClickAction2 Default_TabEmptyClickR
		{
			get { return TbTabClickAction2.ShowPageListMenu; }
		}


		#endregion

		#endregion

		#region Property

		/// <summary>̃CX^XɕύX֎~ɂȂĂ邩ǂ擾܂B
		/// ̒l^̂ƂÃCX^X̃vpeBύXƗO܂B</summary>
		[XmlIgnore]
		public bool IsSealed
		{
			get { return this._sealed; }
		}

		#region +--  For Management

		/// <summary>^uJƂ̏oő吔B</summary>
		public int MaxTabCount
		{
			get { return this._max_tab_count; }
			set { this.Assert(); this._max_tab_count = value; }
		}
		/// <summary>Ōɕ^uŕ闚̍ő吔擾܂</summary>
		public int MaxHistoryTrace
		{
			get { return this._max_history_trace; }
			set { this.Assert(); this._max_history_trace = value; }
		}
		/// <summary>Ōɕ^uێő吔ł</summary>
		public int MaxCloseTabHistory
		{
			get { return this._max_close_tab_history; }
			set { this.Assert(); this._max_close_tab_history = value; }
		}

		/// <summary>bNꂽ^u̐U镑ł
		/// ݂܂Lł͂܂</summary>
		public LockedTabBehaviors LockedTabBehavior
		{
			get { return this._locked_tab_behavior; }
			set { this.Assert(); this._locked_tab_behavior = value; }
		}

		/// <summary>OuEU̎st@C̃tpXł</summary>
		public string BrowserPath
		{
			get { return this._browser_path; }
			set { this.Assert(); this._browser_path = value ?? String.Empty; }
		}

		#endregion

		#region +--  For Security

		/// <summary>irQ[gɁAURLɂZLeBGAgp邩ǂł
		/// V^uJɎw肳܂</summary>
		public bool EnableAutoSecurity
		{
			get { return this._enable_auto_security; }
			set { this.Assert(); this._enable_auto_security = value; }
		}

		/// <summary>V^uJƂ̃ftHg̃ZLeBԂł</summary>
		public SecurityFlags DefaultSecurity
		{
			get { return this._default_security; }
			set { this.Assert(); this._default_security = value; }
		}
		/// <summary>TrustZoneUrlɃ}b`URL̃TCgŃftHgɎgpZLeBԂł</summary>
		public SecurityFlags DefaultSecurityTrust
		{
			get { return this._default_security_trust; }
			set { this.Assert(); this._default_security_trust = value; }
		}
		/// <summary>UntrustZoneUrlɃ}b`URL̃TCgŃftHgɎgpZLeBԂł</summary>
		public SecurityFlags DefaultSecurityUntrust
		{
			get { return this._default_security_untrust; }
			set { this.Assert(); this._default_security_untrust = value; }
		}

		/// <summary>MURL\K\ł</summary>
		[XmlIgnore]
		public ReadOnlyCollection<RegexInfo> TrustZoneMatch
		{
			get { return this._trustzone_Match; }
			set { this.Assert(); this._trustzone_Match = value ?? new ReadOnlyCollection<RegexInfo>(new RegexInfo[0]); }
		}
		/// <summary>ZLeBׂURL\K\ł</summary>
		[XmlIgnore]
		public ReadOnlyCollection<RegexInfo> UntrustZoneMatch
		{
			get { return this._untrustzone_Match; }
			set { this.Assert(); this._untrustzone_Match = value ?? new ReadOnlyCollection<RegexInfo>(new RegexInfo[0]); }
		}

		[XmlElement("TrustZoneMatch")]
		public RegexInfo[] _SerialEntry_TrustZoneMatch
		{
			get { return ColToArr<RegexInfo>(this._trustzone_Match); }
			set { this._trustzone_Match = ArrToCol<RegexInfo>(value); }
		}
		[XmlElement("UntrustZoneMatch")]
		public RegexInfo[] _SerialEntry_UntrustZoneMatch
		{
			get { return ColToArr<RegexInfo>(this._untrustzone_Match); }
			set { this._untrustzone_Match = ArrToCol<RegexInfo>(value); }
		}

		#endregion

		#region +--  For Display

		/// <summary>K\gpy[W^Cg\ύXsǂ擾܂</summary>
		public bool EnableRegexEditTitle
		{
			get { return this._enable_Rxedit_title; }
			set { this.Assert(); this._enable_Rxedit_title = value; }
		}

		/// <summary>Vvȕ\^Cg폜p̕擾܂B</summary>
		public string EditTitleSimpleRemove
		{
			get { return this._editTitleSimpleRemove; }
			set { this.Assert(); this._editTitleSimpleRemove = value; }
		}

		/// <summary>y[W^Cg\ύX̎̍ŏIIȍő啶</summary>
		public int EditTitle_MaxLength
		{
			get { return this._edit_title_maxlength; }
			set { this.Assert(); this._edit_title_maxlength = value; }
		}

		/// <summary>\^CgҏWׂ̐K\Q擾Eݒ肵܂B</summary>
		[XmlIgnore]
		public ReadOnlyCollection<EditTitleInfo> EditTitleInfos
		{
			get { return this._editTitleInfo; }
			set { this.Assert(); this._editTitleInfo = value ?? new ReadOnlyCollection<EditTitleInfo>(new EditTitleInfo[0]); }
		}
		[XmlElement("EditTitleInfos")]
		public EditTitleInfo[] _SerialEntry_EditTitleInfos
		{
			get { return ColToArr<EditTitleInfo>(this._editTitleInfo); }
			set { this._editTitleInfo = ArrToCol<EditTitleInfo>(value); }
		}


		#endregion

		#region +--  For Reaction / Action

		/// <summary>zC[NbNŊJ^uɃtH[JX܂</summary>
		public bool FocusOnCenterClickOpen
		{
			get { return this._focus_centerclickopen; }
			set { this.Assert(); this._focus_centerclickopen = value; }
		}
		/// <summary>tH[JX̂^uƂɉEփtH[JXڂ܂</summary>
		public bool FocusRightWhenFocusedClosed
		{
			get { return this._focus_right_focusedclosed; }
			set { this.Assert(); this._focus_right_focusedclosed = value; }
		}
		/// <summary>^ũzC[őI^uɕύX܂</summary>
		public bool EnableTabWheel
		{
			get { return this._enable_tabwheel; }
			set { this.Assert(); this._enable_tabwheel = value; }
		}
		/// <summary>^ũzC[őI^uύXƂA[[փ[e[V܂</summary>
		public bool TabWheelRotate
		{
			get { return this._tabwheel_rotate; }
			set { this.Assert(); this._tabwheel_rotate = value; }
		}
		/// <summary>^uzC[NbN̓</summary>
		public TbTabClickAction TabMouseDownM
		{
			get { return this._ontab_m_down; }
			set { this._ontab_m_down = value; }
		}
		/// <summary>^u_uNbN̓</summary>
		public TbTabClickAction TabDoubleClickL
		{
			get { return this._ontab_l_dclick; }
			set { this.Assert(); this._ontab_l_dclick = value; }
		}
		/// <summary>^ůO_uNbN̓</summary>
		public TbTabClickAction2 TabEmptyDoubleClickL
		{
			get { return this._outtab_l_dclick; }
			set { this.Assert(); this._outtab_l_dclick = value; }
		}
		/// <summary>^ůOzC[NbN̓</summary>
		public TbTabClickAction2 TabEmptyWheelClick
		{
			get { return this._outtab_wheelclick; }
			set { this.Assert(); this._outtab_wheelclick = value; }
		}
		/// <summary>^ůOENbNƂ̓</summary>
		public TbTabClickAction2 TabEmptyClickR
		{
			get { return this._outtab_r_click; }
			set { this.Assert(); this._outtab_r_click = value; }
		}


		#endregion

		#endregion

		#region Constructor

		/// <summary>
		/// ̃NX̃Rs[pRXgN^łB
		/// SealĂȂԂ̃CX^X쐬܂B
		/// </summary>
		/// <param name="data">Rs[̃f[^</param>
		public TabBrowserSetting(TabBrowserSetting data)
		{
			this._sealed = false;

			this.MaxTabCount = data.MaxTabCount;
			this.MaxHistoryTrace = data.MaxHistoryTrace;
			this.MaxCloseTabHistory = data.MaxCloseTabHistory;

			this.LockedTabBehavior = data.LockedTabBehavior;
			this.BrowserPath = data.BrowserPath;

			this.EnableAutoSecurity = data.EnableAutoSecurity;
			this.DefaultSecurity = data.DefaultSecurity;
			this.DefaultSecurityTrust = data.DefaultSecurityTrust;
			this.DefaultSecurityUntrust = data.DefaultSecurityUntrust;
			this.TrustZoneMatch = data.TrustZoneMatch;
			this.UntrustZoneMatch = data.UntrustZoneMatch;

			this.EnableRegexEditTitle = data.EnableRegexEditTitle;
			this.EditTitleSimpleRemove = data.EditTitleSimpleRemove;
			this.EditTitle_MaxLength = data.EditTitle_MaxLength;
			this.EditTitleInfos = data.EditTitleInfos;

			this.FocusOnCenterClickOpen = data.FocusOnCenterClickOpen;
			this.FocusRightWhenFocusedClosed = data.FocusRightWhenFocusedClosed;
			this.EnableTabWheel = data.EnableTabWheel;
			this.TabWheelRotate = data.TabWheelRotate;

			this.TabMouseDownM = data.TabMouseDownM;
			this.TabDoubleClickL = data.TabDoubleClickL;
			this.TabEmptyDoubleClickL = data.TabEmptyDoubleClickL;
			this.TabEmptyWheelClick = data.TabEmptyWheelClick;
			this.TabEmptyClickR = data.TabEmptyClickR;
		}

		/// <summary>ftHg̃RXgN^B
		/// ׂĂ̏񂪃ftHgl̃CX^X쐬܂B</summary>
		public TabBrowserSetting()
		{
			this.load_default();
		}

		#endregion

		#region Methods

		/// <summary>
		/// ̃CX^X𕕈󂵁Aȍ~ׂ͂ẴvpeBύXȂƂۏႵ܂B
		/// ̃\bhĂяoꂽAvpeBɒlݒ肷ƗO܂B
		/// </summary>
		public void SealInstance()
		{
			this._sealed = true;
		}

		/// <summary>CX^XftHgŏ܂B</summary>
		private void load_default()
		{
			this._sealed = false;

			this.MaxTabCount = Default_MaxTabCount;
			this.MaxHistoryTrace = Default_MaxHistoryTrace;
			this.MaxCloseTabHistory = Default_MaxCloseTabHistory;

			this.LockedTabBehavior = Default_LockedTabBehavior;
			this.BrowserPath = Default_BrowserPath;

			this.EnableAutoSecurity = Default_EnableAutoSecurity;
			this.DefaultSecurity = Default_DefaultSecurity;
			this.DefaultSecurityTrust = Default_DefaultSecurityTrust;
			this.DefaultSecurityUntrust = Default_DefaultSecurityUntrust;
			this.TrustZoneMatch = Default_TrustZoneMatch;
			this.UntrustZoneMatch = Default_UntrustZoneMatch;

			this.EnableRegexEditTitle = Default_EnableRegexEditTitle;
			this.EditTitleSimpleRemove = Default_EditTitleSimpleRemove;
			this.EditTitle_MaxLength = Default_EditTitle_MaxLength;
			this.EditTitleInfos = Default_EditTitleInfos;

			this.FocusOnCenterClickOpen = Default_FocusOnCenterClickOpen;
			this.FocusRightWhenFocusedClosed = Default_FocusRightWhenFocusedClosed;
			this.EnableTabWheel = Default_EnableTabWheel;
			this.TabWheelRotate = Default_TabWheelRotate;

			this.TabMouseDownM = Default_TabMouseDownM;
			this.TabDoubleClickL = Default_TabDoubleClickL;
			this.TabEmptyDoubleClickL = Default_TabEmptyDoubleClickL;
			this.TabEmptyWheelClick = Default_TabEmptyWheelClick;
			this.TabEmptyClickR = Default_TabEmptyClickR;
		}

		#region ISerializable o

		public void GetObjectData(SerializationInfo info, StreamingContext context)
		{
			throw new NotImplementedException();
		}

		#endregion

		#endregion

		#region Static Methods

		private static T[] ColToArr<T>(ReadOnlyCollection<T> col)
		{
			if(col == null) { return null; }
			T[] arr = new T[col.Count];
			int c = 0;
			foreach(T item in col)
			{
				arr[c++] = item;
			}
			return arr;
		}
		private static ReadOnlyCollection<T> ArrToCol<T>(T[] arr)
		{
			if(arr == null) { return null; }
			ReadOnlyCollection<T> col = new ReadOnlyCollection<T>(arr);
			return col;
		}

		#endregion
	}

	/// <summary>^CgҏWׂ̐K\jbg\܂B</summary>
	[Serializable]
	public class EditTitleInfo : ISerializable
	{
		private string _name;
		private bool _enabled;
		private RegexInfo _entry;
		private RegexReplaceInfo _edit;

		/// <summary>RXgN^łB</summary>
		/// <param name="name">̃jbg̖OłB</param>
		/// <param name="enabled">̃jbgLɂ邩ǂ</param>
		/// <param name="entry">ҏWsURLǂ𔻒f鐳K\</param>
		/// <param name="replacer">K\ɂ^CguҏẄׂ̏</param>
		public EditTitleInfo(string name, bool enabled, RegexInfo entry, RegexReplaceInfo replacer)
		{
			this._name = name;
			this._entry = new RegexInfo(name, entry.Pattern, entry.Options, enabled);
			this._edit = new RegexReplaceInfo(name, replacer.Pattern, replacer.Replace, replacer.Options, enabled);
			this._enabled = enabled;
		}
		/// <summary>RXgN^łB</summary>
		/// <param name="name">̃jbg̖OłB</param>
		/// <param name="enabled">̃jbgLɂ邩ǂ</param>
		/// <param name="entryMatch">URLAҏWsׂǂ𔻒f鐳K\</param>
		/// <param name="entryOptions"><paramref name="entryMatch"/>Kpۂ̐K\IvV</param>
		/// <param name="replaceMatch">^CguҏẄׂ̐K\}b`p^[</param>
		/// <param name="replacePattern">^CguҏW̐K\uo̓p^[</param>
		/// <param name="replaceOptions"><paramref name="replacePattern"/>Kpۂ̐K\IvV</param>
		public EditTitleInfo(string name, bool enabled, string entryMatch, RegexOptions entryOptions, string replaceMatch, string replacePattern, RegexOptions replaceOptions)
		{
			this._name = name;
			this._enabled = enabled;
			this._entry = new RegexInfo(name, entryMatch, entryOptions, enabled);
			this._edit = new RegexReplaceInfo(name, replaceMatch, replacePattern, replaceOptions, enabled);
		}

		/// <summary>RXgN^łBftHgRXgN^XmlSerializer痘p邽߂ɗpӂĂ܂B</summary>
		public EditTitleInfo()
		{
			this._name = "<No Title>";
			this._entry = null;
			this._edit = null;
			this._enabled = false;
		}

		/// <summary>̃jbg\O擾Eݒ肵܂B</summary>
		public string Name
		{
			get { return this._name; }
			set
			{
				this._name = value;
				if(this._entry != null) { this._entry.Name = value; }
				if(this._edit != null) { this._edit.Name = value; }
			}
		}

		/// <summary>̃jbgLǂ擾Eݒ肵܂B</summary>
		public bool Enabled
		{
			get { return this._enabled; }
			set
			{
				this._enabled = value; 
				if(this._entry != null) { this._entry.Enabled = value; }
				if(this._edit != null) {this._edit.Enabled = value;}
			}
		}

		/// <summary>URLAҏWsׂǂ𔻒f鐳K\擾Eݒ肵܂B</summary>
		public RegexInfo Entry
		{
			get { return this._entry; }
			set { this._entry = value; }
		}
		/// <summary>ۂ̃^CguҏWsׂ̐K\擾Eݒ肵܂B</summary>
		public RegexReplaceInfo Replacer
		{
			get { return this._edit; }
			set { this._edit = value; }
		}


		#region ISerializable o

		public void GetObjectData(SerializationInfo info, StreamingContext context)
		{
			throw new NotImplementedException();
		}

		#endregion
	}

}