﻿using System;
using System.Drawing;
using System.ComponentModel;
using System.Windows.Forms;
using System.Text.RegularExpressions;

namespace Alternative.Controls.Browsers
{
	/// <summary><see cref="RegexReplaceInfo"/>を編集する為のダイアログです。</summary>
	internal partial class RegexReplaceInfoEditDialog : Form
	{
		private RegexReplaceInfo _info;

		/// <summary>Constructor</summary>
		public RegexReplaceInfoEditDialog()
		{
			this._info = null;
			InitializeComponent();
		}

		/// <summary>このメソッド以外のオーバーロードメソッドを使用しないでください。
		/// ダイアログで、正規表現置換パターンを編集環境を表示します。</summary>
		/// <param name="owner">ダイアログのモーダルオーナー</param>
		/// <param name="baseInfo">編集するRegexReplaceInfo</param>
		/// <param name="newInfo">編集されたRegexReplaceInfo。戻り値がDialogResult.OK以外の場合、nullが格納されます。</param>
		/// <returns></returns>
		public DialogResult ShowDialogAndEdit(IWin32Window owner, RegexReplaceInfo baseInfo, out RegexReplaceInfo newInfo)
		{
			if(baseInfo == null) { throw new ArgumentNullException(); }
			this._info = new RegexReplaceInfo(baseInfo);
			newInfo = null;
			this.Attach();

			DialogResult dl = base.ShowDialog(owner);
			if(dl == DialogResult.OK)
			{
				newInfo = this._info;
			}
			this._info = null;
			return dl;
		}

		/// <summary>このメソッドは使用できません。<see cref="ShowDialogAndEdit"/>を使用してください。</summary>
		/// <returns>例外が発生します。</returns>
		public new DialogResult ShowDialog() { throw new InvalidOperationException(); }
		/// <summary>このメソッドは使用できません。<see cref="ShowDialogAndEdit"/>を使用してください。</summary>
		/// <param name="owner">使用しません。</param>
		/// <returns>例外が発生します。</returns>
		public new DialogResult ShowDialog(IWin32Window owner) { throw new InvalidOperationException(); }


		private void btnOK_Click(object sender, EventArgs e)
		{
			string err = null;

			this._info.Name = (this.txtName.Text.Length == 0) ? "<No Title>" : this.txtName.Text;
			this._info.Pattern = this.txtValue2.Text;
			this._info.Replace = this.txtValue3.Text;

			if(!RegexReplaceInfo.CheckRegexInfo(this._info, out err))
			{
                MessageBox.Show(err, Application.ProductName);
			}
			else
			{
				this.DialogResult = DialogResult.OK;
			}
		}

		private void btnCancel_Click(object sender, EventArgs e)
		{
			this._info = null;
			this.txtValue2.Text = String.Empty;
			this.txtValue3.Text = String.Empty;

			this.DialogResult = DialogResult.Cancel;
		}

		private void btnTest_Click(object sender, EventArgs e)
		{
			Regex rxMatch;
			string msg;

			if(!RegexInfo.TryCreateRegex(this.txtValue2.Text, out rxMatch))
			{
				msg = "マッチパターンの解釈に失敗しました。";
			}
			else
			{
				try
				{
					msg = rxMatch.Replace(this.txtTestTitle.Text, this.txtValue3.Text);
				}
				catch(Exception exc)
				{
					msg = "正規表現の適用中にエラーが発生しました。\n\n" + exc.Message;
				}
			}
			if(msg.Length > 60) { msg = msg.Substring(0,58) + ".."; }
            MessageBox.Show(msg, Application.ProductName);
		}


		private void txtValue2_Validating(object sender, CancelEventArgs e)
		{
			string message;
			if(!RegexInfo.CheckRegexPattern(this.txtValue2.Text, out message))
			{
				this.lbCheckMatch.BackColor = Color.Red;
			}
			else
			{
				this.lbCheckMatch.BackColor = Color.LightGreen;
			}
		}

		private void lbCheckMatch_Click(object sender, EventArgs e)
		{
		}


		private void Attach()
		{
			this.txtName.Text = this._info.Name;
			this.txtValue2.Text = this._info.Pattern;
			this.txtValue3.Text = this._info.Replace;
		}


	}
}
