using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using System.Diagnostics;

namespace Alternative.Controls.Browsers
{
    using Alternative.Win32;

	/// <summary>WebBrowserExŗpZLeB}l[W[łB
	/// IInternetSecurityManager̃wp[NXłB</summary>
	public class InternetSecurityManager
		: IInternetSecurityManager, IServiceProviderForIISM
	{
		#region Const

		/// <summary>
		/// CurrentZonevpeBl̒`̈B
		/// ftHgiǂ̃][ɂĂȂƁj\B
		/// </summary>
		public const int SEC_INDEX_DEF = 0;
		/// <summary>
		/// CurrentZonevpeBl̒`̈B
		/// ݒ肪LłȂA[U[ɂݒɌŒ肵Ă邱Ƃ\B
		/// </summary>
		public const int SEC_INDEX_MY = 1;
		/// <summary>
		/// CurrentZonevpeBl̒`̈B
		/// ZoneAɑĂ邱Ƃ\B
		/// </summary>
		public const int SEC_INDEX_A = 2;
		/// <summary>
		/// CurrentZonevpeBl̒`̈B
		/// ZoneBɑĂ邱Ƃ\B
		/// </summary>
		public const int SEC_INDEX_B = 3;

        /// <summary>ׂĂ̕Ƀ}b`ȂK\p^[łB</summary>
		public const string NO_MATCH_PATTERN = @"[^\s\S]";

		#endregion

		#region Field

		private SecurityFlags[] _security;
		private bool _autoSecurity = true;

		private int _current_zone_key = SEC_INDEX_DEF;
		private ReadOnlyCollection<RegexInfo> _urlZone_matchA;
		private ReadOnlyCollection<RegexInfo> _urlZone_matchB;

		#endregion

		#region Constructor

		/// <summary>
		/// ̃NX̃RXgN^łBCX^X쐬Anꂽ<see cref="System.Windows.Forms.WebBrowser"/>ActiveXInstanceɃA^b`܂B
		/// </summary>
		/// <param name="browserCore">̃IuWFNg𗘗pWebBrowserIServiceProviderActiveXRA</param>
		public InternetSecurityManager(object browserCore)
		{
			this._security = new SecurityFlags[] { SecurityFlags.None, SecurityFlags.None, SecurityFlags.None, SecurityFlags.None };
			this._urlZone_matchA = null;
			this._urlZone_matchB = null;
			this._autoSecurity = true;
			this._current_zone_key = SEC_INDEX_DEF;

			IServiceProvider pISP = browserCore as IServiceProvider;
			if(pISP == null) { throw new ArgumentException("InternetSecurityManager::ctorɓnꂽsłB\ñIuWFNgIServiceProvider𗘗pł܂B"); }
			object obj = null;
			pISP.QueryService(ref ComDefines.SID_SProfferService, ref ComDefines.IID_IProfferService, out obj);
			IProfferService IProf = obj as IProfferService;
			int cookie = 0;
			IProf.ProfferService(ref ComDefines.IID_IInternetSecurityManager, this as IServiceProviderForIISM, ref cookie);
		}

		#endregion


		#region Properties

		/// <summary>
		/// ݗpĂ][擾܂B
		/// ĺÃNXconsto[łSEC_INDEX_`ɑΉĂ܂B
		/// </summary>
		public int CurrentZone
		{
			get { return this._current_zone_key; }
		}

		/// <summary>
		/// URL𗘗pĎŃ][𔻒fĐݒ肷邩ǂ擾Eݒ肵܂B
		/// ̒lfalse̎ANavigateToPagesĂZLeB̏ԂύX܂B
		/// </summary>
		/// <remarks>
		/// ̒lfalsȅꍇACurrentZonevpeB<see cref="SEC_INDEX_DEF"/>Ԃ܂B
		/// ̒lύXĂACurrentZone͒ɕύX킯ł͂܂B
		/// <see cref="NavigateToPage"/>Ăяoꂽɔf܂B
		/// </remarks>
		public bool AutoSecurity
		{
			get { return this._autoSecurity; }
			set { this._autoSecurity = value; }
		}
		/// <summary>
		/// <see cref="CurrentZone"/><see cref="SEC_INDEX_MY"/>̏ꍇɗp<see cref="SecurityFlags"/>̐ݒ擾Eݒ肵܂B
		/// AutoSecurityfalse̎ɓKpݒł邱ƂӖ܂B
		/// </summary>
		public SecurityFlags MySecurityFlags
		{
			get { return this._security[SEC_INDEX_MY]; }
			set { this._security[SEC_INDEX_MY] = value; }
		}
		/// <summary>
		/// ZLeB̎ݒ莞ɁAׂẴ][`ɓKȂꍇɎgp<see cref="SecurityFlags"/>擾Eݒ肵܂B
		/// </summary>
		public SecurityFlags DefaultSecurityFlags
		{
			get { return this._security[SEC_INDEX_DEF]; }
			set { this._security[SEC_INDEX_DEF] = value; }
		}
		/// <summary>
		/// ZLeB̎ݒ莞ɁAZoneȀɓKꍇɎgp<see cref="SecurityFlags"/>擾Eݒ肵܂B
		/// ZoneAZoneBD揇ʂɂ܂B
		/// </summary>
		public SecurityFlags SecurityFlagsZoneA
		{
			get { return this._security[SEC_INDEX_A]; }
			set { this._security[SEC_INDEX_A] = value; }
		}
		/// <summary>
		/// ZLeB̎ݒ莞ɁAZoneB̏ɓKꍇɎgp<see cref="SecurityFlags"/>擾Eݒ肵܂B
		/// ZoneAZoneBD揇ʂɂ܂B
		/// </summary>
		public SecurityFlags SecurityFragsZoneB
		{
			get { return this._security[SEC_INDEX_B]; }
			set { this._security[SEC_INDEX_B] = value; }
		}

		/// <summary>
		/// ZoneA̒`擾Eݒ肵܂BURL񂪁ÃvpeBl̐K\Ƀ}b`邩ǂfłB
		/// Al<see cref="System.String.Empty"/>̏ꍇASׂ̈ɂURLZoneAɃ}b`ȂȂ܂B
		/// </summary>
		public ReadOnlyCollection<RegexInfo> UrlZoneA
		{
			get { return this._urlZone_matchA; }
			set { this._urlZone_matchA = value; }
		}
		/// <summary>
		/// ZoneB̒`擾Eݒ肵܂BURL񂪁ÃvpeBl̐K\Ƀ}b`邩ǂfłB
		/// Al<see cref="System.String.Empty"/>̏ꍇASׂ̈ɂURLZoneBɃ}b`ȂȂ܂B
		/// </summary>
		public ReadOnlyCollection<RegexInfo> UrlZoneB
		{
			get { return this._urlZone_matchB; }
			set { this._urlZone_matchB = value; }
		}

		#endregion

		#region Methods

		/// <summary>URLɂčœKȃ][𔻒fă][ݒ肵܂B
		/// WebBrowsery[WJڂۂɌĂяoĂB</summary>
		/// <param name="url">][̔fƂȂURL</param>
		public void NavigateToPage(string url)
		{
			// Original Zone
			if(!this.AutoSecurity) { this._current_zone_key = SEC_INDEX_MY; return; }
			if(this._urlZone_matchA != null)
			{
				foreach(RegexInfo ri in this.UrlZoneA)
				{
					if(Regex.IsMatch(url, ri.Pattern, ri.Options))
					{
						this._current_zone_key = SEC_INDEX_A; return;
					}
				}
			}
			if(this._urlZone_matchB != null)
			{
				foreach(RegexInfo ri in this.UrlZoneB)
				{
					if(Regex.IsMatch(url, ri.Pattern, ri.Options))
					{
						this._current_zone_key = SEC_INDEX_B; return;
					}
				}
			}
			this._current_zone_key = SEC_INDEX_DEF;
		}

		#endregion

		#region IInternetSecurityManager o

		int IInternetSecurityManager.ProcessUrlAction(string pwszUrl, int dwAction, out byte pPolicy, int cbPolicy, byte pContext, int cbContext, int dwFlags, int dwReserved)
		{
			pPolicy = 0;
			int key = this.CurrentZone;
			if(URLACTION.SCRIPT_MIN <= dwAction && dwAction <= URLACTION.SCRIPT_MAX)
			{
				if((this._security[key] & SecurityFlags.Script) == SecurityFlags.Script)
				{
					pPolicy = URLPOLYCY.ALLOW;
					return ComDefines.S_OK;
				}
				else
				{
					pPolicy = URLPOLYCY.DISALLOW;
					return ComDefines.S_OK;
				}
			}
			else if(URLACTION.JAVA_MIN <= dwAction && dwAction <= URLACTION.JAVA_MAX)
			{
				if((this._security[key] & SecurityFlags.JAVA) == SecurityFlags.JAVA)
				{
					pPolicy = URLPOLYCY.ALLOW;
					return ComDefines.S_OK;
				}
				else
				{
					pPolicy = URLPOLYCY.DISALLOW;
					return ComDefines.S_OK;
				}
			}
			else if(URLACTION.ACTIVEX_RUN == dwAction)
			{
				if((this._security[key] & SecurityFlags.AxExecute) == SecurityFlags.AxExecute)
				{
					pPolicy = URLPOLYCY.ALLOW;
					return ComDefines.S_OK;
				}
				else
				{
					pPolicy = URLPOLYCY.DISALLOW;
					return ComDefines.S_OK;
				}
			}
			else if(dwAction == URLACTION.DOWNLOAD_UNSIGNED_ACTIVEX || dwAction == URLACTION.DOWNLOAD_SIGNED_ACTIVEX)
			{
				if((this._security[key] & SecurityFlags.AxDownload) == SecurityFlags.AxDownload)
				{
					pPolicy = URLPOLYCY.ALLOW;
					return ComDefines.S_OK;
				}
				else
				{
					pPolicy = URLPOLYCY.DISALLOW;
					return ComDefines.S_OK;
				}
			}
			else if(dwAction == URLACTION.BEHAVIOR_RUN)
			{
				pPolicy = URLPOLYCY.DISALLOW;
				return ComDefines.S_OK;
			}
			return ComDefines.INET_E_DEFAULT_ACTION;
		}
		int IInternetSecurityManager.MapUrlToZone(string pwszUrl, out int pdwZone, int dwFlags)
		{
			pdwZone = 0;
			return ComDefines.INET_E_DEFAULT_ACTION;
		}
		int IInternetSecurityManager.GetSecuritySite(IInternetSecurityMgrSite pSite)
		{
			return ComDefines.INET_E_DEFAULT_ACTION;
		}
		int IInternetSecurityManager.GetSecurityId(string pwszUrl, byte[] pbSecurityId, ref uint pcbSecurityId, uint dwReserved)
		{
			return ComDefines.INET_E_DEFAULT_ACTION;
		}
		int IInternetSecurityManager.SetSecuritySite(IInternetSecurityMgrSite pSite)
		{
			return ComDefines.INET_E_DEFAULT_ACTION;
		}
		int IInternetSecurityManager.QueryCustomPolicy(string pwszUrl, ref Guid guidKey, byte ppPolicy, int pcbPolicy, byte pContext, int cbContext, int dwReserved)
		{
			return ComDefines.INET_E_DEFAULT_ACTION;
		}
		int IInternetSecurityManager.SetZoneMapping(int dwZone, string lpszPattern, int dwFlags)
		{
			return ComDefines.INET_E_DEFAULT_ACTION;
		}
		int IInternetSecurityManager.GetZoneMappings(int dwZone, out System.Runtime.InteropServices.ComTypes.IEnumString ppenumString, int dwFlags)
		{
			ppenumString = null;
			return ComDefines.INET_E_DEFAULT_ACTION;
		}

		#endregion

		#region IServiceProviderForIISM o

		int IServiceProviderForIISM.QueryService(ref Guid guidService, ref Guid riid, out IInternetSecurityManager ppvObject)
		{
			ppvObject = null;
			if(guidService == ComDefines.IID_IInternetSecurityManager)
			{
				ppvObject = this as IInternetSecurityManager;
				return ComDefines.S_OK;
			}
			return ComDefines.E_NOINTERFACE;
		}

		#endregion
	}


	/// <summary>
	/// InternetSecurityManagerɂċANV\܂BrbgtB[h^̃tOłB
	/// </summary>
	[Serializable]
	[Flags]
	public enum SecurityFlags : uint
	{
		/// <summary>
		/// Script,JAVA,ActiveX̃ANV͖ɂȂ܂
		/// </summary>
		None = 0x00000000,
		/// <summary>
		/// Script̎s܂
		/// </summary>
		Script = 0x00000FFF,
		/// <summary>
		/// JAVA̎s܂
		/// </summary>
		JAVA = 0x0000F000,
		/// <summary>
		/// ActiveXvOC̎s܂
		/// </summary>
		AxExecute = 0x00FF0000,
		/// <summary>
		/// ActiveXvOC̃_E[h܂
		/// </summary>
		AxDownload = 0x0F000000,
	}
}
