using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Web;
using mshtml;

namespace Alternative.Controls.Browsers
{
    using Alternative.Functions;

	/// <summary>jRjRWebTCgHTMLҏWs߂<see cref="Alternative.Functions.IHtmlDocumentEditor"/>̎񋟂܂B</summary>
	class NicovideoDownloadHtmlEditor : Alternative.Functions.IHtmlDocumentEditor
	{
        const string Key_EditedAttribute = "Alternative Editor";
		const string Value_EditedAttribute = "nicovideo.edt";
		const string Format_Downlink = "<a href=\"{0}\" class=\"boon_download_link\" style=\"font-size:small;\">[Download]</a>";
		
		Regex RxEditHostMatch;

		private HtmlEditTrigger _trigger;

		/// <summary>RXgN^łB</summary>
		public NicovideoDownloadHtmlEditor()
		{
			
			this.RxEditHostMatch = new Regex(
				"^http://",
				 RegexOptions.IgnoreCase | RegexOptions.Compiled | RegexOptions.Singleline);

			this._trigger = HtmlEditTrigger.OnDownloadCompleted;
		}

		#region IHtmlDocumentEditor o

		public bool IsSupported(string url, HtmlEditTrigger trigger)
		{
			if((trigger | this._trigger) != HtmlEditTrigger.NotDefined)
			{
				return this.RxEditHostMatch.IsMatch(url);
			}
			else return false;
		}

		public bool EditDocument(string url, HtmlEditTrigger trigger, IHTMLDocument2 document)
		{
			if(((trigger & this._trigger) != HtmlEditTrigger.NotDefined) && this.RxEditHostMatch.IsMatch(url))
			{
				IHTMLElementCollection links = document.links as IHTMLElementCollection;
				try
				{
					foreach(IHTMLElement e in links)
					{
						try
						{
							if((!String.IsNullOrEmpty(e.innerHTML))
								&& (!e.innerHTML.StartsWith("<IMG ", StringComparison.CurrentCultureIgnoreCase)))
							{
								string editkey = e.getAttribute(Key_EditedAttribute, 0) as String;
								if(String.IsNullOrEmpty(editkey))
								{
									NicoVideoPageUrl watchUrl;
									string href = e.getAttribute("href", 0) as String ?? String.Empty;

									if(NicoVideoPageUrl.TryCreate(href, out watchUrl))
									{
										e.setAttribute(Key_EditedAttribute, Value_EditedAttribute, 0);
										string title = e.innerText;
										string downlink = CommonRequestProvider.CreateRequest(
											watchUrl.Url,
											RequestParams.DisplayTitle.Make(title));
										downlink = String.Format(Format_Downlink, downlink);
										e.insertAdjacentHTML("afterEnd", downlink);
									}
								}
							}
						}
						catch(Exception ex) { System.Diagnostics.Trace.WriteLine("NicovideoDownloadHtmlEditor::EditDocument\n" + ex.Message); }
						finally { Marshal.ReleaseComObject(e); }
					}
				}
				finally { Marshal.ReleaseComObject(links); }
			}
			return true;
		}

		private string make_urlAction_param(string key, string value)
		{
			const string tmp = "{0}={1}";
			if(String.IsNullOrEmpty(key)) { throw new ArgumentNullException(); }
			if(value == null) { value = String.Empty; }

			return String.Format(tmp, key, HttpUtility.UrlEncode(value));
		}

		#endregion

	}
}
