using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text.RegularExpressions;
using System.Runtime.Serialization;
using System.Windows.Forms;

namespace Alternative.Controls.Browsers
{
    using Alternative.Win32;

    #region Travel Log Management

	/// <summary>
	/// uEŨirQ[V̗Ǘ܂B<see cref="ITravelLogStg"/>ŕ\COMIuWFNg̃bpNXłB
	/// </summary>
	public class ExHtmlHistory : IDisposable
	{
		#region Field
		private ITravelLogStg _travelLog;
		#endregion

		#region Constructor / Destructor

		/// <summary>gbNWebBrowserRg[w肵ẴNX쐬܂</summary>
		/// <param name="browser">̃IuWFNgɓo^uEUIuWFNgB</param>
		/// <exception cref="NotSupportedException">gxOCOMIuWFNg𗘗płȂꍇɔ܂B</exception>
		public ExHtmlHistory(WebBrowserAx browser)
		{
			if(browser == null) { throw new NullReferenceException(); }
			Guid SID_STravelLogCursor = ComDefines.SID_STravelLogCursor;
			Guid IID_ITravelLogStg = ComDefines.IID_ITravelLogStg;
			IServiceProvider pISP = null;
			object ppvObject = null;

			pISP = (IServiceProvider)browser.Application;
			pISP.QueryService(ref SID_STravelLogCursor, ref IID_ITravelLogStg, out ppvObject);
			Marshal.ReleaseComObject(pISP);
			pISP = null;

			if(ppvObject != null) { this._travelLog = (ITravelLogStg)ppvObject; }
			else { throw new NotSupportedException("gxŐ@\pł܂B"); }
		}

		~ExHtmlHistory()
		{
			this.Dispose(false);
		}

		#endregion

		#region Public Methods

		/// <summary>̈ꗗ擾܂B</summary>
		/// <param name="flags">擾ΏۂƂȂ闚͈̔͂\tOB</param>
		/// <param name="maxEntries">擾闚̍ő吔B</param>
		/// <returns>TravelLogEntry̔zAsꍇnullԂ܂B</returns>
		public TravelLogEntry[] EnumEntries(TLENUMF flags, int maxEntries)
		{
			IEnumTravelLogEntry pTLEnum = null;
			ITravelLogEntry pEntry = null;
			List<TravelLogEntry> history = null;
			int tmp = 0;
			try
			{
				if(this._travelLog.EnumEntries(flags, ref pTLEnum) == ComDefines.S_OK)
				{
					history = new List<TravelLogEntry>(maxEntries);
					while(maxEntries > history.Count)
					{
						int res = pTLEnum.Next(1, out pEntry, out tmp);
						if(pEntry == null) { break; }
						history.Add(new TravelLogEntry(pEntry));
						while(Marshal.ReleaseComObject(pEntry) > 0) ;
					}
					tmp = 0;
				}
				else { tmp = -1; }
			}
			catch(Exception e)
			{
				tmp = -1;
				InnerLogger.LOut("ExHtmlEntry::EnumEntries / " + e.Message, InnerLogger.ErrorLevel.L2_WARNING);
			}
			finally
			{
				if(pTLEnum != null) { while(Marshal.ReleaseComObject(pTLEnum) > 0) ;}
				if(pEntry != null) { while(Marshal.ReleaseComObject(pEntry) > 0) ;}
			}
			return (history != null && tmp >= 0) ? history.ToArray() : null;
		}

		/// <summary>w肵̈ʒuɈړ܂</summary>
		/// <param name="offset">߂͕̒lAiޕ͐̒l</param>
		public void TravelTo(int offset)
		{
			ITravelLogEntry pEntry = null;
			try
			{
				this._travelLog.GetRelativeEntry(offset, out pEntry);
				if(pEntry != null) { this._travelLog.TravelTo(pEntry); }
			}
			finally { if(pEntry != null) { while(Marshal.ReleaseComObject(pEntry) > 0);} }
		}

		/// <summary>ɕێĂvfA@w肵Ď擾܂BsꍇA-1ԂƂ܂B</summary>
		/// <param name="flags">@\<see cref="TLENUMF"/>tOB</param>
		/// <returns>ɂvf̐B</returns>
		public int GetCount(TLENUMF flags)
		{
			int entries = 0;
			if(this._travelLog.GetCount(flags, out entries) != ComDefines.S_OK) { entries = -1; }
			return entries;
		}



		/// <summary>uEUɃgxO\܂B
		/// ̃\bh́AuEU<see cref="WebBrowserAx.DocumentCompleted"/>CxgʒmāAgxO쐬ꂽł̂ݐ܂B
		/// ̃\bȟĂяo<see cref="RestoreWindowDelayedAction"/>ɈCׂłB</summary>
		/// <param name="data">f[^i[<see cref="ClosedTabData"/></param>
		/// <param name="restoreSize">闚̐̍ől</param>
		/// <exception cref="InvalidOperationException"><see cref="Alternative.Controls.Browsers.WebBrowserAx.DocumentCompleted"/>̏ʒmȑOŌĂяoꂽꍇɔ܂B</exception>
		/// <exception cref="ArgumentException"><paramref name="restoreSize"/>̒ll̏ꍇɔ܂B</exception>
		internal void RestoreEntry(ClosedTabData data, int restoreSize)
		{
			if(restoreSize < 0) { throw new ArgumentException("restoreSize̒llłB"); }
			if(restoreSize == 0) { return; }
			if(data == null || String.IsNullOrEmpty(data.Url)) { return; }

			int entries = 0;
			ITravelLogEntry cursor = null;

			// Throw on Error in COM.
			if(this._travelLog.GetCount(TLENUMF.TLEF_ABSOLUTE | TLENUMF.TLEF_INCLUDE_UNINVOKEABLE, out entries) != ComDefines.S_OK) { goto LB_InvalidOperation; }

			if(entries > 0)
			{
				ITravelLogEntry lastone = null;
				try
				{
					this._travelLog.GetRelativeEntry(0, out cursor);
					this._travelLog.GetRelativeEntry(-1, out lastone);
					if(lastone != null && cursor != null)
					{
						if(data.ForeLog.Length > 0) { this.restoreForelog(data.ForeLog, restoreSize, cursor); }
						if(data.BackLog.Length > 0) { this.restoreBacklog(data.BackLog, restoreSize, cursor); }
						this._travelLog.RemoveEntry(lastone);
					}
				}
				catch(Exception e) { InnerLogger.LOut("RestoreEntry:  " + e.Message, InnerLogger.ErrorLevel.L2_WARNING); }
				finally
				{
					if(cursor != null) { while(Marshal.ReleaseComObject(cursor) > 0); cursor = null; }
					if(lastone != null) { while(Marshal.ReleaseComObject(lastone) > 0); lastone = null; }
				}
			}
			return;
		// LABEL ::  On Error  //
		LB_InvalidOperation:
			if(cursor != null) { Marshal.ReleaseComObject(cursor); cursor = null; }
			throw new InvalidOperationException();
		}

		/// <summary>O̕B</summary>
		/// <param name="forelog">ClosedTabData.ForeLog</param>
		/// <param name="maxCount">ő啜闚̍őGg[</param>
		/// <param name="currentEntry">̊̕Gg[B݂̈ʒũGg[n܂B</param>
		private void restoreForelog(TravelLogEntry[] forelog, int maxCount, ITravelLogEntry currentEntry)
		{
			ITravelLogEntry pCurrent = null;
			ITravelLogEntry pEntry = null;
			int limit = Math.Min(maxCount, forelog.Length);
			try
			{
				for(int i = 0; i < limit; ++i)
				{
					this._travelLog.CreateEntry(forelog[i].Url, forelog[i].Title, i == 0 ? currentEntry : pCurrent, false, out pEntry);
					if(pCurrent != null) { while(Marshal.ReleaseComObject(pCurrent) > 0); pCurrent = null; }
					pCurrent = pEntry;
					pEntry = null;
				}
			}
			finally
			{
				if(pEntry != null) { Marshal.ReleaseComObject(pEntry); }
				if(pCurrent != null) { Marshal.ReleaseComObject(pCurrent); }
			}
		}
		/// <summary>̕B</summary>
		/// <param name="backlog">ClosedTabData.BackLog</param>
		/// <param name="maxCount">ő啜闚̍őGg[</param>
		/// <param name="currentEntry">̊̕Gg[B݂̈ʒũGg[n܂B</param>
		private void restoreBacklog(TravelLogEntry[] backlog ,int maxCount, ITravelLogEntry currentEntry)
		{
			ITravelLogEntry pCurrent = null;
			ITravelLogEntry pEntry = null;
			int limit = Math.Min(maxCount, backlog.Length);
			try
			{
				for(int i = 0; i < limit; ++i)
				{
					this._travelLog.CreateEntry(backlog[i].Url, backlog[i].Title, i == 0 ? currentEntry : pCurrent, true, out pEntry);
					if(pCurrent != null) { while(Marshal.ReleaseComObject(pCurrent) > 0); pCurrent = null; }
					pCurrent = pEntry;
					pEntry = null;
				}
			}
			finally
			{
				if(pEntry != null) { Marshal.ReleaseComObject(pEntry); }
				if(pCurrent != null) { Marshal.ReleaseComObject(pCurrent); }
			}
		}

		#region IDisposable o

		/// <summary>̃A}l[W\[XJ܂B</summary>
		public void Dispose()
		{
			this.Dispose(true);
		}

		/// <summary>̃A}l[W\[XJ܂B</summary>
		/// <param name="disposing">̃\bht@CiCUĂяoꂽꍇfalsen܂B</param>
		protected virtual void Dispose(bool disposing)
		{
			if(disposing)
			{
				GC.SuppressFinalize(this);
			}

			// Release unmanaged resource
			if(this._travelLog != null)
			{
				while(Marshal.ReleaseComObject(this._travelLog) > 0) ;
				this._travelLog = null;
			}
		}

		#endregion

		#endregion

		#region Private Methods

		/// <summary>ẅʒuɍ쐬܂</summary>
		/// <param name="url">쐬闚Ɋ֘AtURL</param>
		/// <param name="title">쐬闚Ɋ֘Aty[W^Cg</param>
		/// <param name="travelLogEntry">ƂȂGg[</param>
		/// <param name="prepend">̑Oɍ쐬ꍇtrueAɍ쐬ꍇfalse</param>
		/// <returns>V쐬ꂽGg[ւ̎Q</returns>
		private ITravelLogEntry InsertEntry(string url, string title, ITravelLogEntry travelLogEntry, bool prepend)
		{
			ITravelLogEntry TLEntry = null;
			this._travelLog.CreateEntry(url, title, travelLogEntry, prepend, out TLEntry);
			return TLEntry;
		}

		/// <summary>݈ʒuɂ擾܂B</summary>
		/// <param name="offset">݂̃Gg[ɂint32lB߂͕l</param>
		/// <returns>擾vf</returns>
		private ITravelLogEntry GetRelativeEntry(int offset)
		{
			ITravelLogEntry TLEntry = null;
			this._travelLog.GetRelativeEntry(offset, out TLEntry);
			return TLEntry;
		}

		/// <summary>Xgw肵vf폜܂B</summary>
		/// <param name="travelLogEntry">폜vf</param>
		private void RemoveEntry(ITravelLogEntry travelLogEntry)
		{
			this._travelLog.RemoveEntry(travelLogEntry);
		}

		#endregion

	}

	/// <summary>uEȔ̗ێNXłB</summary>
	/// <remarks><see cref="ITravelLogEntry"/>̓A}l[WhCOMIuWFNgłׁÃNXɃXgAėp܂B</remarks>
	[Serializable]
	public class TravelLogEntry : ISerializable
	{
		#region Field

		private string _title;
		private string _url;

		#endregion

		#region Constructors

		/// <summary>̃NX̃RXgN^łB̗쐬܂B</summary>
		public TravelLogEntry() : this(String.Empty, String.Empty) { }

		/// <summary>̃NX̃RXgN^łB^CgURLw肵ėvf쐬܂</summary>
		/// <param name="title">y[W̃^Cg</param>
		/// <param name="url">y[WURL</param>
		public TravelLogEntry(string title, string url)
		{
			this._title = title;
			this._url = url;
		}

		/// <summary>̃NX̃RXgN^łBA}l[Wȗ񂩂擾ăIuWFNg쐬܂B</summary>
		/// <param name="iTravLog">A<see cref="ITravelLogEntry"/>ւ̃|C^</param>
		public TravelLogEntry(ITravelLogEntry iTravLog)
		{
			IntPtr pTitle = IntPtr.Zero;
			IntPtr pUrl = IntPtr.Zero;
			try
			{
				if(iTravLog.GetTitle(out pTitle) == ComDefines.S_OK)
					this._title = Marshal.PtrToStringUni(pTitle);
				if(iTravLog.GetURL(out pUrl) == ComDefines.S_OK)
					this._url = Marshal.PtrToStringUni(pUrl);
			}
			catch(Exception e) { Trace.WriteLine("TLE::ctor " + e.Message); }
			finally
			{
				if(pTitle != IntPtr.Zero) { Marshal.FreeCoTaskMem(pTitle); }
				if(pUrl != IntPtr.Zero) { Marshal.FreeCoTaskMem(pUrl); }
			}
		}

		public TravelLogEntry(SerializationInfo info, StreamingContext context)
		{
			this._title = info.GetString(SK_Title);
			this._url = info.GetString(SK_Url);
		}

		#endregion

		#region Public : Property / Methods

		/// <summary>̃y[W^Cg擾Eݒ肵܂</summary>
		public string Title
		{
			get { return this._title; }
			set { this._title = value; }
		}
		/// <summary>URL擾Eݒ肵܂</summary>
		public string Url
		{
			get { return this._url; }
			set { this._url = value; }
		}

		/// <summary>I[o[ChĂ܂B񂩂Au^Cg(URL)v̕擾܂</summary>
		/// <returns>u^Cg(URL)v`̕</returns>
		public override string ToString()
		{
			return String.Format("{0}({1})", this._title, this._url);
		}
		/// <summary>gpė𕶎ɕϊ܂B</summary>
		/// <param name="format">tH[}bgwB{0} UrlɁA{1} Titleɒu܂B</param>
		/// <returns></returns>
		public string ToString(String format)
		{
			return String.Format(format, this._url, this._title);
		}

		#endregion

		#region ISerializable o

		const string SK_Title = "Title";
		const string SK_Url = "Url";

		public void GetObjectData(SerializationInfo info, StreamingContext context)
		{
			info.AddValue(SK_Title, this._title ?? String.Empty);
			info.AddValue(SK_Url, this._url ?? String.Empty);
		}

		#endregion
	}


	#endregion
}
