﻿using System;

namespace Alternative.Controls.Browsers
{
	/// <summary>
	/// ロックされたタブの振舞い方を制御するフラグ（ビットフィールド）
	/// </summary>
	[Flags]
	public enum LockedTabBehaviors
	{
		/// <summary>ロックされていないタブと変わりはありません。</summary>
		AsNotLocked = 0x0,
		/// <summary>ユーザーによる閉じる操作を受け付けません。</summary>
		IgnoreClose = 0x1,
		/// <summary>タブ上でページを遷移せず、新しいタブに開きます。</summary>
		NavigateOnNew = 0x2,
		/// <summary>戻る・進む操作をタブ上で行わず、新しいタブに開きます。</summary>
		ForeBackOnNew = 0x4,
		/// <summary>再読み込みをタブ上で行わず、新しいタブに開きます。</summary>
		ReloadOnNew = 0x8,

		/// <summary>BOON-SUTAZIOと互換の設定です。</summary>
		BoonCompatible = 0x7,
	}

	/// <summary><see cref="TabBrowserControl"/>に対し、一つのタブに直接作用する動作を定義します。</summary>
	public enum TbTabClickAction : byte
	{
		/// <summary>何もしません</summary>
		None = 0x0,
		/// <summary>タブをロックします</summary>
		LockTab = 0x1,
		/// <summary>タブを閉じます</summary>
		CloseTab = 0x3,
		/// <summary>タブを再読み込みします</summary>
		Reload = 0x7,
	}
	/// <summary><see cref="TabBrowserControl"/>に対し、特定のタブに依存しない動作を定義します</summary>
	public enum TbTabClickAction2 : byte
	{
		/// <summary>何もしません</summary>
		None = 0x0,
		/// <summary>空のタブを開きます</summary>
		OpenBlank = 0x11,
		/// <summary>登録したURLのタブを開きます。実装されていません。</summary>
		OpenMyUrl = 0x13,
		/// <summary>表示中のページ一覧を開きます</summary>
		ShowPageListMenu = 0x31,
		/// <summary>最近閉じたタブの一覧を開きます</summary>
		ShowRecentClosedMenu = 0x33,
	}

	/// <summary>WebBrowserAx::Navigateに渡される引数の内の一つ。ビットフィールドです。</summary>
	[Flags]
	public enum BrowserNavConstants
	{
		/// <summary>新しいウィンドウで開きます。</summary>
		navOpenInNewWindow = 0x1,
		/// <summary>IEの履歴に追加しません。</summary>
		navNoHistory = 0x2,
		/// <summary>キャッシュの検索を行いません。</summary>
		navNoReadFromCache = 0x4,
		/// <summary>ファイルをキャッシュしません。</summary>
		navNoWriteToCache = 0x8,
		/// <summary></summary>
		navAllowAutosearch = 0x10,
		/// <summary></summary>
		navBrowserBar = 0x20,
		/// <summary></summary>
		navHyperlink = 0x40,
		/// <summary></summary>
		navEnforceRestricted = 0x80,
		/// <summary></summary>
		navNewWindowsManaged = 0x0100,
		/// <summary></summary>
		navUntrustedForDownload = 0x0200,
		/// <summary></summary>
		navTrustedForActiveX = 0x0400,
		/// <summary></summary>
		navOpenInNewTab = 0x0800,
		/// <summary></summary>
		navOpenInBackgroundTab = 0x1000,
		/// <summary></summary>
		navKeepWordWheelText = 0x2000,
		/// <summary></summary>
		navVirtualTab = 0x4000
	}
	/// <summary>
	/// WebBrowserAx::Refreshに渡される引数の一つ
	/// </summary>
	public enum RefreshConstant
	{
		/// <summary>標準の動作です。</summary>
		REFRESH_NORMAL = 0,
		/// <summary>期限切れのキャッシュに関しては再ダウンロードします。</summary>
		REFRESH_IFEXPIRED = 1,
		/// <summary>すべてのファイルを再ダウンロードします。</summary>
		REFRESH_COMPLETELY = 3
	}
	/// <summary>ページの暗号化状態を表す列挙子</summary>
	public enum SecureLockIconConstants
	{
		Unsecure = 0,
		Mixed = 0x1,
		SecureUnknownBits = 0x2,
		Secure40Bit = 0x3,
		Secure56Bit = 0x4,
		SecureFortezza = 0x5,
		Secure128Bit = 0x6
	}
}
