﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Alternative.Controls.Browsers
{
    using Alternative.Win32;

    /// <summary>閉じられたタブの情報を保持するクラスです。</summary>
	[Serializable]
	public class ClosedTabData
	{
		#region Fields

		string _url;
		string _title;

		bool _onExit;
		bool _locked;

		TravelLogEntry[] _backlog;
		TravelLogEntry[] _forelog;

		#endregion

		#region Properties

		/// <summary>最後に表示していたURLを取得・設定します。</summary>
		public string Url
		{
			get { return this._url; }
			set { this._url = value; }
		}
		/// <summary>最後に表示していたタイトルを取得・設定します。</summary>
		public string Title
		{
			get { return this._title; }
			set { this._title = value; }
		}
		/// <summary>終了処理によって閉じられたかどうかを取得・設定します。</summary>
		public bool ClosedOnExit
		{
			get { return this._onExit; }
			set { this._onExit = value; }
		}
		/// <summary>ロックされていたかどうかを取得・設定します。</summary>
		public bool LockedTab
		{
			get { return this._locked; }
			set { this._locked = value; }
		}
		/// <summary>戻る方向の履歴を取得・設定します。インデックスの小さい値がカレントエントリーに近い履歴です。</summary>
		public TravelLogEntry[] BackLog
		{
			get { return this._backlog; }
			set { this._backlog = value; }
		}
		/// <summary>進む方向の履歴を取得・設定します。インデックスの小さい値がカレントエントリーに近い履歴です。</summary>
		public TravelLogEntry[] ForeLog
		{
			get { return this._forelog; }
			set { this._forelog = value; }
		}

		#endregion

		/// <summary>デシリアライズ用のコンストラクタです。内容が空のオブジェクトが作成されます。</summary>
		public ClosedTabData()
		{
		}
		/// <summary>閉じるブラウザから情報を抽出してオブジェクトを作成します。</summary>
		/// <param name="browser">履歴を抽出するブラウザ</param>
		/// <param name="closedOnExit">終了処理によって閉じられたものかどうか</param>
		/// <param name="locked">タブロックされていたかどうか</param>
		public ClosedTabData(WebBrowserAx browser, bool closedOnExit, bool locked)
		{
			if (browser != null)
			{
				this._url = browser.Url;
				this._title = browser.DocumentTitle;
				this._backlog = browser.History.EnumEntries(TLENUMF.TLEF_RELATIVE_BACK, 5);
				this._forelog = browser.History.EnumEntries(TLENUMF.TLEF_RELATIVE_FORE, 5);
				this._onExit = closedOnExit;
				this._locked = locked;
			}
		}

	}
	/// <summary>起動時に復元するタブを指定するフラグです。</summary>
	[Flags]
	[Serializable]
	public enum RestoreClosedTabFlags : byte
	{
		/// <summary>このフラグを指定しない場合、すべてのタブは復元されません。</summary>
		OnExit = 0x01,
		/// <summary>終了時にロックされていたタブのみを復元します。</summary>
		OnlyLocked = 0x02,
		/// <summary>このフラグを指定すると、タブにナビゲート履歴を復元しません。</summary>
		NoNavigateHistory = 0x04,
	}

}
