using System;
using System.Runtime.InteropServices;
using System.Collections.Generic;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using System.Diagnostics;
using System.Runtime.Serialization;
using mshtml;

using IDataObject = System.Runtime.InteropServices.ComTypes.IDataObject;

namespace Alternative.Controls.Browsers
{
    using Alternative.Win32;

	/// <summary><see cref="WebBrowserAx"/>ׂ̈IDocHostUIHandler܂B</summary>
	internal class DocHostUIHandler : IDocHostUIHandler, IDisposable
	{
		#region Fields

		private WebBrowserAx _pHost;

		#endregion

		#region Constructor

		public DocHostUIHandler(WebBrowserAx host)
		{
			_pHost = host;
		}

		#endregion

		#region Property

		#endregion

		#region Events

		#endregion

		#region IDocHostUIHandler o

		/// <summary>[_ UI \ɌĂяoB</summary>
		/// @retval S_OK B
		/// @retval ̑ ُB
		void IDocHostUIHandler.EnableModeless(int fEnable)
		{
			// no implement
		}

		/// <summary>zXg MSTML f[^IuWFNguB</summary>
		/// @retval S_OK uB
		/// @retval S_FALSE uȂB
		HRESULT IDocHostUIHandler.FilterDataObject(IDataObject pDO, out IDataObject ppDORet)
		{
			ppDORet = null;
			return HRESULT.S_FALSE;
		}
		/// <summary>hbvzXgɒʒmB</summary>
		/// @retval S_OK B
		/// @retval ̑ ُB
		HRESULT IDocHostUIHandler.GetDropTarget(IDropTarget pDropTarget, out IDropTarget ppDropTarget)
		{
			ppDropTarget = null;
			return HRESULT.S_OK;
		}
		/// <summary>zXg IDispatch C^tF[X擾B</summary>
		/// @retval S_OK B
		/// @retval ̑ ُB
		void IDocHostUIHandler.GetExternal(out object ppDispatch)
		{
			ppDispatch = null;
			// no implement
		}
		/// <summary>zXgԂB</summary>
		/// @retval S_OK B
		/// @retval ̑ ُB
		void IDocHostUIHandler.GetHostInfo(ref DOCHOSTUIINFO pInfo)
		{
			// no implement
		}
		/// <summary>Internet Explorer WXgݒɏ㏑TuL[pX擾B</summary>
		/// @retval S_OK B
		/// @retval ̑ ُB
		void IDocHostUIHandler.GetOptionKeyPath(ref string pchKey, uint dw)
		{
			// no implement
		}
		/// <summary>j[ƃc[o[BB</summary>
		/// @retval S_OK B
		/// @retval ̑ ُB
		void IDocHostUIHandler.HideUI()
		{
			// no implement
		}
		/// <summary>EBhANeBuɌĂяoB</summary>
		/// @retval S_OK B
		/// @retval ̑ ُB
		void IDocHostUIHandler.OnDocWindowActivate(int fActivate)
		{
			// no implement
		}
		/// <summary>t[EBhANeBuɌĂяoB</summary>
		/// @retval S_OK B
		/// @retval ̑ ُB
		void IDocHostUIHandler.OnFrameWindowActivate(int fActivate)
		{
			// no implement
		}
		/// <summary>gTCYύXɌĂяoB</summary>
		/// @retval S_OK B
		/// @retval ̑ ُB
		void IDocHostUIHandler.ResizeBorder(ref tagRECT prcBorder, int pUIWindow, int fFrameWindow)
		{
			// no implement
		}
		/// <summary>V[gJbgj[LɂB</summary>
		/// @retval S_OK zXg\AMSHTML ͕\ȂB
		/// @retval S_FALSE zXg͕\AMSHTML \B
		/// @retval DOCHOST_E_UNKNOWN ʎqsBMSHTL \B
		HRESULT IDocHostUIHandler.ShowContextMenu(uint dwID, ref tagPOINT ppt, object pcmdtReserved, object pdispReserved)
		{
			return HRESULT.S_FALSE;
		}
		/// <summary>MSHTML ̃j[c[o[uB</summary>
		/// @retval S_OK zXg\B
		/// @retval S_FALSE MSHTML \B
		/// @retval DOCHOST_E_UNKNOWN UI ʎqsBMSHTML \B
		HRESULT IDocHostUIHandler.ShowUI(uint dwID, object pActiveObject, object pCommandTarget, object pFrame, object pDoc)
		{
			return HRESULT.S_FALSE;
		}
		/// <summary>L[͎ɌĂяoB</summary>
		/// @retval S_OK B
		/// @retval ̑ ُB
		HRESULT IDocHostUIHandler.TranslateAccelerator(ref tagMSG lpMsg, ref Guid pguidCmdGroup, uint nCmdID)
		{
			return HRESULT.S_OK;
		}
		/// <summary>[h URL zXgŕύXB</summary>
		/// @retval S_OK B
		/// @retval S_FALSE URL FłȂB
		HRESULT IDocHostUIHandler.TranslateUrl(uint dwTranslate, string pchURLIn, ref string ppchURLOut)
		{
			return HRESULT.S_OK;
		}
		/// <summary>R}hԂ̕ωʒmB</summary>
		/// @retval S_OK B
		/// @retval ̑ ُB
		void IDocHostUIHandler.UpdateUI()
		{
			// no implement
		}
		#endregion

		#region IDisposable o

		public void Dispose()
		{
			if(this._pHost != null)
			{
				this._pHost = null;
			}
		}

		#endregion
	}


    internal static class InnerLogger
	{
		public static class ErrorLevel
		{
			/// <summary>
			/// vOɂƂĒvIȃG[o
			/// ł<see cref="TabBrowserException"/>X[܂B
			/// </summary>
			public const int L0_CRITICAL = 0;
			/// <summary>
			/// vOł̕so
			/// </summary>
			public const int L1_ERROR = 1;
			/// <summary>
			/// vOł̕sȏo
			/// ł̓bZ[W{bNX\܂B
			/// </summary>
			public const int L2_WARNING = 2;
			/// <summary>
			/// T|[gȂ[U[ɑ΂o
			/// ł̓bZ[W{bNX\܂B
			/// </summary>
			public const int L3_ALART = 3;
			/// <summary>
			/// ȓ̂AfobOɏdvȂ̂o
			/// ł̓fobOo͂ɂȂ܂B
			/// </summary>
			public const int L4_NOTIFY = 4;
			/// <summary>
			/// ȓ̂AfobOł̏dv̒Ⴂ̂o
			/// ł͕\܂B
			/// </summary>
			public const int L5_LOG = 5;
		}

		/// <summary>
		/// ̃\bhgpďo͂ꂽf[^́A
		/// DebugR\[ɏo͂܂B
		/// </summary>
		/// <param name="message"></param>
        [Conditional("DEBUG")]
		public static void Out(string message)
		{
			Debug.WriteLine(message);
		}

        [Conditional("DEBUG")]
        public static void Out(string format, params object[] obj)
		{
			Debug.WriteLine(String.Format(format, obj));
		}

		/// <summary>
		/// ̃\bhgpďo͂f[^́AfobOEg[X̂ݏo͂܂B
		/// </summary>
		/// <param name="m"></param>
		/// <param name="level">0-2:MSGBOX/3-4:Trace/5:Debug</param>
		[Conditional("DEBUG")]
		[Conditional("TRACE")]
		public static void LOut(string m, int level)
		{
			switch(level)
			{
				case 0:
					MessageBox.Show(m);
					throw new TabBrowserException("m");
				case 1:
					MessageBox.Show(m);
					break;
				case 2:
					MessageBox.Show(m);
					break;
				case 3:
					Trace.WriteLine(m);
					break;
				case 4:
					Trace.WriteLine(m);
					break;
				case 5:
					//Debug.WriteLine(m);
					break;
				default:
					MessageBox.Show(m);
					break;
			}
		}
	}

	internal static class TeThrowHelper
	{
		const string CLS_NAME = "Alternative.Controls.Browsers.TabBrowserControl";

		public static TabBrowserException ExGeneric(string message, string method)
		{
			TabBrowserException tbe = new TabBrowserException(message);
			tbe.Source = CLS_NAME;
			return tbe;
		}
		public static IndexOutOfRangeException ExIndexOutOfRange()
		{
			IndexOutOfRangeException iex = new IndexOutOfRangeException();
			iex.Source = CLS_NAME;
			return iex;
		}
		public static ArgumentException ExInit_InvalidArgument()
		{
			return new ArgumentException("Ɏw肳ꂽpX͖ł");
		}
	}

	#region Exceptions
	/// <summary>
	/// <see cref="TabBrowserControl"/>ŔO\NXłB
	/// </summary>
	public class TabBrowserException : Exception, ISerializable
	{
		public const string DEF_MESSAGE = @"^uuEURg[ŃG[܂B";
		/// <summary>
		/// ̃NX̃RXgN^BftHg̃bZ[Wi[܂B
		/// </summary>
		public TabBrowserException() : base(DEF_MESSAGE) { }
		/// <summary>
		/// ̃NX̃RXgN^BftHg̃bZ[Wi[܂B
		/// </summary>
		/// <param name="innerException">ʂ`BꂽO</param>
		public TabBrowserException(Exception innerException) : base(DEF_MESSAGE, innerException) { }
		/// <summary>
		/// ̃NX̃RXgN^B
		/// </summary>
		/// <param name="message">i[郁bZ[W</param>
		public TabBrowserException(string message) : base(message) { }
		/// <summary>
		/// ̃NX̃RXgN^B
		/// </summary>
		/// <param name="message">i[郁bZ[W</param>
		/// <param name="innerExc">ʂ`BꂽO</param>
		public TabBrowserException(string message, Exception innerExc) : base(message, innerExc) { }
		/// <summary>
		/// <see cref="System.Runtime.Serialization.ISerializable"/>ׂ̈̃RXgN^
		/// </summary>
		/// <param name="info"></param>
		/// <param name="context"></param>
		public TabBrowserException(SerializationInfo info, StreamingContext context) : base(info, context) { }

		#region ISerializable o

		void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
		{
			base.GetObjectData(info, context);
		}

		#endregion
	}

	/// <summary>
	/// <see cref="TabBrowserControl"/>ŁA^u<see cref="ITbPageControl"/>̈ΈΉj]Ƃoɔ܂B
	/// </summary>
	public class TeContradictionException : TabBrowserException, ISerializable
	{
		public new const string DEF_MESSAGE = @"^uƃy[W̊֌W̖o܂B";
		/// <summary>
		/// ̃NX̃RXgN^BftHg̃bZ[Wi[܂B
		/// </summary>
		public TeContradictionException() : base(DEF_MESSAGE) { }
		/// <summary>
		/// ̃NX̃RXgN^B
		/// </summary>
		/// <param name="message">i[郁bZ[W</param>
		public TeContradictionException(string message) : base(message) { }
		/// <summary>
		/// <see cref="System.Runtime.Serialization.ISerializable"/>ׂ̈̃RXgN^
		/// </summary>
		/// <param name="info"></param>
		/// <param name="context"></param>
		public TeContradictionException(SerializationInfo info, StreamingContext context) { }

		#region ISerializable o

		void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
		{
			base.GetObjectData(info, context);
		}

		#endregion
	}
	/// <summary>
	/// nꂽ<see cref="ITbPageControl"/>A<see cref="System.Windows.Forms.Control"/>pĂȂƂɔ܂B
	/// </summary>
	/// <seealso cref="ITbPageControl"/>
	public class TeInvalidPageException : TabBrowserException, ISerializable
	{
		public new const string DEF_MESSAGE = @"nꂽy[WRg[́ASystem.Windows.Forms.Control̔hNXł͂܂B";

		/// <summary>
		/// ̃NX̃RXgN^BftHg̃bZ[Wi[܂B
		/// </summary>
		public TeInvalidPageException() : this(DEF_MESSAGE) { }
		/// <summary>
		/// ̃NX̃RXgN^B
		/// </summary>
		/// <param name="message">i[郁bZ[W</param>
		public TeInvalidPageException(string message) : base(message) { }
		/// <summary>
		/// <see cref="System.Runtime.Serialization.ISerializable"/>ׂ̈̃RXgN^
		/// </summary>
		/// <param name="info"></param>
		/// <param name="context"></param>
		public TeInvalidPageException(SerializationInfo info, StreamingContext context) { }

		#region ISerializable o

		void ISerializable.GetObjectData(SerializationInfo info, StreamingContext context)
		{
			base.GetObjectData(info, context);
		}

		#endregion
	}


	#endregion
}
