﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Windows.Forms;
using System.ComponentModel;
using System.Diagnostics;

namespace Alternative.Controls.Browsers
{
	/// <summary>HTMLのハイパーリンクに関するポップアップメニューを表示する際に発生するイベントを表します。</summary>
	/// <param name="sender">イベントを発生させたオブジェクト</param>
	/// <param name="args">イベントの情報を格納したオブジェクト</param>
	public delegate void AnchorMenuPopupEventHandler(object sender, AnchorMenuPopupEventArgs args);

	/// <summary>HTMLのハイパーリンクに関するポップアップメニューを表示する際に発生するイベントの情報を格納します。</summary>
	/// <seealso cref="AnchorMenuPopupEventHandler"/>
	[DebuggerDisplay("href = {PageUrl}")]
	public class AnchorMenuPopupEventArgs : CancelEventArgs
	{
		private string _page;
		private string _link;
		private string _frame;
		private Point _clientpos;
		private Keys _keys;

		public const Keys CodeApps = Keys.Apps;
		public const Keys CodeRButton = Keys.RButton;
		public const Keys CodeLButton = Keys.LButton;
		public const Keys CodeShift = Keys.Shift;
		public const Keys CodeCtrl = Keys.Control;
		public const Keys CodeAlt = Keys.Alt;

		public const Keys Code_LinkExByMouse = Keys.Control | Keys.LButton;
		public const Keys Code_LinkExByKey = Keys.Apps | Keys.LButton;

		/// <summary>コンストラクタです。</summary>
		/// <param name="linkUrl">リンク先のURL</param>
		/// <param name="frame"></param>
		/// <param name="currentUrl"></param>
		/// <param name="pos">メニュー表示の基準となるクライアント座標</param>
		/// <param name="keys"></param>
		public AnchorMenuPopupEventArgs(string linkUrl, string frame, string currentUrl, Point pos, Keys keys)
			:base(false)
		{
			this._frame = frame;
			this._link = linkUrl;
			this._page = currentUrl;
			this._clientpos = pos;
			this._keys = keys;
		}

		/// <summary>表示中のページのURLを取得します。</summary>
		public string PageUrl
		{
			get { return this._page; }
		}

		/// <summary>このイベントに関連するリンク先のページのURLを取得します。</summary>
		public string LinkUrl
		{
			get { return this._link; }
		}

		/// <summary>リンクのターゲットフレーム名を取得します。指定されていない時は<see cref="String.Empty"/>が返ります。</summary>
		public string TargetFrame
		{
			get { return this._frame; }
		}

		/// <summary>ポップアップメニューの表示の際の基準となる座標を取得します。</summary>
		public Point Location
		{
			get { return this._clientpos; }
		}

		/// <summary>イベントの発生の原因となったキーやマウスボタンを取得します。</summary>
		public Keys Code
		{
			get { return this._keys; }
		}


	}
}
