using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

namespace Alternative
{
	/// <summary>TCgURL͂f[^ێNX̊{@\񋟂܂B</summary>
	[DebuggerDisplay("{ServiceName} : Url = {Url}")]
	public abstract class VideoPageUrl
	{
		/// <summary>hNXŃI[o[ChƁAURL̓TCg\擾܂B</summary>
		public abstract string ServiceName { get; }

		/// <summary>hNXŃI[o[ChƁA͌ɂȂURL擾܂B</summary>
		public abstract string Url { get;}

		/// <summary>hNXŃI[o[ChƁAURL̂GETp[^擾܂B</summary>
		public abstract string Location { get;}

		/// <summary>hNXŃI[o[ChƁAURLɕt^ꂽGETp[^̕擾܂B
		/// URLɂ̒l܂܂ȂꍇnullԂ܂B</summary>
		public abstract string Parameter { get;}

		/// <summary>hNXŃI[o[ChƁAURLɕt^ꂽWṽtOg\擾܂B
		/// URLɂ̒l܂܂ȂꍇnullԂ܂B</summary>
		public abstract string TargetFragment { get;}


		/// <summary>̃IuWFNg\<see cref="System.String"/>Ԃ܂B
		/// <para>̒l͌pŃI[o[ChĂȂ<see cref="Url"/>vpeB̒lɓłB</para></summary>
		/// <returns>̃IuWFNg\<see cref="System.String"/></returns>
		public override string ToString()
		{
			return this.Url;
		}

		/// <summary>URLɊ܂܂ĂGETp[^񋓂邽߂̃IuWFNg擾܂B
		/// <para>uO=lvKeyValuePair&lt;String,String&gt;Ɋi[ہA
		/// lłꍇKeyValuePair&lt;String,String&gt;.Value̒l<see cref="String.Empty"/>ƂȂ܂B</para>
		/// <para>Au=v̂܂܂ĂȂꍇValuenullƂȂ܂B</para></summary>
		/// <param name="decode">OAlURLfR[h邩ǂw肵܂B</param>
		/// <returns>ep[^́AOƒl̃yAłKeyValuePair&lt;String,String&gt;񋓂ׂ̃IuWFNgB</returns>
		public IEnumerable<KeyValuePair<String, String>> EnumerateParams(bool decode)
		{
			string raw = this.Parameter;
			if(String.IsNullOrEmpty(raw) == false)
			{
				foreach(String param in raw.Split('&'))
				{
					if(param.Length >= 1)
					{
						string[] pair = param.Split('=');
						if(pair.Length == 1)
						{
							yield return new KeyValuePair<String, String>(
								decode ? System.Web.HttpUtility.UrlDecode(pair[0]) : pair[0],
								null);
						}
						else // u=v2ȏ܂܂Ăꍇ2ڂ́u=vȍ~̕𖳎
						{
							yield return new KeyValuePair<String, String>(
								decode ? System.Web.HttpUtility.UrlDecode(pair[0]) : pair[0],
								decode ? System.Web.HttpUtility.UrlDecode(pair[1]) : pair[1]);
						}
					}
				}
			}
		}
	}

	/// <summary>URL񂩂<see cref="VideoPageUrl"/>̍쐬T|[g܂B
	/// ʏ̎gpłstatico𗘗pł܂AΉVideoPageUrl̕ύXKvȏꍇ̓CX^X쐬ł܂B</summary>
	public class VideoPageUrlCreator
	{
		#region Const / Static

		/// <summary>̃NXstatic\bhgpftHg̃CX^XłB</summary>
		private static readonly VideoPageUrlCreator instance = new VideoPageUrlCreator(
			new VideoPageUrlCreatorDelegate(NicoVideoPageUrl.TryCreateForFactory)
			);

		/// <summary>w肵URLɁAgp\<see cref="VideoPageUrlCreatorDelegate"/>̈ꗗgp
		/// <see cref="VideoPageUrl"/>NX̃CX^X쐬܂B
		/// w肵URLɑΉ<see cref="VideoPageUrlCreatorDelegate"/>ȂꍇnullԂ܂B</summary>
		/// <param name="url"><see cref="VideoPageUrl"/>IuWFNg쐬錳ɂȂURL</param>
		/// <returns>쐬ꂽ<see cref="VideoPageUrl"/>IuWFNgAnullB</returns>
		public static VideoPageUrl CreateUrl(String url)
		{
			return instance.Create(url);
		}

		#endregion

		/// <summary>̃IuWFNgT|[g<see cref="VideoPageUrl"/>쐬ׂ̈<see cref="CreateDelegate"/>̈ꗗłB</summary>
		private VideoPageUrlCreatorDelegate _creators;


		#region Constructors

		/// <summary><see cref="VideoPageUrlCreator"/>NX̃CX^X܂B</summary>
		/// <param name="creators"><see cref="VideoPageUrl"/>쐬ׂ̈<see cref="CreateDelegate"/>̈ꗗ</param>
		public VideoPageUrlCreator(VideoPageUrlCreatorDelegate creators)
		{
			this._creators = creators;
		}

		/// <summary><see cref="VideoPageUrlCreator"/>NX̃CX^X܂B</summary>
		/// <param name="creators"><see cref="VideoPageUrl"/>쐬ׂ̈<see cref="VideoPageUrlCreatorDelegate"/>̈ꗗ</param>
		public VideoPageUrlCreator(params VideoPageUrlCreatorDelegate[] creators)
		{
			if(creators != null) { throw new ArgumentNullException(); }
			if(creators.Length == 0) { throw new ArgumentException(); }
			this._creators = creators[0];
			for(int i = 0; i < creators.Length; ++i)
			{
				this._creators += creators[i];
			}
		}

		#endregion

		/// <summary>w肵URLɁÃCX^XLĂ<see cref="CreatorDelegate"/>̈ꗗgp
		/// <see cref="VideoPageUrl"/>NX̃CX^X쐬܂B
		/// w肵URLɑΉ<see cref="VideoPageUrlCreatorDelegate"/>ȂꍇnullԂ܂B</summary>
		/// <param name="url"><see cref="VideoPageUrl"/>IuWFNg쐬錳ɂȂURL</param>
		/// <returns>쐬ꂽ<see cref="VideoPageUrl"/>IuWFNgAnullB</returns>
		public VideoPageUrl Create(String url)
		{
			VideoPageUrl result = null;
			foreach(VideoPageUrlCreatorDelegate creator in this._creators.GetInvocationList())
			{
				if(creator(url, out result)) { break; }
			}
			return result;
		}

		/// <summary><see cref="VideoPageUrl"/>NX̃CX^X쐬ׂ̃\bh\܂B</summary>
		/// <param name="url">쐬ƂȂURL</param>
		/// <param name="result">쐬ꂽ<see cref="VideoPageUrl"/>NX̃CX^Xi[܂B</param>
		/// <returns>̃\bhw肳ꂽURLCX^X̍쐬ɐꍇtueԂ܂B</returns>
		public delegate bool VideoPageUrlCreatorDelegate(String url, out VideoPageUrl result);
	}
}
