using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Diagnostics;
using System.Runtime.InteropServices;

namespace Alternative
{
    using WebServiceClient.NicoVideo;

	/// <summary>jRjR掋y[WURLi[NXłB
	/// <para>CX^X̍쐬ɂ́A<see cref="Create"/>ÓI\bhgp܂B</para></summary>
	[DebuggerDisplay("{ServiceName} : ID = {VideoID}, Locale = {Locale}")]
	public class NicoVideoPageUrl : VideoPageUrl
	{
		#region Constants / Static

		/// <summary><see cref="VideoPageUrl"/>gNXT|[gAT[rXʂ镶łB
		/// <para>̒ĺA"nicovideo"łB</para></summary>
		const string SVC_ID = "nicovideo";
		/// <summary>WatchURL̏tH[}bgB{0}=LocaleA{1}=VideoID</summary>
		const string WatchUrlFormat = "http://{0}.nicovideo.jp/watch/{1}";


		#region +--  Regex Codes and Definitions

		/// <summary>jRjR掋y[WURLɃ}b`A𒊏oׂ̐K\B
		/// <para>Lv`RwGn`ɂ܂Ƃ߂Ă܂B</para></summary>
		internal static readonly Regex RxNicoWatchPage = new Regex(
			@"^("
				+ @"?<Location>http://(?<Locale>[a-z]+)\.nicovideo\.jp/watch/"
				+ @"(?<VideoID>(?<VideoIDPrefix>[a-zA-Z]*)(?<VideoIDNumber>[\d]+))"
			+ @")"
			+ @"(?<Followings>"
				+ @"(?<FollowingPref>[#\?])"
				+ @"(?<FollowingValue>"
					+ @"(?<TargetFragment>(?<=#)[^\s\?#]*)"
					+ @"|"
					+ @"(?<Parameters>(?<=\?)[^\s\?#]*)"
				+ @")"
			+ @"){0,5}$"
			, RegexOptions.IgnoreCase
			| RegexOptions.Singleline
			| RegexOptions.Compiled
			| RegexOptions.ExplicitCapture
			);

		internal const string RwGnLocation = "Location";
		internal const string RwGnParameter = "Parameters";
		internal const string RwGnTargetFragment = "TargetFragment";
		internal const string RwGnVideoID = "VideoID";
		internal const string RxGnLocaleCode = "Locale";

		internal const string RxGnExFollowings = "Followings";
		internal const string RxGnExFollowingPref = "FollowingPref";
		internal const string RxGnExFollowingValue = "FollowingValue";
		internal const string RxGnExVideoIDPrefix = "VideoIDPrefix";
		internal const string RxGnExVideoIDNumber = "VideoIDNumber";

		/// <summary>jRjR掋y[WURLɃ}b`鐳K\B
		/// <para>Regex.IsMatcĥ݂Ŏgp邽߂ɏڍׂȃLv`w菜yʔłłB</para></summary>
		internal static readonly Regex RxNicoWatchPageLite = new Regex(
			@"^http://([a-z]+)\.nicovideo\.jp/watch/[a-zA-Z]*[\d]+([#\?].*)?$"
			, RegexOptions.IgnoreCase
			| RegexOptions.Singleline
			| RegexOptions.Compiled
			| RegexOptions.ExplicitCapture
			);

		/// <summary>jRjR̊SȓIDɂ̂݃}b`鐳K\B</summary>
		internal static readonly Regex RxNicoVideoIDRestrict = new Regex(
			@"^(?<Signiture>[a-z]*)(?<Number>[\d]+)$"
			, RegexOptions.Compiled
			| RegexOptions.IgnoreCase
			| RegexOptions.Singleline
			| RegexOptions.ExplicitCapture
			);

		#endregion

		#region +--  Factory Methods

		/// <summary>URL؂AjRjR掋y[Ŵ̂ł<see cref="NicoVideoPageUrl"/>NX̃CX^XԂ܂B
		/// <para>nꂽURLy[Ŵ̂łȂꍇnullԂ܂B</para></summary>
		/// <param name="url">؂URL</param>
		/// <returns>،ʂi[<see cref="NicoVideoPageUrl"/>NX̃CX^XBnullB</returns>
		public static NicoVideoPageUrl Create(String url)
		{
			NicoVideoPageUrl result = null;
			return TryCreate(url, out result) ? result : null;
		}

		public static NicoVideoPageUrl CreateFromVideoID(String videoID)
		{
			if(RxNicoVideoIDRestrict.IsMatch(videoID))
			{
				String watchUrl = String.Format(WatchUrlFormat, "www", videoID);
				return Create(watchUrl);
			}
			return null;
		}

		/// <summary>URL؂AjRjR掋y[Ŵ̂ł<see cref="NicoVideoPageUrl"/>NX̃CX^X쐬܂B</summary>
		/// <param name="url">؂URL</param>
		/// <param name="result">쐬ꂽ<see cref="NicoVideoPageUrl"/>NX̃CX^Xi[܂B</param>
		/// <returns>URLjRjR掋y[Ŵ̂łA͂ɐtrueԂ܂B</returns>
		public static bool TryCreate(String url, out NicoVideoPageUrl result)
		{
			if(!String.IsNullOrEmpty(url))
			{
				try
				{
					Match match = RxNicoWatchPage.Match(url);
					if(match.Success)
					{
						LocaleCode loc;
						string[] data;
						Exception error;
						if(trygetRxMatchData(match, out data, false, out error)
							&& GetLocale(data[IX_LocaleCode], out loc))
						{
							result = new NicoVideoPageUrl();
							result._withoutparam = data[IX_Location];
							result._locale = loc;
							result._videoid = data[IX_VideoID];
							result._parameter = data[IX_Parameter];
							result._tgtFragment = data[IX_TargetFragment];
							return true;
						}
					}
				}
				catch(Exception e) { Debug.WriteLine(e); }
			}
			result = null;
			return false;
		}

		public static bool TryCreateForFactory(String url, out VideoPageUrl result)
		{
			NicoVideoPageUrl res_;
			if(TryCreate(url, out res_))
			{
				result = res_;
			}
			else { result = null; }
			return (result != null);
		}


		/// <summary>RxNicoWatchPagẽ}b`ʂ̃f[^擾ʉB</summary>
		/// <param name="match">RxNicoWatchPageɂ}b`</param>
		/// <param name="data">of[^i[StringzBeCfbNX̒l IX_` 萔ɂĒ`B</param>
		/// <param name="needException">OIuWFNgKvȏꍇtrueBfalseɂƁA<paramref name="error"/>p[^͏nullƂȂ܂B</param>
		/// <param name="error">ɔOi[BG[ȂꍇA<paramref name="neetException"/>falsenꍇnullɂȂ܂B</param>
		/// <returns>Kvȕʂ̃f[^擾ɐAG[ȂꍇtrueԂ܂B</returns>
		private static bool trygetRxMatchData(Match match, out string[] data, bool needException, out Exception error)
		{
			bool result = true;
			Group g = null;

			error = null;
			data = new string[IXLength];
			data[IX_LocaleCode] = match.Groups[RxGnLocaleCode].Value;
			data[IX_VideoID] = match.Groups[RwGnVideoID].Value;
			data[IX_Location] = match.Groups[RwGnLocation].Value;
			data[IX_Parameter] = null;
			data[IX_TargetFragment] = null;

			g = match.Groups[RwGnParameter];
			if(g.Success)
			{
				if(g.Captures.Count >= 2)
				{
					result = false;
					if(needException) { error = new ArgumentException("p[^ʂ镶łu?v܂܂Ă܂B"); }
					data[IX_Parameter] = null;
				}
				else { data[IX_Parameter] = g.Value; }
			}
			g = match.Groups[RwGnTargetFragment];
			if(g.Success)
			{
				if(g.Captures.Count >= 2)
				{
					result = false;
					if(needException) { error = new ArgumentException("WvtOgʂ镶łu#v܂܂Ă܂B"); }
					data[IX_TargetFragment] = null;
				}
				else { data[IX_TargetFragment] = g.Value; }
			}

			if(String.IsNullOrEmpty(data[IX_VideoID])
				|| String.IsNullOrEmpty(data[IX_LocaleCode])
				|| String.IsNullOrEmpty(data[IX_Location]))
			{
				result = false;
				if(needException) { error = new ArgumentException("nꂽURL̓jRjR掋y[Ŵ̂ł͂܂B"); }
			}
			return result;
		}

		/// <summary><see cref="trygetRxMatchData"/>\bhdata (out string[]^p[^) Ɋi[ef[^̃CfbNXłB</summary>
		private const int
			IX_Location = 0,
			IX_Parameter = 1,
			IX_TargetFragment = 2,
			IX_VideoID = 3,
			IX_LocaleCode = 4,
			IXLength = 5;

		#endregion

		/// <summary><see cref="VideoPageUrl"/>gNXT|[gAT[rXʂ镶擾܂B
		/// <para>̒ĺA"nicovideo"łB</para></summary>
		public static string ServiceID { get { return SVC_ID; } }

		/// <summary>nꂽURL񂪃jRjR掋y[Ŵ̂ł邩ǂ؂܂B</summary>
		/// <param name="url">؂URL</param>
		/// <returns>񂪃jRjR掋y[WURL`łtrueԂ܂B
		/// URLGETp[^܂܂ĂĂ؂̌ʂ͕ς܂B</returns>
		public static bool IsWatchPage(String url)
		{
			return RxNicoWatchPageLite.IsMatch(url);
		}

		/// <summary>nꂽ񂪃jRjR̓ID\Ă邩ǂ؂܂B
		/// p[^Ȃǂ̗]ȏ񂪊܂܂ĂꍇfalseԂ܂B</summary>
		/// <param name="videoId">؂镶B</param>
		/// <returns>񂪐ȓIĎ`ĂtrueԂ܂B</returns>
		public static bool IsVideoID(String videoId)
		{
			return RxNicoVideoIDRestrict.IsMatch(videoId);
		}

		/// <summary>jRjR̃P[\񂩂<see cref="WebServiceClient.NicoVideo.LocaleCode"/>擾܂B</summary>
		/// <param name="code">؂郍P[B(Fwww{Atwp)</param>
		/// <param name="locale">ʂi[ϐQ</param>
		/// <returns></returns>
		private static bool GetLocale(string code, out LocaleCode locale)
		{

			switch(code)
			{
				case "www":
				case "ja":
					locale = LocaleCode.Japan;
					return true;
				case "tw":
					locale = LocaleCode.Taiwan;
					return true;
				case "de":
					locale = LocaleCode.Germany;
					return true;
				case "es":
					locale = LocaleCode.Spanien;
					return true;
				default:
					locale = LocaleCode.Default;
					return false;
			}
		}

		#endregion

		#region Fields

		string _withoutparam;
		string _videoid;
		LocaleCode _locale;
		string _parameter;
		string _tgtFragment;

		#endregion
		
		#region Properties

		/// <summary>URL̓TCg\擾܂B</summary>
		public override string ServiceName
		{
			get { return ServiceID; }
		}

		/// <summary>͌ɂȂURL擾܂B
		/// <para>p[^ƃWvID̏͌̕ł̓oꏇɕKv܂B</para>
		///  <see cref="Location"/>?<see cref="Parameter"/>#<see cref="TargetFragment"/> ̏ɔzu܂B</summary>
		public override string Url
		{
			get
			{
				String url = _withoutparam;
				if(String.IsNullOrEmpty(_parameter) == false) { url += ("?" + _parameter); }
				if(String.IsNullOrEmpty(_tgtFragment) == false) { url += ("#" + _tgtFragment); }
				return url;
			}
		}

		/// <summary>URL̂AGETp[^擾܂B</summary>
		public override string Location
		{
			get { return _withoutparam; }
		}
		/// <summary>URLɕt^ꂽGETp[^̕擾܂B</summary>
		public override string Parameter
		{
			get { return _parameter; }
		}
		/// <summary>URLɕt^ꂽWvtOgi#nameŎw肳namelj̕擾܂B</summary>
		public override string TargetFragment
		{
			get { return _tgtFragment; }
		}

		/// <summary>URL\Ă<see cref="WebServiceClient.NicoVideo.LocaleCode"/>擾܂B</summary>
		public LocaleCode Locale
		{
			get { return this._locale; }
		}

		/// <summary>URL\ĂjRjR掋y[W̓ID擾܂B</summary>
		public string VideoId
		{
			get { return this._videoid; }
		}


		#endregion

		#region Constructor

		/// <summary>RXgN^BvCx[głB</summary>
		private NicoVideoPageUrl()
		{
			_withoutparam = String.Empty;
			this._videoid = null;
			this._locale = LocaleCode.Default;
			_parameter = null;
			_tgtFragment = null;
		}
		/// <summary><see cref="NicoVideoPageUrl"/>NX̃CX^X܂B
		/// <para>ʏ<see cref="Create"/>ÓI\bhgpĂB</para></summary>
		/// <param name="url">ɂȂURLBy[WȊÔ̂nƗO܂B</param>
		/// <remarks>
		/// ʏ̃CX^X쐬ɂ́ÃRXgN^gp<see cref="Create"/>ÓI\bhgp܂B
		/// ܂AURLy[Ŵ̂ł邩ǂ𒲂ׂׂɂ<see cref="IsWatchPage"/>ÓI\bhgp܂B
		/// </remarks>
		/// <exception cref="ArgumentException">nꂽURL񂪃jRjR掋y[Ŵ̂łȂꍇɔ܂B</exception>
		public NicoVideoPageUrl(String url)
		{
			LocaleCode loc;
			string[] data;
			Exception error;
			Match match = RxNicoWatchPage.Match(url);

			if(!match.Success) { throw new ArgumentException("nꂽURL̓jRjR掋y[Ŵ̂ł͂܂B"); }
			if(trygetRxMatchData(match, out data, true, out error) == false) { throw error; }
			if(!GetLocale(data[IX_LocaleCode], out loc)) { throw new ArgumentException(String.Format("{0} ƂP[͎gpł܂B", data[IX_LocaleCode] ?? "null")); }

			_withoutparam = data[IX_Location];
			this._locale = loc;
			this._videoid = data[IX_VideoID];
			_parameter = data[IX_Parameter] ?? String.Empty;
			_tgtFragment = data[IX_TargetFragment] ?? String.Empty;
		}

		#endregion
	}
}
