using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;

namespace Alternative
{
    using WebServiceClient.Collections;
    using WebServiceClient.NicoVideo;

    public class NicoVideoFile : NicoFileInfo
    {
        #region Field

        /// <summary>t@C̊gq\ <see cref="ReadOnlyDictionary{TKey,TValue}">ReadOnlyDictionary&lt;string, string&gt;</see>B</summary>
        public static readonly ReadOnlyDictionary<string, string> NicoVideoExtensions;
        /// <summary>֘At@C̊gq\ <see cref="ReadOnlyDictionary{TKey,TValue}">ReadOnlyDictionary&lt;string, string&gt;</see>B</summary>
        public static readonly ReadOnlyDictionary<string, string> NicoRelatedExtensions;
        /// <summary>t@C̏p^[\ string[]B</summary>
        public static readonly string[] NicoFileNameFormats;

        #endregion

        #region Constructor

        /// <summary>ÓItB[h܂B</summary>
        static NicoVideoFile()
        {
            Dictionary<string, string> videoExt = new Dictionary<string, string>();
            videoExt.Add(".mp4", ".mp4");
            videoExt.Add( ".flv", ".flv");
            videoExt.Add(".swf",".swf");
            videoExt.Add(".avi",".avi");
            videoExt.Add(".wmv", ".wmv");
            NicoVideoExtensions = new ReadOnlyDictionary<string, string>(videoExt);

            Dictionary<string, string> relatedExt = new Dictionary<string, string>();
            relatedExt.Add(".xml", ".xml");
            NicoRelatedExtensions = new ReadOnlyDictionary<string, string>(relatedExt);

            NicoFileNameFormats = new string[]
            {
                FileTitleFormat + "(" + VideoIdFormat + ")." + ExtensionFormat
            };
        }

        /// <summary>CX^X܂B</summary>
        /// <param name="localPath">t@Cւ̃pX\ stringB</param>
        public NicoVideoFile(string localPath)
            : base(localPath)
        {
        }

        #endregion

        #region Static Method

        /// <summary>t@C̓ ID 擾܂B</summary>
        /// <param name="path">t@C̃pX\ stringB</param>
        /// <returns>擾 ID \ stringB</returns>
        public static string GetVideoId(string path)
        {
            return GetVideoId(path, NicoFileNameFormats);
        }

        /// <summary>t@C̓ ID 擾܂B</summary>
        /// <param name="path">t@C̃pX\ stringB</param>
        /// <param name="formats">t@C̏\ string[]B</param>
        /// <returns>擾 ID \ stringB</returns>
        public static string GetVideoId(string path, string[] formats)
        {
            // t@C̃Xg[擾
            if (NicoVideoFile.ExistsFileInfo(path) == true)
            {
                NicoFileInfo info = NicoFileInfo.GetNicoFileInfo(path);
                if (info != null)
                {
                    return info.VideoId;
                }
            }

            // Rgt@CBoonSutazioǉXMLRgAview_counter^O擾
            string comment = Path.Combine(Path.GetDirectoryName(path), Path.GetFileNameWithoutExtension(path)) + ".xml";
            if (File.Exists(comment) == true)
            {
                using (FileStream stream = new FileStream(comment, FileMode.Open, FileAccess.Read))
                using (StreamReader reader = new StreamReader(stream, new UTF8Encoding(false)))
                {
                    char[] buffer = new char[512];
                    int size = reader.Read(buffer, 0, buffer.Length);
                    string text = new string(buffer, 0, size);

                    Regex regex = new Regex("(BoonSutazioData=(?<VideoId>[0-9A-Za-z]+)|view_counter id=\"(?<VideoId>[0-9A-Za-z]+)\")");
                    Match match = regex.Match(text);
                    if (match.Success == true)
                    {
                        return match.Groups["VideoId"].Value;
                    }
                }
            }

            // t@C擾
            if (formats !=null && formats.Length > 0)
            {
                string[] metaChars = new string[] { "\\", ".", "$", "^", "{", "}", "[", "]", "(", ")", "|", "*", "+", "?" };

                foreach (string format in formats)
                {
                    string pattern = format;
                    foreach (string meta in metaChars)
                    {
                        pattern = pattern.Replace(meta, @"\" + meta);
                    }

                    pattern = pattern.Replace(FileTitleFormat, ".*");
                    pattern = pattern.Replace(ExtensionFormat, "[0-9A-Za-z]+");
                    pattern = pattern.Replace(VideoIdFormat, "(?<VideoId>[0-9A-Za-z]+)");

                    Regex regex = new Regex("^" + pattern + "$");
                    Match match = regex.Match(Path.GetFileName(path));
                    if (match.Success == true)
                    {
                        return match.Groups["VideoId"].Value;
                    }
                }
            }

            return "";
        }

        /// <summary>t@CƊ֘At@Cړ܂B</summary>
        /// <param name="path">ړ铮t@C̃pX\ stringB</param>
        /// <param name="directory">ړ̃fBNg\ stringB</param>
        public static void Move(string path, string directory)
        {
            string title = Path.GetFileNameWithoutExtension(path);
            string src = Path.Combine(Path.GetDirectoryName(path), title);
            string dest = Path.Combine(directory, title);

            foreach (string ext in NicoVideoExtensions.Values)
            {
                if (File.Exists(src + ext) == true)
                {
                    File.Move(src + ext, dest + ext);
                    break;
                }
            }

            foreach (string ext in NicoRelatedExtensions.Values)
            {
                if (File.Exists(src + ext) == true)
                {
                    File.Move(src + ext, dest + ext);
                }
            }
        }

        /// <summary>t@CƊ֘At@C폜܂B</summary>
        /// <param name="path">ړ铮t@C̃pX\ stringB</param>
        public static void Delete(string path)
        {
            string title = Path.GetFileNameWithoutExtension(path);
            string src = Path.Combine(Path.GetDirectoryName(path), title);

            foreach (string ext in NicoVideoExtensions.Values)
            {
                if (File.Exists(src + ext) == true)
                {
                    File.Delete(src + ext);
                    break;
                }
            }

            foreach (string ext in NicoRelatedExtensions.Values)
            {
                if (File.Exists(src + ext) == true)
                {
                    File.Delete(src + ext);
                }
            }
        }

        /// <summary>w̓ ID t@CɊ܂ޓt@C܂B</summary>
        /// <param name="directory">tH_̃pX\ stringB</param>
        /// <param name="videoId"> ID \ stringB</param>
        /// <param name="option">͈͂\ <see cref="SearchOption"/>B</param>
        /// <returns>擾t@C\ <see cref="NicoVideoFile">NicoVideoFile[]</see></returns>
        public static List<NicoVideoFile> FindVideoFiles(string directory, string videoId, SearchOption option)
        {
            List<NicoVideoFile> files = new List<NicoVideoFile>();

            foreach (string filePath in Directory.GetFiles(directory, "*" + videoId + "*", SearchOption.AllDirectories))
            {
                if (NicoVideoExtensions.ContainsKey(Path.GetExtension(filePath).ToLower()) == true)
                {
                    files.Add(new NicoVideoFile(filePath));
                }
            }

            return files;
        }

        #endregion

        #region Method

        /// <summary>t@CƊ֘At@Cړ܂B</summary>
        /// <param name="directory">ړ̃fBNg\ stringB</param>
        public void Move(string directory)
        {
            NicoVideoFile.Move(_localFile.FullName, directory);
        }

        /// <summary>t@CƊ֘At@C폜܂B</summary>
        public void Delete()
        {
            NicoVideoFile.Delete(_localFile.FullName);
        }

        #endregion
    }
}
