using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.Text.RegularExpressions;

namespace Alternative
{
	/// <summary>NGXgURL̍쐬̂߂̕W\bh񋟂܂B</summary>
	public class CommonRequestProvider
	{
		/// <summary>W̃NGXgURL̃tH[}bgłB{0}Ƀp[^w肵܂B</summary>
		public const String RequestFormat = "boon://download/?{0}";

		/// <summary>URLBoonURIł邱Ƃ؂܂B</summary>
		internal static readonly Regex RxRequestUrl = new Regex(
			@"boon://"
			+ @"(?<function>[^/]+)/?"//boon/?"+ 
			+ @"((?<withquery>\?)?(?<params>(.*)))?",
			RegexOptions.Compiled | RegexOptions.IgnoreCase | RegexOptions.Singleline | RegexOptions.ExplicitCapture);

		/// <summary>w肵p[^gpăNGXgURL쐬܂B</summary>
		/// <param name="url">K{p[^łurl̒lw肵܂B</param>
		/// <param name="parameters">̑̃p[^"A=B"̌`Ŏw肵܂Bl͂炩UrlEncodeKv܂B</param>
		/// <returns>쐬ꂽNGXgURL񂪕Ԃ܂B</returns>
		public static String CreateRequest(String url, params String[] parameters)
		{
			return String.Format(RequestFormat, RequestParams.MakeParameters(url, parameters));
		}
		/// <summary>w肵p[^gpăNGXgURL쐬܂B</summary>
		/// <param name="url">K{p[^łurl̒lw肵܂B</param>
		/// <returns>쐬ꂽNGXgURL񂪕Ԃ܂B</returns>
		public static String CreateRequest(String url)
		{
			return String.Format(RequestFormat, RequestParams.MakeParameters(url));
		}
		/// <summary>w肵p[^gpăNGXgURL쐬܂B</summary>
		/// <param name="url">K{p[^łurl̒lw肵܂B</param>
		/// <param name="parameters">̑̃p[^KeyValuePaiř`œn܂Bl̓GR[hKv͂܂B</param>
		/// <returns>쐬ꂽNGXgURL񂪕Ԃ܂B</returns>
		public static String CreateRequest(String pageUrl, IEnumerable<KeyValuePair<String, String>> parameters)
		{
			return String.Format(RequestFormat, RequestParams.MakeParameters(pageUrl ,parameters));
		}

		/// <summary>w肳ꂽURLANGXgURLł邩ǂmF܂B</summary>
		/// <param name="url">mFURL</param>
		/// <returns>NGXgURLłtrue</returns>
		public static bool IsRequestUrl(string url)
		{
			Match match = RxRequestUrl.Match(url);
			if(match.Success)
			{
				switch(match.Groups["function"].Value)
				{
					case "":
					case "download":
						return true;
				}
			}
			return false;
		}
	}

	/// <summary>NGXgURLɊ܂܂p[^̏WA
	/// VXegp\ς݃p[^`܂B</summary>
	public class RequestParams
	{
		/// <summary>W̃p[^tH[}bgłB"{1}={2}"</summary>
		public const String ParameterFormat = "{0}={1}";

		/// <summary>NGXgURL̂߂̃p[^쐬܂Blɂ́ApXƂ̋E\u?v͊܂܂܂B</summary>
		/// <param name="url">K{p[^łurl̒lw肵܂B</param>
		/// <param name="parameters">̑̃p[^"A=B"̌`Ŏw肵܂Bl͂炩UrlEncodeKv܂B</param>
		/// <returns>쐬ꂽp[^񂪕Ԃ܂Blɂ́ApXƂ̋E\u?v͊܂܂܂B</returns>
		public static string MakeParameters(String url, params String[] parameters)
		{
			if(String.IsNullOrEmpty(url)) { throw new ArgumentNullException("url"); }
			String sb = Url.Make(url);
			if(parameters != null)
			{
				string sub = String.Join("&", parameters);
				if(sub.Length >= 1)
				{
					sb += ("&" + sub);
				}
			}
			return sb;
		}
		/// <summary>NGXgURL̂߂̃p[^쐬܂Blɂ́ApXƂ̋E\u?v͊܂܂܂B</summary>
		/// <param name="url">K{p[^łurl̒lw肵܂B</param>
		/// <param name="parameters">̑̃p[^i[KeyValuePair&lt;String,String&gt;IEnumerableBl͂炩UrlEncodeKv܂B</param>
		/// <returns>쐬ꂽp[^񂪕Ԃ܂Blɂ́ApXƂ̋E\u?v͊܂܂܂B</returns>
		public static string MakeParameters(String pageUrl, IEnumerable<KeyValuePair<String, String>> parameters)
		{
			StringBuilder sb = new StringBuilder(Url.Make(pageUrl));
			if(parameters != null)
			{
				foreach(KeyValuePair<String, String> para in parameters)
				{
					sb.Append("&");
					sb.Append(Make(para.Key, para.Value));
				}
			}
			return sb.ToString();
		}

		/// <summary>w肵OƒlURLGR[hς݂GETp[^쐬܂B</summary>
		/// <param name="name">p[^̖O</param>
		/// <param name="value">p[^̒l</param>
		/// <returns>쐬ꂽuO=lvBlURLGR[h܂B</returns>
		public static string Make(String name, String value)
		{
			return String.Format(ParameterFormat, name, HttpUtility.UrlEncode(value));
		}

		#region Parameter Class

		/// <summary>NGXgp[^́uurlv\܂B̃p[^͕K{łB
		/// <para>̃p[^́A_E[hy[WURLi[܂B</para></summary>
		public static class Url
		{
			/// <summary>̃p[^̖OłB</summary>
			public const string Name = "url";

			/// <summary>w肵l炱̃p[^쐬܂B</summary>
			/// <param name="value">p[^Ɏw肷l</param>
			/// <returns>uO=lv`̕BlUrlGR[h܂B</returns>
			public static string Make(string value)
			{
				return RequestParams.Make(Name, value);
			}
		}
		/// <summary>NGXgp[^́unamev\܂B
		/// <para>̃p[^́A_E[hɖIɎw肳ꂽ^Cgit@Cji[܂B</para></summary>
		public static class NewName
		{
			/// <summary>̃p[^̖OłB</summary>
			public const string Name = "name";

			/// <summary>w肵l炱̃p[^쐬܂B</summary>
			/// <param name="value">p[^Ɏw肷l</param>
			/// <returns>uO=lv`̕BlUrlGR[h܂B</returns>
			public static string Make(string value)
			{
				return RequestParams.Make(Name, value);
			}
		}
		/// <summary>NGXgp[^́ucustomv\܂B
		/// <para>̃p[^́A_E[hɏڍׂȃNGXg쐬vǂi[܂B</para></summary>
		public static class Custom
		{
			/// <summary>̃p[^̖OłB</summary>
			public const string Name = "custom";

			/// <summary>p[^l̈łB̒ltrue\܂B</summary>
			public const string V_Custom = "custom";

			/// <summary>p[^l̈łB̒lfalse\܂B</summary>
			public const string V_None = "none";

			/// <summary>w肵l炱̃p[^쐬܂B</summary>
			/// <param name="value">p[^Ɏw肷l</param>
			/// <returns>uO=lv`̕BlUrlGR[h܂B</returns>
			public static string Make(bool value)
			{
				return RequestParams.Make(Name, value ? V_Custom : V_None);
			}

			/// <summary>̃p[^̒lAl\boolɕϊ܂B</summary>
			/// <param name="value">p[^Ɋi[ĂlB</param>
			/// <returns></returns>
			public static bool GetBoolean(string value)
			{
				switch(HttpUtility.UrlDecode(value))
				{
					case V_Custom: return true;
					case V_None: return false;
					default: return false;
				}
			}
		}

		/// <summary>NGXgp[^́ureservedv\܂B
		/// <para>̃p[^́A_E[hɏڍׂȃNGXg쐬vǂi[܂B</para></summary>
		public static class Reserved
		{
			/// <summary>̃p[^̖OłB</summary>
			public const string Name = "reserved";

			/// <summary>p[^l̈łB̒ltrue\܂B</summary>
			public const string V_Reserved = "reserved";

			/// <summary>p[^l̈łB̒lfalse\܂B</summary>
			public const string V_None = "none";

			/// <summary>w肵l炱̃p[^쐬܂B</summary>
			/// <param name="value">p[^Ɏw肷l</param>
			/// <returns>uO=lv`̕BlUrlGR[h܂B</returns>
			public static string Make(bool value)
			{
				return RequestParams.Make(Name, value ? V_Reserved : V_None);
			}

			/// <summary>̃p[^̒lAl\boolɕϊ܂B</summary>
			/// <param name="value">p[^Ɋi[ĂlB</param>
			/// <returns></returns>
			public static bool GetBoolean(string value)
			{
				switch(HttpUtility.UrlDecode(value))
				{
					case V_Reserved: return true;
					case V_None: return false;
					default: return false;
				}
			}
		}
		/// <summary>NGXgp[^́utitlev\܂B
		/// <para>̃p[^́A_E[hXgo^ɕ\ׂ̃^Cgi[܂B</para></summary>
		public static class DisplayTitle
		{
			/// <summary>̃p[^̖OłB</summary>
			public const string Name = "title";

			/// <summary>w肵l炱̃p[^쐬܂B</summary>
			/// <param name="value">p[^Ɏw肷l</param>
			/// <returns>uO=lv`̕BlUrlGR[h܂B</returns>
			public static string Make(string value)
			{
				return RequestParams.Make(Name, value);
			}
		}

		#endregion
	}
}
