using System;
using System.ComponentModel;
using System.Collections.Generic;
using System.Diagnostics;
using System.Windows.Forms;
using System.IO;
using System.Xml;
using System.Xml.Serialization;

namespace Alternative
{
    using WebServiceClient;
    using WebServiceClient.NicoVideo;
    using Alternative.Forms;
    using Alternative.Controls.Browsers;

    #region Enumration

    /// <summary>N̓eB</summary>
    public enum StartUpAction
    {
        #region Enum Members

        /// <summary>OĨ^uJB</summary>
        [Description("OĨ^uJ")]
        OpenPreviousTab,
        /// <summary>z[y[WJB</summary>
        [Description("z[y[WJ")]
        OpenHomeUrl,
        /// <summary>bN^uJB</summary>
        [Description("bN^uJ")]
        OpenLockTab,

        #endregion
    }

    /// <summary>vLVT[o[̐ݒB</summary>
    public enum ProxySetting
    {
        #region Enum Members

        /// <summary>ȂB</summary>
        None,
        /// <summary>InternetExplorer ̐ݒB</summary>
        InternetExplorer,
        /// <summary>JX^B</summary>
        Custom,

    #endregion
    }

    #endregion

    /// <summary>ݒ\NXłB</summary>
    [Serializable()]
    [XmlType("AlternativeConfigRoot")]
    public class AlternativeConfig
    {
        #region Field

        /// <summary>ݒ̃o[WԍłB</summary>
        [XmlElement("ProductVersion", typeof(string), IsNullable = false)]
        private readonly string _productVersion;

        /// <summary>N̓lłB</summary>
        [XmlElement("StartUpAction", typeof(StartUpAction), IsNullable = false)]
        private StartUpAction _startUpAction;

        /// <summary>z[URLłB</summary>
        [XmlElement("HomeUrl", typeof(string), IsNullable = false)]
        private string _homeUrl;

        /// <summary>ۑ̃tH_łB</summary>
        [XmlElement("SaveFolderPath", typeof(string), IsNullable = false)]
        private string _saveFolderPath;

        /// <summary>t@C̏łB</summary>
        [XmlElement("SaveFileFormat", typeof(string), IsNullable = false)]
        private string _saveFileFormat;

        /// <summary>ő哯_E[hłB</summary>
        [XmlElement("MaxDownloadConnections", typeof(int), IsNullable = false)]
        private int _maxDownloadConnections;

        /// <summary>OC̗LElłB</summary>
        [XmlElement("IsAutoLogin", typeof(bool), IsNullable = false)]
        private bool _isAutoLogin;

        /// <summary>OCp[AhXłB</summary>
        [XmlElement("LoginMailAddress", typeof(string), IsNullable = false)]
        private string _loginMailAddress;

        /// <summary>OCppX[hłB</summary>
        [XmlElement("EncryptPassword", typeof(string), IsNullable = false)]
        private string _loginPassword;

        /// <summary>SWFt@C̍ĐɃ[JvOgp邩ǂlłB</summary>
        [XmlElement("UseSwfPlayer", typeof(bool), IsNullable = false)]
        private bool _useSwfPlayer;

        /// <summary>SWFt@C̍ĐɎgvC[ւ̃tpXłB</summary>
        [XmlElement("SwfPlayerPath", typeof(string), IsNullable = false)]
        private string _swfPlayerPath;

        /// <summary>t@C̍ĐɃ[JvOgp邩ǂlłB</summary>
        [XmlElement("UseOtherPlayer", typeof(bool), IsNullable = false)]
        private bool _useOtherPlayer;

        /// <summary>t@C̍ĐɎgvC[ւ̃tpXłB</summary>
        [XmlElement("OtherPlayerPath", typeof(string), IsNullable = false)]
        private string _otherPlayerPath;

        /// <summary>gpvLVT[o[̎ނlłB</summary>
        [XmlElement("ProxySetting", typeof(ProxySetting), IsNullable = false)]
        private ProxySetting _proxySetting;

        /// <summary>vLVT[õAhXłB</summary>
        [XmlElement("ProxyAddress", typeof(string), IsNullable = false)]
        private string _proxyAddress;

        /// <summary>vLVT[õ|[gԍłB</summary>
        [XmlElement("ProxyPort", typeof(int), IsNullable = false)]
        private int _proxyPort;

        /// <summary>NɃ[JvLVT[oN邩ǂ̒lłB</summary>
        [XmlElement("IsLocalProxyStartUp", typeof(bool), IsNullable = false)]
        private bool _isLocalProxyStartUp;

        /// <summary>[J̃vLVT[ovOւ̃tpXłB</summary>
        [XmlElement("LocalProxyPath", typeof(string), IsNullable = false)]
        private string _localProxyPath;

        /// <summary>[JvLVT[ovOÑEGCgߎ(b)łB</summary>
        [XmlElement("LocalProxyStartUpWaitSeconds", typeof(int), IsNullable = false)]
        private int _localProxyStartUpWaitSeconds;

        /// <summary><see cref="TabBrowserControl"/> ׂ̈̐ݒłB</summary>
        [XmlElement("TabBrowserSetting", typeof(TabBrowserSetting), IsNullable = false)]
        private TabBrowserSetting _tabBrowserSetting;

        /// <summary>t@C̐ݒłB</summary>
        [XmlElement("SearchFileInfo", typeof(SearchFileInfo), IsNullable = false)]
        private SearchFileInfo _searchFileInfo;

        /// <summary>tH_쐬̐ݒłB</summary>
        [XmlElement("CreateFolderInfo", typeof(CreateFolderInfo), IsNullable = false)]
        private CreateFolderInfo _createFolderInfo;

        #endregion

        #region Constructor

        /// <summary>CX^X܂B</summary>
        public AlternativeConfig()
        {
            _productVersion = Application.ProductVersion;
            _startUpAction = StartUpAction.OpenPreviousTab;
            _homeUrl = NicoUrl.DefaultTopPage;
            _saveFolderPath = Environment.GetFolderPath(Environment.SpecialFolder.Personal);
            _saveFileFormat = @"<TITLE>(<ID>).<EXT>";
            _maxDownloadConnections = 1;
            _isAutoLogin = false;
            _loginMailAddress = "";
            _loginPassword = StringHelper.Encrypt("");
            _useSwfPlayer = false;
            _swfPlayerPath = "";
            _useOtherPlayer = false;
            _otherPlayerPath = "";
            _proxySetting = ProxySetting.InternetExplorer;
            _proxyAddress = "";
            _proxyPort = 0;
            _isLocalProxyStartUp = false;
            _localProxyPath = "";
            _localProxyStartUpWaitSeconds = 3;
            _tabBrowserSetting = new TabBrowserSetting();
            _searchFileInfo = new SearchFileInfo();
            _createFolderInfo = new CreateFolderInfo();
        }

        #endregion

        #region Properties

        /// <summary>ݒ̃o[Wԍ擾܂(ǂݎp)B</summary>
        public string ProductVersion
        {
            get { return _productVersion; }
            set { /* VACYp */ }
        }

        /// <summary>N̓e擾Eݒ肵܂B</summary>
        public StartUpAction StartUpAction
        {
            get { return _startUpAction; }
            set { _startUpAction = value; }
        }

        /// <summary>z[URL擾Eݒ肵܂B</summary>
        public string HomeUrl
        {
            get { return _homeUrl; }
            set { _homeUrl = value ?? NicoUrl.DefaultTopPage; }
        }

        /// <summary>ۑ̃tH_擾Eݒ肵܂B</summary>
        public string SaveFolderPath
        {
            get { return (_saveFolderPath); }
            set { _saveFolderPath = (value ?? "").Trim(' ', '.', '\\'); }
        }

        /// <summary>ۑt@C擾Eݒ肵܂B</summary>
        public string SaveFileFormat
        {
            get { return _saveFileFormat; }
            set { _saveFileFormat = (value ?? "").Trim(' ', '.'); }
        }

        /// <summary>ۑt@CtpX擾܂(ǂݎp)B</summary>
        public string SaveFullPathFormat
        {
            get { return _saveFolderPath + @"\" + _saveFileFormat; }
        }

        /// <summary>ő哯_E[h擾Eݒ肵܂B</summary>
        public int MaxDownloadConnections
        {
            get { return _maxDownloadConnections; }
            set
            {
                if (value < 0 || value > 3)
                {
                    throw new ArgumentOutOfRangeException(new StackFrame().GetMethod().Name);
                }
                else
                {
                    _maxDownloadConnections = value;
                }
            }
        }

        /// <summary>OC̗LE擾Eݒ肵܂B</summary>
        public bool IsAutoLogin
        {
            get { return _isAutoLogin == true; }
            set { _isAutoLogin = value; }
        }

        /// <summary>OCp[AhX擾Eݒ肵܂B</summary>
        public string LoginMailAddress
        {
            get { return _loginMailAddress; }
            set { _loginMailAddress = value ?? ""; }
        }

        /// <summary>OCppX[h擾Eݒ肵܂B</summary>
        [XmlIgnore()]
        public string LoginPassword
        {
            get { return StringHelper.Decrypt(_loginPassword); }
            set { _loginPassword = StringHelper.Encrypt(value ?? ""); }
        }

        /// <summary>VACYppX[h擾Eݒ肵܂B</summary>
        [Browsable(false)]
        public string EncryptPassword
        {
            get { return _loginPassword; }
            set { _loginPassword = (value ?? StringHelper.Encrypt("")); }
        }

        /// <summary>SWFt@C̍ĐɃ[JvOgp邩ǂ擾Eݒ肵܂B</summary>
        public bool UseSwfPlayer
        {
            get { return _useSwfPlayer; }
            set { _useSwfPlayer = value; }
        }

        /// <summary>SWFt@C̍ĐɎgvC[ւ̃tpX擾Eݒ肵܂B</summary>
        public string SwfPlayerPath
        {
            get { return _swfPlayerPath; }
            set { _swfPlayerPath = value ?? ""; }
        }

        /// <summary>t@C̍ĐɃ[JvOgp邩ǂ擾Eݒ肵܂B</summary>
        public bool UseOtherPlayer
        {
            get { return _useOtherPlayer; }
            set { _useOtherPlayer = value; }
        }

        /// <summary>t@C̍ĐɎgvC[ւ̃tpX擾Eݒ肵܂B</summary>
        public string OtherPlayerPath
        {
            get { return _otherPlayerPath; }
            set { _otherPlayerPath = value ?? ""; }
        }

        /// <summary>gpvLVT[o[̎ނ擾Eݒ肵܂B</summary>
        public ProxySetting ProxySetting
        {
            get { return _proxySetting; }
            set { _proxySetting = value; }
        }

        /// <summary>vLVT[õAhX擾Eݒ肵܂B</summary>
        public string ProxyAddress
        {
            get { return _proxyAddress; }
            set { _proxyAddress = value ?? ""; }
        }

        /// <summary>vLVT[õ|[gԍ擾Eݒ肵܂B</summary>
        public int ProxyPort
        {
            get { return _proxyPort; }
            set { _proxyPort = value; }
        }

        /// <summary>NɃ[JvLVT[oN邩ǂ擾Eݒ肵܂B</summary>
        public bool IsLocalProxyStartUp
        {
            get { return _isLocalProxyStartUp; }
            set { _isLocalProxyStartUp = value; }
        }

        /// <summary>[J̃vLVT[ovOւ̃tpX擾Eݒ肵܂B</summary>
        public string LocalProxyPath
        {
            get { return _localProxyPath; }
            set { _localProxyPath = value ?? ""; }
        }

        /// <summary>[JvLVT[ovOÑEGCgߎ(b)擾Eݒ肵܂B</summary>
        public int LocalProxyStartUpWaitSeconds
        {
            get { return _localProxyStartUpWaitSeconds; }
            set { _localProxyStartUpWaitSeconds = value; }
        }

        /// <summary><see cref="TabBrowserControl"/> ׂ̈̐ݒ擾Eݒ肵܂B</summary>
        public TabBrowserSetting TabBrowserSetting
        {
            get { return _tabBrowserSetting; }
            set { _tabBrowserSetting = value; }
        }

        /// <summary>t@C̐ݒ擾Eݒ肵܂B</summary>
        public SearchFileInfo SearchFileInfo
        {
            get { return _searchFileInfo; }
            set { _searchFileInfo = value; }
        }

        /// <summary>tH_쐬̐ݒ擾Eݒ肵܂B</summary>
        public CreateFolderInfo CreateFolderInfo
        {
            get { return _createFolderInfo; }
            set { _createFolderInfo = value; }
        }

        #endregion
    }
}
