/*
 * blancoDb
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.invoker;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.db.common.expander.BlancoDbAbstractClass;
import blanco.db.common.util.BlancoDbUtil;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.db.expander.query.Finalize;
import blanco.db.expander.query.GetQueryMethod;
import blanco.db.expander.query.GetStatementMethod;
import blanco.db.expander.query.PrepareStatementMethod;
import blanco.db.expander.query.PrepareStatementMethod2;
import blanco.db.expander.query.QueryConstructor;
import blanco.db.expander.query.field.ConnectionField;
import blanco.db.expander.query.field.LogField;
import blanco.db.expander.query.field.LogSqlDynamicSqlField;
import blanco.db.expander.query.field.LogSqlInParamField;
import blanco.db.expander.query.field.StatementField;
import blanco.db.expander.query.iterator.SetInputParameterMethod;
import blanco.db.resourcebundle.BlancoDbResourceBundle;

/**
 * ʂ̃NXWJ邽߂̃NXB
 * 
 * @author Yasuo Nakanishi
 */
public class QueryInvokerClass extends BlancoDbAbstractClass {
    private final BlancoDbResourceBundle fBundle = new BlancoDbResourceBundle();

    public QueryInvokerClass(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory) {
        super(argDbSetting, argSqlInfo, argCgFactory);
    }

    public BlancoCgSourceFile expand() {
        final String className = BlancoNameAdjuster.toClassName(fSqlInfo
                .getName()) + "Invoker";

        fCgSourceFile = fCgFactory.createSourceFile(
                BlancoDbUtil.getBasePackage(fSqlInfo, fDbSetting) + ".query",
                "This code is generated by blanco Framework.");
        fCgClass = fCgFactory.createClass(className, "[" + fSqlInfo.getName()
                + "] " + fSqlInfo.getDescription() + " (QueryInvoker)");
        fCgSourceFile.getClassList().add(fCgClass);

     // (2013/01/08 Uo^) fCgClass.getExtendClassList().add(fCgFactory.createType("java.io.Closeable"));
        fCgClass.getImplementInterfaceList().add(fCgFactory.createType("blanco.db.runtime.BlancoDbQuery"));

        // Ame[Vt^܂B
        fCgClass.getAnnotationList().add("BlancoGeneratedBy(name = \"blancoDb\")");
        fCgSourceFile.getImportList().add("blanco.fw.BlancoGeneratedBy");

        fCgClass.getLangDoc().getDescriptionList()
                .add("s^SQLbsOĊeANZT񋟂܂B<br>");
        if (fSqlInfo.getSingle()) {
            fCgClass.getLangDoc().getDescriptionList()
                    .add("VO: L (҂鏈1)<br>");
        }

        fCgSourceFile.getImportList().add(
                BlancoDbUtil.getRuntimePackage(fDbSetting)
                        + ".exception.IntegrityConstraintException");

        // BlancoDbUtil͏ɃC|[g܂B
        fCgSourceFile.getImportList().add(
                BlancoDbUtil.getRuntimePackage(fDbSetting)
                        + ".util.BlancoDbUtil");

        new ConnectionField(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                fCgClass).expand();
        new StatementField(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                fCgClass, false).expand();

        new QueryConstructor(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                fCgClass).expand();
        new GetQueryMethod(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                fCgClass).expand();

        new PrepareStatementMethod(fDbSetting, fSqlInfo, fCgFactory,
                fCgSourceFile, fCgClass).expand();
        // t.iga
        new PrepareStatementMethod2(fDbSetting, fSqlInfo, fCgFactory,
                fCgSourceFile, fCgClass).expand();

        // ̓p[^ꍇɂ̂bind܂B
        if (fSqlInfo.getInParameterList().size() > 0) {
            new SetInputParameterMethod(fDbSetting, fSqlInfo, fCgFactory,
                    fCgSourceFile, fCgClass, false).expand();
        }
        new ExecuteUpdateMethod(fDbSetting, fSqlInfo, fCgFactory,
                fCgSourceFile, fCgClass).expand();
        if (fSqlInfo.getSingle()) {
            new ExecuteSingleUpdateMethod(fDbSetting, fSqlInfo, fCgFactory,
                    fCgSourceFile, fCgClass).expand();
        }

        if (fBundle.getExpanderDisableGetStatement().equals("true") == false) {
            // 1.6.8ȑOƌ݊Kvꍇɂ̂ getStatement𐶐܂B
            new GetStatementMethod(fDbSetting, fSqlInfo, fCgFactory,
                    fCgSourceFile, fCgClass, false).expand();
        }

        new CloseMethod(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                fCgClass).expand();

        new Finalize(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile, fCgClass)
                .expand();

		if (fDbSetting.getLoggingsql()) {
			// Wo͂ɏóB
			new LogSqlInParamField(fDbSetting, fSqlInfo, fCgFactory,
					fCgSourceFile, fCgClass).expand();
			if (fSqlInfo.getDynamicSql()) {
				new LogSqlDynamicSqlField(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile, fCgClass).expand();
			}
		}

        if (fDbSetting.getLogging()) {
            fCgSourceFile.getImportList().add(
                    "org.apache.commons.logging.LogFactory");
            new LogField(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                    fCgClass).expand();
        }

        return fCgSourceFile;
    }
}