package blanco.html.parser;

import java.io.File;
import java.io.IOException;
import java.util.List;

import junit.framework.TestCase;
import blanco.commons.util.BlancoFileUtil;
import blanco.html.parser.helper.BlancoHtmlNullContentHandler;
import blanco.html.parser.valueobject.BlancoHtmlAttribute;

public class BlancoHtmlParserTest extends TestCase {
    class MyHandler extends BlancoHtmlNullContentHandler {
        public void startDocument() throws IOException {
            System.out.println("startDocument()");
        }

        public void endDocument() throws IOException {
            System.out.println("endDocument()");
        }

        public void startElement(final String name,
                final List<BlancoHtmlAttribute> attrs) {
            System.out.println("startElement(" + name + ", " + attrs.toString()
                    + ")");
        }

        public void endElement(final String name) {
            System.out.println("endElement(" + name + ")");
        }

        public void characters(final String argCharacters) {
            System.out.println("characters(" + argCharacters + ")");
        }

        public void comments(final String argComments, final int argType) {
            System.out.println("comments(" + argComments + ")");
        }
    }

    public void testParser001() throws Exception {
        new File("tmp").mkdirs();

        // ̓f[^B
        final byte[] inputData = BlancoFileUtil.file2Bytes(new File(
                "./test/data/test001.html"));

        // HTML̃GR[fBO擾B
        final BlancoHtmlParser encodingParser = BlancoHtmlParserFactory
                .getInstance();
        encodingParser.parse(inputData);

        final BlancoHtmlContentSerializer serializer = new BlancoHtmlContentSerializer();
        serializer.setWriter(BlancoHtmlParserTestUtil.getWriter(new File(
                "./tmp/test001.html"), encodingParser.getEncoding()));

        final BlancoHtmlParser parser = BlancoHtmlParserFactory.getInstance();
        parser.setHandler(serializer);

        parser.parse(inputData);
        serializer.getWriter().close();

        // o̓f[^B
        final byte[] outputData = BlancoFileUtil.file2Bytes(new File(
                "./tmp/test001.html"));
        assertEquals(new String(inputData, encodingParser.getEncoding()),
                new String(outputData, encodingParser.getEncoding()));
    }
}
