/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.xml.bind;

import java.util.ArrayList;
import java.util.List;

import blanco.xml.bind.valueobject.BlancoXmlAttribute;
import blanco.xml.bind.valueobject.BlancoXmlCdata;
import blanco.xml.bind.valueobject.BlancoXmlCharacters;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * blancoXmlBindingœꂽo[IuWFNgɑ΂鑀x[eBeBłB
 * 
 * @author IGA Tosiki
 */
public class BlancoXmlBindingUtil {
    /**
     * ̃NX̓CX^X͂܂B
     */
    private BlancoXmlBindingUtil() {
    }

    /**
     * ^ꂽhLgGg擾܂B
     * 
     * ŏɌGg߂܂B
     * 
     * @param argDocument
     *            ΏۂƂȂhLgB
     * @return (ŏɌ)GgBGgȂꍇɂnull߂܂B
     */
    public static final BlancoXmlElement getDocumentElement(
            final BlancoXmlDocument argDocument) {
        final List<blanco.xml.bind.valueobject.BlancoXmlNode> listRoot = argDocument
                .getChildNodes();
        for (int index = 0; index < listRoot.size(); index++) {
            final Object objLook = listRoot.get(index);
            if (objLook instanceof BlancoXmlElement == false) {
                continue;
            }
            return (BlancoXmlElement) objLook;
        }

        // ЂƂ܂łB
        return null;
    }

    /**
     * ^ꂽGg̎qm[hGg擾܂B
     * 
     * ɍvSẴGg߂܂B
     * 
     * @param argElement
     *            ΏۂƂȂGgB
     * @param argTagname
     *            ^OB([J)
     * @return Gg̃XgBGgȂꍇɂ͋List߂܂B
     */
    public static final List<blanco.xml.bind.valueobject.BlancoXmlElement> getElementsByTagName(
            final BlancoXmlElement argElement, final String argTagname) {
        if (argElement == null) {
            throw new IllegalArgumentException(
                    "BlancoXmlBindingUtil.getElementsByTagName: (Gg)null^܂B");
        }

        final List<blanco.xml.bind.valueobject.BlancoXmlElement> listResult = new ArrayList<blanco.xml.bind.valueobject.BlancoXmlElement>();

        final List<blanco.xml.bind.valueobject.BlancoXmlNode> listChild = argElement
                .getChildNodes();
        for (int index = 0; index < listChild.size(); index++) {
            final Object objLook = listChild.get(index);
            if (objLook instanceof BlancoXmlElement == false) {
                continue;
            }

            final BlancoXmlElement elementLook = (BlancoXmlElement) objLook;
            if (elementLook.getLocalName().equals(argTagname)) {
                listResult.add((BlancoXmlElement) objLook);
            }
        }

        return listResult;
    }

    /**
     * ^ꂽGg̎qm[hGg擾܂B
     * 
     * ŏɌGg߂܂B̃GgvƂĂQڈȍ~͖܂B
     * 
     * @param argElement
     *            ΏۂƂȂGgB
     * @param argTagname
     *            ^OB([J)
     * @return ŏɌGgBGgȂꍇɂnull߂܂B
     */
    public static final BlancoXmlElement getElement(
            final BlancoXmlElement argElement, final String argTagname) {
        final List<blanco.xml.bind.valueobject.BlancoXmlNode> listChild = argElement
                .getChildNodes();
        for (int index = 0; index < listChild.size(); index++) {
            final Object objLook = listChild.get(index);
            if (objLook instanceof BlancoXmlElement == false) {
                continue;
            }

            final BlancoXmlElement elementLook = (BlancoXmlElement) objLook;
            if (elementLook.getLocalName().equals(argTagname)) {
                return elementLook;
            }
        }

        // ЂƂ܂łB
        return null;
    }

    /**
     * Iꂽm[h(Ggł)當擾܂B
     * 
     * m[hɂԂ炳ĂSẴeLXgf[^擾ꍇɗp܂B
     * 
     * @param argElement
     *            ΏۂƂ^[QbgGg
     * @return 擾ꂽeLXgB擾Ȃꍇɂnull߂܂B
     */
    public static final String getTextContent(final BlancoXmlElement argElement) {
        if (argElement == null) {
            throw new IllegalArgumentException(
                    "m[heLXg擾郁\bhnull^܂BnullȊO̒l^悤ɂĂB");
        }

        final StringBuffer result = new StringBuffer();
        boolean isProcessed = false;

        final List<blanco.xml.bind.valueobject.BlancoXmlNode> listText = argElement
                .getChildNodes();
        final int sizeChildList = listText.size();
        for (int indexChild = 0; indexChild < sizeChildList; indexChild++) {
            final Object objLook = listText.get(indexChild);
            if (objLook instanceof BlancoXmlCharacters) {
                final BlancoXmlCharacters textLook = (BlancoXmlCharacters) objLook;
                result.append(textLook.getValue());
                isProcessed = true;
            } else if (objLook instanceof BlancoXmlCdata) {
                final BlancoXmlCdata cdataLook = (BlancoXmlCdata) objLook;
                result.append(getTextContent(cdataLook));
                isProcessed = true;
            }
            // BlancoXmlIgnorableWhitespace ͏Ώۂ͂܂B
        }

        if (isProcessed == false) {
            return null;
        } else {
            return result.toString();
        }
    }

    /**
     * Ggw̃^O̕ǂݍ݂܂B
     * 
     * @param elementTarget
     *            ΏۂƂ^[QbgGg
     * @param tagName
     *            ^O
     * @return 擾ꂽeLXgB擾Ȃꍇɂnull߂܂B
     */
    public static final String getTextContent(
            final BlancoXmlElement elementTarget, final String tagName) {
        if (elementTarget == null) {
            throw new IllegalArgumentException(
                    "GgeLXg擾郁\bhɃGgƂnull^܂BnullȊO̒l^悤ɂĂB");
        }
        if (tagName == null) {
            throw new IllegalArgumentException(
                    "GgeLXg擾郁\bhɃ^OƂnull^܂BnullȊO̒l^悤ɂĂB");
        }

        final StringBuffer result = new StringBuffer();
        boolean isProcessed = false;

        final List<blanco.xml.bind.valueobject.BlancoXmlElement> listElementTarget = getElementsByTagName(
                elementTarget, tagName);
        final int sizeList = listElementTarget.size();
        for (int index = 0; index < sizeList; index++) {
            final Object nodeLook = listElementTarget.get(index);
            if (nodeLook instanceof BlancoXmlElement) {
                final BlancoXmlElement elementLook = (BlancoXmlElement) nodeLook;

                final List<blanco.xml.bind.valueobject.BlancoXmlNode> listText = elementLook
                        .getChildNodes();
                final int sizeChildList = listText.size();
                for (int indexChild = 0; indexChild < sizeChildList; indexChild++) {
                    final Object nodeChild = listText.get(indexChild);
                    if (nodeChild instanceof BlancoXmlCharacters) {
                        final BlancoXmlCharacters textLook = (BlancoXmlCharacters) nodeChild;
                        result.append(textLook.getValue());
                        isProcessed = true;
                    } else if (nodeChild instanceof BlancoXmlCdata) {
                        final BlancoXmlCdata cdataLook = (BlancoXmlCdata) nodeChild;
                        result.append(getTextContent(cdataLook));
                        isProcessed = true;
                    }
                    // BlancoXmlIgnorableWhitespace ͏Ώۂ͂܂B
                }
            }
        }

        if (isProcessed == false) {
            return null;
        } else {
            return result.toString();
        }
    }

    /**
     * ^ꂽ CDATA eLXgǂݏo܂B
     * 
     * @param argCdata
     * @return
     */
    public static final String getTextContent(final BlancoXmlCdata argCdata) {
        if (argCdata == null) {
            throw new IllegalArgumentException(
                    "CDATAeLXg擾郁\bhnull^܂BnullȊO̒l^悤ɂĂB");
        }

        final StringBuffer result = new StringBuffer();
        boolean isProcessed = false;

        final List<blanco.xml.bind.valueobject.BlancoXmlNode> listText = argCdata
                .getChildNodes();
        final int sizeChildList = listText.size();
        for (int indexChild = 0; indexChild < sizeChildList; indexChild++) {
            final Object objLook = listText.get(indexChild);
            if (objLook instanceof BlancoXmlCharacters) {
                final BlancoXmlCharacters textLook = (BlancoXmlCharacters) objLook;
                result.append(textLook.getValue());
                isProcessed = true;
            } else if (objLook instanceof BlancoXmlCdata) {
                final BlancoXmlCdata cdataLook = (BlancoXmlCdata) objLook;
                for (int index = 0; index < cdataLook.getChildNodes().size(); index++) {

                    result.append(getTextContent(cdataLook));
                }
                isProcessed = true;
            }
            // BlancoXmlIgnorableWhitespace ͏Ώۂ͂܂B
        }

        if (isProcessed == false) {
            return null;
        } else {
            return result.toString();
        }
    }

    /**
     * Gg^ꂽQNameɂAgr[gl擾܂B
     * 
     * @param argElement
     * @param argQName
     * @return
     */
    public static final String getAttribute(final BlancoXmlElement argElement,
            final String argQName) {
        for (int indexAttr = 0; indexAttr < argElement.getAtts().size(); indexAttr++) {
            final BlancoXmlAttribute attr = argElement.getAtts().get(indexAttr);
            if (argQName.equals(attr.getQName())) {
                return attr.getValue();
            }
        }

        // ł܂łB
        return null;
    }
}
