/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.eclipseplugingen.task;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.xml.transform.TransformerException;

import blanco.eclipseplugingen.BlancoEclipsePluginGenConstants;
import blanco.eclipseplugingen.BlancoEclipsePluginGenMeta2Xml;
import blanco.eclipseplugingen.BlancoEclipsePluginGenXml2JavaClass;
import blanco.eclipseplugingen.task.valueobject.BlancoEclipsePluginGenProcessInput;

public class BlancoEclipsePluginGenProcessImpl implements
        BlancoEclipsePluginGenProcess {

    public int execute(final BlancoEclipsePluginGenProcessInput input)
            throws IOException, IllegalArgumentException {
        System.out.println("- " + BlancoEclipsePluginGenConstants.PRODUCT_NAME
                + " (" + BlancoEclipsePluginGenConstants.VERSION + ")");

        try {
            final File blancoTmpAntTaskDirectory = new File(input.getTmpdir()
                    + BlancoEclipsePluginGenConstants.TARGET_SUBDIRECTORY);
            blancoTmpAntTaskDirectory.mkdirs();

            final File fileMetadir = new File(input.getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException("^fBNg["
                        + input.getMetadir() + "]݂܂B");
            }

            final File[] fileMeta = fileMetadir.listFiles();
            for (int index = 0; index < fileMeta.length; index++) {
                if (fileMeta[index].getName().endsWith(".xls") == false) {
                    continue;
                }
                final File fileTmpTarget = new File(blancoTmpAntTaskDirectory
                        + "/" + fileMeta[index].getName() + ".xml");

                InputStream inStream = null;
                OutputStream outStream = null;
                try {
                    inStream = new BufferedInputStream(new FileInputStream(
                            fileMeta[index]));
                    outStream = new BufferedOutputStream(new FileOutputStream(
                            fileTmpTarget));
                    new BlancoEclipsePluginGenMeta2Xml().process(inStream,
                            outStream);
                    outStream.flush();
                } finally {
                    if (inStream != null) {
                        inStream.close();
                    }
                    if (outStream != null) {
                        outStream.close();
                    }
                }
            }

            final File[] fileTmp = blancoTmpAntTaskDirectory.listFiles();
            for (int index = 0; index < fileTmp.length; index++) {
                if (fileTmp[index].getName().endsWith(".xml")) {
                    new BlancoEclipsePluginGenXml2JavaClass().process(
                            fileTmp[index], new File(input.getTargetdir()),
                            new File(input.getRootdir()));
                }
            }

            return BlancoEclipsePluginGenBatchProcess.END_SUCCESS;
        } catch (TransformerException e) {
            throw new IOException("XMLϊ̉ߒŗO܂: " + e.toString());
        }
    }
}
