/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.commons.calc.parser.block;

/**
 * e[u\܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoCalcParserTableColumn {

    private String _columnName = "name";

    private String[] _columnString = null;

    private int columnPosition = -1;

    /**
     * e[ũJIuWFNg̃RXgN^B
     * 
     * @param name
     *            JB
     */
    public BlancoCalcParserTableColumn(final String name) {
        this._columnName = name;
    }

    /**
     * e[u̗ރIuWFNg̃RXgN^B
     * 
     * @param name
     *            JB
     * @param columnString
     *            J̔zB
     */
    public BlancoCalcParserTableColumn(final String name,
            final String[] columnString) {
        this._columnName = name;
        this._columnString = columnString;
    }

    /**
     * ̖O擾܂B
     * 
     * @return ̖OB
     */
    public String getName() {
        return _columnName;
    }

    /**
     * ̖Oݒ肵܂B
     * 
     * @param arg
     *            ̖OB
     */
    public void setName(final String arg) {
        _columnName = arg;
    }

    /**
     * JL܂B
     * 
     * @param arg
     *            J̔zB
     */
    public void setColumnString(final String[] arg) {
        _columnString = arg;
    }

    /**
     * JnɃqbg邩ǂ܂B
     * 
     * @param arg
     *            JnB
     * @return qbgǂB
     */
    public boolean isStartString(String arg) {
        final int columnStringLength = _columnString.length;
        for (int index = 0; index < columnStringLength; index++) {
            if (_columnString[index].equals(arg)) {
                return true;
            }
        }
        return false;
    }

    /**
     * ̃Jԍ擾܂B
     * 
     * @return ̃JԍB
     */
    public int getColumnPosition() {
        return columnPosition;
    }

    /**
     * ̃JԍL܂B
     * 
     * @param arg
     *            ̃JԍB
     */
    public void setColumnPosition(int arg) {
        columnPosition = arg;
    }
}
