/*
 * blancoCommons Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.commons.calc.parser;

import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;

import junit.framework.TestCase;

import org.xml.sax.InputSource;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

import blanco.commons.calc.parser.block.BlancoCalcParserPropertyBlock;
import blanco.commons.calc.parser.block.BlancoCalcParserPropertyKey;
import blanco.commons.calc.parser.block.BlancoCalcParserTableBlock;
import blanco.commons.calc.parser.block.BlancoCalcParserTableColumn;
import blanco.commons.calc.parser.block.BlancoCalcParserValueMapping;
import blanco.commons.parser.SystemOutContentHandler;

/**
 * @author iga
 */
public class BlancoCalcParserTest extends TestCase {

    /*
     * void parse ̃eXg̃NX(String)
     */
    public void testParseString() {
        OutputStream outStream = null;

        BlancoCalcParserPropertyBlock propertyBlock = new BlancoCalcParserPropertyBlock(
                "attribute");
        propertyBlock.setStartString(new String[] { "Ɩ" });
        propertyBlock
                .setValueMapping(new BlancoCalcParserValueMapping[] {
                        new BlancoCalcParserValueMapping(new String[] { "",
                                "" }, "true"),
                        new BlancoCalcParserValueMapping(new String[] { "Ȃ" },
                                "false"),
                        new BlancoCalcParserValueMapping(
                                new String[] { "^" }, "iterator"),
                        new BlancoCalcParserValueMapping(
                                new String[] { "s^" }, "invoker"),
                        new BlancoCalcParserValueMapping(
                                new String[] { "KP" }, "true"),
                        new BlancoCalcParserValueMapping(
                                new String[] { "(0܂)" }, "false") });

        BlancoCalcParserPropertyKey propertyTitle = new BlancoCalcParserPropertyKey(
                "gamen-id", new String[] { "ID" });
        propertyTitle.setSearchRangeX(4);
        propertyBlock.add(propertyTitle);

        propertyTitle = new BlancoCalcParserPropertyKey("name",
                new String[] { "NG" });
        propertyTitle.setSearchRangeX(4);
        propertyBlock.add(propertyTitle);

        propertyTitle = new BlancoCalcParserPropertyKey("query-type",
                new String[] { "SQL^Cv" });
        propertyTitle.setSearchRangeX(8);
        propertyBlock.add(propertyTitle);

        propertyTitle = new BlancoCalcParserPropertyKey("single",
                new String[] { "҂鏈" });
        propertyTitle.setSearchRangeX(8);
        propertyBlock.add(propertyTitle);

        propertyTitle = new BlancoCalcParserPropertyKey("scroll",
                new String[] { "XN[" });
        propertyTitle.setSearchRangeX(8);
        propertyBlock.add(propertyTitle);

        propertyTitle = new BlancoCalcParserPropertyKey("updatable",
                new String[] { "XV\" });
        propertyTitle.setSearchRangeX(8);
        propertyBlock.add(propertyTitle);

        BlancoCalcParser parser = new BlancoCalcParser();
        parser.add(propertyBlock);

        // ʂ̃ubN
        BlancoCalcParserTableBlock tableBlock = new BlancoCalcParserTableBlock(
                "parameters");
        tableBlock.setStartString(new String[] { "SQL̓p[^" });
        tableBlock.setRowName("parameter");
        tableBlock.setSearchRangeForTitleY(2);
        BlancoCalcParserTableColumn tableTitle = new BlancoCalcParserTableColumn(
                "name", new String[] { "p[^ID" });
        tableBlock.add(tableTitle);

        tableTitle = new BlancoCalcParserTableColumn("type",
                new String[] { "^Cv" });
        tableBlock.add(tableTitle);

        tableTitle = new BlancoCalcParserTableColumn("p[^",
                new String[] { "p[^" });
        tableBlock.add(tableTitle);

        parser.add(tableBlock);

        // ʂ̃ubN
        tableBlock = new BlancoCalcParserTableBlock("query");
        tableBlock.setStartString(new String[] { "SQL" });
        tableBlock.setEndString(new String[] { "SQLGAI" });
        tableBlock.setSearchRangeForTitleY(1);
        tableBlock.setSearchRangeY(100);
        tableTitle = new BlancoCalcParserTableColumn("query-line",
                new String[] { "SQL" });
        tableBlock.add(tableTitle);
        parser.add(tableBlock);

        // ̓Iȃnh ̃eXg͏܂B
        parser.chainContentHandlerStream(new BlancoDbExcelContentHandler(
                new SystemOutContentHandler()));

        try {
            // [gm[hwB
            parser.setProperty(BlancoCalcParser.URI_PROPERTY_NAME_WORKBOOK,
                    "blanco-db");
            outStream = new BufferedOutputStream(new FileOutputStream(
                    "./meta/blancoCalcParserTestData.xml"));
            BlancoCalcParser.getTransformer().transform(
                    new SAXSource(parser, new InputSource(
                            "./meta/blancoCalcParserTestData.xls")),
                    new StreamResult(outStream));
            outStream.flush();
            outStream.close();
            outStream = null;
        } catch (TransformerException ex) {
            System.out.println("XMLhLgۑɕϊO܂.:" + ex.toString());
            ex.printStackTrace();
            return;
        } catch (IOException ex3) {
            System.out.println("XMLhLgۑɓo͗O܂.:" + ex3.toString());
            ex3.printStackTrace();
            return;
        } catch (SAXNotRecognizedException e) {
            // TODO ꂽ catch ubN
            e.printStackTrace();
        } catch (SAXNotSupportedException e) {
            // TODO ꂽ catch ubN
            e.printStackTrace();
        } finally {
            if (outStream != null) {
                try {
                    outStream.close();
                } catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}
