/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.bcel.task;

import java.io.File;
import java.io.IOException;

import blanco.bcel.BlancoBcelConstants;
import blanco.bcel.BlancoBcelJavaClass2Xml;

/**
 * Apache Jakarta BCELpāA JavaoCgR[h(classt@C)͂ BCEL͌ʂXMLt@Cɏo͂܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoBcelJava2XmlTask extends AbstractBlancoBcelJava2XmlTask {
    /**
     * Ant^XN̖{s܂B
     * 
     * ̃\bh Ant^XN̂߂̒ۃ\bhĂяo܂B<br>
     * K{ڂ̃`FbNȂǂIA܂KvɉftHglZbgꂽԂŏ̃\bhւƈn܂B
     * 
     * @throws IllegalArgumentException
     *             ^ꂽfBNgȂǂ̓͗Oɔ܂B
     */
    protected void process() throws IllegalArgumentException {
        System.out.println("- " + BlancoBcelConstants.PRODUCT_NAME + " ("
                + BlancoBcelConstants.VERSION + ")");

        System.out.println("j2x: begin.");
        final long startMills = System.currentTimeMillis();

        final File fileMetadir = new File(getMetadir());
        if (fileMetadir.exists() == false) {
            throw new IllegalArgumentException("w肳ꂽ^fBNg["
                    + fileMetadir.getAbsolutePath() + "]܂łB");
        }
        if (fileMetadir.isDirectory() == false) {
            throw new IllegalArgumentException("w肳ꂽ^fBNg["
                    + fileMetadir.getAbsolutePath() + "]̓fBNgł͂܂B");
        }

        final File fileTargetdir = new File(getTargetdir());
        if (fileTargetdir.exists() == false) {
            if (fileTargetdir.mkdirs() == false) {
                throw new IllegalArgumentException("w肳ꂽo͐fBNg["
                        + fileTargetdir.getAbsolutePath() + "]̍쐬Ɏs܂B");
            }
        }

        final File[] files = fileMetadir.listFiles();
        for (int index = 0; index < files.length; index++) {
            if (files[index].isFile() == false) {
                // t@CȊO͏܂B
                continue;
            }
            if (files[index].getName().endsWith(".class") == false) {
                // *.classȊO͏܂B
                continue;
            }

            try {
                new BlancoBcelJavaClass2Xml().process(files[index], new File(
                        fileTargetdir.getAbsolutePath() + "/"
                                + files[index].getName() + ".xml"));
            } catch (IOException ex) {
                ex.printStackTrace();
            } catch (IllegalArgumentException ex) {
                ex.printStackTrace();
                throw ex;
            }
        }

        final long endMills = System.currentTimeMillis() - startMills;
        System.out.println("j2x: end: " + (endMills / 1000) + " sec.");
    }
}
