/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.wsdl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoStringUtil;
import blanco.commons.util.BlancoXmlUtil;
import blanco.wsdl.resourcebundle.BlancoWsdlResourceBundle;
import blanco.xsd.BlancoXsdUtil;
import blanco.xsd.concretesax.BlancoXsdSerializer;

/**
 * blancoWsdl̒XMLt@C`ꂽ^t@C͂ƂāAXSDt@C𐶐܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoWsdlXml2Xsd {
    /**
     * fobOo͂sǂ̃XCb`
     */
    private static final boolean IS_DEBUG = false;

    /**
     * \[XohIuWFNgB
     */
    private static final BlancoWsdlResourceBundle bundle = new BlancoWsdlResourceBundle();

    /**
     * uXML Schema̗vf錾𐶐vIvVwł悤ɂ邽߂̃tOłB<br>
     * {Iɂ́Afalseŗp܂B<br>
     * XML SchemaP̂p XML Schema`FbNȂ悤ȋǖʂɂāÃXCb`trueɕύXKv܂B<br>
     * ʏWebT[rXł ̃tOfalseɐݒ肳Ă邱Ƃł傤B
     */
    private boolean fIsGenerateXsdElementDeclaration = false;

    /**
     * Kw`\L[[hłB
     */
    private static final String HIERARCHY = "hierarchy";

    /**
     * uXML Schema̗vf錾𐶐vIvVwł悤ɂ邽߂̃tOłB<br>
     * {Iɂ́Afalseŗp܂B<br>
     * XML SchemaP̂p XML Schema`FbNȂ悤ȋǖʂɂāÃXCb`trueɕύXKv܂B<br>
     * ʏWebT[rXł ̃tOfalseɐݒ肳Ă邱Ƃł傤B
     * 
     * @param arg
     *            XML Schema̗vf錾𐶐邩ǂB
     */
    public void setGenerateXsdElementDeclaration(final boolean arg) {
        fIsGenerateXsdElementDeclaration = arg;
    }

    /**
     * uXML Schema̗vf錾𐶐vIvVwł悤ɂ邽߂̃tOłB<br>
     * {Iɂ́Afalseŗp܂B<br>
     * XML SchemaP̂p XML Schema`FbNȂ悤ȋǖʂɂāÃXCb`trueɕύXKv܂B<br>
     * ʏWebT[rXł ̃tOfalseɐݒ肳Ă邱Ƃł傤B
     * 
     * @return XML Schema̗vf錾𐶐邩ǂB
     */
    public boolean getGenerateXsdElementDeclaration() {
        return fIsGenerateXsdElementDeclaration;
    }

    /**
     * s܂BNX̏s̃Gg|Cgł
     * 
     * @param fileSource
     * @param directoryTarget
     * @throws IOException
     * @throws SAXException
     * @throws TransformerException
     */
    public void process(final File fileSource, final File directoryTarget)
            throws IOException, SAXException, TransformerException {
        final DOMResult result = new DOMResult();
        InputStream inStream = null;
        try {
            inStream = new FileInputStream(fileSource);
            final TransformerFactory tf = TransformerFactory.newInstance();
            final Transformer transformer = tf.newTransformer();
            transformer.transform(new StreamSource(inStream), result);
        } finally {
            if (inStream != null) {
                inStream.close();
                inStream = null;
            }
        }

        final Node rootNode = result.getNode();
        if (rootNode instanceof Document) {
            // ꂪnBhLg[g擾
            final Document rootDocument = (Document) rootNode;
            final NodeList listSheet = rootDocument
                    .getElementsByTagName("sheet");
            final int sizeListSheet = listSheet.getLength();
            for (int index = 0; index < sizeListSheet; index++) {
                final Element elementSheet = (Element) listSheet.item(index);

                final NodeList listCommon = elementSheet
                        .getElementsByTagName("blancotelegram-common");
                if (listCommon.getLength() == 0) {
                    // commonꍇɂ̓XLbv܂B
                    continue;
                }

                final Element elementCommon = (Element) listCommon.item(0);

                final String telemgramId = BlancoXmlUtil.getTextContent(
                        elementCommon, "telegramId");
                if (telemgramId == null) {
                    // dIDL͖̂̂B
                    continue;
                }

                expandSheet(elementSheet, elementCommon, directoryTarget);
            }
        }
    }

    /**
     * dIDApXAO͂ƂāAõ͎NX肵܂B
     * 
     * @param telegramId
     *            dIDB
     * @param path
     *            pXB
     * @param name
     *            OB
     * @return õ͎NXB
     */
    private static String toClassName(final String telegramId,
            final String path, final String name) {
        if (path == null || path.length() == 0) {
            return telegramId + "_" + BlancoNameAdjuster.toClassName(name);
        } else {
            return telegramId + "_"
                    + BlancoNameAdjuster.toClassName(path + "/" + name);
        }
    }

    /**
     * V[gWJ܂B
     * 
     * @param elementSheet
     * @param elementCommon
     * @param directoryTarget
     * @throws IOException
     * @throws SAXException
     * @throws TransformerConfigurationException
     */
    private void expandSheet(final Element elementSheet,
            final Element elementCommon, final File directoryTarget)
            throws IOException, SAXException, TransformerConfigurationException {
        final String telegramId = BlancoXmlUtil.getTextContent(elementCommon,
                "telegramId");
        final String telegramNamespace = BlancoXmlUtil.getTextContent(
                elementCommon, "telegramNamespace");
        final String packageName = BlancoXmlUtil.getTextContent(elementCommon,
                "packageName");

        if (telegramNamespace == null) {
            throw new IllegalArgumentException(bundle
                    .getXml2xsdCheck021(telegramId));
        }

        final NodeList listTelegramList = elementSheet
                .getElementsByTagName("blancotelegram-list");
        // dɂẮAdꗗ󗓂łƂĂs܂B
        // ̂߁AlistTelegramList̒`FbN͍s܂B

        OutputStream outStream = null;
        try {
            directoryTarget.mkdirs();
            outStream = new FileOutputStream(directoryTarget.getAbsolutePath()
                    + "/" + telegramId + ".xsd");

            final BlancoXsdSerializer serializer = new BlancoXsdSerializer(
                    outStream);
            serializer.startDocument();
            serializer.startElementXsdSchema(
                    "http://www.w3.org/2001/XMLSchema", telegramNamespace,
                    "http://java.sun.com/xml/ns/jaxb", telegramNamespace,
                    "qualified");

            if (BlancoStringUtil.null2Blank(packageName).length() > 0) {
                // annotationփpbP[W𖄂ߍ݂܂B
                serializer.characters("\n  ");
                serializer.startElementXsdAnnotation();
                serializer.characters("\n    ");
                serializer.startElementXsdAppinfo();
                serializer.characters("\n      ");
                serializer.startElementJxbSchemaBindings();
                serializer.characters("\n        ");
                serializer.startElementJxbPackage(packageName);
                serializer.endElementJxbPackage();
                serializer.characters("\n      ");
                serializer.endElementJxbSchemaBindings();
                serializer.characters("\n    ");
                serializer.endElementXsdAppinfo();
                serializer.characters("\n  ");
                serializer.endElementXsdAnnotation();
            }

            if (listTelegramList != null) {
                // pẌꗗ擾܂B
                final LinkedHashMap pathList = new LinkedHashMap();
                // ő[̃pXL܂B
                int maxPathDeapth = 0;

                final NodeList listTelegram = ((Element) listTelegramList
                        .item(0)).getElementsByTagName("telegram");
                final int sizeListRow = listTelegram.getLength();

                // dvF`ɂ͓ɋLڂȂƂA[g(:root)
                // Öق̂(邢̓ftHg)݂pXłB
                // ̂߁AŃ}bvɑ΂ĖIɓo^{܂B
                pathList.put("", "root");

                // ŏɃpẌꗗmKv̂ŁApXr߂܂B
                for (int indexField = 0; indexField < sizeListRow; indexField++) {
                    final Element elementTelegram = (Element) listTelegram
                            .item(indexField);

                    String fieldPath = BlancoXmlUtil.getTextContent(
                            elementTelegram, "fieldPath");
                    // ŃpẌꗗL܂B
                    pathList.put(fieldPath, fieldPath);
                    maxPathDeapth = Math.max(BlancoNameUtil
                            .splitPath(fieldPath).length, maxPathDeapth);
                }

                serializer.characters("\n");

                // Vv^`stB[ḧꗗێ܂B
                final LinkedHashMap simpleTypeList = new LinkedHashMap();

                // Vv^`KvǂfAKvɉĒ`{܂B
                for (int indexField = 0; indexField < sizeListRow; indexField++) {
                    final Element elementTelegram = (Element) listTelegram
                            .item(indexField);

                    final String minLength = BlancoXmlUtil.getTextContent(
                            elementTelegram, "minLength");
                    final String maxLength = BlancoXmlUtil.getTextContent(
                            elementTelegram, "maxLength");
                    final String minInclusive = BlancoXmlUtil.getTextContent(
                            elementTelegram, "minInclusive");
                    final String maxInclusive = BlancoXmlUtil.getTextContent(
                            elementTelegram, "maxInclusive");
                    final String pattern = BlancoXmlUtil.getTextContent(
                            elementTelegram, "pattern");

                    // Vv^`̕Kv̗L`FbN
                    if (minLength != null || maxLength != null
                            || minInclusive != null || maxInclusive != null
                            || pattern != null) {
                        // ŏEő咷EŏlEőlEp^[ɂẮA
                        // Vv^`̎{KvɂȂ܂B
                        final String fieldName = BlancoXmlUtil.getTextContent(
                                elementTelegram, "fieldName");
                        final String fieldPath = BlancoXmlUtil.getTextContent(
                                elementTelegram, "fieldPath");

                        expandSimpleType(telegramId, elementTelegram,
                                serializer);
                        // dIDtœo^܂B
                        simpleTypeList.put(toClassName(telegramId, fieldPath,
                                fieldName), "^`ς");
                        if (IS_DEBUG) {
                            System.out.println("Vv^["
                                    + toClassName(telegramId, fieldPath,
                                            fieldName) + "]`܂");
                        }
                    }
                }

                final HashMap processedPath = new HashMap();
                for (int pathDeapth = maxPathDeapth; pathDeapth >= 0; pathDeapth--) {
                    // SĂ̊KwɂāA[̋tŏs܂B
                    for (Iterator iterator = pathList.keySet().iterator(); iterator
                            .hasNext();) {
                        String fieldPath = (String) iterator.next();
                        if (fieldPath == null) {
                            fieldPath = "";
                        }
                        // Kw̐[vꍇɂ̂ݏs܂B
                        if (pathDeapth != BlancoNameUtil.splitPath(fieldPath).length) {
                            continue;
                        }

                        if (processedPath.get(fieldPath) != null) {
                            // ɏspXłBXLbv܂B
                            continue;
                        }
                        processedPath.put(fieldPath, fieldPath);
                        expandPath(telegramId, simpleTypeList,
                                listTelegramList, serializer, fieldPath);
                    }
                }
            }

            if (getGenerateXsdElementDeclaration()) {
                /*
                 * uXML Schema̗vf錾𐶐v𐶐IvVw肳Ă܂B XML SchemaP̂p XML
                 * Schema`FbN\Ȃ悤ɐȂ܂B ʏWebT[rXł
                 * ̃tOfalseɐݒ肳Ă邱Ƃł傤B
                 */

                serializer.characters("  ");
                serializer.startElementXsdElement(telegramId, "tns:"
                        + telegramId, null, null);
                serializer.endElementXsdElement();
                serializer.characters("\n");
            }

            serializer.endElementXsdSchema();
            serializer.endDocument();
            outStream.flush();
        } finally {
            if (outStream != null) {
                outStream.close();
            }
        }
    }

    /**
     * Vv^`𑕔܂B
     * 
     * @param elementTelegram
     * @param serializer
     * @throws SAXException
     */
    private static void expandSimpleType(final String telegramId,
            final Element elementTelegram, BlancoXsdSerializer serializer)
            throws SAXException {
        final String no = BlancoXmlUtil.getTextContent(elementTelegram, "no");
        final String strNo = (no == null ? "" : " ڔԍ[" + no + "]");
        final String fieldName = BlancoXmlUtil.getTextContent(elementTelegram,
                "fieldName");
        final String fieldType = BlancoXmlUtil.getTextContent(elementTelegram,
                "fieldType");
        final String minLength = BlancoXmlUtil.getTextContent(elementTelegram,
                "minLength");
        final String maxLength = BlancoXmlUtil.getTextContent(elementTelegram,
                "maxLength");
        final String minInclusive = BlancoXmlUtil.getTextContent(
                elementTelegram, "minInclusive");
        final String maxInclusive = BlancoXmlUtil.getTextContent(
                elementTelegram, "maxInclusive");
        final String pattern = BlancoXmlUtil.getTextContent(elementTelegram,
                "pattern");
        final String fieldPath = BlancoXmlUtil.getTextContent(elementTelegram,
                "fieldPath");

        if (pattern != null && pattern.length() > 0) {
            try {
                Pattern.compile(pattern);
            } catch (java.util.regex.PatternSyntaxException ex) {
                throw new IllegalArgumentException(bundle.getXml2xsdPattern001(
                        telegramId, strNo, fieldName, pattern)
                        + ex.getMessage());
            }
        }

        // փ`FbN
        if (minInclusive != null && minInclusive.length() > 0) {
            if (fieldType.equals("xsd:int") || fieldType.equals("xsd:long")
                    || fieldType.equals("xsd:decimal")) {
                // ̌^͏邱Ƃł܂B
                // ȂA xsd:dateTime͏\Xg珜OĂ܂B
            } else {
                throw new IllegalArgumentException(bundle.getXml2xsdCheck001(
                        telegramId, strNo, fieldName, fieldType, minInclusive));
            }
        }
        if (maxInclusive != null && maxInclusive.length() > 0) {
            if (fieldType.equals("xsd:int") || fieldType.equals("xsd:long")
                    || fieldType.equals("xsd:decimal")) {
                // ̌^͏邱Ƃł܂B
                // ȂA xsd:dateTime͏\Xg珜OĂ܂B
            } else {
                throw new IllegalArgumentException(bundle.getXml2xsdCheck002(
                        telegramId, strNo, fieldName, fieldType, maxInclusive));
            }
        }
        if (fieldType.equals("xsd:int")) {
            int intMinInclusive = Integer.MIN_VALUE;
            int intMaxInclusive = Integer.MAX_VALUE;
            if (minInclusive != null && minInclusive.length() > 0) {
                try {
                    intMinInclusive = Integer.parseInt(minInclusive);
                } catch (NumberFormatException ex) {
                    throw new IllegalArgumentException(bundle
                            .getXml2xsdCheck017(telegramId, strNo, fieldName,
                                    fieldType, minInclusive));
                }
            }
            if (maxInclusive != null && maxInclusive.length() > 0) {
                try {
                    intMaxInclusive = Integer.parseInt(maxInclusive);
                } catch (NumberFormatException ex) {
                    throw new IllegalArgumentException(bundle
                            .getXml2xsdCheck018(telegramId, strNo, fieldName,
                                    fieldType, maxInclusive));
                }
            }
            if (intMinInclusive > intMaxInclusive) {
                throw new IllegalArgumentException(bundle.getXml2xsdCheck019(
                        telegramId, strNo, fieldName, fieldType, minInclusive,
                        maxInclusive));
            }
        }
        if (fieldType.equals("xsd:long")) {
            long longMinInclusive = Long.MIN_VALUE;
            long longMaxInclusive = Long.MAX_VALUE;
            if (minInclusive != null && minInclusive.length() > 0) {
                try {
                    longMinInclusive = Long.parseLong(minInclusive);
                } catch (NumberFormatException ex) {
                    throw new IllegalArgumentException(bundle
                            .getXml2xsdCheck017(telegramId, strNo, fieldName,
                                    fieldType, minInclusive));
                }
            }
            if (maxInclusive != null && maxInclusive.length() > 0) {
                try {
                    longMaxInclusive = Long.parseLong(maxInclusive);
                } catch (NumberFormatException ex) {
                    throw new IllegalArgumentException(bundle
                            .getXml2xsdCheck018(telegramId, strNo, fieldName,
                                    fieldType, maxInclusive));
                }
            }
            if (longMinInclusive > longMaxInclusive) {
                throw new IllegalArgumentException(bundle.getXml2xsdCheck019(
                        telegramId, strNo, fieldName, fieldType, minInclusive,
                        maxInclusive));
            }
        }
        if (fieldType.equals("xsd:decimal")) {
            BigDecimal decMinInclusive = null;
            BigDecimal decMaxInclusive = null;
            if (minInclusive != null && minInclusive.length() > 0) {
                try {
                    decMinInclusive = new BigDecimal(minInclusive);
                } catch (NumberFormatException ex) {
                    throw new IllegalArgumentException(bundle
                            .getXml2xsdCheck017(telegramId, strNo, fieldName,
                                    fieldType, minInclusive));
                }
            }
            if (maxInclusive != null && maxInclusive.length() > 0) {
                try {
                    decMaxInclusive = new BigDecimal(maxInclusive);
                } catch (NumberFormatException ex) {
                    throw new IllegalArgumentException(bundle
                            .getXml2xsdCheck018(telegramId, strNo, fieldName,
                                    fieldType, maxInclusive));
                }
            }
            if (decMinInclusive != null && decMaxInclusive != null
                    && decMinInclusive.compareTo(decMaxInclusive) > 0) {
                throw new IllegalArgumentException(bundle.getXml2xsdCheck019(
                        telegramId, strNo, fieldName, fieldType, minInclusive,
                        maxInclusive));
            }
        }

        serializer.characters("  ");
        // Vv^`̖Oɂ dIDt^܂B
        // ɂAOԏՓ˂܂B
        serializer.startElementXsdSimpleType(toClassName(telegramId, fieldPath,
                fieldName));
        serializer.characters("\n");
        serializer.characters("    ");
        serializer.startElementXsdRestriction(fieldType);
        serializer.characters("\n");

        if (minLength != null && maxLength != null
                && minLength.equals(maxLength)) {
            serializer.characters("      ");
            serializer.startElementXsdLength(minLength, "true");
            serializer.endElementXsdLength();
            serializer.characters("\n");
        } else {
            if (minLength != null) {
                serializer.characters("      ");
                serializer.startElementXsdMinLength(minLength);
                serializer.endElementXsdMinLength();
                serializer.characters("\n");
            }
            if (maxLength != null) {
                serializer.characters("      ");
                serializer.startElementXsdMaxLength(maxLength);
                serializer.endElementXsdMaxLength();
                serializer.characters("\n");
            }
        }

        if (minInclusive != null) {
            serializer.characters("      ");
            serializer.startElementXsdMinInclusive(minInclusive);
            serializer.endElementXsdMinInclusive();
            serializer.characters("\n");
        }
        if (maxInclusive != null) {
            serializer.characters("      ");
            serializer.startElementXsdMaxInclusive(maxInclusive);
            serializer.endElementXsdMaxInclusive();
            serializer.characters("\n");
        }
        if (pattern != null) {
            serializer.characters("      ");
            serializer.startElementXsdPattern(pattern);
            serializer.endElementXsdPattern();
            serializer.characters("\n");
        }

        serializer.characters("    ");
        serializer.endElementXsdRestriction();
        serializer.characters("\n");
        serializer.characters("  ");
        serializer.endElementXsdSimpleType();
        serializer.characters("\n");
    }

    /**
     * w肳ꂽPath (XPath) ɂēWJs܂B
     * 
     * @param telegramId
     * @param telegramType
     * @param listTelegramList
     * @param serializer
     * @param targetFieldPath
     *            null͗^ȂłB
     * @throws SAXException
     */
    private static void expandPath(final String telegramId,
            final LinkedHashMap simpleTypeList,
            final NodeList listTelegramList,
            final BlancoXsdSerializer serializer, final String targetFieldPath)
            throws SAXException {
        if (IS_DEBUG) {
            System.out.println("pX[" + targetFieldPath + "]");
        }

        serializer.characters("\n  ");
        if (targetFieldPath == null) {
            serializer.startElementXsdComplexType(telegramId);
        } else {
            serializer.startElementXsdComplexType(BlancoXsdUtil
                    .getComplexTypeName(telegramId, targetFieldPath));
        }

        serializer.characters("\n    ");
        serializer.startElementXsdSequence();

        NodeList listTelegram = ((Element) listTelegramList.item(0))
                .getElementsByTagName("telegram");
        int sizeListRow = listTelegram.getLength();
        for (int indexField = 0; indexField < sizeListRow; indexField++) {
            final Element elementTelegram = (Element) listTelegram
                    .item(indexField);

            final String no = BlancoXmlUtil.getTextContent(elementTelegram,
                    "no");
            final String strNo = (no == null ? "" : " ڔԍ[" + no + "]");
            final String fieldName = BlancoXmlUtil.getTextContent(
                    elementTelegram, "fieldName");
            if (fieldName == null) {
                // ږZbgĂȂ̂ɂĂ͏XLbv܂B
                continue;
            }
            if (fieldName.indexOf(' ') >= 0) {
                // ږɕsK؂ȕł󔒂܂܂ꍇB
                throw new IllegalArgumentException(bundle.getXml2xsdCheck022(
                        telegramId, strNo, fieldName));
            }

            // 2006.06.30 t.iga ǉB
            // d`̍ږ𐳋K\ɂă`FbN@\ǉ܂B
            try {
                final Pattern pattern = Pattern.compile(bundle
                        .getXml2xsdCheck023Regex());
                final Matcher matcher = pattern.matcher(fieldName);
                if (matcher.matches()) {
                    // ږ̃`FbNpX܂B
                } else {
                    throw new IllegalArgumentException(bundle
                            .getXml2xsdCheck023Message(telegramId, strNo,
                                    fieldName));
                }
            } catch (PatternSyntaxException ex) {
                throw new IllegalArgumentException(bundle
                        .getXml2xsdCheck023RegexError(bundle
                                .getXml2xsdCheck023Regex()));
            }

            final String fieldType = BlancoXmlUtil.getTextContent(
                    elementTelegram, "fieldType");
            String fieldPath = BlancoXmlUtil.getTextContent(elementTelegram,
                    "fieldPath");
            if (fieldPath == null) {
                // nullƈ̂ 󔒂Zbg܂B
                fieldPath = "";
            }
            final String minOccurs = BlancoXmlUtil.getTextContent(
                    elementTelegram, "minOccurs");
            if (minOccurs == null || minOccurs.trim().length() == 0) {
                throw new IllegalArgumentException(bundle.getXml2xsdCheck020(
                        telegramId, strNo, fieldName));
            }
            String maxOccurs = BlancoXmlUtil.getTextContent(elementTelegram,
                    "maxOccurs");
            if (maxOccurs != null && maxOccurs.equals("un")) {
                // ununboundedɓǂݑւ܂B
                maxOccurs = BlancoXsdUtil.MAX_OCCURS_UNBOUNDED;
            }

            if (fieldName == null && fieldType == null) {
                // K{ڂĖݒ̏ꍇɂ͍sǂݔ΂܂B
                continue;
            }
            if (fieldName != null && fieldType == null) {
                throw new IllegalArgumentException(bundle.getXml2xsdCheck003(
                        telegramId, strNo, fieldName));
            }
            if (fieldName == null && fieldType != null) {
                throw new IllegalArgumentException(bundle.getXml2xsdCheck004(
                        telegramId, strNo, fieldType));
            }
            if (minOccurs != null && minOccurs.length() > 0) {
                try {
                    BlancoXsdUtil.minOccurs2Int(minOccurs);
                } catch (NumberFormatException ex) {
                    throw new IllegalArgumentException(bundle
                            .getXml2xsdCheck005(telegramId, strNo, fieldName,
                                    minOccurs)
                            + ex.getMessage());
                } catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException(bundle
                            .getXml2xsdCheck006(telegramId, strNo, fieldName,
                                    minOccurs)
                            + ex.getMessage());
                }
            }
            if (maxOccurs != null && maxOccurs.length() > 0) {
                try {
                    BlancoXsdUtil.isMaxOccursArray(maxOccurs);
                } catch (NumberFormatException ex) {
                    throw new IllegalArgumentException(bundle
                            .getXml2xsdCheck007(telegramId, strNo, fieldName,
                                    maxOccurs)
                            + ex.getMessage());
                } catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException(bundle
                            .getXml2xsdCheck008(telegramId, strNo, fieldName,
                                    maxOccurs)
                            + ex.getMessage());
                }
            }
            if (BlancoXsdUtil.minOccurs2Int(minOccurs) > BlancoXsdUtil
                    .maxOccurs2Int(maxOccurs)) {
                throw new IllegalArgumentException(bundle.getXml2xsdCheck009(
                        telegramId, strNo, fieldName, minOccurs, maxOccurs));
            }

            final String minLength = BlancoXmlUtil.getTextContent(
                    elementTelegram, "minLength");
            final String maxLength = BlancoXmlUtil.getTextContent(
                    elementTelegram, "maxLength");
            if (minLength != null && minLength.length() > 0) {
                try {
                    BlancoXsdUtil.minLength2Int(minLength);
                } catch (NumberFormatException ex) {
                    throw new IllegalArgumentException(bundle
                            .getXml2xsdCheck010(telegramId, strNo, fieldName,
                                    minLength)
                            + ex.getMessage());
                } catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException(bundle
                            .getXml2xsdCheck011(telegramId, strNo, fieldName,
                                    minLength)
                            + ex.getMessage());
                }
            }
            if (maxLength != null && maxLength.length() > 0) {
                try {
                    Integer.parseInt(maxLength);
                } catch (NumberFormatException ex) {
                    throw new IllegalArgumentException(bundle
                            .getXml2xsdCheck012(telegramId, strNo, fieldName,
                                    maxLength)
                            + ex.getMessage());
                } catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException(bundle
                            .getXml2xsdCheck013(telegramId, strNo, fieldName,
                                    maxLength)
                            + ex.getMessage());
                }
            }
            if (BlancoXsdUtil.minLength2Int(minLength) > BlancoXsdUtil
                    .maxLength2Int(maxLength)) {
                throw new IllegalArgumentException(bundle.getXml2xsdCheck014(
                        telegramId, strNo, fieldName, minLength, maxLength));
            }

            // ֊֌W`FbN
            if (minLength != null && minLength.length() > 0
                    && fieldType.equals("xsd:string") == false) {
                throw new IllegalArgumentException(bundle.getXml2xsdCheck015(
                        telegramId, strNo, fieldName, fieldType, minLength));
            }
            if (maxLength != null && maxLength.length() > 0
                    && fieldType.equals("xsd:string") == false) {
                throw new IllegalArgumentException(bundle.getXml2xsdCheck016(
                        telegramId, strNo, fieldName, fieldType, maxLength));
            }

            if (fieldPath.equals(targetFieldPath) == false) {
                // pXقȂĂ܂B̕Kv͂܂B
                // ȂA̔rɂ悤ɁAnull͒lƂēĂȂƂƉ肵܂B
                continue;
            }

            // Kw`ł̂ŁÂ悤ɏs܂B
            if (fieldType.equals(HIERARCHY)) {
                // minInclusive, maxInclusive, minLength,
                // maxLength͕ʂ̉ӏŃ`FbNĂ܂B
                final String pattern = BlancoXmlUtil.getTextContent(
                        elementTelegram, "pattern");
                if (pattern != null && pattern.length() > 0) {
                    throw new IllegalArgumentException(bundle
                            .getXml2xsdHierarchy001(telegramId, strNo,
                                    fieldName, pattern));
                }

                serializer.characters("\n      ");
                serializer.startElementXsdElement(fieldName, "tns:"
                        + BlancoXsdUtil.getComplexTypeName(telegramId,
                                (fieldPath == null ? "" : fieldPath) + "/"
                                        + fieldName), minOccurs, maxOccurs);
                serializer.endElementXsdElement();
                continue;
            }

            serializer.characters("\n      ");
            if (simpleTypeList
                    .get(toClassName(telegramId, fieldPath, fieldName)) == null) {
                if (IS_DEBUG) {
                    System.out.println("pX[" + fieldPath + "] tB[h["
                            + fieldName + "]͌܂");
                }
                serializer.startElementXsdElement(fieldName, fieldType,
                        minOccurs, maxOccurs);
            } else {
                // Vv^`ς݂Ȃ̂ŁAQƂ悤ɂ܂B
                serializer.startElementXsdElement(fieldName, "tns:"
                        + toClassName(telegramId, fieldPath, fieldName),
                        minOccurs, maxOccurs);
            }
            serializer.endElementXsdElement();
        }

        serializer.characters("\n    ");
        serializer.endElementXsdSequence();
        serializer.characters("\n  ");
        serializer.endElementXsdComplexType();
        serializer.characters("\n");
    }
}