/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.test.db.ddl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

import blanco.commons.util.BlancoNameUtil;

/**
 * {vOblancoDb̎ڂ̂AP\Ɋւ鎎{邽߂̃[eBeBłB
 * 
 * SĂ̌^g񂪊܂܂ꂽ\ΏۂƂȂ܂B<br>
 * ̃vO SQL Server 2005pDDL𐶐܂B
 */
public class SimpleTableSQLServer2005AllColumnDDL {
    /**
     * DDL̏o̓C^B
     */
    private PrintWriter fWriter = null;

    /**
     * DDL̍쐬s܂B
     * 
     * @param args
     *            Bw肳ꂽe͖܂B
     */
    public static void main(final String[] args) {
        try {
            new SimpleTableSQLServer2005AllColumnDDL().generate();
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private final void generate() throws IOException {
        final File fileTargetDirectory = new File("./sqlserver2005/ddl");
        if (fileTargetDirectory.exists() == false) {
            fileTargetDirectory.mkdirs();
        }

        fWriter = new PrintWriter(new OutputStreamWriter(new FileOutputStream(
                fileTargetDirectory.getAbsolutePath()
                        + "/"
                        + BlancoNameUtil.trimJavaPackage(this.getClass()
                                .getName()) + ".txt")));
        try {
            fWriter.println("------------------------------------------");
            fWriter.println("-- 폜GAłB --");
            fWriter.println("------------------------------------------");

            generateDeleteAllColumnPrimary1();
            generateDeleteAllColumnNonPrimary();

            fWriter.println("------------------------------------------");
            fWriter.println("-- 琶GAłB --");
            fWriter.println("------------------------------------------");

            generateAllColumnPrimary1();
            generateAllColumnNonPrimary();
        } finally {
            fWriter.close();
        }
    }

    private final void generateAllColumnPrimary1() throws IOException {
        fWriter.println("------------------------------------------");
        fWriter.println("-- SĂ̌^gA1ڂ̃vC}L[ɂ\쐬܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        fWriter.println("CREATE TABLE TEST_ALL_COLUMN_PRIMARY1 (");
        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            fWriter.println((index == 0 ? "" : ", ") + "FIELD_" + fieldName
                    + " " + TypesOfSQLServer2005.TYPES[index] + " NOT NULL");
        }
        // ЂƂ߂̌^()𔺂Ȃ̂Ɖ肵Ă܂B
        fWriter.println(", PRIMARY KEY (FIELD_" + TypesOfSQLServer2005.TYPES[0]
                + ")");
        fWriter.println(");");
        fWriter.println("");
    }

    // SĂ̗vC}L[ɂ͐ݒł܂B
    // SQL Server 2005ł 16̃vC}L[ő吔łB

    private final void generateAllColumnNonPrimary() throws IOException {
        fWriter.println("------------------------------------------");
        fWriter.println("-- SĂ̌^gAЂƂvC}L[񂪖\쐬܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        fWriter.println("CREATE TABLE TEST_ALL_COLUMN_NONPRIMARY (");
        for (int index = 0; index < TypesOfSQLServer2005.TYPES.length; index++) {
            final int spacePosition = TypesOfSQLServer2005.TYPES[index]
                    .indexOf("(");
            String fieldName = TypesOfSQLServer2005.TYPES[index];
            if (spacePosition >= 0) {
                fieldName = fieldName.substring(0, spacePosition);
            }

            fWriter.println((index == 0 ? "" : ", ") + "FIELD_" + fieldName
                    + " " + TypesOfSQLServer2005.TYPES[index] + " NOT NULL");
        }
        fWriter.println(");");
        fWriter.println("");
    }

    // ͍폜GAłB
    // 폜pDDL𐶐܂B

    private final void generateDeleteAllColumnPrimary1() throws IOException {
        fWriter.println("------------------------------------------");
        fWriter.println("-- SĂ̌^gA1ڂ̃vC}L[ɂ\폜܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        fWriter.println("DROP TABLE TEST_ALL_COLUMN_PRIMARY1;");
    }

    // SĂ̗vC}L[ɂ͐ݒł܂B
    // SQL Server 2005ł 16̃vC}L[ő吔łB

    private final void generateDeleteAllColumnNonPrimary() throws IOException {
        fWriter.println("------------------------------------------");
        fWriter.println("-- SĂ̌^gAЂƂvC}L[񂪖\폜܂B");
        fWriter.println("------------------------------------------");
        fWriter.println("");

        fWriter.println("DROP TABLE TEST_ALL_COLUMN_NONPRIMARY;");
    }
}
