/*
 * Decompiled with CFR 0.152.
 */
package org.awk4j.bench.target;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Trim {
    private static final Pattern RIGHT_TRIM_CLASSIC = Pattern.compile("[\\s]+$");
    private static final Pattern RIGHT_TRIM_REGEX = Pattern.compile("[\u0000- ]+$");

    public static String rTrimRegex01Classic(String s) {
        Matcher m = RIGHT_TRIM_CLASSIC.matcher(s);
        if (m.find()) {
            return s.substring(0, m.start());
        }
        return s;
    }

    public static String rTrimRegex02New(String s) {
        Matcher m = RIGHT_TRIM_REGEX.matcher(s);
        if (m.find()) {
            return s.substring(0, m.start());
        }
        return s;
    }

    private static int leftTrimParts(CharSequence s, int end) {
        int start;
        for (start = 0; start < end && ' ' >= s.charAt(start); ++start) {
        }
        return start;
    }

    private static int rightTrimParts(CharSequence s, int start, int end) {
        while (start <= --end && ' ' >= s.charAt(end)) {
        }
        return end + 1;
    }

    public static String trim04String(String s) {
        int length = s.length();
        int start = Trim.leftTrimParts(s, length);
        int end = Trim.rightTrimParts(s, start, length);
        return end < length || 0 < start ? s.substring(start, end) : s;
    }

    public static String trim05CharSeq(CharSequence s) {
        int length = s.length();
        int start = Trim.leftTrimParts(s, length);
        int end = Trim.rightTrimParts(s, start, length);
        if (end < length || 0 < start) {
            s = s.subSequence(start, end);
        }
        return s instanceof String ? (String)s : s.toString();
    }

    public static String rTrim06String(String s) {
        int length = s.length();
        int end = Trim.rightTrimParts(s, 0, length);
        return end < length ? s.substring(0, end) : s;
    }

    public static StringBuilder rTrim07Builder(StringBuilder sb) {
        int length = sb.length();
        int end = Trim.rightTrimParts(sb, 0, length);
        if (end < length) {
            sb.setLength(end);
        }
        return sb;
    }
}

