/*
 * Decompiled with CFR 0.152.
 */
package org.awk4j.bench;

import org.awk4j.bench.Bench;
import org.awk4j.bench.target.Trim;

class F01Classic {
    private static final StringBuilder sb = new StringBuilder(Bench.BENCH_DATA.length());

    F01Classic() {
    }

    private static int driver01Regex() {
        String rs;
        long start;
        long nano = Bench.driver_loop_time;
        int count = 0;
        do {
            start = System.nanoTime();
            rs = Trim.rTrimRegex01Classic(Bench.BENCH_DATA);
        } while (!Bench.isDriverComplete(++count) && 0L < (nano -= System.nanoTime() - start));
        assert (Bench.ANS_RIGHT.equals(rs)) : rs;
        return count;
    }

    private static int driver02Regex() {
        String rs;
        long start;
        long nano = Bench.driver_loop_time;
        int count = 0;
        do {
            start = System.nanoTime();
            rs = Trim.rTrimRegex02New(Bench.BENCH_DATA);
        } while (!Bench.isDriverComplete(++count) && 0L < (nano -= System.nanoTime() - start));
        assert (Bench.ANS_RIGHT.equals(rs)) : rs;
        return count;
    }

    static int driver03TrimOriginal() {
        String rs;
        long start;
        long nano = Bench.driver_loop_time;
        int count = 0;
        do {
            start = System.nanoTime();
            rs = Bench.BENCH_DATA.trim();
        } while (!Bench.isDriverComplete(++count) && 0L < (nano -= System.nanoTime() - start));
        assert ("^^);".equals(rs)) : rs;
        return count;
    }

    static int driver04TrimString() {
        String rs;
        long start;
        long nano = Bench.driver_loop_time;
        int count = 0;
        do {
            start = System.nanoTime();
            rs = Trim.trim04String(Bench.BENCH_DATA);
        } while (!Bench.isDriverComplete(++count) && 0L < (nano -= System.nanoTime() - start));
        assert ("^^);".equals(rs)) : rs;
        return count;
    }

    static int driver05TrimCharSeq() {
        String rs;
        long start;
        long nano = Bench.driver_loop_time;
        int count = 0;
        do {
            start = System.nanoTime();
            rs = Trim.trim05CharSeq(Bench.BENCH_DATA);
        } while (!Bench.isDriverComplete(++count) && 0L < (nano -= System.nanoTime() - start));
        assert ("^^);".equals(rs)) : rs;
        return count;
    }

    static int driver06rTrimString() {
        String rs;
        long start;
        long nano = Bench.driver_loop_time;
        int count = 0;
        do {
            start = System.nanoTime();
            rs = Trim.rTrim06String(Bench.BENCH_DATA);
        } while (!Bench.isDriverComplete(++count) && 0L < (nano -= System.nanoTime() - start));
        assert (Bench.ANS_RIGHT.equals(rs)) : rs;
        return count;
    }

    static int driver07rTrimBuilder() {
        long start;
        long nano = Bench.driver_loop_time;
        int count = 0;
        do {
            sb.setLength(0);
            sb.append(Bench.BENCH_DATA);
            start = System.nanoTime();
            Trim.rTrim07Builder(sb);
        } while (!Bench.isDriverComplete(++count) && 0L < (nano -= System.nanoTime() - start));
        assert (Bench.ANS_RIGHT.contentEquals(sb)) : sb;
        return count;
    }

    static void warmupTarget() {
        Trim.rTrimRegex01Classic(Bench.BENCH_DATA);
        Trim.rTrimRegex02New(Bench.BENCH_DATA);
        Bench.BENCH_DATA.trim();
        Trim.trim04String(Bench.BENCH_DATA);
        Trim.trim05CharSeq(Bench.BENCH_DATA);
        Trim.rTrim06String(Bench.BENCH_DATA);
        sb.setLength(0);
        sb.append(Bench.BENCH_DATA);
        Trim.rTrim07Builder(sb);
    }

    static void crew(int[] ANSWER) {
        ANSWER[1] = F01Classic.driver01Regex();
        Bench.cool();
        ANSWER[2] = F01Classic.driver02Regex();
        Bench.cool();
        ANSWER[3] = F01Classic.driver03TrimOriginal();
        Bench.cool();
        ANSWER[4] = F01Classic.driver04TrimString();
        Bench.cool();
        ANSWER[5] = F01Classic.driver05TrimCharSeq();
        Bench.cool();
        ANSWER[6] = F01Classic.driver06rTrimString();
        Bench.cool();
        ANSWER[7] = F01Classic.driver07rTrimBuilder();
    }
}

