/*
 * Decompiled with CFR 0.152.
 */
package org.awk4j.bench;

import org.awk4j.bench.Trim;

class BenchV1 {
    private static final String PATTERN_01 = "^^);";
    private static final String PATTERN_02 = "\u203b";
    private static final String pattern = "^^);";
    private static final String SPACE_32 = "                                ";
    private static final String SPACE_128 = "                                                                                                                                ";
    private static final String SPACE_256 = "                                                                                                                                                                                                                                                                ";
    private static final String test_data = " ^^);                                                                                                                                                                                                                                                                ";
    private static final String ans_right = " ^^);";
    private static final String ans_both = "^^);";
    private static final int main_loop = 100000;
    private static final int warmUp_loop = 20000;
    private static int loop_count = 20000;
    private static boolean isPrint = false;

    BenchV1() {
    }

    static void bench() {
        BenchV1.benchV1(20000);
        isPrint = true;
        for (int i = 0; i < 12; ++i) {
            BenchV1.benchV1(100000);
            System.err.println();
        }
    }

    static void benchV1(int loop) {
        loop_count = loop;
        BenchV1.bench1Regex();
        BenchV1.bench2Regex();
        BenchV1.bench3TrimOriginal();
        BenchV1.bench4TrimCustomize();
        BenchV1.bench5TrimCharSeq();
        BenchV1.bench6rTrimString();
        BenchV1.bench7rTrimBuilder();
    }

    private static void bench1Regex() {
        String rs = null;
        long nano = 0L;
        for (int i = 0; i < loop_count; ++i) {
            long start = System.nanoTime();
            rs = Trim.rTrimRegex01Classic(test_data);
            nano += System.nanoTime() - start;
        }
        assert (ans_right.equals(rs)) : rs;
        if (isPrint) {
            System.err.println("\t1. regex.Classic\t" + nano);
        }
    }

    private static void bench2Regex() {
        String rs = null;
        long nano = 0L;
        for (int i = 0; i < loop_count; ++i) {
            long start = System.nanoTime();
            rs = Trim.rTrimRegex02New(test_data);
            nano += System.nanoTime() - start;
        }
        assert (ans_right.equals(rs)) : rs;
        if (isPrint) {
            System.err.println("\t2. regex.New\t" + nano);
        }
    }

    private static void bench3TrimOriginal() {
        String rs = null;
        long nano = 0L;
        for (int i = 0; i < loop_count; ++i) {
            long start = System.nanoTime();
            rs = test_data.trim();
            nano += System.nanoTime() - start;
        }
        assert ("^^);".equals(rs)) : rs;
        if (isPrint) {
            System.err.println("\t3. Trim.Original\t" + nano);
        }
    }

    private static void bench4TrimCustomize() {
        String rs = null;
        long nano = 0L;
        for (int i = 0; i < loop_count; ++i) {
            long start = System.nanoTime();
            rs = Trim.trim04String(test_data);
            nano += System.nanoTime() - start;
        }
        assert ("^^);".equals(rs)) : rs;
        if (isPrint) {
            System.err.println("\t4. Trim.String\t" + nano);
        }
    }

    private static void bench5TrimCharSeq() {
        String rs = null;
        long nano = 0L;
        for (int i = 0; i < loop_count; ++i) {
            long start = System.nanoTime();
            rs = Trim.trim05CharSeq(test_data);
            nano += System.nanoTime() - start;
        }
        assert ("^^);".equals(rs)) : rs;
        if (isPrint) {
            System.err.println("\t5. Trim.CharSeq\t" + nano);
        }
    }

    private static void bench6rTrimString() {
        String rs = null;
        long nano = 0L;
        for (int i = 0; i < loop_count; ++i) {
            long start = System.nanoTime();
            rs = Trim.rTrim06String(test_data);
            nano += System.nanoTime() - start;
        }
        assert (ans_right.equals(rs)) : rs;
        if (isPrint) {
            System.err.println("\t6. rTrim.String\t" + nano);
        }
    }

    private static void bench7rTrimBuilder() {
        StringBuilder sb = new StringBuilder(test_data.length());
        long nano = 0L;
        for (int i = 0; i < loop_count; ++i) {
            sb.setLength(0);
            sb.append(test_data);
            long start = System.nanoTime();
            Trim.rTrim07Builder(sb);
            nano += System.nanoTime() - start;
        }
        assert (ans_right.contentEquals(sb)) : sb;
        if (isPrint) {
            System.err.println("\t7. rTrim.Builder\t" + nano);
        }
    }

    private static void test() {
        int no = 0;
        String rs = Trim.trim05CharSeq("");
        System.err.println(++no + " rs:[" + rs + "] len:" + rs.length());
        rs = Trim.trim05CharSeq("XX");
        System.err.println(++no + " rs:[" + rs + "] len:" + rs.length());
        rs = Trim.trim05CharSeq(" X");
        System.err.println(++no + " rs:[" + rs + "] len:" + rs.length());
        rs = Trim.trim05CharSeq("X ");
        System.err.println(++no + " rs:[" + rs + "] len:" + rs.length());
        rs = Trim.trim05CharSeq(" X ");
        System.err.println(++no + " rs:[" + rs + "] len:" + rs.length());
    }
}

