/*
 * Copyright (C) 2009 awk4j - https://ja.osdn.net/projects/awk4j/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.awk4j.bench;

/**
 * benchTrim - Benchmark framework.
 *
 * @author kunio himei.
 */
public class Main {

    private static final String USAGE =
            """
                    benchTrim [-options] 1><JIT.log> 2><Result list>
                    -T=<title>
                    -priority=10   1...10
                    -warmup        Disable warmup
                      -prefetch=0  1st loop (times)
                      -loop=100    2nd loop (ms)
                    -cool=50 ms.   cool down
                    -ice=300 ms.   Forced cooling
                    -v Version 1.0.1""";

    // Warm-up parameters
    static String title = "No title";
    static int priority = Thread.MAX_PRIORITY; // 10
    static boolean warmup = true;
    static int prefetch = 11_000; // 1st loop (times)
    static int loop = 100; // 2nd loop (ms) (standard 10_000 times)
    static int cool = 50; // 0.05 sec.
    static int ice = 300; // 0.3 sec.

    /*
     * Main.
     */
    public static void main(String[] args) {
        int ix = 0;
        for (; ix < args.length; ix++) {
            String arg = args[ix];
            if ('-' != arg.charAt(0)) break;

            if (arg.startsWith("-v")) {
                System.err.println(USAGE);
                return;

            } else if (arg.startsWith("-T=")) {
                title = arg.substring(3);

            } else if (arg.startsWith("-priority=")) {
                priority = Integer.parseInt(arg.substring(10));

            } else if (arg.startsWith("-prefetch=")) {
                prefetch = Integer.parseInt(arg.substring(10));

            } else if (arg.startsWith("-loop=")) {
                loop = Integer.parseInt(arg.substring(6));

            } else if (arg.startsWith("-cool=")) {
                cool = Integer.parseInt(arg.substring(6));

            } else if (arg.startsWith("-ice=")) {
                ice = Integer.parseInt(arg.substring(5));

            } else if (arg.startsWith("-warmup")) {
                warmup = false;

            } else {
                throw new IllegalArgumentException(arg);
            }
        }
        Thread thread = Thread.currentThread();
        thread.setPriority(priority);
        BenchV2.bench();
    }
}
/*
        Thread th = new Thread(BenchV2::bench);
        th.setPriority(priority);
        th.start();
*/