/*
 * Decompiled with CFR 0.152.
 */
package org.awk4j.space;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

class Tools {
    static int RSTART;
    static int RLENGTH;
    private static final String WHITE_SPACES = " \t\n\r\u001e";

    Tools() {
    }

    static boolean match(@NotNull Pattern r, CharSequence s, int group) {
        Matcher m;
        if (r == null) {
            Tools.$$$reportNull$$$0(0);
        }
        if ((m = r.matcher(s)).find()) {
            RSTART = m.start(group);
            RLENGTH = m.end(group) - RSTART;
            return true;
        }
        return false;
    }

    @NotNull
    static String trim(@NotNull String s) {
        int st;
        int end;
        if (s == null) {
            Tools.$$$reportNull$$$0(1);
        }
        int length = end = s.length();
        for (st = 0; st < end && ' ' >= s.charAt(st); ++st) {
        }
        while (st < end-- && ' ' >= s.charAt(end)) {
        }
        String string = ++end < length || st > 0 ? s.substring(st, end) : s;
        if (string == null) {
            Tools.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    static String lTrim(@NotNull String s) {
        if (s == null) {
            Tools.$$$reportNull$$$0(3);
        }
        int i = -1;
        int len = s.length();
        while (++i < len && ' ' >= s.charAt(i)) {
        }
        String string = i > 0 ? s.substring(i) : s;
        if (string == null) {
            Tools.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    static String rTrim(@NotNull String s) {
        int len;
        if (s == null) {
            Tools.$$$reportNull$$$0(5);
        }
        int i = len = s.length();
        while (0 <= --i && ' ' >= s.charAt(i)) {
        }
        String string = ++i < len ? s.substring(0, i) : s;
        if (string == null) {
            Tools.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    static StringBuilder rTrim(@NotNull StringBuilder sb) {
        int len;
        if (sb == null) {
            Tools.$$$reportNull$$$0(7);
        }
        int i = len = sb.length();
        while (0 <= --i && ' ' >= sb.charAt(i)) {
        }
        if (++i < len) {
            sb.setLength(i);
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            Tools.$$$reportNull$$$0(8);
        }
        return stringBuilder;
    }

    static void rTrimTwins(@NotNull StringBuilder sb, @NotNull StringBuilder sx) {
        if (sb == null) {
            Tools.$$$reportNull$$$0(9);
        }
        if (sx == null) {
            Tools.$$$reportNull$$$0(10);
        }
        int len = Tools.rTrim(sx).length();
        sb.setLength(len);
    }

    static char charAt(@NotNull CharSequence cs, int ix) {
        if (cs == null) {
            Tools.$$$reportNull$$$0(11);
        }
        int len = cs.length();
        assert (0 <= ix && ix < len) : String.format("IndexOutOfBoundsException Index: %d/%d [%s]", ix, len, cs);
        return Tools.toWhiteSpace(cs.charAt(ix));
    }

    static char charAtLast(@NotNull CharSequence cs) {
        if (cs == null) {
            Tools.$$$reportNull$$$0(12);
        }
        int ix = cs.length() - 1;
        assert (0 <= ix) : "EmptyStringException";
        return Tools.toWhiteSpace(cs.charAt(ix));
    }

    static boolean endsWith(@NotNull CharSequence cs, char c) {
        if (cs == null) {
            Tools.$$$reportNull$$$0(13);
        }
        if (!cs.isEmpty()) {
            return Tools.toWhiteSpace(c) == Tools.charAtLast(cs);
        }
        return false;
    }

    static char toWhiteSpace(char c) {
        return 0 <= WHITE_SPACES.indexOf(c) ? (char)' ' : (char)c;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/awk4j/space/Tools";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sx";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/awk4j/space/Tools";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "trim";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "lTrim";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "rTrim";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "trim";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lTrim";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "rTrim";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "rTrimTwins";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "charAt";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "charAtLast";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 6, 8 -> new IllegalStateException(string);
        };
    }
}

