/*
 * Copyright (C) 2009 awk4j - https://ja.osdn.net/projects/awk4j/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.awk4j.space;

import org.jetbrains.annotations.NotNull;

/**
 * cutSpace - Language.
 *
 * @author kunio himei.
 */
enum Lang {
    SCRIPT,
    CSS,
    HTML;

    static Lang language = HTML; // Current language
    static Lang mark = HTML;

    static boolean is(Lang lang) {
        return language == lang;
    }

    // Current language.
    static Lang top() {
        return language;
    }

    // Push language.
    static void push(Lang lang) {
        if (language != lang) {
            mark = language;
            language = lang;
        }
    }

    // Go back the language to the past. ※(Swap)
    static void mark() {
        Lang w = language;
        language = mark;
        mark = w;
    }

    // Revert to the old language. ※(Alias)
    static void reset() {
        mark();
    }

    // Returns whether it can be targeted
    static boolean isExpand(@NotNull String target) {
        char c = language.name().charAt(0);
        return 0 <= target.indexOf(c); // Compare in uppercase
    }
}